package fr.unice.i3s.keia.irWithIga.statistics;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.multiobjective.MultiObjectiveFitness;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

import java.io.*;
import java.util.ArrayList;

public class FrontRecordsStatistic extends Statistics {

    private String statisticsBaseName;

    // --------------------- Constructors and setup --------------------------//

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        statisticsBaseName = state.parameters
                .getString(base.push("file"), null);

    }

    // --------------------- Statistics functions ----------------------------//

    public void preInitializationStatistics(final EvolutionState state) {
        super.preInitializationStatistics(state);
    }

    public void preBreedingStatistics(final EvolutionState state) {

        for (int subpop = 0; subpop < state.population.subpops.length; subpop++) {

            @SuppressWarnings("unchecked")
            ArrayList<ArrayList<Individual>> frontsByRank = MultiObjectiveFitness
                    .partitionIntoRanks(state.population.subpops[subpop].individuals);

            for (int rank = 0; rank < frontsByRank.size(); rank++) {

                File log = new File(statisticsBaseName + "_subpop_" + subpop
                        + "_gen_" + state.generation + "_rank_" + rank + ".rec");
                PrintWriter output = null;
                try {
                    output = new PrintWriter(new BufferedWriter(new FileWriter(
                            log, true)));
                } catch (IOException e) {
                    e.printStackTrace();
                    System.exit(0);
                }

                // Print headers information
                DoubleVectorIndividual individual = (DoubleVectorIndividual) state.population.subpops[0].individuals[0];
                for (int i = 0; i < individual.genomeLength(); i++) {
                    output.print("ind" + i + " ");
                }
                MultiObjectiveFitness fit = ((MultiObjectiveFitness) individual.fitness);
                for (int i = 0; i < fit.getNumObjectives(); i++) {
                    output.print("obj" + i + " ");
                }
                output.print("\n");

                // Print stats
                for (Individual ind : frontsByRank.get(rank)) {
                    DoubleVectorIndividual vecInd = (DoubleVectorIndividual) ind;
                    for (int i = 0; i < vecInd.genomeLength(); i++) {
                        output.print(vecInd.genome[i] + " ");
                    }
                    MultiObjectiveFitness currentFitness = ((MultiObjectiveFitness) ind.fitness);
                    for (int i = 0; i < currentFitness.getNumObjectives() - 1; i++) {
                        output.print(currentFitness.getObjective(i) + " ");
                    }
                    output.print(currentFitness.getObjective(currentFitness
                            .getNumObjectives() - 1) + "\n");
                    output.flush();
                }
                output.flush();
                output.close();
            }
        }
    }

    public void finalStatistics(final EvolutionState state, final int result) {

    }
}
