/*
 * Copyright 2016 by Romaric Pighetti, CNRS, I3S
 * Licensed under the Academic Free License version 3.0
 */
package fr.unice.i3s.keia.irWithIga.objective;

import cec2013.CEC2013;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class Cec2013Objective implements Objective {

    private int     functionNumber = -1;
    private int     multiplier     = 1;
    private CEC2013 comp           = new CEC2013();

    @Override
    public void setup(EvolutionState state, Parameter base) {
        try {
            int multiplier = state.parameters.getInt(base.push("multiplier"),
                    null);
            this.setMultiplier(multiplier);
        } catch (Exception e) {
            state.output
                    .error("Couldn't read multiplier for Cec2013Objective, keep 1 as multiplier");
        }

        functionNumber = state.parameters.getInt(base.push("function"), null);
    }

    @Override
    public double evaluate(EvolutionState state, Individual ind,
            int subpopulation, int threadnum) {

        DoubleVectorIndividual individual = (DoubleVectorIndividual) ind;

        return comp.getFunctions().get(functionNumber)
                .evaluate(individual.genome)
                * multiplier;
    }

    @Override
    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

}
