/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.JDK6Console;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<String, ParameterDescription> m_descriptions;
    private List<Object> m_objects = Lists.newArrayList();
    private Field m_mainParameterField = null;
    private Object m_mainParameterObject;
    private Parameter m_mainParameterAnnotation;
    private ParameterDescription m_mainParameterDescription;
    private Map<Field, ParameterDescription> m_requiredFields = Maps.newHashMap();
    private Map<Field, ParameterDescription> m_fields = Maps.newHashMap();
    private ResourceBundle m_bundle;
    private IDefaultProvider m_defaultProvider;
    private Map<ProgramName, JCommander> m_commands = Maps.newLinkedHashMap();
    private Map<String, ProgramName> aliasMap = Maps.newLinkedHashMap();
    private String m_parsedCommand;
    private String m_parsedAlias;
    private ProgramName m_programName;
    private Comparator<? super ParameterDescription> m_parameterDescriptionComparator = new Comparator<ParameterDescription>(){

        @Override
        public int compare(ParameterDescription p0, ParameterDescription p1) {
            return p0.getLongestName().compareTo(p1.getLongestName());
        }
    };
    private int m_columnSize = 79;
    private static Console m_console;
    private static LinkedList<IStringConverterFactory> CONVERTER_FACTORIES;

    static {
        CONVERTER_FACTORIES = Lists.newLinkedList();
        CONVERTER_FACTORIES.addFirst(new DefaultConverterFactory());
    }

    public JCommander() {
    }

    public JCommander(Object object) {
        this.addObject(object);
        this.createDescriptions();
    }

    public JCommander(Object object, ResourceBundle bundle) {
        this.addObject(object);
        this.setDescriptionsBundle(bundle);
    }

    public JCommander(Object object, ResourceBundle bundle, String ... args) {
        this.addObject(object);
        this.setDescriptionsBundle(bundle);
        this.parse(args);
    }

    public JCommander(Object object, String ... args) {
        this.addObject(object);
        this.parse(args);
    }

    public static Console getConsole() {
        if (m_console == null) {
            try {
                Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
                Object console = consoleMethod.invoke(null, new Object[0]);
                m_console = new JDK6Console(console);
            }
            catch (Throwable t) {
                m_console = new DefaultConsole();
            }
        }
        return m_console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object o : (Iterable)object) {
                this.m_objects.add(o);
            }
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.m_objects.add(o);
                ++n2;
            }
        } else {
            this.m_objects.add(object);
        }
    }

    public final void setDescriptionsBundle(ResourceBundle bundle) {
        this.m_bundle = bundle;
    }

    public void parse(String ... args) {
        this.parse(true, args);
    }

    public void parseWithoutValidation(String ... args) {
        this.parse(false, args);
    }

    private void parse(boolean validate, String ... args) {
        StringBuilder sb = new StringBuilder("Parsing \"");
        sb.append((CharSequence)this.join(args).append("\"\n  with:").append((CharSequence)this.join(this.m_objects.toArray())));
        this.p(sb.toString());
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(args));
        if (validate) {
            this.validateOptions();
        }
    }

    private StringBuilder join(Object[] args) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(args[i]);
            ++i;
        }
        return result;
    }

    private void initializeDefaultValues() {
        if (this.m_defaultProvider != null) {
            for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
                this.initializeDefaultValue(parameterDescription);
            }
            for (Map.Entry entry : this.m_commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder missingFields = new StringBuilder();
            for (ParameterDescription pd : this.m_requiredFields.values()) {
                missingFields.append(pd.getNames()).append(" ");
            }
            throw new ParameterException("The following options are required: " + missingFields);
        }
        if (this.m_mainParameterDescription != null && this.m_mainParameterDescription.getParameter().required() && !this.m_mainParameterDescription.isAssigned()) {
            throw new ParameterException("Main parameters are required (\"" + this.m_mainParameterDescription.getDescription() + "\")");
        }
    }

    private String[] expandArgs(String[] originalArgv) {
        List vResult1 = Lists.newArrayList();
        String[] stringArray = originalArgv;
        int n = originalArgv.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult1.addAll(JCommander.readFile(fileName));
            } else {
                List<String> expanded = this.expandDynamicArg(arg);
                vResult1.addAll(expanded);
            }
            ++n2;
        }
        List vResult2 = Lists.newArrayList();
        int i = 0;
        while (i < vResult1.size()) {
            String arg = (String)vResult1.get(i);
            String[] v1 = vResult1.toArray(new String[0]);
            if (this.isOption(v1, arg)) {
                String sep = this.getSeparatorFor(v1, arg);
                if (!" ".equals(sep)) {
                    String[] sp;
                    String[] stringArray2 = sp = arg.split("[" + sep + "]", 2);
                    int n3 = sp.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String ssp = stringArray2[n4];
                        vResult2.add(ssp);
                        ++n4;
                    }
                } else {
                    vResult2.add(arg);
                }
            } else {
                vResult2.add(arg);
            }
            ++i;
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private List<String> expandDynamicArg(String arg) {
        for (ParameterDescription pd : this.m_descriptions.values()) {
            if (!pd.isDynamicParameter()) continue;
            String[] stringArray = pd.getParameter().names();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (arg.startsWith(name) && !arg.equals(name)) {
                    return Arrays.asList(name, arg.substring(name.length()));
                }
                ++n2;
            }
        }
        return Arrays.asList(arg);
    }

    private boolean isOption(String[] args, String arg) {
        String prefixes = this.getOptionPrefixes(args, arg);
        return prefixes.indexOf(arg.charAt(0)) >= 0;
    }

    private ParameterDescription getPrefixDescriptionFor(String arg) {
        for (Map.Entry<String, ParameterDescription> es : this.m_descriptions.entrySet()) {
            if (!arg.startsWith(es.getKey())) continue;
            return es.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String[] args, String arg) {
        ParameterDescription result = this.getPrefixDescriptionFor(arg);
        if (result != null) {
            return result;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            ParameterDescription pd = this.getPrefixDescriptionFor(arg);
            if (pd != null) {
                result = pd;
            }
            if (a.equals(arg)) {
                return result;
            }
            ++n2;
        }
        throw new ParameterException("Unknown parameter: " + arg);
    }

    private String getSeparatorFor(String[] args, String arg) {
        Parameters p;
        ParameterDescription pd = this.getDescriptionFor(args, arg);
        if (pd != null && (p = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p.separators();
        }
        return " ";
    }

    private String getOptionPrefixes(String[] args, String arg) {
        Parameters p;
        ParameterDescription pd = this.getDescriptionFor(args, arg);
        if (pd != null && (p = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p.optionPrefixes();
        }
        return "-";
    }

    private static List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new FileReader(fileName));
            while ((line = bufRead.readLine()) != null) {
                if (line.length() <= 0) continue;
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new ParameterException("Could not read file " + fileName + ": " + e);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"")) {
            if (result.endsWith("\"")) {
                return result.substring(1, result.length() - 1);
            }
            return result.substring(1);
        }
        return result;
    }

    private void createDescriptions() {
        this.m_descriptions = Maps.newHashMap();
        for (Object object : this.m_objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> cls = object.getClass();
        while (!Object.class.equals(cls)) {
            Field[] fieldArray = cls.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterDescription pd;
                String name;
                int n3;
                int n4;
                String[] stringArray;
                Field f = fieldArray[n2];
                this.p("Field:" + cls.getSimpleName() + "." + f.getName());
                f.setAccessible(true);
                Parameter annotation = f.getAnnotation(Parameter.class);
                ParametersDelegate delegateAnnotation = f.getAnnotation(ParametersDelegate.class);
                DynamicParameter dynamicParameter = f.getAnnotation(DynamicParameter.class);
                if (annotation != null) {
                    Parameter p = annotation;
                    if (p.names().length == 0) {
                        this.p("Found main parameter:" + f);
                        if (this.m_mainParameterField != null) {
                            throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameterField + " and " + f);
                        }
                        this.m_mainParameterField = f;
                        this.m_mainParameterObject = object;
                        this.m_mainParameterAnnotation = p;
                        this.m_mainParameterDescription = new ParameterDescription(object, p, f, this.m_bundle, this);
                    } else {
                        stringArray = p.names();
                        n4 = stringArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            name = stringArray[n3];
                            if (this.m_descriptions.containsKey(name)) {
                                throw new ParameterException("Found the option " + name + " multiple times");
                            }
                            this.p("Adding description for " + name);
                            pd = new ParameterDescription(object, p, f, this.m_bundle, this);
                            this.m_fields.put(f, pd);
                            this.m_descriptions.put(name, pd);
                            if (p.required()) {
                                this.m_requiredFields.put(f, pd);
                            }
                            ++n3;
                        }
                    }
                } else if (delegateAnnotation != null) {
                    try {
                        Object delegateObject = f.get(object);
                        if (delegateObject == null) {
                            throw new ParameterException("Delegate field '" + f.getName() + "' cannot be null.");
                        }
                        this.addDescription(delegateObject);
                    }
                    catch (IllegalAccessException delegateObject) {}
                } else if (dynamicParameter != null) {
                    DynamicParameter dp = dynamicParameter;
                    stringArray = dp.names();
                    n4 = stringArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        name = stringArray[n3];
                        if (this.m_descriptions.containsKey(name)) {
                            throw new ParameterException("Found the option " + name + " multiple times");
                        }
                        this.p("Adding description for " + name);
                        pd = new ParameterDescription(object, dp, f, this.m_bundle, this);
                        this.m_fields.put(f, pd);
                        this.m_descriptions.put(name, pd);
                        if (dp.required()) {
                            this.m_requiredFields.put(f, pd);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            cls = cls.getSuperclass();
        }
    }

    private void initializeDefaultValue(ParameterDescription pd) {
        String[] stringArray = pd.getParameter().names();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String optionName = stringArray[n2];
            String def = this.m_defaultProvider.getDefaultValueFor(optionName);
            if (def != null) {
                this.p("Initializing " + optionName + " with default value:" + def);
                pd.addValue(def, true);
                return;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseValues(String[] args) {
        boolean commandParsed = false;
        int i = 0;
        while (i < args.length && !commandParsed) {
            String arg = args[i];
            String a = JCommander.trim(arg);
            this.p("Parsing arg:" + a);
            JCommander jc = this.findCommandByAlias(arg);
            if (this.isOption(args, a) && jc == null) {
                ParameterDescription pd = this.m_descriptions.get(a);
                if (pd == null) throw new ParameterException("Unknown option: " + arg);
                if (pd.getParameter().password()) {
                    char[] password = this.readPassword(pd.getDescription());
                    pd.addValue(new String(password));
                    this.m_requiredFields.remove(pd.getField());
                } else if (pd.getParameter().variableArity()) {
                    i = this.processVariableArity(args, i, pd);
                } else {
                    Class<?> fieldType = pd.getField().getType();
                    if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && pd.getParameter().arity() == -1) {
                        pd.addValue("true");
                        this.m_requiredFields.remove(pd.getField());
                    } else {
                        i = this.processFixedArity(args, i, pd, fieldType);
                    }
                }
            } else if (!JCommander.isStringEmpty(arg)) {
                if (this.m_commands.isEmpty()) {
                    ParameterizedType p;
                    Type cls;
                    List<?> mp = this.getMainParameter(arg);
                    String value = arg;
                    Object convertedValue = value;
                    if (this.m_mainParameterField.getGenericType() instanceof ParameterizedType && (cls = (p = (ParameterizedType)this.m_mainParameterField.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                        convertedValue = this.convertValue(this.m_mainParameterField, (Class)cls, value);
                    }
                    ParameterDescription.validateParameter(this.m_mainParameterAnnotation.validateWith(), "Default", value);
                    this.m_mainParameterDescription.setAssigned(true);
                    mp.add(convertedValue);
                } else {
                    if (jc == null) {
                        throw new MissingCommandException("Expected a command, got " + arg);
                    }
                    this.m_parsedCommand = jc.m_programName.m_name;
                    this.m_parsedAlias = arg;
                    jc.parse(this.subArray(args, i + 1));
                    commandParsed = true;
                }
            }
            ++i;
        }
        for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
            if (!parameterDescription.isAssigned()) continue;
            this.m_fields.get(parameterDescription.getField()).setAssigned(true);
        }
    }

    private Type findFieldGenericType(Field field) {
        ParameterizedType p;
        Type cls;
        if (field.getGenericType() instanceof ParameterizedType && (cls = (p = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
            return cls;
        }
        return null;
    }

    private int processVariableArity(String[] args, int index, ParameterDescription pd) {
        Object arg = pd.getObject();
        if (!(arg instanceof IVariableArity)) {
            throw new ParameterException("Arg class " + arg.getClass() + " should implement IVariableArity");
        }
        IVariableArity va = (IVariableArity)arg;
        List currentArgs = Lists.newArrayList();
        int j = index + 1;
        while (j < args.length) {
            currentArgs.add(args[j]);
            ++j;
        }
        int result = va.processVariableArity(pd.getParameter().names()[0], currentArgs.toArray(new String[0]));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] args, int index, ParameterDescription pd, Class<?> fieldType) {
        int n;
        String arg = args[index];
        int arity = pd.getParameter().arity();
        int n2 = n = arity != -1 ? arity : 1;
        if (n == 0 && (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType))) {
            pd.addValue("true");
            this.m_requiredFields.remove(pd.getField());
            return index;
        } else {
            int offset;
            if (index >= args.length - 1) throw new ParameterException("Expected a value after parameter " + arg);
            int n3 = offset = "--".equals(args[index + 1]) ? 1 : 0;
            if (index + n >= args.length) throw new ParameterException("Expected " + n + " values after " + arg);
            int j = 1;
            while (j <= n) {
                pd.addValue(JCommander.trim(args[index + j + offset]));
                this.m_requiredFields.remove(pd.getField());
                ++j;
            }
            index += n + offset;
        }
        return index;
    }

    private char[] readPassword(String description) {
        JCommander.getConsole().print(String.valueOf(description) + ": ");
        return JCommander.getConsole().readPassword();
    }

    private String[] subArray(String[] args, int index) {
        int l = args.length - index;
        String[] result = new String[l];
        System.arraycopy(args, index, result, 0, l);
        return result;
    }

    private static boolean isStringEmpty(String s) {
        return s == null || "".equals(s);
    }

    private List<?> getMainParameter(String arg) {
        if (this.m_mainParameterField == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined");
        }
        try {
            List result = (List)this.m_mainParameterField.get(this.m_mainParameterObject);
            if (result == null) {
                result = Lists.newArrayList();
                if (!List.class.isAssignableFrom(this.m_mainParameterField.getType())) {
                    throw new ParameterException("Main parameter field " + this.m_mainParameterField + " needs to be of type List, not " + this.m_mainParameterField.getType());
                }
                this.m_mainParameterField.set(this.m_mainParameterObject, result);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new ParameterException("Couldn't access main parameter: " + ex.getMessage());
        }
    }

    public String getMainParameterDescription() {
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        return this.m_mainParameterAnnotation != null ? this.m_mainParameterAnnotation.description() : null;
    }

    private int longestName(Collection<?> objects) {
        int result = 0;
        for (Object o : objects) {
            int l = o.toString().length();
            if (l <= result) continue;
            result = l;
        }
        return result;
    }

    public void setProgramName(String name) {
        this.setProgramName(name, new String[0]);
    }

    public void setProgramName(String name, String ... aliases) {
        this.m_programName = new ProgramName(name, Arrays.asList(aliases));
    }

    public void usage(String commandName) {
        StringBuilder sb = new StringBuilder();
        this.usage(commandName, sb);
        JCommander.getConsole().println(sb.toString());
    }

    public void usage(String commandName, StringBuilder out) {
        this.usage(commandName, out, "");
    }

    public void usage(String commandName, StringBuilder out, String indent) {
        String description = this.getCommandDescription(commandName);
        JCommander jc = this.findCommandByAlias(commandName);
        if (description != null) {
            out.append(indent).append(description);
            out.append("\n");
        }
        jc.usage(out, indent);
    }

    public String getCommandDescription(String commandName) {
        JCommander jc = this.findCommandByAlias(commandName);
        if (jc == null) {
            throw new ParameterException("Asking description for unknown command: " + commandName);
        }
        Parameters p = jc.getObjects().get(0).getClass().getAnnotation(Parameters.class);
        String result = jc.getMainParameterDescription();
        if (p != null) {
            result = this.getI18nString(p.commandDescriptionKey(), p.commandDescription());
        }
        return result;
    }

    private String getI18nString(String key, String def) {
        String s = this.m_bundle != null ? this.m_bundle.getString(key) : null;
        return s != null ? s : def;
    }

    public void usage() {
        StringBuilder sb = new StringBuilder();
        this.usage(sb);
        JCommander.getConsole().println(sb.toString());
    }

    public void usage(StringBuilder out) {
        this.usage(out, "");
    }

    public void usage(StringBuilder out, String indent) {
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        boolean hasCommands = !this.m_commands.isEmpty();
        String programName = this.m_programName != null ? this.m_programName.getDisplayName() : "<main class>";
        out.append(indent).append("Usage: " + programName + " [options]");
        if (hasCommands) {
            out.append(indent).append(" [command] [command options]");
        }
        if (this.m_mainParameterDescription != null) {
            out.append(" " + this.m_mainParameterDescription.getDescription());
        }
        int longestName = 0;
        List<ParameterDescription> sorted = Lists.newArrayList();
        for (ParameterDescription parameterDescription : this.m_fields.values()) {
            if (parameterDescription.getParameter().hidden()) continue;
            sorted.add(parameterDescription);
            int length = parameterDescription.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        Collections.sort(sorted, this.getParameterDescriptionComparator());
        if (sorted.size() > 0) {
            out.append(indent).append("\n").append(indent).append("  Options:\n");
        }
        for (ParameterDescription parameterDescription : sorted) {
            int l = parameterDescription.getNames().length();
            int spaceCount = longestName - l;
            int start = out.length();
            WrappedParameter parameter = parameterDescription.getParameter();
            out.append(indent).append("  " + (parameter.required() ? "* " : "  ") + parameterDescription.getNames() + this.s(spaceCount));
            int indentCount = out.length() - start;
            this.wrapDescription(out, indentCount, parameterDescription.getDescription());
            Object def = parameterDescription.getDefault();
            if (parameterDescription.isDynamicParameter()) {
                out.append("\n" + this.spaces(indentCount + 1)).append("Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value");
            }
            if (def != null && !"".equals(def)) {
                out.append("\n" + this.spaces(indentCount + 1)).append("Default: " + (parameter.password() ? "********" : def));
            }
            out.append("\n");
        }
        if (hasCommands) {
            out.append("  Commands:\n");
            for (Map.Entry entry : this.m_commands.entrySet()) {
                ProgramName progName = (ProgramName)entry.getKey();
                String dispName = progName.getDisplayName();
                out.append(indent).append("    " + dispName);
                this.usage(progName.getName(), out, "      ");
                out.append("\n");
            }
        }
    }

    private Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.m_parameterDescriptionComparator;
    }

    public void setParameterDescriptionComparator(Comparator<? super ParameterDescription> c) {
        this.m_parameterDescriptionComparator = c;
    }

    public void setColumnSize(int columnSize) {
        this.m_columnSize = columnSize;
    }

    public int getColumnSize() {
        return this.m_columnSize;
    }

    private void wrapDescription(StringBuilder out, int indent, String description) {
        int max = this.getColumnSize();
        String[] words = description.split(" ");
        int current = indent;
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (word.length() > max || current + word.length() <= max) {
                out.append(" ").append(word);
                current += word.length() + 1;
            } else {
                out.append("\n").append(this.spaces(indent + 1)).append(word);
                current = indent;
            }
            ++i;
        }
    }

    private String spaces(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.m_fields.values());
    }

    public ParameterDescription getMainParameter() {
        return this.m_mainParameterDescription;
    }

    private void p(String string) {
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            JCommander.getConsole().println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider defaultProvider) {
        this.m_defaultProvider = defaultProvider;
        for (Map.Entry<ProgramName, JCommander> entry : this.m_commands.entrySet()) {
            entry.getValue().setDefaultProvider(defaultProvider);
        }
    }

    public void addConverterFactory(IStringConverterFactory converterFactory) {
        CONVERTER_FACTORIES.addFirst(converterFactory);
    }

    public <T> Class<? extends IStringConverter<T>> findConverter(Class<T> cls) {
        for (IStringConverterFactory f : CONVERTER_FACTORIES) {
            Class<IStringConverter<T>> result = f.getConverter(cls);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object convertValue(ParameterDescription pd, String value) {
        return this.convertValue(pd.getField(), pd.getField().getType(), value);
    }

    public Object convertValue(Field field, Class type, String value) {
        Object result;
        block14: {
            boolean listConverterWasSpecified;
            Parameter annotation = field.getAnnotation(Parameter.class);
            if (annotation == null) {
                return value;
            }
            Class converterClass = annotation.converter();
            boolean bl = listConverterWasSpecified = annotation.listConverter() != NoConverter.class;
            if (converterClass == null || converterClass == NoConverter.class) {
                converterClass = type.isEnum() ? type : this.findConverter(type);
            }
            if (converterClass == null) {
                Type elementType = this.findFieldGenericType(field);
                converterClass = elementType != null ? this.findConverter((Class)elementType) : StringConverter.class;
            }
            result = null;
            try {
                String optionName;
                String[] names = annotation.names();
                String string = optionName = names.length > 0 ? names[0] : "[Main class]";
                if (converterClass.isEnum()) {
                    try {
                        result = Enum.valueOf(converterClass, value.toUpperCase());
                        break block14;
                    }
                    catch (Exception e) {
                        throw new ParameterException("Invalid value for " + optionName + " parameter. Allowed values:" + EnumSet.allOf(converterClass));
                    }
                }
                IStringConverter<?> converter = this.instantiateConverter(optionName, converterClass);
                if (type.isAssignableFrom(List.class) && field.getGenericType() instanceof ParameterizedType) {
                    if (listConverterWasSpecified) {
                        IStringConverter<?> listConverter = this.instantiateConverter(optionName, annotation.listConverter());
                        result = listConverter.convert(value);
                    } else {
                        result = this.convertToList(value, converter, annotation.splitter());
                    }
                } else {
                    result = converter.convert(value);
                }
            }
            catch (InstantiationException e) {
                throw new ParameterException(e);
            }
            catch (IllegalAccessException e) {
                throw new ParameterException(e);
            }
            catch (InvocationTargetException e) {
                throw new ParameterException(e);
            }
        }
        return result;
    }

    private Object convertToList(String value, IStringConverter<?> converter, Class<? extends IParameterSplitter> splitterClass) throws InstantiationException, IllegalAccessException {
        IParameterSplitter splitter = splitterClass.newInstance();
        List result = Lists.newArrayList();
        for (String param : splitter.split(value)) {
            result.add(converter.convert(param));
        }
        return result;
    }

    private IStringConverter<?> instantiateConverter(String optionName, Class<? extends IStringConverter<?>> converterClass) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] ctors;
        Constructor<?> ctor = null;
        Constructor<?> stringCtor = null;
        Constructor<?>[] constructorArray = ctors = converterClass.getDeclaredConstructors();
        int n = ctors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Class<?>[] types = c.getParameterTypes();
            if (types.length == 1 && types[0].equals(String.class)) {
                stringCtor = c;
            } else if (types.length == 0) {
                ctor = c;
            }
            ++n2;
        }
        IStringConverter result = stringCtor != null ? (IStringConverter)stringCtor.newInstance(optionName) : (IStringConverter)ctor.newInstance(new Object[0]);
        return result;
    }

    public void addCommand(String name, Object object) {
        this.addCommand(name, object, new String[0]);
    }

    public void addCommand(Object object) {
        Parameters p = object.getClass().getAnnotation(Parameters.class);
        if (p != null && p.commandNames().length > 0) {
            String[] stringArray = p.commandNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String commandName = stringArray[n2];
                this.addCommand(commandName, object);
                ++n2;
            }
        } else {
            throw new ParameterException("Trying to add command " + object.getClass().getName() + " without specifying its names in @Parameters");
        }
    }

    public void addCommand(String name, Object object, String ... aliases) {
        JCommander jc = new JCommander(object);
        jc.setProgramName(name, aliases);
        jc.setDefaultProvider(this.m_defaultProvider);
        ProgramName progName = jc.m_programName;
        this.m_commands.put(progName, jc);
        this.aliasMap.put(name, progName);
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            if (!alias.equals(name)) {
                ProgramName mappedName = this.aliasMap.get(alias);
                if (mappedName != null && !mappedName.equals(progName)) {
                    throw new ParameterException("Cannot set alias " + alias + " for " + name + " command because it has already been defined for " + mappedName.m_name + " command");
                }
                this.aliasMap.put(alias, progName);
            }
            ++n2;
        }
    }

    public Map<String, JCommander> getCommands() {
        Map<String, JCommander> res = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.m_commands.entrySet()) {
            res.put(entry.getKey().m_name, entry.getValue());
        }
        return res;
    }

    public String getParsedCommand() {
        return this.m_parsedCommand;
    }

    public String getParsedAlias() {
        return this.m_parsedAlias;
    }

    private String s(int count) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < count) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public List<Object> getObjects() {
        return this.m_objects;
    }

    private JCommander findCommandByAlias(String commandOrAlias) {
        ProgramName progName = this.aliasMap.get(commandOrAlias);
        if (progName == null) {
            return null;
        }
        JCommander jc = this.m_commands.get(progName);
        if (jc == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jc;
    }

    private static final class ProgramName {
        private final String m_name;
        private final List<String> m_aliases;

        ProgramName(String name, List<String> aliases) {
            this.m_name = name;
            this.m_aliases = aliases;
        }

        public String getName() {
            return this.m_name;
        }

        private String getDisplayName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_name);
            if (!this.m_aliases.isEmpty()) {
                sb.append("(");
                Iterator<String> aliasesIt = this.m_aliases.iterator();
                while (aliasesIt.hasNext()) {
                    sb.append(aliasesIt.next());
                    if (!aliasesIt.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramName other = (ProgramName)obj;
            return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

