/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MacClipboard
extends ImagePlus
implements PlugIn {
    static Clipboard clipboard;

    @Override
    public void run(String string) {
        Image image = this.showSystemClipboard();
        if (image != null) {
            this.setImage(image);
        }
    }

    Image showSystemClipboard() {
        Image image = null;
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        try {
            Transferable transferable = clipboard.getContents(null);
            image = this.displayMacImage(transferable);
        }
        catch (Throwable throwable) {
            IJ.handleException(throwable);
        }
        return image;
    }

    Image displayMacImage(Transferable transferable) {
        Image image = this.getMacImage(transferable);
        if (image != null) {
            WindowManager.checkForDuplicateName = true;
            new ImagePlus("Clipboard", image).show();
        }
        return image;
    }

    Image getMacImage(Transferable transferable) {
        if (!this.isQTJavaInstalled()) {
            return null;
        }
        Image image = null;
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray == null || dataFlavorArray.length == 0) {
            return null;
        }
        try {
            Object object = transferable.getTransferData(dataFlavorArray[0]);
            if (object == null || !(object instanceof InputStream)) {
                return null;
            }
            image = this.getImageFromPictStream((InputStream)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    Image getImageFromPictStream(InputStream inputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[512];
            byte[] byArray2 = new byte[4096];
            int n = 0;
            int n2 = 0;
            byteArrayOutputStream.write(byArray, 0, 512);
            while ((n = inputStream.read(byArray2, 0, 4096)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            n2 = byteArrayOutputStream.size();
            if (n2 <= 0) {
                return null;
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            Class<?> clazz = Class.forName("quicktime.QTSession");
            Method method = clazz.getMethod("isInitialized", null);
            Boolean bl = (Boolean)method.invoke(null, null);
            if (!bl.booleanValue()) {
                method = clazz.getMethod("open", null);
                method.invoke(null, null);
            }
            clazz = Class.forName("quicktime.util.QTHandle");
            Constructor<?> constructor = clazz.getConstructor(byArray3.getClass());
            Object obj = constructor.newInstance(new Object[]{byArray3});
            String string = new String("PICT");
            clazz = Class.forName("quicktime.util.QTUtils");
            method = clazz.getMethod("toOSType", string.getClass());
            Integer n3 = (Integer)method.invoke(null, string);
            clazz = Class.forName("quicktime.std.image.GraphicsImporter");
            Class[] classArray = new Class[1];
            classArray[0] = Integer.TYPE;
            constructor = clazz.getConstructor(classArray);
            Object obj2 = constructor.newInstance(n3);
            method = clazz.getMethod("setDataHandle", Class.forName("quicktime.util.QTHandleRef"));
            method.invoke(obj2, obj);
            method = clazz.getMethod("getNaturalBounds", null);
            Object object = method.invoke(obj2, null);
            clazz = Class.forName("quicktime.app.view.GraphicsImporterDrawer");
            constructor = clazz.getConstructor(obj2.getClass());
            Object obj3 = constructor.newInstance(obj2);
            method = object.getClass().getMethod("getWidth", null);
            Integer n4 = (Integer)method.invoke(object, null);
            method = object.getClass().getMethod("getHeight", null);
            Integer n5 = (Integer)method.invoke(object, null);
            Dimension dimension = new Dimension(n4, n5);
            clazz = Class.forName("quicktime.app.view.QTImageProducer");
            constructor = clazz.getConstructor(obj3.getClass(), dimension.getClass());
            Object obj4 = constructor.newInstance(obj3, dimension);
            if (obj4 instanceof ImageProducer) {
                return Toolkit.getDefaultToolkit().createImage((ImageProducer)obj4);
            }
        }
        catch (Exception exception) {
            IJ.showStatus("" + exception);
        }
        return null;
    }

    boolean isQTJavaInstalled() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("quicktime.QTSession");
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

