/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.CommandListener;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Menu;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class Executer
implements Runnable {
    private static String previousCommand;
    private static CommandListener listener;
    private static Vector listeners;
    private String command;
    private Thread thread;

    public Executer(String string) {
        this.command = string;
    }

    public Executer(String string, ImagePlus imagePlus) {
        if (string.startsWith("Repeat")) {
            this.command = previousCommand;
            IJ.setKeyUp(16);
        } else {
            this.command = string;
            if (!string.equals("Undo") && !string.equals("Close")) {
                previousCommand = string;
            }
        }
        IJ.resetEscape();
        this.thread = new Thread((Runnable)this, string);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        if (imagePlus != null) {
            WindowManager.setTempCurrentImage(this.thread, imagePlus);
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            Object object;
            if (this.command == null) {
                return;
            }
            if (listeners.size() > 0) {
                Vector vector = listeners;
                synchronized (vector) {
                    for (int i = 0; i < listeners.size(); ++i) {
                        object = (CommandListener)listeners.elementAt(i);
                        this.command = object.commandExecuting(this.command);
                        if (this.command != null) continue;
                        return;
                    }
                }
            }
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command);
                    Recorder.saveCommand();
                } else {
                    this.runCommand(this.command);
                }
                int n = this.command.length();
                if (this.command.charAt(n - 1) != ']') {
                    IJ.setKeyUp(-1);
                }
            }
            catch (Throwable throwable) {
                IJ.showStatus("");
                IJ.showProgress(1, 1);
                ImagePlus imagePlus = WindowManager.getCurrentImage();
                if (imagePlus != null) {
                    imagePlus.unlock();
                }
                object = throwable.getMessage();
                if (throwable instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (throwable instanceof RuntimeException && object != null && ((String)object).equals("Macro canceled")) break block20;
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                PrintWriter printWriter = new PrintWriter(charArrayWriter);
                throwable.printStackTrace(printWriter);
                String string = charArrayWriter.toString();
                if (IJ.isMacintosh()) {
                    if (string.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    string = Tools.fixNewLines(string);
                }
                int n = 500;
                int n2 = 300;
                if (string.indexOf("UnsupportedClassVersionError") != -1) {
                    if (string.indexOf("version 49.0") != -1) {
                        string = throwable + "\n \nThis plugin requires Java 1.5 or later.";
                        n = 700;
                        n2 = 150;
                    }
                    if (string.indexOf("version 50.0") != -1) {
                        string = throwable + "\n \nThis plugin requires Java 1.6 or later.";
                        n = 700;
                        n2 = 150;
                    }
                    if (string.indexOf("version 51.0") != -1) {
                        string = throwable + "\n \nThis plugin requires Java 1.7 or later.";
                        n = 700;
                        n2 = 150;
                    }
                }
                if (IJ.getInstance() != null) {
                    new TextWindow("Exception", string, n, n2);
                }
                IJ.log(string);
            }
        }
    }

    void runCommand(String string) {
        Hashtable hashtable = Menus.getCommands();
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            int n;
            String string3 = "";
            if (string2.endsWith("\")") && (n = string2.lastIndexOf("(\"")) > 0) {
                string3 = string2.substring(n + 2, string2.length() - 2);
                string2 = string2.substring(0, n);
            }
            if (IJ.shiftKeyDown() && string2.startsWith("ij.plugin.Macro_Runner") && !Menus.getShortcuts().contains("*" + string)) {
                IJ.open(IJ.getDirectory("plugins") + string3);
            } else {
                IJ.runPlugIn(string, string2, string3);
            }
        } else {
            if (MacroInstaller.runMacroCommand(string)) {
                return;
            }
            String string4 = IJ.getDirectory("luts") + string + ".lut";
            File file = new File(string4);
            if (file.exists()) {
                String string5 = OpenDialog.getLastDirectory();
                IJ.open(string4);
                OpenDialog.setLastDirectory(string5);
            } else if (!this.openRecent(string)) {
                IJ.error("Unrecognized command: " + string);
            }
        }
    }

    boolean openRecent(String string) {
        Menu menu = Menus.openRecentMenu;
        if (menu == null) {
            return false;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!menu.getItem(i).getLabel().equals(string)) continue;
            IJ.open(string);
            return true;
        }
        return false;
    }

    public static String getCommand() {
        return previousCommand;
    }

    public static void addCommandListener(CommandListener commandListener) {
        listeners.addElement(commandListener);
    }

    public static void removeCommandListener(CommandListener commandListener) {
        listeners.removeElement(commandListener);
    }

    static {
        listeners = new Vector();
    }
}

