/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.CompositeImage;
import ij.Executer;
import ij.IJEventListener;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.HTMLDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.MessageDialog;
import ij.gui.NewImage;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.PluginClassLoader;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Macro_Runner;
import ij.plugin.Memory;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.process.AutoThresholder;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class IJ {
    public static final String URL = "http://imagej.nih.gov/ij";
    public static final int ALL_KEYS = -1;
    public static boolean debugMode;
    public static boolean hideProcessStackDialog;
    public static final char micronSymbol = '\u00b5';
    public static final char angstromSymbol = '\u00c5';
    public static final char degreeSymbol = '\u00b0';
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static String osname;
    private static String osarch;
    private static boolean isMac;
    private static boolean isWin;
    private static boolean isJava2;
    private static boolean isJava14;
    private static boolean isJava15;
    private static boolean isJava16;
    private static boolean isJava17;
    private static boolean isLinux;
    private static boolean isVista;
    private static boolean is64Bit;
    private static boolean controlDown;
    private static boolean altDown;
    private static boolean spaceDown;
    private static boolean shiftDown;
    private static boolean macroRunning;
    private static Thread previousThread;
    private static TextPanel logPanel;
    private static boolean checkForDuplicatePlugins;
    private static ClassLoader classLoader;
    private static boolean memMessageDisplayed;
    private static long maxMemory;
    private static boolean escapePressed;
    private static boolean redirectErrorMessages;
    private static boolean redirectErrorMessages2;
    private static boolean suppressPluginNotFoundError;
    private static Hashtable commandTable;
    private static Vector eventListeners;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat[] df;
    private static DecimalFormat[] sf;
    private static DecimalFormatSymbols dfs;
    static ExceptionHandler exceptionHandler;

    static void init(ImageJ imageJ, Applet applet) {
        ij = imageJ;
        IJ.applet = applet;
        progressBar = ij.getProgressBar();
    }

    static void cleanup() {
        ij = null;
        applet = null;
        progressBar = null;
        textPanel = null;
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static String runMacro(String string) {
        return IJ.runMacro(string, "");
    }

    public static String runMacro(String string, String string2) {
        Macro_Runner macro_Runner = new Macro_Runner();
        return macro_Runner.runMacro(string, string2);
    }

    public static String runMacroFile(String string, String string2) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro_Runner macro_Runner = new Macro_Runner();
        return macro_Runner.runMacroFile(string, string2);
    }

    public static String runMacroFile(String string) {
        return IJ.runMacroFile(string, null);
    }

    public static Object runPlugIn(ImagePlus imagePlus, String string, String string2) {
        if (imagePlus != null) {
            ImagePlus imagePlus2 = WindowManager.getTempCurrentImage();
            WindowManager.setTempCurrentImage(imagePlus);
            Object object = IJ.runPlugIn("", string, string2);
            WindowManager.setTempCurrentImage(imagePlus2);
            return object;
        }
        return IJ.runPlugIn(string, string2);
    }

    public static Object runPlugIn(String string, String string2) {
        return IJ.runPlugIn("", string, string2);
    }

    static Object runPlugIn(String string, String string2, String string3) {
        if (debugMode) {
            IJ.log("runPlugin: " + string2 + " " + string3);
        }
        if (string3 == null) {
            string3 = "";
        }
        if (!string2.startsWith("ij.") && applet == null) {
            return IJ.runUserPlugIn(string, string2, string3, false);
        }
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var3_3 = clazz.newInstance();
            if (var3_3 instanceof PlugIn) {
                ((PlugIn)var3_3).run(string3);
            } else {
                new PlugInFilterRunner(var3_3, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (IJ.getApplet() == null) {
                IJ.log("Plugin or class not found: \"" + string2 + "\"\n(" + classNotFoundException + ")");
            }
        }
        catch (InstantiationException instantiationException) {
            IJ.log("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.log("Unable to load plugin, possibly \nbecause it is not public.");
        }
        redirectErrorMessages = false;
        return var3_3;
    }

    static Object runUserPlugIn(String string, String string2, String string3, boolean bl) {
        if (applet != null) {
            return null;
        }
        if (checkForDuplicatePlugins) {
            IJ.runPlugIn("ij.plugin.ClassChecker", "");
            checkForDuplicatePlugins = false;
        }
        if (bl) {
            classLoader = null;
        }
        ClassLoader classLoader = IJ.getClassLoader();
        Object var5_5 = null;
        try {
            var5_5 = classLoader.loadClass(string2).newInstance();
            if (var5_5 instanceof PlugIn) {
                ((PlugIn)var5_5).run(string3);
            } else if (var5_5 instanceof PlugInFilter) {
                new PlugInFilterRunner(var5_5, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string2.indexOf(95) != -1 && !suppressPluginNotFoundError) {
                IJ.error("Plugin or class not found: \"" + string2 + "\"\n(" + classNotFoundException + ")");
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            int n = string2.indexOf(46);
            if (n >= 0) {
                return IJ.runUserPlugIn(string, string2.substring(n + 1), string3, bl);
            }
            if (string2.indexOf(95) != -1 && !suppressPluginNotFoundError) {
                IJ.error("Plugin or class not found: \"" + string2 + "\"\n(" + noClassDefFoundError + ")");
            }
        }
        catch (InstantiationException instantiationException) {
            IJ.error("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.error("Unable to load plugin, possibly \nbecause it is not public.");
        }
        if (redirectErrorMessages && !"HandleExtraFileTypes".equals(string2)) {
            redirectErrorMessages = false;
        }
        suppressPluginNotFoundError = false;
        return var5_5;
    }

    static void wrongType(int n, String string) {
        String string2 = "\"" + string + "\" requires an image of type:\n \n";
        if ((n & 1) != 0) {
            string2 = string2 + "    8-bit grayscale\n";
        }
        if ((n & 2) != 0) {
            string2 = string2 + "    8-bit color\n";
        }
        if ((n & 4) != 0) {
            string2 = string2 + "    16-bit grayscale\n";
        }
        if ((n & 8) != 0) {
            string2 = string2 + "    32-bit (float) grayscale\n";
        }
        if ((n & 0x10) != 0) {
            string2 = string2 + "    RGB color\n";
        }
        IJ.error(string2);
    }

    public static void doCommand(String string) {
        if (ij != null) {
            ij.doCommand(string);
        }
    }

    public static void run(String string) {
        IJ.run(string, null);
    }

    public static void run(String string, String string2) {
        Object object;
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro.abort = false;
        Macro.setOptions(string2);
        Thread thread = Thread.currentThread();
        if (!(previousThread != null && thread == previousThread || ((String)(object = thread.getName())).startsWith("Run$_"))) {
            thread.setName("Run$_" + (String)object);
        }
        string = IJ.convert(string);
        previousThread = thread;
        macroRunning = true;
        object = new Executer(string);
        ((Executer)object).run();
        macroRunning = false;
        Macro.setOptions(null);
        IJ.testAbort();
    }

    private static String convert(String string) {
        String string2;
        if (commandTable == null) {
            commandTable = new Hashtable(23);
            commandTable.put("New...", "Image...");
            commandTable.put("Threshold", "Make Binary");
            commandTable.put("Display...", "Appearance...");
            commandTable.put("Start Animation", "Start Animation [\\]");
            commandTable.put("Convert Images to Stack", "Images to Stack");
            commandTable.put("Convert Stack to Images", "Stack to Images");
            commandTable.put("Convert Stack to RGB", "Stack to RGB");
            commandTable.put("Convert to Composite", "Make Composite");
            commandTable.put("New HyperStack...", "New Hyperstack...");
            commandTable.put("Stack to HyperStack...", "Stack to Hyperstack...");
            commandTable.put("HyperStack to Stack", "Hyperstack to Stack");
            commandTable.put("RGB Split", "Split Channels");
            commandTable.put("RGB Merge...", "Merge Channels...");
            commandTable.put("Channels...", "Channels Tool...");
            commandTable.put("New... ", "Table...");
            commandTable.put("Arbitrarily...", "Rotate... ");
            commandTable.put("Measurements...", "Results... ");
            commandTable.put("List Commands...", "Find Commands...");
            commandTable.put("Capture Screen ", "Capture Screen");
            commandTable.put("Add to Manager ", "Add to Manager");
            commandTable.put("In", "In [+]");
            commandTable.put("Out", "Out [-]");
        }
        if ((string2 = (String)commandTable.get(string)) != null) {
            return string2;
        }
        return string;
    }

    public static void run(ImagePlus imagePlus, String string, String string2) {
        if (imagePlus != null) {
            ImagePlus imagePlus2 = WindowManager.getTempCurrentImage();
            WindowManager.setTempCurrentImage(imagePlus);
            IJ.run(string, string2);
            WindowManager.setTempCurrentImage(imagePlus2);
        } else {
            IJ.run(string, string2);
        }
    }

    static void init() {
        Menus menus = new Menus(null, null);
        Prefs.load(menus, null);
        menus.addMenuBar();
    }

    private static void testAbort() {
        if (Macro.abort) {
            IJ.abort();
        }
    }

    public static boolean macroRunning() {
        return macroRunning;
    }

    public static boolean isMacro() {
        return macroRunning || Interpreter.getInstance() != null;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String string) {
        ImagePlus imagePlus;
        ImageCanvas imageCanvas;
        if (ij != null) {
            ij.showStatus(string);
        }
        ImageCanvas imageCanvas2 = imageCanvas = (imagePlus = WindowManager.getCurrentImage()) != null ? imagePlus.getCanvas() : null;
        if (imageCanvas != null) {
            imageCanvas.setShowCursorStatus(string.length() == 0);
        }
    }

    public static void write(String string) {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        if (textPanel != null) {
            textPanel.append(string);
        } else {
            System.out.println(string);
        }
    }

    private static void showResults() {
        TextWindow textWindow = new TextWindow("Results", "", 400, 250);
        textPanel = textWindow.getTextPanel();
        textPanel.setResultsTable(Analyzer.getResultsTable());
    }

    public static synchronized void log(String string) {
        if (string == null) {
            return;
        }
        if (logPanel == null && ij != null) {
            TextWindow textWindow = new TextWindow("Log", "", 400, 250);
            logPanel = textWindow.getTextPanel();
            logPanel.setFont(new Font("SansSerif", 0, 16));
        }
        if (logPanel != null) {
            if (string.startsWith("\\")) {
                IJ.handleLogCommand(string);
            } else {
                logPanel.append(string);
            }
        } else {
            System.out.println(string);
        }
    }

    static void handleLogCommand(String string) {
        if (string.equals("\\Closed")) {
            logPanel = null;
        } else if (string.startsWith("\\Update:")) {
            int n = logPanel.getLineCount();
            String string2 = string.substring(8, string.length());
            if (n == 0) {
                logPanel.append(string2);
            } else {
                logPanel.setLine(n - 1, string2);
            }
        } else if (string.startsWith("\\Update")) {
            int n = string.indexOf(":");
            if (n == -1) {
                logPanel.append(string);
                return;
            }
            String string3 = string.substring(7, n);
            int n2 = (int)Tools.parseDouble(string3, -1.0);
            if (n2 < 0 || n2 > 25) {
                logPanel.append(string);
                return;
            }
            for (int i = logPanel.getLineCount(); n2 >= i; ++i) {
                IJ.log("");
            }
            String string4 = string.substring(n + 1, string.length());
            logPanel.setLine(n2, string4);
        } else if (string.equals("\\Clear")) {
            logPanel.clear();
        } else if (string.equals("\\Close")) {
            Frame frame = WindowManager.getFrame("Log");
            if (frame != null && frame instanceof TextWindow) {
                ((TextWindow)frame).close();
            }
        } else {
            logPanel.append(string);
        }
    }

    public static synchronized String getLog() {
        if (logPanel == null || ij == null) {
            return null;
        }
        return logPanel.getText();
    }

    public static void setColumnHeadings(String string) {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        if (textPanel != null) {
            textPanel.setColumnHeadings(string);
        } else {
            System.out.println(string);
        }
    }

    public static boolean isResultsWindow() {
        return textPanel != null;
    }

    public static void renameResults(String string) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextWindow textWindow = (TextWindow)frame;
            if (textWindow.getTextPanel().getResultsTable() == null) {
                IJ.error("Rename", "\"" + textWindow.getTitle() + "\" is not a results table");
                return;
            }
            textWindow.rename(string);
        } else if (IJ.isResultsWindow()) {
            TextPanel textPanel = IJ.getTextPanel();
            TextWindow textWindow = (TextWindow)textPanel.getParent();
            textWindow.rename(string);
        }
    }

    public static void deleteRows(int n, int n2) {
        int n3 = n2 - n + 1;
        ResultsTable resultsTable = Analyzer.getResultsTable();
        for (int i = n; i < n + n3; ++i) {
            resultsTable.deleteRow(n);
        }
        resultsTable.show("Results");
    }

    public static TextPanel getTextPanel() {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        return textPanel;
    }

    public static void setTextPanel(TextPanel textPanel) {
        IJ.textPanel = textPanel;
    }

    public static void noImage() {
        IJ.error("No Image", "There are no images open.");
    }

    public static void outOfMemory(String string) {
        Undo.reset();
        System.gc();
        String string2 = Runtime.getRuntime().totalMemory() / 0x100000L + "MB";
        if (!memMessageDisplayed) {
            IJ.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        IJ.log("<Out of memory>");
        if (!memMessageDisplayed) {
            IJ.log("<All available memory (" + string2 + ") has been>");
            IJ.log("<used. Instructions for making more>");
            IJ.log("<available can be found in the \"Memory\" >");
            IJ.log("<sections of the installation notes at>");
            IJ.log("<http://imagej.nih.gov/ij/docs/install/>");
            IJ.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
            memMessageDisplayed = true;
        }
        Macro.abort();
    }

    public static void showProgress(double d) {
        if (progressBar != null) {
            progressBar.show(d, false);
        }
    }

    public static void showProgress(int n, int n2) {
        if (progressBar != null) {
            progressBar.show(n, n2);
            if (n == n2) {
                progressBar.setBatchMode(false);
            }
        }
    }

    public static void showMessage(String string) {
        IJ.showMessage("Message", string);
    }

    public static void showMessage(String string, String string2) {
        if (ij != null) {
            if (string2 != null && string2.startsWith("<html>")) {
                new HTMLDialog(string, string2);
            } else {
                new MessageDialog((Frame)ij, string, string2);
            }
        } else {
            System.out.println(string2);
        }
    }

    public static void error(String string) {
        IJ.error(null, string);
        if (Thread.currentThread().getName().endsWith("JavaScript")) {
            throw new RuntimeException("Macro canceled");
        }
        Macro.abort();
    }

    public static void error(String string, String string2) {
        boolean bl;
        String string3 = string != null ? string : "ImageJ";
        boolean bl2 = bl = string != null;
        if (redirectErrorMessages || redirectErrorMessages2) {
            IJ.log(string3 + ": " + string2);
            if (bl && (string.equals("Opener") || string.equals("Open URL") || string.equals("DicomDecoder"))) {
                bl = false;
            }
        } else {
            IJ.showMessage(string3, string2);
        }
        redirectErrorMessages = false;
        if (bl) {
            Macro.abort();
        }
    }

    public static boolean showMessageWithCancel(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addMessage(string2);
        genericDialog.showDialog();
        return !genericDialog.wasCanceled();
    }

    public static double getNumber(String string, double d) {
        GenericDialog genericDialog = new GenericDialog("");
        int n = (double)((int)d) == d ? 0 : 2;
        genericDialog.addNumericField(string, d, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return -2.147483648E9;
        }
        double d2 = genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            return d;
        }
        return d2;
    }

    public static String getString(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog("");
        genericDialog.addStringField(string, string2, 20);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return "";
        }
        return genericDialog.getNextString();
    }

    public static void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        long l = IJ.currentMemory();
        String string = l < 10240000L ? l / 1024L + "K" : l / 0x100000L + "MB";
        String string2 = "";
        long l2 = IJ.maxMemory();
        if (l2 > 0L) {
            double d = l * 100L / l2;
            string2 = " of " + l2 / 0x100000L + "MB (" + (d < 1.0 ? "<1" : IJ.d2s(d, 0)) + "%)";
        }
        return string + string2;
    }

    public static long currentMemory() {
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        return l2 - l;
    }

    public static long maxMemory() {
        Memory memory;
        if (maxMemory == 0L && (maxMemory = (memory = new Memory()).getMemorySetting()) == 0L) {
            maxMemory = memory.maxMemory();
        }
        return maxMemory;
    }

    public static void showTime(ImagePlus imagePlus, long l, String string) {
        IJ.showTime(imagePlus, l, string, 1);
    }

    public static void showTime(ImagePlus imagePlus, long l, String string, int n) {
        if (Interpreter.isBatchMode()) {
            return;
        }
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        double d2 = (double)imagePlus.getWidth() * (double)imagePlus.getHeight();
        double d3 = d2 * (double)n / d;
        String string2 = d3 > 1.0E9 ? "" : (d3 < 1000000.0 ? ", " + IJ.d2s(d3, 0) + " pixels/second" : ", " + IJ.d2s(d3 / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(string + d + " seconds" + string2);
    }

    public static String time(ImagePlus imagePlus, long l) {
        double d = imagePlus.getStackSize();
        double d2 = (double)(System.nanoTime() - l) / 1.0E9;
        double d3 = (double)(imagePlus.getWidth() * imagePlus.getHeight()) * d / 1000000.0;
        String string = d2 < 1.0 ? IJ.d2s(d2 * 1000.0, 0) + " ms" : IJ.d2s(d2, 1) + " seconds";
        return string + ", " + IJ.d2s(d3 / d2, 1) + " million pixels/second";
    }

    public static String d2s(double d) {
        return IJ.d2s(d, 2);
    }

    public static String d2s(double d, int n) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return "" + d;
        }
        if (d == 3.4028234663852886E38) {
            return "3.4e38";
        }
        double d2 = d;
        if (d < 0.0) {
            d2 = -d;
        }
        if (df == null) {
            dfs = new DecimalFormatSymbols(Locale.US);
            df = new DecimalFormat[10];
            IJ.df[0] = new DecimalFormat("0", dfs);
            IJ.df[1] = new DecimalFormat("0.0", dfs);
            IJ.df[2] = new DecimalFormat("0.00", dfs);
            IJ.df[3] = new DecimalFormat("0.000", dfs);
            IJ.df[4] = new DecimalFormat("0.0000", dfs);
            IJ.df[5] = new DecimalFormat("0.00000", dfs);
            IJ.df[6] = new DecimalFormat("0.000000", dfs);
            IJ.df[7] = new DecimalFormat("0.0000000", dfs);
            IJ.df[8] = new DecimalFormat("0.00000000", dfs);
            IJ.df[9] = new DecimalFormat("0.000000000", dfs);
        }
        if (n < 0) {
            if ((n = -n) > 9) {
                n = 9;
            }
            if (sf == null) {
                sf = new DecimalFormat[10];
                IJ.sf[1] = new DecimalFormat("0.0E0", dfs);
                IJ.sf[2] = new DecimalFormat("0.00E0", dfs);
                IJ.sf[3] = new DecimalFormat("0.000E0", dfs);
                IJ.sf[4] = new DecimalFormat("0.0000E0", dfs);
                IJ.sf[5] = new DecimalFormat("0.00000E0", dfs);
                IJ.sf[6] = new DecimalFormat("0.000000E0", dfs);
                IJ.sf[7] = new DecimalFormat("0.0000000E0", dfs);
                IJ.sf[8] = new DecimalFormat("0.00000000E0", dfs);
                IJ.sf[9] = new DecimalFormat("0.000000000E0", dfs);
            }
            return sf[n].format(d);
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 9) {
            n = 9;
        }
        return df[n].format(d);
    }

    public static String pad(int n, int n2) {
        String string = "" + n;
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static void register(Class clazz) {
        if (ij != null) {
            ij.register(clazz);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean controlKeyDown() {
        return controlDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    public static boolean shiftKeyDown() {
        return shiftDown;
    }

    public static void setKeyDown(int n) {
        if (debugMode) {
            IJ.log("setKeyDown: " + n);
        }
        switch (n) {
            case 17: {
                controlDown = true;
                break;
            }
            case 157: {
                if (!IJ.isMacintosh()) break;
                controlDown = true;
                break;
            }
            case 18: {
                altDown = true;
                break;
            }
            case 16: {
                shiftDown = true;
                if (!debugMode) break;
                IJ.beep();
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1, -1, -1);
                break;
            }
            case 27: {
                escapePressed = true;
            }
        }
    }

    public static void setKeyUp(int n) {
        if (debugMode) {
            IJ.log("setKeyUp: " + n);
        }
        switch (n) {
            case 17: {
                controlDown = false;
                break;
            }
            case 157: {
                if (!IJ.isMacintosh()) break;
                controlDown = false;
                break;
            }
            case 18: {
                altDown = false;
                break;
            }
            case 16: {
                shiftDown = false;
                if (!debugMode) break;
                IJ.beep();
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1, -1, -1);
                break;
            }
            case -1: {
                spaceDown = false;
                altDown = false;
                controlDown = false;
                shiftDown = false;
            }
        }
    }

    public static void setInputEvent(InputEvent inputEvent) {
        altDown = inputEvent.isAltDown();
        shiftDown = inputEvent.isShiftDown();
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return IJ.isMacintosh();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isJava2() {
        return isJava2;
    }

    public static boolean isJava14() {
        return isJava14;
    }

    public static boolean isJava15() {
        return isJava15;
    }

    public static boolean isJava16() {
        return isJava16;
    }

    public static boolean isJava17() {
        return isJava17;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isVista() {
        return isVista;
    }

    public static boolean is64Bit() {
        if (osarch == null) {
            osarch = System.getProperty("os.arch");
        }
        return osarch != null && osarch.indexOf("64") != -1;
    }

    public static boolean versionLessThan(String string) {
        boolean bl;
        boolean bl2 = bl = "1.45r".compareTo(string) < 0;
        if (bl) {
            IJ.error("This plugin or macro requires ImageJ " + string + " or later. Use\nHelp>Update ImageJ to upgrade to the latest version.");
        }
        return bl;
    }

    public static int setupDialog(ImagePlus imagePlus, int n) {
        if (imagePlus == null || ij != null && IJ.ij.hotkey) {
            return n;
        }
        int n2 = imagePlus.getStackSize();
        if (n2 > 1) {
            if (imagePlus.isComposite() && ((CompositeImage)imagePlus).getMode() == 1) {
                return n + 32;
            }
            String string = Macro.getOptions();
            if (string != null) {
                if (string.indexOf("stack ") >= 0) {
                    return n + 32;
                }
                return n;
            }
            if (hideProcessStackDialog) {
                return n;
            }
            String string2 = (n & 0x80) == 0 ? " There is\nno Undo if you select \"Yes\"." : "";
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + n2 + " images?" + string2);
            if (yesNoCancelDialog.cancelPressed()) {
                return 4096;
            }
            if (yesNoCancelDialog.yesPressed()) {
                if (imagePlus.getStack().isVirtual() && (n & 0x80) == 0) {
                    int n3 = (n2 * imagePlus.getWidth() * imagePlus.getHeight() * imagePlus.getBytesPerPixel() + 524288) / 0x100000;
                    String string3 = "Use the Process>Batch>Virtual Stack command\nto process a virtual stack ike this one or convert\nit to a normal stack using Image>Duplicate, which\nwill require " + n3 + "MB of additional memory.";
                    IJ.error(string3);
                    return 4096;
                }
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return n + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return n;
    }

    public static void makeRectangle(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 < 0) {
            IJ.getImage().killRoi();
        } else {
            ImagePlus imagePlus = IJ.getImage();
            if (Interpreter.isBatchMode()) {
                imagePlus.setRoi(new Roi(n, n2, n3, n4), false);
            } else {
                imagePlus.setRoi(n, n2, n3, n4);
            }
        }
    }

    public static void makeOval(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 < 0) {
            IJ.getImage().killRoi();
        } else {
            ImagePlus imagePlus = IJ.getImage();
            imagePlus.setRoi(new OvalRoi(n, n2, n3, n4));
        }
    }

    public static void makeLine(int n, int n2, int n3, int n4) {
        IJ.getImage().setRoi(new Line(n, n2, n3, n4));
    }

    public static void makePoint(int n, int n2) {
        ImagePlus imagePlus = IJ.getImage();
        Roi roi = imagePlus.getRoi();
        if (IJ.shiftKeyDown() && roi != null && roi.getType() == 10) {
            Polygon polygon = roi.getPolygon();
            polygon.addPoint(n, n2);
            imagePlus.setRoi(new PointRoi(polygon.xpoints, polygon.ypoints, polygon.npoints));
            IJ.setKeyUp(16);
        } else if (IJ.altKeyDown() && roi != null && roi.getType() == 10) {
            ((PolygonRoi)roi).deleteHandle(n, n2);
            IJ.setKeyUp(18);
        } else {
            imagePlus.setRoi(new PointRoi(n, n2));
        }
    }

    public static void makeLine(double d, double d2, double d3, double d4) {
        IJ.getImage().setRoi(new Line(d, d2, d3, d4));
    }

    public static void setMinAndMax(double d, double d2) {
        IJ.setMinAndMax(IJ.getImage(), d, d2, 7);
    }

    public static void setMinAndMax(ImagePlus imagePlus, double d, double d2) {
        IJ.setMinAndMax(imagePlus, d, d2, 7);
    }

    public static void setMinAndMax(double d, double d2, int n) {
        IJ.setMinAndMax(IJ.getImage(), d, d2, n);
    }

    private static void setMinAndMax(ImagePlus imagePlus, double d, double d2, int n) {
        Calibration calibration = imagePlus.getCalibration();
        d = calibration.getRawValue(d);
        d2 = calibration.getRawValue(d2);
        if (n == 7) {
            imagePlus.setDisplayRange(d, d2);
        } else {
            imagePlus.setDisplayRange(d, d2, n);
        }
        imagePlus.updateAndDraw();
    }

    public static void resetMinAndMax() {
        IJ.resetMinAndMax(IJ.getImage());
    }

    public static void resetMinAndMax(ImagePlus imagePlus) {
        imagePlus.resetDisplayRange();
        imagePlus.updateAndDraw();
    }

    public static void setThreshold(double d, double d2) {
        IJ.setThreshold(d, d2, null);
    }

    public static void setThreshold(double d, double d2, String string) {
        IJ.setThreshold(IJ.getImage(), d, d2, string);
    }

    public static void setThreshold(ImagePlus imagePlus, double d, double d2) {
        IJ.setThreshold(imagePlus, d, d2, "Red");
    }

    public static void setThreshold(ImagePlus imagePlus, double d, double d2, String string) {
        int n = 0;
        if (string != null) {
            if ((string = string.toLowerCase(Locale.US)).indexOf("black") != -1) {
                n = 1;
            } else if (string.indexOf("over") != -1) {
                n = 3;
            } else if (string.indexOf("no") != -1) {
                n = 2;
            }
        }
        Calibration calibration = imagePlus.getCalibration();
        d = calibration.getRawValue(d);
        d2 = calibration.getRawValue(d2);
        imagePlus.getProcessor().setThreshold(d, d2, n);
        if (n != 2) {
            imagePlus.getProcessor().setLutAnimation(true);
            imagePlus.updateAndDraw();
        }
    }

    public static void setAutoThreshold(ImagePlus imagePlus, String string) {
        block6: {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (imageProcessor instanceof ColorProcessor) {
                throw new IllegalArgumentException("Non-RGB image required");
            }
            imageProcessor.setRoi(imagePlus.getRoi());
            if (string != null) {
                try {
                    if (string.indexOf("stack") != -1) {
                        IJ.setStackThreshold(imagePlus, imageProcessor, string);
                        break block6;
                    }
                    imageProcessor.setAutoThreshold(string);
                }
                catch (Exception exception) {
                    IJ.log(exception.getMessage());
                }
            } else {
                imageProcessor.setAutoThreshold(1, 0);
            }
        }
        imagePlus.updateAndDraw();
    }

    private static void setStackThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, String string) {
        double d;
        double d2;
        boolean bl = string.indexOf("dark") != -1;
        StackStatistics stackStatistics = new StackStatistics(imagePlus);
        AutoThresholder autoThresholder = new AutoThresholder();
        double d3 = 0.0;
        double d4 = 255.0;
        if (imagePlus.getBitDepth() != 8) {
            d3 = stackStatistics.min;
            d4 = stackStatistics.max;
        }
        int n = autoThresholder.getThreshold(string, stackStatistics.histogram);
        if (bl) {
            if (imageProcessor.isInvertedLut()) {
                d2 = 0.0;
                d = n;
            } else {
                d2 = n + 1;
                d = 255.0;
            }
        } else if (imageProcessor.isInvertedLut()) {
            d2 = n + 1;
            d = 255.0;
        } else {
            d2 = 0.0;
            d = n;
        }
        if (d2 > 255.0) {
            d2 = 255.0;
        }
        if (d4 > d3) {
            d2 = d3 + d2 / 255.0 * (d4 - d3);
            d = d3 + d / 255.0 * (d4 - d3);
        } else {
            d2 = d = d3;
        }
        imageProcessor.setMinAndMax(d3, d4);
        imageProcessor.setThreshold(d2, d, 0);
        imagePlus.updateAndDraw();
    }

    public static void resetThreshold() {
        IJ.resetThreshold(IJ.getImage());
    }

    public static void resetThreshold(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.resetThreshold();
        imageProcessor.setLutAnimation(true);
        imagePlus.updateAndDraw();
    }

    public static void selectWindow(int n) {
        ImagePlus imagePlus;
        if (n > 0) {
            n = WindowManager.getNthImageID(n);
        }
        if ((imagePlus = WindowManager.getImage(n)) == null) {
            IJ.error("Macro Error", "Image " + n + " not found or no images are open.");
        }
        if (Interpreter.isBatchMode()) {
            ImagePlus imagePlus2 = WindowManager.getCurrentImage();
            if (imagePlus2 != null && imagePlus2 != imagePlus) {
                imagePlus2.saveRoi();
            }
        } else {
            ImageWindow imageWindow = imagePlus.getWindow();
            imageWindow.toFront();
            WindowManager.setWindow(imageWindow);
            long l = System.currentTimeMillis();
            String string = Thread.currentThread().getName();
            int n2 = string != null && string.indexOf("EventQueue") != -1 ? 0 : 2000;
            do {
                IJ.wait(10);
                imagePlus = WindowManager.getCurrentImage();
                if (imagePlus == null || imagePlus.getID() != n) continue;
                return;
            } while (System.currentTimeMillis() - l <= (long)n2);
            WindowManager.setCurrentWindow(imageWindow);
            return;
        }
        WindowManager.setTempCurrentImage(imagePlus);
        WindowManager.setWindow(null);
    }

    public static void selectWindow(String string) {
        if (string.equals("ImageJ") && ij != null) {
            ij.toFront();
            return;
        }
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 3000L) {
            Frame frame = WindowManager.getFrame(string);
            if (frame != null && !(frame instanceof ImageWindow)) {
                IJ.selectWindow(frame);
                return;
            }
            int[] nArray = WindowManager.getIDList();
            int n = nArray != null ? nArray.length : 0;
            for (int i = 0; i < n; ++i) {
                ImagePlus imagePlus = WindowManager.getImage(nArray[i]);
                if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
                IJ.selectWindow(imagePlus.getID());
                return;
            }
            IJ.wait(10);
        }
        IJ.error("Macro Error", "No window with the title \"" + string + "\" found.");
    }

    static void selectWindow(Frame frame) {
        frame.toFront();
        long l = System.currentTimeMillis();
        do {
            IJ.wait(10);
            if (WindowManager.getFrontWindow() != frame) continue;
            return;
        } while (System.currentTimeMillis() - l <= 1000L);
        WindowManager.setWindow(frame);
    }

    public static void setForegroundColor(int n, int n2, int n3) {
        IJ.setColor(n, n2, n3, true);
    }

    public static void setBackgroundColor(int n, int n2, int n3) {
        IJ.setColor(n, n2, n3, false);
    }

    static void setColor(int n, int n2, int n3, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        Color color = new Color(n, n2, n3);
        if (bl) {
            Toolbar.setForegroundColor(color);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.getProcessor().setColor(color);
            }
        } else {
            Toolbar.setBackgroundColor(color);
        }
    }

    public static void setTool(int n) {
        Toolbar.getInstance().setTool(n);
    }

    public static boolean setTool(String string) {
        return Toolbar.getInstance().setTool(string);
    }

    public static String getToolName() {
        return Toolbar.getToolName();
    }

    public static int doWand(int n, int n2) {
        return IJ.doWand(IJ.getImage(), n, n2, 0.0, null);
    }

    public static int doWand(int n, int n2, double d, String string) {
        return IJ.doWand(IJ.getImage(), n, n2, d, string);
    }

    public static int doWand(ImagePlus imagePlus, int n, int n2, double d, String string) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imagePlus.getType() == 2 && Double.isNaN(imageProcessor.getPixelValue(n, n2))) {
            return 0;
        }
        int n3 = 1;
        if (string != null) {
            if (string.startsWith("4")) {
                n3 = 4;
            } else if (string.startsWith("8")) {
                n3 = 8;
            }
        }
        Wand wand = new Wand(imageProcessor);
        double d2 = imageProcessor.getMinThreshold();
        if (d2 == -808080.0 || imageProcessor.getLutUpdateMode() == 2 && d > 0.0) {
            wand.autoOutline(n, n2, d, n3);
        } else {
            wand.autoOutline(n, n2, d2, imageProcessor.getMaxThreshold(), n3);
        }
        if (wand.npoints > 0) {
            Roi roi = imagePlus.getRoi();
            int n4 = Wand.allPoints() ? 3 : 4;
            PolygonRoi polygonRoi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, n4);
            imagePlus.killRoi();
            imagePlus.setRoi(polygonRoi);
            if (roi != null) {
                polygonRoi.update(IJ.shiftKeyDown(), IJ.altKeyDown());
            }
        }
        return wand.npoints;
    }

    public static void setPasteMode(String string) {
        string = string.toLowerCase(Locale.US);
        int n = 0;
        if (string.startsWith("ble") || string.startsWith("ave")) {
            n = 7;
        } else if (string.startsWith("diff")) {
            n = 8;
        } else if (string.indexOf("zero") != -1) {
            n = 14;
        } else if (string.startsWith("tran")) {
            n = 2;
        } else if (string.startsWith("and")) {
            n = 9;
        } else if (string.startsWith("or")) {
            n = 10;
        } else if (string.startsWith("xor")) {
            n = 11;
        } else if (string.startsWith("sub")) {
            n = 4;
        } else if (string.startsWith("add")) {
            n = 3;
        } else if (string.startsWith("div")) {
            n = 6;
        } else if (string.startsWith("mul")) {
            n = 5;
        } else if (string.startsWith("min")) {
            n = 12;
        } else if (string.startsWith("max")) {
            n = 13;
        }
        Roi.setPasteMode(n);
    }

    public static ImagePlus getImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            if (ij == null) {
                System.exit(0);
            } else {
                IJ.abort();
            }
        }
        return imagePlus;
    }

    public static void setSlice(int n) {
        IJ.getImage().setSlice(n);
    }

    public static String getVersion() {
        return "1.45r";
    }

    public static String getDirectory(String string) {
        if (string.equals("plugins")) {
            return Menus.getPlugInsPath();
        }
        if (string.equals("macros")) {
            return Menus.getMacrosPath();
        }
        if (string.equals("luts")) {
            String string2 = IJ.getIJDir();
            if (string2 != null) {
                return string2 + "luts" + File.separator;
            }
            return null;
        }
        if (string.equals("home")) {
            return System.getProperty("user.home") + File.separator;
        }
        if (string.equals("startup")) {
            return Prefs.getHomeDir() + File.separator;
        }
        if (string.equals("imagej")) {
            return IJ.getIJDir();
        }
        if (string.equals("current")) {
            return OpenDialog.getDefaultDirectory();
        }
        if (string.equals("temp")) {
            String string3 = System.getProperty("java.io.tmpdir");
            if (IJ.isMacintosh()) {
                string3 = "/tmp/";
            }
            if (string3 != null && !string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            return string3;
        }
        if (string.equals("image")) {
            FileInfo fileInfo;
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            FileInfo fileInfo2 = fileInfo = imagePlus != null ? imagePlus.getOriginalFileInfo() : null;
            if (fileInfo != null && fileInfo.directory != null) {
                return fileInfo.directory;
            }
            return null;
        }
        DirectoryChooser directoryChooser = new DirectoryChooser(string);
        String string4 = directoryChooser.getDirectory();
        if (string4 == null) {
            Macro.abort();
        }
        return string4;
    }

    private static String getIJDir() {
        String string = Menus.getPlugInsPath();
        if (string == null) {
            return null;
        }
        String string2 = new File(string).getParent();
        if (string2 != null) {
            string2 = string2 + File.separator;
        }
        return string2;
    }

    public static void open() {
        IJ.open(null);
    }

    public static void open(String string) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Opener opener = new Opener();
        macroRunning = true;
        if (string == null || string.equals("")) {
            opener.open();
        } else {
            opener.open(string);
        }
        macroRunning = false;
    }

    public static void open(String string, int n) {
        ImagePlus imagePlus;
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        if ((imagePlus = IJ.openImage(string, n)) != null) {
            imagePlus.show();
        }
    }

    public static ImagePlus openImage(String string) {
        return new Opener().openImage(string);
    }

    public static ImagePlus openImage(String string, int n) {
        return new Opener().openImage(string, n);
    }

    public static ImagePlus openImage() {
        return IJ.openImage(null);
    }

    public static String openUrlAsString(String string) {
        StringBuffer stringBuffer = null;
        string = string.replaceAll(" ", "%20");
        try {
            String string2;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getContentLength();
            if (l > 0x100000L) {
                return "<Error: file is larger than 1MB>";
            }
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            inputStream.close();
        }
        catch (Exception exception) {
            return "<Error: " + exception + ">";
        }
        if (stringBuffer != null) {
            return new String(stringBuffer);
        }
        return "";
    }

    public static void save(String string) {
        IJ.save(null, string);
    }

    public static void save(ImagePlus imagePlus, String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            ImagePlus imagePlus2 = imagePlus;
            if (imagePlus2 == null) {
                imagePlus2 = WindowManager.getCurrentImage();
            }
            String string2 = imagePlus2 != null ? imagePlus2.getTitle() : null;
            IJ.saveAs(imagePlus, string.substring(n + 1), string);
            if (string2 != null) {
                imagePlus2.setTitle(string2);
            }
        } else {
            IJ.error("The file path passed to IJ.save() method or save()\nmacro function is missing the required extension.\n \n\"" + string + "\"");
        }
    }

    public static void saveAs(String string, String string2) {
        IJ.saveAs(null, string, string2);
    }

    public static void saveAs(ImagePlus imagePlus, String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if ((string = string.toLowerCase(Locale.US)).indexOf("tif") != -1) {
            if (string2 != null && !string2.endsWith(".tiff")) {
                string2 = IJ.updateExtension(string2, ".tif");
            }
            string = "Tiff...";
        } else if (string.indexOf("jpeg") != -1 || string.indexOf("jpg") != -1) {
            string2 = IJ.updateExtension(string2, ".jpg");
            string = "Jpeg...";
        } else if (string.indexOf("gif") != -1) {
            string2 = IJ.updateExtension(string2, ".gif");
            string = "Gif...";
        } else if (string.indexOf("text image") != -1) {
            string2 = IJ.updateExtension(string2, ".txt");
            string = "Text Image...";
        } else if (string.indexOf("text") != -1 || string.indexOf("txt") != -1) {
            if (string2 != null && !string2.endsWith(".xls")) {
                string2 = IJ.updateExtension(string2, ".txt");
            }
            string = "Text...";
        } else if (string.indexOf("zip") != -1) {
            string2 = IJ.updateExtension(string2, ".zip");
            string = "ZIP...";
        } else if (string.indexOf("raw") != -1) {
            string = "Raw Data...";
        } else if (string.indexOf("avi") != -1) {
            string2 = IJ.updateExtension(string2, ".avi");
            string = "AVI... ";
        } else if (string.indexOf("bmp") != -1) {
            string2 = IJ.updateExtension(string2, ".bmp");
            string = "BMP...";
        } else if (string.indexOf("fits") != -1) {
            string2 = IJ.updateExtension(string2, ".fits");
            string = "FITS...";
        } else if (string.indexOf("png") != -1) {
            string2 = IJ.updateExtension(string2, ".png");
            string = "PNG...";
        } else if (string.indexOf("pgm") != -1) {
            string2 = IJ.updateExtension(string2, ".pgm");
            string = "PGM...";
        } else if (string.indexOf("lut") != -1) {
            string2 = IJ.updateExtension(string2, ".lut");
            string = "LUT...";
        } else if (string.indexOf("results") != -1 || string.indexOf("measurements") != -1) {
            string = "Results...";
        } else if (string.indexOf("selection") != -1 || string.indexOf("roi") != -1) {
            string2 = IJ.updateExtension(string2, ".roi");
            string = "Selection...";
        } else if (string.indexOf("xy") != -1 || string.indexOf("coordinates") != -1) {
            string2 = IJ.updateExtension(string2, ".txt");
            string = "XY Coordinates...";
        } else {
            IJ.error("Unsupported save() or saveAs() file format: \"" + string + "\"\n \n\"" + string2 + "\"");
        }
        if (string2 == null) {
            IJ.run(string);
        } else {
            IJ.run(imagePlus, string, "save=[" + string2 + "]");
        }
    }

    static String updateExtension(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        int n2 = string.lastIndexOf(File.separator);
        string = n >= 0 && n > n2 && string.length() - n <= 5 ? (n + 1 < string.length() && Character.isDigit(string.charAt(n + 1)) ? string + string2 : string.substring(0, n) + string2) : string + string2;
        return string;
    }

    public static String saveString(String string, String string2) {
        return IJ.write(string, string2, false);
    }

    public static String append(String string, String string2) {
        return IJ.write(string + "\n", string2, true);
    }

    private static String write(String string, String string2, boolean bl) {
        Object object;
        if (string2 == null || string2.equals("")) {
            object = bl ? "Append String..." : "Save String...";
            SaveDialog saveDialog = new SaveDialog((String)object, "Untitled", ".txt");
            String string3 = saveDialog.getFileName();
            if (string3 == null) {
                return null;
            }
            string2 = saveDialog.getDirectory() + string3;
        }
        try {
            object = new BufferedWriter(new FileWriter(string2, bl));
            ((Writer)object).write(string);
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            return "" + iOException;
        }
        return null;
    }

    public static String openAsString(String string) {
        CharSequence charSequence;
        Object object;
        Object object2;
        if (string == null || string.equals("")) {
            object2 = new OpenDialog("Open Text File", "");
            object = ((OpenDialog)object2).getDirectory();
            charSequence = ((OpenDialog)object2).getFileName();
            if (charSequence == null) {
                return null;
            }
            string = (String)object + (String)charSequence;
        }
        object2 = "";
        object = new File(string);
        if (!((File)object).exists()) {
            return "Error: file not found";
        }
        try {
            String string2;
            charSequence = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object));
            while ((string2 = bufferedReader.readLine()) != null) {
                ((StringBuffer)charSequence).append(string2 + "\n");
            }
            bufferedReader.close();
            object2 = new String((StringBuffer)charSequence);
        }
        catch (Exception exception) {
            object2 = "Error: " + exception.getMessage();
        }
        return object2;
    }

    public static ImagePlus createImage(String string, String string2, int n, int n2, int n3) {
        string2 = string2.toLowerCase(Locale.US);
        int n4 = 8;
        if (string2.indexOf("16") != -1) {
            n4 = 16;
        }
        if (string2.indexOf("24") != -1 || string2.indexOf("rgb") != -1) {
            n4 = 24;
        }
        if (string2.indexOf("32") != -1) {
            n4 = 32;
        }
        int n5 = 4;
        if (n4 == 16 || n4 == 32) {
            n5 = 1;
        }
        if (string2.indexOf("white") != -1) {
            n5 = 4;
        } else if (string2.indexOf("black") != -1) {
            n5 = 1;
        } else if (string2.indexOf("ramp") != -1) {
            n5 = 2;
        }
        return NewImage.createImage(string, n, n2, n3, n4, n5 += 8);
    }

    public static void newImage(String string, String string2, int n, int n2, int n3) {
        ImagePlus imagePlus = IJ.createImage(string, string2, n, n2, n3);
        if (imagePlus != null) {
            macroRunning = true;
            imagePlus.show();
            macroRunning = false;
        }
    }

    public static boolean escapePressed() {
        return escapePressed;
    }

    public static void resetEscape() {
        escapePressed = false;
    }

    public static void redirectErrorMessages() {
        redirectErrorMessages = true;
    }

    public static void redirectErrorMessages(boolean bl) {
        redirectErrorMessages2 = bl;
    }

    public static boolean redirectingErrorMessages() {
        return redirectErrorMessages || redirectErrorMessages2;
    }

    public static void suppressPluginNotFoundError() {
        suppressPluginNotFoundError = true;
    }

    public static ClassLoader getClassLoader() {
        if (classLoader == null) {
            String string;
            String string2 = Menus.getPlugInsPath();
            if (string2 == null && (string = System.getProperty("plugins.dir")) != null) {
                if (!string.endsWith(Prefs.separator)) {
                    string = string + Prefs.separator;
                }
                if (!new File(string2 = string + "plugins" + Prefs.separator).isDirectory()) {
                    string2 = string;
                }
            }
            if (string2 == null) {
                return IJ.class.getClassLoader();
            }
            classLoader = Menus.jnlp ? new PluginClassLoader(string2, true) : new PluginClassLoader(string2);
        }
        return classLoader;
    }

    public static Dimension getScreenSize() {
        if (IJ.isWindows()) {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (GraphicsEnvironment.isHeadless()) {
            return new Dimension(0, 0);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[0].getConfigurations();
        Rectangle rectangle = graphicsConfigurationArray[0].getBounds();
        if (rectangle.x == 0 && rectangle.y == 0) {
            return new Dimension(rectangle.width, rectangle.height);
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    static void abort() {
        if (ij != null || Interpreter.isBatchMode()) {
            throw new RuntimeException("Macro canceled");
        }
    }

    static void setClassLoader(ClassLoader classLoader) {
        IJ.classLoader = classLoader;
    }

    public static void handleException(Throwable throwable) {
        if (exceptionHandler != null) {
            exceptionHandler.handle(throwable);
            return;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        throwable.printStackTrace(printWriter);
        String string = charArrayWriter.toString();
        if (IJ.getInstance() != null) {
            new TextWindow("Exception", string, 500, 300);
        } else {
            IJ.log(string);
        }
    }

    public static void setExceptionHandler(ExceptionHandler exceptionHandler) {
        IJ.exceptionHandler = exceptionHandler;
    }

    public static void addEventListener(IJEventListener iJEventListener) {
        eventListeners.addElement(iJEventListener);
    }

    public static void removeEventListener(IJEventListener iJEventListener) {
        eventListeners.removeElement(iJEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyEventListeners(int n) {
        Vector vector = eventListeners;
        synchronized (vector) {
            for (int i = 0; i < eventListeners.size(); ++i) {
                IJEventListener iJEventListener = (IJEventListener)eventListeners.elementAt(i);
                iJEventListener.eventOccurred(n);
            }
        }
    }

    static {
        checkForDuplicatePlugins = true;
        eventListeners = new Vector();
        osname = System.getProperty("os.name");
        isWin = osname.startsWith("Windows");
        isMac = !isWin && osname.startsWith("Mac");
        isLinux = osname.startsWith("Linux");
        isVista = isWin && (osname.indexOf("Vista") != -1 || osname.indexOf(" 7") != -1);
        String string = System.getProperty("java.version").substring(0, 3);
        if (string.compareTo("2.9") <= 0) {
            isJava2 = string.compareTo("1.1") > 0;
            isJava14 = string.compareTo("1.3") > 0;
            isJava15 = string.compareTo("1.4") > 0;
            isJava16 = string.compareTo("1.5") > 0;
            isJava17 = string.compareTo("1.6") > 0;
        }
    }

    public static interface ExceptionHandler {
        public void handle(Throwable var1);
    }
}

