/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.RecentOpener;
import ij.SocketListener;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.JavaProperties;
import ij.plugin.MacroInstaller;
import ij.plugin.Orthogonal_Views;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Editor;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener,
Runnable {
    public static final String VERSION = "1.45r";
    public static final String BUILD = "";
    public static Color backgroundColor = new Color(220, 220, 220);
    public static final Font SansSerif12 = new Font("SansSerif", 0, 12);
    public static final int DEFAULT_PORT = 57294;
    public static final int STANDALONE = 0;
    public static final int EMBEDDED = 1;
    public static final int NO_SHOW = 2;
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static int port = 57294;
    private static String[] arguments;
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuitting;
    private boolean quitting;
    private long keyPressedTime;
    private long actionPerformedTime;
    private String lastKeyCommand;
    private boolean embedded;
    private boolean windowClosed;
    boolean hotkey;

    public ImageJ() {
        this(null, 0);
    }

    public ImageJ(int n) {
        this(null, n);
    }

    public ImageJ(Applet applet) {
        this(applet, 0);
    }

    public ImageJ(Applet applet, int n) {
        super("ImageJ");
        Object object;
        this.embedded = applet == null && (n == 1 || n == 2);
        this.applet = applet;
        String string = Prefs.load(this, applet);
        if (IJ.isLinux()) {
            backgroundColor = new Color(240, 240, 240);
            this.setBackground(backgroundColor);
        }
        Menus menus = new Menus(this, applet);
        String string2 = menus.addMenuBar();
        menus.installPopupMenu(this);
        this.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.setFont(SansSerif12);
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(120, 20);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.statusBar.setSize(this.toolbar.getPreferredSize());
        this.add(this.statusBar);
        IJ.init(this, applet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.setFocusTraversalKeysEnabled(false);
        Point point = this.getPreferredLocation();
        Dimension dimension = this.toolbar.getPreferredSize();
        int n2 = dimension.width + 10;
        int n3 = 100;
        this.setCursor(Cursor.getDefaultCursor());
        if (n != 2) {
            if (IJ.isWindows()) {
                try {
                    this.setIcon();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBounds(point.x, point.y, n2, n3);
            this.setLocation(point.x, point.y);
            this.pack();
            this.setResizable(!IJ.isMacintosh() && !IJ.isWindows());
            this.show();
        }
        if (string != null) {
            IJ.error(string);
        }
        if (string2 != null) {
            IJ.error(string2);
            IJ.runPlugIn("ij.plugin.ClassChecker", BUILD);
        }
        menus.installStartupMacroSet();
        if (IJ.isMacintosh() && applet == null) {
            object = null;
            object = IJ.runPlugIn("MacAdapter", BUILD);
            if (object == null) {
                IJ.runPlugIn("QuitHandler", BUILD);
            }
        }
        if (applet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", BUILD);
        }
        object = menus.getMacroCount() == 1 ? " macro" : " macros";
        IJ.showStatus(this.version() + menus.getPluginCount() + " commands; " + menus.getMacroCount() + (String)object);
        if (applet == null && !this.embedded && Prefs.runSocketListener) {
            new SocketListener();
        }
        this.configureProxy();
    }

    void configureProxy() {
        if (Prefs.useSystemProxies) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (Exception exception) {}
        } else {
            String string = Prefs.get("proxy.server", null);
            if (string == null || string.equals(BUILD)) {
                return;
            }
            int n = (int)Prefs.get("proxy.port", 0.0);
            if (n == 0) {
                return;
            }
            Properties properties = System.getProperties();
            properties.put("proxySet", "true");
            properties.put("http.proxyHost", string);
            properties.put("http.proxyPort", BUILD + n);
        }
    }

    void setIcon() throws Exception {
        URL uRL = this.getClass().getResource("/microscope.gif");
        if (uRL == null) {
            return;
        }
        Image image = this.createImage((ImageProducer)uRL.getContent());
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public Point getPreferredLocation() {
        int n;
        if (!IJ.isJava14()) {
            return new Point(0, 0);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n2 = Prefs.getInt(IJ_X, -99);
        int n3 = Prefs.getInt(IJ_Y, -99);
        if (n2 >= 0 && n3 > 0 && n2 < rectangle.x + rectangle.width - 75) {
            return new Point(n2, n3);
        }
        Dimension dimension = this.toolbar.getPreferredSize();
        double d = rectangle.width > 832 ? 0.8 : 0.9;
        n2 = (int)(d * (double)(rectangle.width - (n = dimension.width + 10)));
        if (n2 < 10) {
            n2 = 10;
        }
        return new Point(n2, rectangle.y);
    }

    void showStatus(String string) {
        this.statusLine.setText(string);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public Panel getStatusBar() {
        return this.statusBar;
    }

    void doCommand(String string) {
        new Executer(string, null);
    }

    public void runFilterPlugIn(Object object, String string, String string2) {
        new PlugInFilterRunner(object, string, string2);
    }

    public Object runUserPlugIn(String string, String string2, String string3, boolean bl) {
        return IJ.runUserPlugIn(string, string2, string3, bl);
    }

    public static String modifiers(int n) {
        String string = " [ ";
        if (n == 0) {
            return BUILD;
        }
        if ((n & 1) != 0) {
            string = string + "Shift ";
        }
        if ((n & 2) != 0) {
            string = string + "Control ";
        }
        if ((n & 4) != 0) {
            string = string + "Meta ";
        }
        if ((n & 8) != 0) {
            string = string + "Alt ";
        }
        string = string + "] ";
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuContainer menuContainer;
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            ImagePlus imagePlus = null;
            if (menuItem.getParent() == Menus.openRecentMenu) {
                new RecentOpener(string);
                return;
            }
            if (menuItem.getParent() == Menus.getPopupMenu() && (menuContainer = Menus.getPopupMenu().getParent()) instanceof ImageCanvas) {
                imagePlus = ((ImageCanvas)menuContainer).getImage();
            }
            int n = actionEvent.getModifiers();
            this.hotkey = false;
            this.actionPerformedTime = System.currentTimeMillis();
            long l = this.actionPerformedTime - this.keyPressedTime;
            if (!(string == null || l < 200L && string.equals(this.lastKeyCommand))) {
                if ((n & 8) != 0) {
                    IJ.setKeyDown(18);
                }
                if ((n & 1) != 0) {
                    IJ.setKeyDown(16);
                }
                new Executer(string, imagePlus);
            }
            this.lastKeyCommand = null;
            if (IJ.debugMode) {
                IJ.log("actionPerformed: time=" + l + ", " + actionEvent);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        MenuComponent menuComponent = (MenuComponent)((Object)menuItem.getParent());
        String string = itemEvent.getItem().toString();
        if ((Menu)menuComponent == Menus.window) {
            WindowManager.activateWindow(string, menuItem);
        } else {
            this.doCommand(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Undo.reset();
        if (!Prefs.noClickToGC) {
            System.gc();
        }
        IJ.showStatus(this.version() + IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    private String version() {
        return "ImageJ 1.45r; Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " [64-bit]; " : " [32-bit]; ");
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Cloneable cloneable;
        boolean bl;
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        this.hotkey = false;
        if (n == 17 || n == 16) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyPressed: code=" + n + " (" + KeyEvent.getKeyText(n) + "), char=\"" + c + "\" (" + c + "), flags=" + KeyEvent.getKeyModifiersText(n2));
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 8) != 0;
        boolean bl5 = (n2 & 4) != 0;
        String string = null;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        boolean bl6 = bl = imagePlus != null && imagePlus.getStackSize() > 1;
        if (imagePlus != null && !bl3 && (c >= ' ' && c <= '\u00ff' || c == '\b' || c == '\n') && (cloneable = imagePlus.getRoi()) instanceof TextRoi) {
            if ((n2 & 4) != 0 && IJ.isMacOSX()) {
                return;
            }
            if (bl4) {
                switch (c) {
                    case 'm': 
                    case 'u': {
                        c = '\u00b5';
                        break;
                    }
                    case 'A': {
                        c = '\u00c5';
                        break;
                    }
                }
            }
            ((TextRoi)cloneable).addChar(c);
            return;
        }
        if (!bl3 && !bl5 && ((Hashtable)(cloneable = Menus.getMacroShortcuts())).size() > 0 && (string = bl2 ? (String)((Hashtable)cloneable).get(new Integer(n + 200)) : (String)((Hashtable)cloneable).get(new Integer(n))) != null) {
            MacroInstaller.runMacroShortcut(string);
            return;
        }
        if ((!Prefs.requireControlKey || bl3 || bl5) && c != '+') {
            cloneable = Menus.getShortcuts();
            string = bl2 ? (String)((Hashtable)cloneable).get(new Integer(n + 200)) : (String)((Hashtable)cloneable).get(new Integer(n));
        }
        if (string == null) {
            switch (c) {
                case ',': 
                case '<': {
                    string = "Previous Slice [<]";
                    break;
                }
                case '.': 
                case ';': 
                case '>': {
                    string = "Next Slice [>]";
                    break;
                }
                case '+': 
                case '=': {
                    string = "In [+]";
                    break;
                }
                case '-': {
                    string = "Out [-]";
                    break;
                }
                case '/': {
                    string = "Reslice [/]...";
                    break;
                }
            }
        }
        if (string == null) {
            switch (n) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    string = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 61: {
                    string = "In [+]";
                    break;
                }
                case 45: {
                    string = "Out [-]";
                    break;
                }
                case 47: 
                case 191: {
                    string = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    string = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    string = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    boolean bl7;
                    if (imagePlus == null) {
                        return;
                    }
                    cloneable = imagePlus.getRoi();
                    if (IJ.shiftKeyDown() && imagePlus == Orthogonal_Views.getImage()) {
                        return;
                    }
                    boolean bl8 = imagePlus.getStackSize() > 1 && (cloneable == null || IJ.shiftKeyDown());
                    boolean bl9 = bl7 = cloneable == null || IJ.shiftKeyDown() || IJ.controlKeyDown();
                    if (bl8 && n == 39) {
                        string = "Next Slice [>]";
                        break;
                    }
                    if (bl8 && n == 37) {
                        string = "Previous Slice [<]";
                        break;
                    }
                    if (bl7 && n == 40 && !this.ignoreArrowKeys(imagePlus)) {
                        string = "Out [-]";
                        break;
                    }
                    if (bl7 && n == 38 && !this.ignoreArrowKeys(imagePlus)) {
                        string = "In [+]";
                        break;
                    }
                    if (cloneable == null) break;
                    if ((n2 & 8) != 0) {
                        ((Roi)cloneable).nudgeCorner(n);
                    } else {
                        ((Roi)cloneable).nudge(n);
                    }
                    return;
                }
                case 27: {
                    this.abortPluginOrMacro(imagePlus);
                    return;
                }
                case 10: {
                    WindowManager.toFront(this);
                    return;
                }
            }
        }
        if (string != null && !string.equals(BUILD)) {
            if (string.equals("Fill") || string.equals("Draw")) {
                this.hotkey = true;
            }
            if (string.charAt(0) == '^') {
                MacroInstaller.runMacroShortcut(string);
            } else {
                this.doCommand(string);
                this.keyPressedTime = System.currentTimeMillis();
                this.lastKeyCommand = string;
            }
        }
    }

    private boolean ignoreArrowKeys(ImagePlus imagePlus) {
        Frame frame = WindowManager.getFrontWindow();
        String string = frame.getTitle();
        if (string != null && string.equals("ROI Manager")) {
            return true;
        }
        if (frame != null && frame instanceof JFrame) {
            return true;
        }
        ImageWindow imageWindow = imagePlus.getWindow();
        return imagePlus.getStackSize() > 1 && imageWindow != null && imageWindow.getClass().getName().startsWith("loci");
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyTyped: char=\"" + c + "\" (" + c + "), flags= " + Integer.toHexString(n) + " (" + KeyEvent.getKeyModifiersText(n) + ")");
        }
        if (c == '\\' || c == '\u00ab' || c == '\u00df') {
            if ((n & 8) != 0) {
                this.doCommand("Animation Options...");
            } else {
                this.doCommand("Start Animation [\\]");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        IJ.setKeyUp(keyEvent.getKeyCode());
    }

    void abortPluginOrMacro(ImagePlus imagePlus) {
        ImageWindow imageWindow;
        if (imagePlus != null && (imageWindow = imagePlus.getWindow()) != null) {
            imageWindow.running = false;
            imageWindow.running2 = false;
        }
        Macro.abort();
        Interpreter.abort();
        if (Interpreter.getInstance() != null) {
            IJ.beep();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.doCommand("Quit");
        this.windowClosed = true;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (IJ.isMacintosh() && !this.quitting) {
            IJ.wait(10);
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public void register(Class clazz) {
        if (!this.classes.contains(clazz)) {
            this.classes.addElement(clazz);
        }
    }

    public void quit() {
        Thread thread = new Thread((Runnable)this, "Quit");
        thread.setPriority(5);
        thread.start();
        IJ.wait(10);
    }

    public boolean quitting() {
        return this.quitting;
    }

    public void savePreferences(Properties properties) {
        Point point = this.getLocation();
        properties.put(IJ_X, Integer.toString(point.x));
        properties.put(IJ_Y, Integer.toString(point.y));
    }

    public static void main(String[] stringArray) {
        int n;
        if (System.getProperty("java.version").substring(0, 3).compareTo("1.5") < 0) {
            JOptionPane.showMessageDialog(null, "ImageJ 1.45r requires Java 1.5 or later.");
            System.exit(0);
        }
        boolean bl = false;
        int n2 = 0;
        arguments = stringArray;
        int n3 = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray[i];
            if (string == null || !stringArray[i].startsWith("-")) continue;
            if (stringArray[i].startsWith("-batch")) {
                bl = true;
                continue;
            }
            if (stringArray[i].startsWith("-debug")) {
                IJ.debugMode = true;
                continue;
            }
            if (stringArray[i].startsWith("-ijpath") && i + 1 < n3) {
                Prefs.setHomeDir(stringArray[i + 1]);
                stringArray[i + 1] = null;
                continue;
            }
            if (!stringArray[i].startsWith("-port")) continue;
            n = (int)Tools.parseDouble(stringArray[i].substring(5, stringArray[i].length()), 0.0);
            if (n == 0) {
                n2 = 1;
                continue;
            }
            if (n <= 0 || 57294 + n >= 65536) continue;
            port = 57294 + n;
        }
        if (!bl && n2 == 0 && ImageJ.isRunning(stringArray)) {
            return;
        }
        ImageJ imageJ = IJ.getInstance();
        if (!bl && (imageJ == null || imageJ != null && !imageJ.isShowing())) {
            imageJ = new ImageJ(null, n2);
            imageJ.exitWhenQuitting = true;
        }
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            Object object;
            String string = stringArray[n];
            if (string == null) continue;
            if (string.startsWith("-")) {
                if ((string.startsWith("-macro") || string.startsWith("-batch")) && n + 1 < n3) {
                    object = n + 2 < n3 ? stringArray[n + 2] : null;
                    Prefs.commandLineMacro = true;
                    if (bl && stringArray[n + 1].endsWith(".js")) {
                        Interpreter.batchMode = true;
                    }
                    IJ.runMacroFile(stringArray[n + 1], (String)object);
                    break;
                }
                if (string.startsWith("-eval") && n + 1 < n3) {
                    object = IJ.runMacro(stringArray[n + 1]);
                    if (object != null) {
                        System.out.print((String)object);
                    }
                    stringArray[n + 1] = null;
                    continue;
                }
                if (!string.startsWith("-run") || n + 1 >= n3) continue;
                IJ.run(stringArray[n + 1]);
                stringArray[n + 1] = null;
                continue;
            }
            if (n4 == 0 && (string.endsWith(".ijm") || string.endsWith(".txt"))) {
                IJ.runMacroFile(string);
                ++n4;
                continue;
            }
            if (string.length() <= 0 || string.indexOf("ij.ImageJ") != -1) continue;
            object = new File(string);
            IJ.open(((File)object).getAbsolutePath());
        }
        if (IJ.debugMode && IJ.getInstance() == null) {
            new JavaProperties().run(BUILD);
        }
        if (bl) {
            System.exit(0);
        }
    }

    static boolean isRunning(String[] stringArray) {
        if (IJ.debugMode) {
            IJ.log("isRunning: " + stringArray.length);
        }
        int n = 0;
        int n2 = stringArray != null ? stringArray.length : 0;
        int n3 = 0;
        try {
            ImageJ.sendArgument("user.dir " + System.getProperty("user.dir"));
            for (int i = 0; i < n2; ++i) {
                String string = stringArray[i];
                if (IJ.debugMode) {
                    IJ.log("isRunning: " + i + " " + string);
                }
                if (string == null) continue;
                String string2 = null;
                if (n == 0 && string.endsWith(".ijm")) {
                    string2 = "macro " + string;
                    ++n;
                } else {
                    if (string.startsWith("-macro") && i + 1 < n2) {
                        String string3 = i + 2 < n2 ? "(" + stringArray[i + 2] + ")" : BUILD;
                        string2 = "macro " + stringArray[i + 1] + string3;
                        ImageJ.sendArgument(string2);
                        ++n3;
                        break;
                    }
                    if (string.startsWith("-eval") && i + 1 < n2) {
                        string2 = "eval " + stringArray[i + 1];
                        stringArray[i + 1] = null;
                    } else if (string.startsWith("-run") && i + 1 < n2) {
                        string2 = "run " + stringArray[i + 1];
                        stringArray[i + 1] = null;
                    } else if (string.indexOf("ij.ImageJ") == -1 && string.length() > 0 && !string.startsWith("-")) {
                        string2 = "open " + string;
                    }
                }
                if (string2 == null) continue;
                ImageJ.sendArgument(string2);
                ++n3;
            }
        }
        catch (IOException iOException) {
            if (IJ.debugMode) {
                IJ.log(BUILD + iOException);
            }
            return false;
        }
        return true;
    }

    static void sendArgument(String string) throws IOException {
        Socket socket = new Socket("localhost", port);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        printWriter.println(string);
        printWriter.close();
        socket.close();
    }

    public static int getPort() {
        return port;
    }

    public static String[] getArgs() {
        return arguments;
    }

    public void exitWhenQuitting(boolean bl) {
        this.exitWhenQuitting = bl;
    }

    @Override
    public void run() {
        Frame[] frameArray;
        ImageObserver imageObserver;
        this.quitting = true;
        boolean bl = false;
        int[] nArray = WindowManager.getIDList();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                imageObserver = WindowManager.getImage(nArray[i]);
                if (imageObserver == null || !((ImagePlus)imageObserver).changes) continue;
                bl = true;
                break;
            }
        }
        if ((frameArray = WindowManager.getNonImageWindows()) != null) {
            for (int i = 0; i < frameArray.length; ++i) {
                if (frameArray[i] == null || !(frameArray[i] instanceof Editor) || !((Editor)frameArray[i]).fileChanged()) continue;
                bl = true;
                break;
            }
        }
        if (!(!this.windowClosed || bl || Menus.window.getItemCount() <= 5 || IJ.macroRunning() && WindowManager.getImageCount() == 0)) {
            imageObserver = new GenericDialog("ImageJ", this);
            ((GenericDialog)imageObserver).addMessage("Are you sure you want to quit ImageJ?");
            ((GenericDialog)imageObserver).showDialog();
            this.quitting = !((GenericDialog)imageObserver).wasCanceled();
            this.windowClosed = false;
        }
        if (!this.quitting) {
            return;
        }
        if (!WindowManager.closeAllWindows()) {
            this.quitting = false;
            return;
        }
        if (this.applet == null) {
            this.saveWindowLocations();
            Prefs.savePreferences();
        }
        IJ.cleanup();
        this.dispose();
        if (this.exitWhenQuitting) {
            System.exit(0);
        }
    }

    void saveWindowLocations() {
        Frame frame = WindowManager.getFrame("B&C");
        if (frame != null) {
            Prefs.saveLocation("b&c.loc", frame.getLocation());
        }
        if ((frame = WindowManager.getFrame("Threshold")) != null) {
            Prefs.saveLocation("threshold.loc", frame.getLocation());
        }
        if ((frame = WindowManager.getFrame("Results")) != null) {
            Prefs.saveLocation("results.loc", frame.getLocation());
            Dimension dimension = frame.getSize();
            Prefs.set("results.width", dimension.width);
            Prefs.set("results.height", dimension.height);
        }
    }
}

