/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.MacroInstaller;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.applet.Applet;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Menus {
    public static final char PLUGINS_MENU = 'p';
    public static final char IMPORT_MENU = 'i';
    public static final char SAVE_AS_MENU = 's';
    public static final char SHORTCUTS_MENU = 'h';
    public static final char ABOUT_MENU = 'a';
    public static final char FILTERS_MENU = 'f';
    public static final char TOOLS_MENU = 't';
    public static final char UTILITIES_MENU = 'u';
    public static final int WINDOW_MENU_ITEMS = 5;
    public static final int NORMAL_RETURN = 0;
    public static final int COMMAND_IN_USE = -1;
    public static final int INVALID_SHORTCUT = -2;
    public static final int SHORTCUT_IN_USE = -3;
    public static final int NOT_INSTALLED = -4;
    public static final int COMMAND_NOT_FOUND = -5;
    public static final int MAX_OPEN_RECENT_ITEMS = 15;
    private static Menus instance;
    private static MenuBar mbar;
    private static CheckboxMenuItem gray8Item;
    private static CheckboxMenuItem gray16Item;
    private static CheckboxMenuItem gray32Item;
    private static CheckboxMenuItem color256Item;
    private static CheckboxMenuItem colorRGBItem;
    private static CheckboxMenuItem RGBStackItem;
    private static CheckboxMenuItem HSBStackItem;
    private static PopupMenu popup;
    private static ImageJ ij;
    private static Applet applet;
    private Hashtable demoImagesTable = new Hashtable();
    private static String pluginsPath;
    private static String macrosPath;
    private static Properties menus;
    private static Properties menuSeparators;
    private static Menu pluginsMenu;
    private static Menu saveAsMenu;
    private static Menu shortcutsMenu;
    private static Menu utilitiesMenu;
    private static Menu macrosMenu;
    static Menu window;
    static Menu openRecentMenu;
    private static Hashtable pluginsTable;
    private static int nPlugins;
    private static int nMacros;
    private static Hashtable shortcuts;
    private static Hashtable macroShortcuts;
    private static Vector pluginsPrefs;
    static int windowMenuItems2;
    private String error;
    private String jarError;
    private String pluginError;
    private boolean isJarErrorHeading;
    private static boolean installingJars;
    private static boolean duplicateCommand;
    private static Vector jarFiles;
    private Map menuEntry2jarFile = new HashMap();
    private static Vector macroFiles;
    private static int userPluginsIndex;
    private static boolean addSorted;
    private static int defaultFontSize;
    private static int fontSize;
    private static Font menuFont;
    static boolean jnlp;
    static final int RGB_STACK = 10;
    static final int HSB_STACK = 11;

    Menus(ImageJ imageJ, Applet applet) {
        ij = imageJ;
        Menus.applet = applet;
        instance = this;
    }

    String addMenuBar() {
        userPluginsIndex = 0;
        nMacros = 0;
        nPlugins = 0;
        duplicateCommand = false;
        installingJars = false;
        addSorted = false;
        this.error = null;
        mbar = null;
        menus = new Properties();
        pluginsTable = new Hashtable();
        shortcuts = new Hashtable();
        pluginsPrefs = new Vector();
        macroShortcuts = null;
        this.setupPluginsAndMacrosPaths();
        Menu menu = Menus.getMenu("File");
        Menu menu2 = Menus.getMenu("File>New", true);
        this.addPlugInItem(menu, "Open...", "ij.plugin.Commands(\"open\")", 79, false);
        this.addPlugInItem(menu, "Open Next", "ij.plugin.NextImageOpener", 79, true);
        Menus.getMenu("File>Open Samples", true);
        this.addOpenRecentSubMenu(menu);
        Menu menu3 = Menus.getMenu("File>Import", true);
        menu.addSeparator();
        this.addPlugInItem(menu, "Close", "ij.plugin.Commands(\"close\")", 87, false);
        this.addPlugInItem(menu, "Close All", "ij.plugin.Commands(\"close-all\")", 0, false);
        this.addPlugInItem(menu, "Save", "ij.plugin.Commands(\"save\")", 83, false);
        saveAsMenu = Menus.getMenu("File>Save As", true);
        this.addPlugInItem(menu, "Revert", "ij.plugin.Commands(\"revert\")", 82, false);
        menu.addSeparator();
        this.addPlugInItem(menu, "Page Setup...", "ij.plugin.filter.Printer(\"setup\")", 0, false);
        this.addPlugInItem(menu, "Print...", "ij.plugin.filter.Printer(\"print\")", 80, false);
        Menu menu4 = Menus.getMenu("Edit");
        this.addPlugInItem(menu4, "Undo", "ij.plugin.Commands(\"undo\")", 90, false);
        menu4.addSeparator();
        this.addPlugInItem(menu4, "Cut", "ij.plugin.Clipboard(\"cut\")", 88, false);
        this.addPlugInItem(menu4, "Copy", "ij.plugin.Clipboard(\"copy\")", 67, false);
        this.addPlugInItem(menu4, "Copy to System", "ij.plugin.Clipboard(\"scopy\")", 0, false);
        this.addPlugInItem(menu4, "Paste", "ij.plugin.Clipboard(\"paste\")", 86, false);
        this.addPlugInItem(menu4, "Paste Control...", "ij.plugin.frame.PasteController", 0, false);
        menu4.addSeparator();
        this.addPlugInItem(menu4, "Clear", "ij.plugin.filter.Filler(\"clear\")", 0, false);
        this.addPlugInItem(menu4, "Clear Outside", "ij.plugin.filter.Filler(\"outside\")", 0, false);
        this.addPlugInItem(menu4, "Fill", "ij.plugin.filter.Filler(\"fill\")", 70, false);
        this.addPlugInItem(menu4, "Draw", "ij.plugin.filter.Filler(\"draw\")", 68, false);
        this.addPlugInItem(menu4, "Invert", "ij.plugin.filter.Filters(\"invert\")", 73, true);
        menu4.addSeparator();
        Menus.getMenu("Edit>Selection", true);
        Menu menu5 = Menus.getMenu("Edit>Options", true);
        Menu menu6 = Menus.getMenu("Image");
        Menu menu7 = Menus.getMenu("Image>Type");
        gray8Item = this.addCheckboxItem(menu7, "8-bit", "ij.plugin.Converter(\"8-bit\")");
        gray16Item = this.addCheckboxItem(menu7, "16-bit", "ij.plugin.Converter(\"16-bit\")");
        gray32Item = this.addCheckboxItem(menu7, "32-bit", "ij.plugin.Converter(\"32-bit\")");
        color256Item = this.addCheckboxItem(menu7, "8-bit Color", "ij.plugin.Converter(\"8-bit Color\")");
        colorRGBItem = this.addCheckboxItem(menu7, "RGB Color", "ij.plugin.Converter(\"RGB Color\")");
        menu7.add(new MenuItem("-"));
        RGBStackItem = this.addCheckboxItem(menu7, "RGB Stack", "ij.plugin.Converter(\"RGB Stack\")");
        HSBStackItem = this.addCheckboxItem(menu7, "HSB Stack", "ij.plugin.Converter(\"HSB Stack\")");
        menu6.add(menu7);
        menu6.addSeparator();
        Menus.getMenu("Image>Adjust", true);
        this.addPlugInItem(menu6, "Show Info...", "ij.plugin.filter.Info", 73, false);
        this.addPlugInItem(menu6, "Properties...", "ij.plugin.filter.ImageProperties", 80, true);
        Menus.getMenu("Image>Color", true);
        Menus.getMenu("Image>Stacks", true);
        Menus.getMenu("Image>Stacks>Tools_", true);
        Menu menu8 = Menus.getMenu("Image>Hyperstacks", true);
        menu6.addSeparator();
        this.addPlugInItem(menu6, "Crop", "ij.plugin.Resizer(\"crop\")", 88, true);
        this.addPlugInItem(menu6, "Duplicate...", "ij.plugin.Duplicator", 68, true);
        this.addPlugInItem(menu6, "Rename...", "ij.plugin.SimpleCommands(\"rename\")", 0, false);
        this.addPlugInItem(menu6, "Scale...", "ij.plugin.Scaler", 69, false);
        Menus.getMenu("Image>Transform", true);
        Menus.getMenu("Image>Zoom", true);
        Menus.getMenu("Image>Overlay", true);
        menu6.addSeparator();
        Menus.getMenu("Image>Lookup Tables", true);
        Menu menu9 = Menus.getMenu("Process");
        this.addPlugInItem(menu9, "Smooth", "ij.plugin.filter.Filters(\"smooth\")", 83, true);
        this.addPlugInItem(menu9, "Sharpen", "ij.plugin.filter.Filters(\"sharpen\")", 0, false);
        this.addPlugInItem(menu9, "Find Edges", "ij.plugin.filter.Filters(\"edge\")", 0, false);
        this.addPlugInItem(menu9, "Find Maxima...", "ij.plugin.filter.MaximumFinder", 0, false);
        this.addPlugInItem(menu9, "Enhance Contrast", "ij.plugin.ContrastEnhancer", 0, false);
        Menus.getMenu("Process>Noise", true);
        Menus.getMenu("Process>Shadows", true);
        Menus.getMenu("Process>Binary", true);
        Menus.getMenu("Process>Math", true);
        Menus.getMenu("Process>FFT", true);
        Menu menu10 = Menus.getMenu("Process>Filters", true);
        menu9.addSeparator();
        Menus.getMenu("Process>Batch", true);
        this.addPlugInItem(menu9, "Image Calculator...", "ij.plugin.ImageCalculator", 0, false);
        this.addPlugInItem(menu9, "Subtract Background...", "ij.plugin.filter.BackgroundSubtracter", 0, false);
        Menus.addItem(menu9, "Repeat Command", 82, true);
        Menu menu11 = Menus.getMenu("Analyze");
        this.addPlugInItem(menu11, "Measure", "ij.plugin.filter.Analyzer", 77, false);
        this.addPlugInItem(menu11, "Analyze Particles...", "ij.plugin.filter.ParticleAnalyzer", 0, false);
        this.addPlugInItem(menu11, "Summarize", "ij.plugin.filter.Analyzer(\"sum\")", 0, false);
        this.addPlugInItem(menu11, "Distribution...", "ij.plugin.Distribution", 0, false);
        this.addPlugInItem(menu11, "Label", "ij.plugin.filter.Filler(\"label\")", 0, false);
        this.addPlugInItem(menu11, "Clear Results", "ij.plugin.filter.Analyzer(\"clear\")", 0, false);
        this.addPlugInItem(menu11, "Set Measurements...", "ij.plugin.filter.Analyzer(\"set\")", 0, false);
        menu11.addSeparator();
        this.addPlugInItem(menu11, "Set Scale...", "ij.plugin.filter.ScaleDialog", 0, false);
        this.addPlugInItem(menu11, "Calibrate...", "ij.plugin.filter.Calibrator", 0, false);
        this.addPlugInItem(menu11, "Histogram", "ij.plugin.Histogram", 72, false);
        this.addPlugInItem(menu11, "Plot Profile", "ij.plugin.filter.Profiler(\"plot\")", 75, false);
        this.addPlugInItem(menu11, "Surface Plot...", "ij.plugin.SurfacePlotter", 0, false);
        Menus.getMenu("Analyze>Gels", true);
        Menu menu12 = Menus.getMenu("Analyze>Tools", true);
        this.addPluginsMenu();
        Menu menu13 = Menus.getMenu("Window");
        this.addPlugInItem(menu13, "Show All", "ij.plugin.WindowOrganizer(\"show\")", 93, false);
        this.addPlugInItem(menu13, "Put Behind [tab]", "ij.plugin.Commands(\"tab\")", 0, false);
        this.addPlugInItem(menu13, "Cascade", "ij.plugin.WindowOrganizer(\"cascade\")", 0, false);
        this.addPlugInItem(menu13, "Tile", "ij.plugin.WindowOrganizer(\"tile\")", 0, false);
        menu13.addSeparator();
        Menu menu14 = Menus.getMenu("Help");
        this.addPlugInItem(menu14, "ImageJ Website...", "ij.plugin.BrowserLauncher", 0, false);
        this.addPlugInItem(menu14, "ImageJ News...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/notes.html\")", 0, false);
        this.addPlugInItem(menu14, "Documentation...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/docs\")", 0, false);
        this.addPlugInItem(menu14, "Installation...", "ij.plugin.SimpleCommands(\"install\")", 0, false);
        this.addPlugInItem(menu14, "Mailing List...", "ij.plugin.BrowserLauncher(\"https://list.nih.gov/archives/imagej.html\")", 0, false);
        menu14.addSeparator();
        this.addPlugInItem(menu14, "Dev. Resources...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/developer/index.html\")", 0, false);
        this.addPlugInItem(menu14, "Plugins...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/plugins\")", 0, false);
        this.addPlugInItem(menu14, "Macros...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/macros/\")", 0, false);
        this.addPlugInItem(menu14, "Macro Functions...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/developer/macro/functions.html\")", 0, false);
        menu14.addSeparator();
        this.addPlugInItem(menu14, "Update ImageJ...", "ij.plugin.ImageJ_Updater", 0, false);
        this.addPlugInItem(menu14, "Refresh Menus", "ij.plugin.ImageJ_Updater(\"menus\")", 0, false);
        menu14.addSeparator();
        Menu menu15 = Menus.getMenu("Help>About Plugins", true);
        this.addPlugInItem(menu14, "About ImageJ...", "ij.plugin.AboutBox", 0, false);
        if (applet == null) {
            menuSeparators = new Properties();
            this.installPlugins();
        }
        menu.addSeparator();
        this.addPlugInItem(menu, "Quit", "ij.plugin.Commands(\"quit\")", 0, false);
        if (fontSize != 0) {
            mbar.setFont(Menus.getFont());
        }
        if (ij != null) {
            ij.setMenuBar(mbar);
        }
        if (this.pluginError != null) {
            String string = this.error = this.error != null ? (this.error = this.error + "\n" + this.pluginError) : this.pluginError;
        }
        if (this.jarError != null) {
            this.error = this.error != null ? (this.error = this.error + "\n" + this.jarError) : this.jarError;
        }
        return this.error;
    }

    void addOpenRecentSubMenu(Menu menu) {
        String string;
        openRecentMenu = Menus.getMenu("File>Open Recent");
        for (int i = 0; i < 15 && (string = Prefs.getString("recent" + i / 10 % 10 + i % 10)) != null; ++i) {
            MenuItem menuItem = new MenuItem(string);
            openRecentMenu.add(menuItem);
            menuItem.addActionListener(ij);
        }
        menu.add(openRecentMenu);
    }

    static void addItem(Menu menu, String string, int n, boolean bl) {
        MenuItem menuItem;
        if (menu == null) {
            return;
        }
        if (n == 0) {
            menuItem = new MenuItem(string);
        } else if (bl) {
            menuItem = new MenuItem(string, new MenuShortcut(n, true));
            shortcuts.put(new Integer(n + 200), string);
        } else {
            menuItem = new MenuItem(string, new MenuShortcut(n));
            shortcuts.put(new Integer(n), string);
        }
        if (addSorted) {
            if (menu == pluginsMenu) {
                Menus.addItemSorted(menu, menuItem, userPluginsIndex);
            } else {
                Menus.addOrdered(menu, menuItem);
            }
        } else {
            menu.add(menuItem);
        }
        menuItem.addActionListener(ij);
    }

    void addPlugInItem(Menu menu, String string, String string2, int n, boolean bl) {
        pluginsTable.put(string, string2);
        ++nPlugins;
        Menus.addItem(menu, string, n, bl);
    }

    CheckboxMenuItem addCheckboxItem(Menu menu, String string, String string2) {
        pluginsTable.put(string, string2);
        ++nPlugins;
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        menu.add(checkboxMenuItem);
        checkboxMenuItem.addItemListener(ij);
        checkboxMenuItem.setState(false);
        return checkboxMenuItem;
    }

    static Menu addSubMenu(Menu menu, String string) {
        String string2;
        String string3 = string.toLowerCase(Locale.US);
        Menu menu2 = new Menu(string.replace('_', ' '));
        int n = string3.indexOf(32);
        if (n > 0) {
            string3 = string3.substring(0, n);
        }
        for (int i = 1; i < 100 && (string2 = Prefs.getString(string3 + i / 10 % 10 + i % 10)) != null; ++i) {
            if (i == 1) {
                menu.add(menu2);
            }
            if (string2.equals("-")) {
                menu2.addSeparator();
                continue;
            }
            Menus.addPluginItem(menu2, string2);
        }
        if (string.equals("Lookup Tables") && applet == null) {
            Menus.addLuts(menu2);
        }
        return menu2;
    }

    static void addLuts(Menu menu) {
        String string = IJ.getDirectory("luts");
        if (string == null) {
            return;
        }
        File file = new File(string);
        String[] stringArray = null;
        if (applet == null && file.exists() && file.isDirectory()) {
            stringArray = file.list();
        }
        if (stringArray == null) {
            return;
        }
        if (IJ.isLinux()) {
            StringSorter.sort(stringArray);
        }
        menu.addSeparator();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.endsWith(".lut")) continue;
            string2 = string2.substring(0, string2.length() - 4);
            MenuItem menuItem = new MenuItem(string2);
            menu.add(menuItem);
            menuItem.addActionListener(ij);
            ++nPlugins;
        }
    }

    static void addPluginItem(Menu menu, String string) {
        int n;
        if (string.startsWith("\"-\"")) {
            Menus.addSeparator(menu);
            return;
        }
        int n2 = string.lastIndexOf(44);
        if (n2 <= 0) {
            return;
        }
        String string2 = string.substring(1, n2 - 1);
        int n3 = 0;
        boolean bl = false;
        if (string2.endsWith("]") && (n = string2.lastIndexOf(91)) > 0) {
            boolean bl2;
            String string3 = string2.substring(n + 1, string2.length() - 1);
            n3 = Menus.convertShortcutToCode(string3);
            boolean bl3 = bl2 = n3 >= 112 && n3 <= 123;
            if (n3 > 0 && !bl2) {
                string2 = string2.substring(0, n);
            }
        }
        if (n3 >= 112 && n3 <= 123) {
            shortcuts.put(new Integer(n3), string2);
            n3 = 0;
        } else if (n3 >= 265 && n3 <= 290) {
            n3 -= 200;
            bl = true;
        }
        Menus.addItem(menu, string2, n3, bl);
        while (string.charAt(n2 + 1) == ' ' && n2 + 2 < string.length()) {
            ++n2;
        }
        String string4 = string.substring(n2 + 1, string.length());
        if (installingJars) {
            duplicateCommand = pluginsTable.get(string2) != null;
        }
        pluginsTable.put(string2, string4);
        ++nPlugins;
    }

    void checkForDuplicate(String string) {
        if (pluginsTable.get(string) != null) {
            // empty if block
        }
    }

    void addPluginsMenu() {
        String string;
        pluginsMenu = Menus.getMenu("Plugins");
        for (int i = 1; i < 100 && (string = Prefs.getString("plug-in" + i / 10 % 10 + i % 10)) != null; ++i) {
            char c = string.charAt(0);
            if (c == '-') {
                pluginsMenu.addSeparator();
                continue;
            }
            if (c == '>') {
                String string2 = string.substring(2, string.length() - 1);
                Menu menu = Menus.addSubMenu(pluginsMenu, string2);
                if (string2.equals("Shortcuts")) {
                    shortcutsMenu = menu;
                    continue;
                }
                if (string2.equals("Utilities")) {
                    utilitiesMenu = menu;
                    continue;
                }
                if (!string2.equals("Macros")) continue;
                macrosMenu = menu;
                continue;
            }
            Menus.addPluginItem(pluginsMenu, string);
        }
        userPluginsIndex = pluginsMenu.getItemCount();
        if (userPluginsIndex < 0) {
            userPluginsIndex = 0;
        }
    }

    void installPlugins() {
        String string;
        int n;
        String[] stringArray = Menus.getPlugins();
        String[] stringArray2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (n = 0; n < 100 && (string = Prefs.getString("plugin" + n / 10 % 10 + n % 10)) != null; ++n) {
            int n2;
            Menu menu;
            char c = string.charAt(0);
            switch (c) {
                default: {
                    menu = pluginsMenu;
                    break;
                }
                case 'i': {
                    menu = Menus.getMenu("File>Import");
                    break;
                }
                case 's': {
                    menu = Menus.getMenu("File>Save As");
                    break;
                }
                case 'h': {
                    menu = shortcutsMenu;
                    break;
                }
                case 'a': {
                    menu = Menus.getMenu("Help>About Plugins");
                    break;
                }
                case 'f': {
                    menu = Menus.getMenu("Process>Filters");
                    break;
                }
                case 't': {
                    menu = Menus.getMenu("Analyze>Tools");
                    break;
                }
                case 'u': {
                    menu = utilitiesMenu;
                }
            }
            String string2 = string;
            string = string.substring(2, string.length());
            String string3 = string.substring(string.lastIndexOf(44) + 1, string.length());
            boolean bl = string3.startsWith("ij.");
            if (!bl && stringArray != null) {
                if (stringArray2 == null) {
                    stringArray2 = this.getStrippedPlugins(stringArray);
                }
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (!string3.startsWith(stringArray2[n2])) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl || menu == pluginsMenu) continue;
            Menus.addPluginItem(menu, string);
            pluginsPrefs.addElement(string2);
            if (string3.endsWith("\")") && (n2 = string3.lastIndexOf("(\"")) > 0) {
                string3 = string3.substring(0, n2);
            }
            hashtable.put(string3, "");
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (hashtable.containsKey(stringArray[n])) continue;
                this.installUserPlugin(stringArray[n]);
            }
        }
        this.installJarPlugins();
        this.installMacros();
    }

    void installMacros() {
        if (macroFiles == null) {
            return;
        }
        for (int i = 0; i < macroFiles.size(); ++i) {
            String string = (String)macroFiles.elementAt(i);
            this.installMacro(string);
        }
    }

    void installMacro(String string) {
        Object object;
        String string2;
        Menu menu = pluginsMenu;
        String string3 = null;
        int n = string.indexOf(47);
        if (n > 0) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
            menu = this.getPluginsSubmenu(string3);
            n = string.indexOf(47);
            if (n > 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1, string.length());
                object = "Plugins>" + string3 + ">" + string2;
                menu = Menus.getMenu((String)object);
                string3 = string3 + File.separator + string2;
            }
        }
        string2 = (string2 = string.replace('_', ' ')).endsWith(".js") ? string2.substring(0, string2.length() - 3) : string2.substring(0, string2.length() - 4);
        string2.trim();
        if (pluginsTable.get(string2) != null) {
            string2 = string2 + " Macro";
        }
        object = new MenuItem(string2);
        Menus.addOrdered(menu, (MenuItem)object);
        ((MenuItem)object).addActionListener(ij);
        String string4 = (string3 != null ? string3 + File.separator : "") + string;
        pluginsTable.put(string2, "ij.plugin.Macro_Runner(\"" + string4 + "\")");
        ++nMacros;
    }

    static int addPluginSeparatorIfNeeded(Menu menu) {
        if (menuSeparators == null) {
            return 0;
        }
        Integer n = (Integer)menuSeparators.get(menu);
        if (n == null) {
            if (menu.getItemCount() > 0) {
                Menus.addSeparator(menu);
            }
            n = new Integer(menu.getItemCount());
            menuSeparators.put(menu, n);
        }
        return n;
    }

    static void addOrdered(Menu menu, MenuItem menuItem) {
        int n;
        String string = menuItem.getLabel();
        for (int i = n = Menus.addPluginSeparatorIfNeeded(menu); i < menu.getItemCount(); ++i) {
            if (string.compareTo(menu.getItem(i).getLabel()) >= 0) continue;
            menu.insert(menuItem, i);
            return;
        }
        menu.add(menuItem);
    }

    public static String getJarFileForMenuEntry(String string) {
        if (instance == null) {
            return null;
        }
        return (String)Menus.instance.menuEntry2jarFile.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installJarPlugins() {
        if (jarFiles == null) {
            return;
        }
        installingJars = true;
        for (int i = 0; i < jarFiles.size(); ++i) {
            this.isJarErrorHeading = false;
            String string = (String)jarFiles.elementAt(i);
            InputStream inputStream = this.getConfigurationFile(string);
            if (inputStream == null) continue;
            int n = 100;
            String[] stringArray = new String[n];
            int n2 = 0;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            try {
                String string2;
                while ((string2 = lineNumberReader.readLine()) != null) {
                    if (n2 == n - 1) {
                        break;
                    }
                    if (string2.length() < 3 || string2.startsWith("#")) continue;
                    stringArray[n2++] = string2;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            for (int j = 0; j < n2; ++j) {
                this.installJarPlugin(string, stringArray[j]);
            }
        }
    }

    void installJarPlugin(String string, String string2) {
        int n;
        String string3;
        Menu menu;
        int n2;
        addSorted = false;
        if (string2.startsWith("Plugins>")) {
            n2 = string2.indexOf(44);
            if (n2 == -1 || n2 <= 8) {
                menu = null;
            } else {
                string3 = string2.substring(8, n2);
                menu = this.getPluginsSubmenu(string3);
            }
        } else if (string2.startsWith("\"") || string2.startsWith("Plugins")) {
            String string4 = this.getSubmenuName(string);
            menu = string4 != null ? this.getPluginsSubmenu(string4) : pluginsMenu;
            addSorted = true;
        } else {
            n2 = string2.indexOf(34);
            string3 = n2 < 0 ? string2 : string2.substring(0, n2).trim();
            n = string3.indexOf(44);
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
            if (string3.startsWith("Help>About")) {
                string3 = "Help>About Plugins";
            }
            menu = Menus.getMenu(string3);
        }
        n2 = string2.indexOf(34);
        if (n2 == -1) {
            return;
        }
        string2 = string2.substring(n2, string2.length());
        if (menu != null) {
            Menus.addPluginSeparatorIfNeeded(menu);
            Menus.addPluginItem(menu, string2);
            addSorted = false;
        }
        string3 = string2;
        if (string2.startsWith("\"")) {
            n = string2.indexOf(34, 1);
            string3 = n < 0 ? string2.substring(1) : string2.substring(1, n);
        } else {
            n = string2.indexOf(44);
            if (n > 0) {
                string3 = string2.substring(0, n);
            }
        }
        if (duplicateCommand) {
            if (this.jarError == null) {
                this.jarError = "";
            }
            this.addJarErrorHeading(string);
            String string5 = (String)this.menuEntry2jarFile.get(string3);
            if (string5 != null && string5.startsWith(pluginsPath)) {
                string5 = string5.substring(pluginsPath.length());
            }
            this.jarError = this.jarError + "    Duplicate command: " + string2 + (string5 != null ? " (already in " + string5 + ")" : "") + "\n";
        } else {
            this.menuEntry2jarFile.put(string3, string);
        }
        duplicateCommand = false;
    }

    void addJarErrorHeading(String string) {
        if (!this.isJarErrorHeading) {
            if (!this.jarError.equals("")) {
                this.jarError = this.jarError + " \n";
            }
            this.jarError = this.jarError + "Plugin configuration error: " + string + "\n";
            this.isJarErrorHeading = true;
        }
    }

    private static Menu getMenu(String string) {
        return Menus.getMenu(string, false);
    }

    private static Menu getMenu(String string, boolean bl) {
        Menu menu;
        if (string.endsWith(">")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((menu = (Menu)menus.get(string)) == null) {
            int n = string.lastIndexOf(62);
            if (n < 0) {
                menu = new Menu(string);
                if (mbar == null) {
                    mbar = new MenuBar();
                }
                if (string.equals("Help")) {
                    mbar.setHelpMenu(menu);
                } else {
                    mbar.add(menu);
                }
                if (string.equals("Window")) {
                    window = menu;
                } else if (string.equals("Plugins")) {
                    pluginsMenu = menu;
                }
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                Menu menu2 = Menus.getMenu(string2);
                menu = new Menu(string3);
                Menus.addPluginSeparatorIfNeeded(menu2);
                if (bl) {
                    menu = Menus.addSubMenu(menu2, string3);
                } else if (string2.startsWith("Plugins") && menuSeparators != null) {
                    Menus.addItemSorted(menu2, menu, string2.equals("Plugins") ? userPluginsIndex : 0);
                } else {
                    menu2.add(menu);
                }
                if (string.equals("File>Open Recent")) {
                    openRecentMenu = menu;
                }
            }
            menus.put(string, menu);
        }
        return menu;
    }

    Menu getPluginsSubmenu(String string) {
        return Menus.getMenu("Plugins>" + string);
    }

    String getSubmenuName(String string) {
        int n;
        if (pluginsPath == null) {
            return null;
        }
        if (string.startsWith(pluginsPath)) {
            string = string.substring(pluginsPath.length() - 1);
        }
        if ((n = string.lastIndexOf(File.separatorChar)) < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(File.separatorChar)) < 0) {
            return null;
        }
        if ((string2 = string2.substring(n + 1)).equals("plugins")) {
            return null;
        }
        return string2;
    }

    static void addItemSorted(Menu menu, MenuItem menuItem, int n) {
        String string = menuItem.getLabel();
        int n2 = menu.getItemCount();
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            MenuItem menuItem2 = menu.getItem(i);
            String string2 = menuItem2.getLabel();
            if (string.compareTo(string2) >= 0) continue;
            menu.insert(menuItem, i);
            bl = true;
            break;
        }
        if (!bl) {
            menu.add(menuItem);
        }
    }

    static void addSeparator(Menu menu) {
        menu.addSeparator();
    }

    InputStream getConfigurationFile(String string) {
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith("plugins.config")) continue;
                return zipFile.getInputStream(zipEntry);
            }
        }
        catch (Throwable throwable) {
            IJ.log(string + ": " + throwable);
        }
        return this.autoGenerateConfigFile(string);
    }

    InputStream autoGenerateConfigFile(String string) {
        StringBuffer stringBuffer = null;
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.endsWith(".class") || string2.indexOf("_") <= 0 || string2.indexOf("$") != -1 || string2.indexOf("/_") != -1 || string2.startsWith("_") || Character.isLowerCase(string2.charAt(0)) && string2.indexOf("/") != -1) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                String string3 = string2.substring(0, string2.length() - 6);
                int n = string3.lastIndexOf(47);
                String string4 = "Plugins";
                if (n >= 0) {
                    string4 = string4 + ">" + string3.substring(0, n).replace('/', '>').replace('_', ' ');
                    string2 = string3.substring(n + 1);
                } else {
                    string2 = string3;
                }
                string2 = string2.replace('_', ' ');
                string3 = string3.replace('/', '.');
                stringBuffer.append(string4 + ", \"" + string2 + "\", " + string3 + "\n");
            }
        }
        catch (Throwable throwable) {
            IJ.log(string + ": " + throwable);
        }
        if (stringBuffer == null) {
            return null;
        }
        return new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    String[] getStrippedPlugins(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i];
            int n = stringArray2[i].lastIndexOf(47);
            if (n < 0) continue;
            stringArray2[i] = stringArray[i].substring(n + 1, stringArray2[i].length());
        }
        return stringArray2;
    }

    void setupPluginsAndMacrosPaths() {
        Object object;
        macrosPath = null;
        pluginsPath = null;
        String string = Prefs.getHomeDir();
        if (string == null) {
            return;
        }
        if (string.endsWith("plugins")) {
            pluginsPath = string + Prefs.separator;
        } else {
            String string2;
            object = System.getProperty("plugins.dir");
            if (object != null && (((String)object).endsWith("/") || ((String)object).endsWith("\\"))) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if ((string2 = object) == null) {
                string2 = string;
            } else if (string2.equals("user.home")) {
                string2 = System.getProperty("user.home");
                if (!new File(string2 + Prefs.separator + "plugins").isDirectory()) {
                    string2 = string2 + Prefs.separator + "ImageJ";
                }
                object = null;
                if (applet == null) {
                    System.setSecurityManager(null);
                }
                jnlp = true;
            }
            pluginsPath = string2 + Prefs.separator + "plugins" + Prefs.separator;
            if (object != null && !new File(pluginsPath).isDirectory()) {
                pluginsPath = string2 + Prefs.separator;
            }
            macrosPath = string2 + Prefs.separator + "macros" + Prefs.separator;
        }
        Object object2 = object = macrosPath != null ? new File(macrosPath) : null;
        if (object != null && !((File)object).isDirectory()) {
            macrosPath = null;
        }
        Object object3 = object = pluginsPath != null ? new File(pluginsPath) : null;
        if (object == null || object != null && !((File)object).isDirectory()) {
            pluginsPath = null;
            return;
        }
    }

    public static synchronized String[] getPlugins() {
        File file;
        File file2 = file = pluginsPath != null ? new File(pluginsPath) : null;
        if (file == null || file != null && !file.isDirectory()) {
            return null;
        }
        Object[] objectArray = file.list();
        if (objectArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        jarFiles = null;
        macroFiles = null;
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            String string = objectArray[i];
            boolean bl2 = string.endsWith(".class");
            boolean bl3 = bl = string.indexOf(95) >= 0;
            if (bl && bl2 && string.indexOf(36) < 0) {
                string = string.substring(0, string.length() - 6);
                vector.addElement(string);
                continue;
            }
            if (bl && (string.endsWith(".jar") || string.endsWith(".zip"))) {
                if (jarFiles == null) {
                    jarFiles = new Vector();
                }
                jarFiles.addElement(pluginsPath + string);
                continue;
            }
            if (bl && string.endsWith(".txt") || string.endsWith(".ijm") || string.endsWith(".js")) {
                if (macroFiles == null) {
                    macroFiles = new Vector();
                }
                macroFiles.addElement(string);
                continue;
            }
            if (bl2) continue;
            Menus.checkSubdirectory(pluginsPath, string, vector);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        return objectArray;
    }

    private static void checkSubdirectory(String string, String string2, Vector vector) {
        if (string2.endsWith(".java")) {
            return;
        }
        File file = new File(string, string2);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        string2 = string2 + "/";
        int n = 0;
        int n2 = 0;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            String string4 = stringArray[i];
            boolean bl2 = bl = string4.indexOf(95) >= 0;
            if (bl && string4.endsWith(".class") && string4.indexOf(36) < 0) {
                string4 = string4.substring(0, string4.length() - 6);
                vector.addElement(string2 + string4);
                ++n;
                string3 = string4;
                continue;
            }
            if (bl && (string4.endsWith(".jar") || string4.endsWith(".zip"))) {
                if (jarFiles == null) {
                    jarFiles = new Vector();
                }
                jarFiles.addElement(file.getPath() + File.separator + string4);
                ++n2;
                continue;
            }
            if (bl && string4.endsWith(".txt") || string4.endsWith(".ijm") || string4.endsWith(".js")) {
                if (macroFiles == null) {
                    macroFiles = new Vector();
                }
                macroFiles.addElement(string2 + string4);
                ++n2;
                continue;
            }
            File file2 = new File(file, string4);
            if (!file2.isDirectory()) continue;
            Menus.installSubdirectorMacros(file2, string2 + string4);
        }
        if (Prefs.moveToMisc && n == 1 && n2 == 0 && string2.indexOf("_") == -1) {
            vector.setElementAt("Miscellaneous/" + string3, vector.size() - 1);
        }
    }

    private static void installSubdirectorMacros(File file, String string) {
        if (string.endsWith("Launchers")) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            String string2 = stringArray[i];
            boolean bl2 = bl = string2.indexOf(95) >= 0;
            if ((!bl || !string2.endsWith(".txt")) && !string2.endsWith(".ijm") && !string2.endsWith(".js")) continue;
            if (macroFiles == null) {
                macroFiles = new Vector();
            }
            macroFiles.addElement(string + "/" + string2);
        }
    }

    void installUserPlugin(String string) {
        this.installUserPlugin(string, false);
    }

    public void installUserPlugin(String string, boolean bl) {
        boolean bl2;
        int n = string.indexOf(47);
        String string2 = n < 0 ? "Plugins" : "Plugins>" + string.substring(0, n).replace('/', '>');
        Menu menu = Menus.getMenu(string2);
        String string3 = string;
        if (n > 0) {
            string3 = string.substring(n + 1);
        }
        string3 = string3.replace('_', ' ');
        string3.trim();
        boolean bl3 = bl2 = pluginsTable.get(string3) != null;
        if (bl && bl2) {
            return;
        }
        if (!bl && bl2) {
            string3 = string3 + " Plugin";
        }
        MenuItem menuItem = new MenuItem(string3);
        if (bl) {
            Menus.addItemSorted(menu, menuItem, 0);
        } else {
            Menus.addOrdered(menu, menuItem);
        }
        menuItem.addActionListener(ij);
        pluginsTable.put(string3, string.replace('/', '.'));
        ++nPlugins;
    }

    void installPopupMenu(ImageJ imageJ) {
        String string;
        int n = 0;
        popup = new PopupMenu("");
        if (fontSize != 0) {
            popup.setFont(Menus.getFont());
        }
        while ((string = Prefs.getString("popup" + ++n / 10 % 10 + n % 10)) != null) {
            if (string.equals("-")) {
                popup.addSeparator();
                continue;
            }
            if (string.equals("")) continue;
            MenuItem menuItem = new MenuItem(string);
            menuItem.addActionListener(imageJ);
            popup.add(menuItem);
        }
    }

    public static MenuBar getMenuBar() {
        return mbar;
    }

    public static Menu getMacrosMenu() {
        return macrosMenu;
    }

    public int getMacroCount() {
        return nMacros;
    }

    public int getPluginCount() {
        return nPlugins;
    }

    public static void updateMenus() {
        Object object;
        if (ij == null) {
            return;
        }
        gray8Item.setState(false);
        gray16Item.setState(false);
        gray32Item.setState(false);
        color256Item.setState(false);
        colorRGBItem.setState(false);
        RGBStackItem.setState(false);
        HSBStackItem.setState(false);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        int n = imagePlus.getType();
        if (imagePlus.getStackSize() > 1) {
            object = imagePlus.getStack();
            if (((ImageStack)object).isRGB()) {
                n = 10;
            } else if (((ImageStack)object).isHSB()) {
                n = 11;
            }
        }
        if (n == 0 && (object = imagePlus.getProcessor()) != null && ((ImageProcessor)object).getMinThreshold() == -808080.0 && ((ImageProcessor)object).isColorLut() && !((ImageProcessor)object).isPseudoColorLut()) {
            n = 3;
            imagePlus.setType(3);
        }
        switch (n) {
            case 0: {
                gray8Item.setState(true);
                break;
            }
            case 1: {
                gray16Item.setState(true);
                break;
            }
            case 2: {
                gray32Item.setState(true);
                break;
            }
            case 3: {
                color256Item.setState(true);
                break;
            }
            case 4: {
                colorRGBItem.setState(true);
                break;
            }
            case 10: {
                RGBStackItem.setState(true);
                break;
            }
            case 11: {
                HSBStackItem.setState(true);
            }
        }
        int n2 = window.getItemCount();
        int n3 = 5 + windowMenuItems2;
        int n4 = n3 + WindowManager.getCurrentIndex();
        try {
            for (int i = n3; i < n2; ++i) {
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)window.getItem(i);
                checkboxMenuItem.setState(i == n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean isColorLut(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        if (indexColorModel == null) {
            return false;
        }
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i] && byArray2[i] == byArray3[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getPlugInsPath() {
        return pluginsPath;
    }

    public static String getMacrosPath() {
        return macrosPath;
    }

    public static Hashtable getCommands() {
        return pluginsTable;
    }

    public static Hashtable getShortcuts() {
        return shortcuts;
    }

    public static Hashtable getMacroShortcuts() {
        if (macroShortcuts == null) {
            macroShortcuts = new Hashtable();
        }
        return macroShortcuts;
    }

    static synchronized void insertWindowMenuItem(Frame frame) {
        if (ij == null || frame == null) {
            return;
        }
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(frame.getTitle());
        checkboxMenuItem.addItemListener(ij);
        int n = 5 + windowMenuItems2;
        if (windowMenuItems2 >= 2) {
            --n;
        }
        window.insert(checkboxMenuItem, n);
        if (++windowMenuItems2 == 1) {
            window.insertSeparator(5 + windowMenuItems2);
            ++windowMenuItems2;
        }
    }

    static synchronized void addWindowMenuItem(ImagePlus imagePlus) {
        if (ij == null) {
            return;
        }
        String string = imagePlus.getTitle();
        int n = imagePlus.getWidth() * imagePlus.getHeight() * imagePlus.getStackSize() / 1024;
        switch (imagePlus.getType()) {
            case 2: 
            case 4: {
                n *= 4;
                break;
            }
            case 1: {
                n *= 2;
                break;
            }
        }
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string + " " + n + "K");
        window.add(checkboxMenuItem);
        checkboxMenuItem.addItemListener(ij);
    }

    static synchronized void removeWindowMenuItem(int n) {
        if (ij == null) {
            return;
        }
        try {
            if (n >= 0 && n < window.getItemCount()) {
                window.remove(5 + n);
                if (n < windowMenuItems2 && --windowMenuItems2 == 1) {
                    window.remove(5);
                    windowMenuItems2 = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void updateWindowMenuItem(String string, String string2) {
        if (string == null || string.equals(string2)) {
            return;
        }
        int n = 5;
        int n2 = window.getItemCount() - 1;
        try {
            for (int i = n; i <= n2; ++i) {
                int n3;
                MenuItem menuItem = window.getItem(i);
                String string3 = menuItem.getLabel();
                if (menuItem == null || !string3.startsWith(string)) continue;
                if (string3.endsWith("K") && (n3 = string3.lastIndexOf(32)) > -1) {
                    string2 = string2 + string3.substring(n3, string3.length());
                }
                menuItem.setLabel(string2);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static synchronized void addOpenRecentItem(String string) {
        if (ij == null) {
            return;
        }
        int n = openRecentMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (openRecentMenu.getItem(n2).getLabel().equals(string)) {
                openRecentMenu.remove(n2);
                --n;
                continue;
            }
            ++n2;
        }
        if (n == 15) {
            openRecentMenu.remove(14);
        }
        MenuItem menuItem = new MenuItem(string);
        openRecentMenu.insert(menuItem, 0);
        menuItem.addActionListener(ij);
    }

    public static PopupMenu getPopupMenu() {
        return popup;
    }

    public static Menu getSaveAsMenu() {
        return saveAsMenu;
    }

    public static int installPlugin(String string, char c, String string2, String string3, ImageJ imageJ) {
        MenuItem menuItem;
        boolean bl;
        Menu menu;
        if (string2.equals("")) {
            return 0;
        }
        if (Menus.commandInUse(string2)) {
            return -1;
        }
        if (!Menus.validShortcut(string3)) {
            return -2;
        }
        if (Menus.shortcutInUse(string3)) {
            return -3;
        }
        switch (c) {
            case 'p': {
                menu = pluginsMenu;
                break;
            }
            case 'i': {
                menu = Menus.getMenu("File>Import");
                break;
            }
            case 's': {
                menu = Menus.getMenu("File>Save As");
                break;
            }
            case 'h': {
                menu = shortcutsMenu;
                break;
            }
            case 'a': {
                menu = Menus.getMenu("Help>About Plugins");
                break;
            }
            case 'f': {
                menu = Menus.getMenu("Process>Filters");
                break;
            }
            case 't': {
                menu = Menus.getMenu("Analyze>Tools");
                break;
            }
            case 'u': {
                menu = utilitiesMenu;
                break;
            }
            default: {
                return 0;
            }
        }
        int n = Menus.convertShortcutToCode(string3);
        boolean bl2 = bl = n >= 112 && n <= 123;
        if (n == 0) {
            menuItem = new MenuItem(string2);
        } else if (bl) {
            string2 = string2 + " [F" + (n - 112 + 1) + "]";
            shortcuts.put(new Integer(n), string2);
            menuItem = new MenuItem(string2);
        } else {
            shortcuts.put(new Integer(n), string2);
            int n2 = n;
            boolean bl3 = false;
            if (n2 >= 265 && n2 <= 290) {
                n2 -= 200;
                bl3 = true;
            }
            menuItem = new MenuItem(string2, new MenuShortcut(n2, bl3));
        }
        menu.add(menuItem);
        menuItem.addActionListener(imageJ);
        pluginsTable.put(string2, string);
        string3 = n > 0 && !bl ? "[" + string3 + "]" : "";
        pluginsPrefs.addElement(c + ",\"" + string2 + string3 + "\"," + string);
        return 0;
    }

    public static int uninstallPlugin(String string) {
        boolean bl = false;
        Enumeration enumeration = pluginsPrefs.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string) <= 0) continue;
            pluginsPrefs.removeElement(string2);
            bl = true;
            break;
        }
        if (bl) {
            return 0;
        }
        return -5;
    }

    public static boolean commandInUse(String string) {
        return pluginsTable.get(string) != null;
    }

    public static int convertShortcutToCode(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 2 && string.charAt(0) == 'F') {
            n = 112 + string.charAt(1) - 49;
            if (n >= 112 && n <= 120) {
                return n;
            }
            return 0;
        }
        if (n2 == 3 && string.charAt(0) == 'F') {
            n = 121 + string.charAt(2) - 48;
            if (n >= 121 && n <= 123) {
                return n;
            }
            return 0;
        }
        if (n2 == 2 && string.charAt(0) == 'N') {
            n = 96 + string.charAt(1) - 48;
            if (n >= 96 && n <= 105) {
                return n;
            }
            switch (string.charAt(1)) {
                case '/': {
                    return 111;
                }
                case '*': {
                    return 106;
                }
                case '-': {
                    return 109;
                }
                case '+': {
                    return 107;
                }
                case '.': {
                    return 110;
                }
            }
            return 0;
        }
        if (n2 != 1) {
            return 0;
        }
        char c = string.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            n = 65 + c - 65 + 200;
        } else if (c >= 'a' && c <= 'z') {
            n = 65 + c - 97;
        } else if (c >= '0' && c <= '9') {
            n = 48 + c - 48;
        }
        return n;
    }

    void installStartupMacroSet() {
        if (applet != null) {
            int n;
            String string = "" + applet.getDocumentBase();
            if (!string.endsWith("/") && (n = string.lastIndexOf("/")) != -1) {
                string = string.substring(0, n + 1);
            }
            IJ.runPlugIn("ij.plugin.URLOpener", string + "StartupMacros.txt");
            return;
        }
        if (macrosPath == null) {
            new MacroInstaller().installFromIJJar("/macros/StartupMacros.txt");
            return;
        }
        String string = macrosPath + "StartupMacros.txt";
        File file = new File(string);
        if (!file.exists() && !(file = new File(string = macrosPath + "StartupMacros.ijm")).exists()) {
            new MacroInstaller().installFromIJJar("/macros/StartupMacros.txt");
            return;
        }
        String string2 = macrosPath + "Library.txt";
        file = new File(string2);
        boolean bl = file.exists();
        try {
            MacroInstaller macroInstaller = new MacroInstaller();
            if (bl) {
                macroInstaller.installLibrary(string2);
            }
            macroInstaller.installFile(string);
            nMacros += macroInstaller.getMacroCount();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean validShortcut(String string) {
        int n = string.length();
        if (string.equals("")) {
            return true;
        }
        if (n == 1) {
            return true;
        }
        return string.startsWith("F") && (n == 2 || n == 3);
    }

    public static boolean shortcutInUse(String string) {
        int n = Menus.convertShortcutToCode(string);
        return shortcuts.get(new Integer(n)) != null;
    }

    public static void setFontSize(int n) {
        if (n < 9 && n != 0) {
            n = 9;
        }
        if (n > 24) {
            n = 24;
        }
        fontSize = n;
    }

    public static int getFontSize() {
        return IJ.isMacintosh() ? 0 : fontSize;
    }

    public static Font getFont() {
        if (menuFont == null) {
            menuFont = new Font("SanSerif", 0, fontSize == 0 ? 12 : fontSize);
        }
        return menuFont;
    }

    public static void savePreferences(Properties properties) {
        String string;
        int n = 0;
        Enumeration enumeration = pluginsPrefs.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = "plugin" + n / 10 % 10 + n % 10;
            string = (String)enumeration.nextElement();
            properties.put(string2, string);
            ++n;
        }
        int n2 = openRecentMenu.getItemCount();
        for (int i = 0; i < n2; ++i) {
            string = "" + i;
            if (string.length() == 1) {
                string = "0" + string;
            }
            string = "recent" + string;
            properties.put(string, openRecentMenu.getItem(i).getLabel());
        }
        properties.put("menu.size", Integer.toString(fontSize));
    }

    public static void updateImageJMenus() {
        macroFiles = null;
        jarFiles = null;
        Menus menus = new Menus(IJ.getInstance(), IJ.getApplet());
        String string = menus.addMenuBar();
        if (string != null) {
            IJ.error(string);
        }
        IJ.setClassLoader(null);
        IJ.runPlugIn("ij.plugin.ClassChecker", "");
        IJ.showStatus("Menus updated: " + nPlugins + " commands, " + nMacros + " macros");
    }

    static {
        defaultFontSize = IJ.isWindows() ? 14 : 0;
        fontSize = Prefs.getInt("menu.size", defaultFontSize);
    }
}

