/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Line;
import ij.gui.ShapeRoi;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;

public class Arrow
extends Line {
    public static final String STYLE_KEY = "arrow.style";
    public static final String WIDTH_KEY = "arrow.width";
    public static final String SIZE_KEY = "arrow.size";
    public static final String DOUBLE_HEADED_KEY = "arrow.double";
    public static final String OUTLINE_KEY = "arrow.outline";
    public static final int FILLED = 0;
    public static final int NOTCHED = 1;
    public static final int OPEN = 2;
    public static final int HEADLESS = 3;
    public static final String[] styles = new String[]{"Filled", "Notched", "Open", "Headless"};
    private static int defaultStyle = (int)Prefs.get("arrow.style", 0.0);
    private static float defaultWidth = (float)Prefs.get("arrow.width", 2.0);
    private static double defaultHeadSize = (int)Prefs.get("arrow.size", 10.0);
    private static boolean defaultDoubleHeaded = Prefs.get("arrow.double", false);
    private static boolean defaultOutline = Prefs.get("arrow.outline", false);
    private int style;
    private double headSize = 10.0;
    private boolean doubleHeaded;
    private boolean outline;
    private float[] points = new float[10];
    private GeneralPath path = new GeneralPath();
    private static Stroke defaultStroke = new BasicStroke();

    public Arrow(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.setStrokeWidth(2.0f);
    }

    public Arrow(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.setStrokeWidth(defaultWidth);
        this.style = defaultStyle;
        this.headSize = defaultHeadSize;
        this.doubleHeaded = defaultDoubleHeaded;
        this.outline = defaultOutline;
    }

    @Override
    public void draw(Graphics graphics) {
        Color color;
        Shape shape = null;
        if (this.doubleHeaded) {
            this.flipEnds();
            shape = this.getShape();
            this.flipEnds();
        }
        Shape shape2 = this.getShape();
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        graphics.setColor(color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getDeviceConfiguration().getDefaultTransform();
        double d = this.getMagnification();
        int n = 0;
        int n2 = 0;
        if (this.ic != null) {
            Rectangle rectangle = this.ic.getSrcRect();
            n = rectangle.x;
            n2 = rectangle.y;
        }
        affineTransform.setTransform(d, 0.0, 0.0, d, (double)(-n) * d, (double)(-n2) * d);
        if (this.outline) {
            float f = (float)(this.getOutlineWidth() * d);
            graphics2D.setStroke(new BasicStroke(f, 0, 1));
            graphics2D.draw(affineTransform.createTransformedShape(shape2));
            if (this.doubleHeaded) {
                graphics2D.draw(affineTransform.createTransformedShape(shape));
            }
            graphics2D.setStroke(defaultStroke);
        } else {
            graphics2D.fill(affineTransform.createTransformedShape(shape2));
            if (this.doubleHeaded) {
                graphics2D.fill(affineTransform.createTransformedShape(shape));
            }
        }
        if (this.state != 0 && !this.overlay) {
            int n3 = 2;
            this.handleColor = Color.white;
            this.drawHandle(graphics, this.screenXD(this.x1d) - n3, this.screenYD(this.y1d) - n3);
            this.drawHandle(graphics, this.screenXD(this.x2d) - n3, this.screenYD(this.y2d) - n3);
            this.drawHandle(graphics, this.screenXD(this.x1d + (this.x2d - this.x1d) / 2.0) - n3, this.screenYD(this.y1d + (this.y2d - this.y1d) / 2.0) - n3);
        }
        if (this.imp != null && this.imp.getRoi() != null) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    private void flipEnds() {
        double d = this.x1R;
        this.x1R = this.x2R;
        this.x2R = d;
        d = this.y1R;
        this.y1R = this.y2R;
        this.y2R = d;
    }

    private Shape getPath() {
        this.path.reset();
        this.path = new GeneralPath();
        this.calculatePoints();
        this.path.moveTo(this.points[0], this.points[1]);
        this.path.lineTo(this.points[2], this.points[3]);
        this.path.moveTo(this.points[2], this.points[3]);
        if (this.style == 2) {
            this.path.moveTo(this.points[4], this.points[5]);
        } else {
            this.path.lineTo(this.points[4], this.points[5]);
        }
        this.path.lineTo(this.points[6], this.points[7]);
        this.path.lineTo(this.points[8], this.points[9]);
        this.path.lineTo(this.points[2], this.points[3]);
        return this.path;
    }

    private void calculatePoints() {
        double d;
        double d2 = 0.0;
        double d3 = this.getStrokeWidth();
        double d4 = 8.0 + 10.0 * d3 * 0.5;
        d4 *= this.headSize / 10.0;
        d4 -= d3 * 1.42;
        if (this.style == 1) {
            d4 *= 0.74;
        }
        if (this.style == 2) {
            d4 *= 1.32;
        }
        if (d4 < 0.0 || this.style == 3) {
            d4 = 0.0;
        }
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        double d5 = this.x2d - this.x1d;
        double d6 = this.y2d - this.y1d;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        d5 /= d7;
        d6 /= d7;
        if (this.doubleHeaded && this.style != 3) {
            this.points[0] = (float)(this.x1d + d5 * d3 * 2.0);
            this.points[1] = (float)(this.y1d + d6 * d3 * 2.0);
        } else {
            this.points[0] = (float)this.x1d;
            this.points[1] = (float)this.y1d;
        }
        if (d4 > 0.0) {
            d = this.style == 2 ? 1.3 : 1.42;
            this.points[6] = (float)(this.x2d - d5 * d3 * d);
            this.points[7] = (float)(this.y2d - d6 * d3 * d);
        } else {
            this.points[6] = (float)this.x2d;
            this.points[7] = (float)this.y2d;
        }
        d = Math.atan2(this.points[7] - this.points[1], this.points[6] - this.points[0]);
        double d8 = 0.0;
        switch (this.style) {
            case 0: 
            case 3: {
                d2 = Math.toRadians(20.0);
                double d9 = Math.toRadians(90.0);
                this.points[2] = (float)((double)this.points[6] - d4 * Math.cos(d));
                this.points[3] = (float)((double)this.points[7] - d4 * Math.sin(d));
                d8 = d4 * Math.sin(d9) / Math.sin(d9 + d2);
                break;
            }
            case 1: {
                d2 = Math.toRadians(20.0);
                double d10 = Math.toRadians(120.0);
                this.points[2] = (float)((double)this.points[6] - d4 * Math.cos(d));
                this.points[3] = (float)((double)this.points[7] - d4 * Math.sin(d));
                d8 = d4 * Math.sin(d10) / Math.sin(d10 + d2);
                break;
            }
            case 2: {
                d2 = Math.toRadians(25.0);
                this.points[2] = this.points[6];
                this.points[3] = this.points[7];
                d8 = d4;
            }
        }
        this.points[4] = (float)((double)this.points[6] - d8 * Math.cos(d + d2));
        this.points[5] = (float)((double)this.points[7] - d8 * Math.sin(d + d2));
        this.points[8] = (float)((double)this.points[6] - d8 * Math.cos(d - d2));
        this.points[9] = (float)((double)this.points[7] - d8 * Math.sin(d - d2));
    }

    private Shape getShape() {
        Shape shape = this.getPath();
        BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(), 0, 0);
        Shape shape2 = basicStroke.createStrokedShape(shape);
        Area area = new Area(shape);
        Area area2 = new Area(shape2);
        try {
            area.add(area2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return area;
    }

    private ShapeRoi getShapeRoi() {
        Shape shape = this.getPath();
        BasicStroke basicStroke = new BasicStroke(this.getStrokeWidth(), 0, 0);
        ShapeRoi shapeRoi = new ShapeRoi(shape);
        Shape shape2 = basicStroke.createStrokedShape(shape);
        shapeRoi.or(new ShapeRoi(shape2));
        return shapeRoi;
    }

    @Override
    public ImageProcessor getMask() {
        return this.getShapeRoi().getMask();
    }

    private double getOutlineWidth() {
        double d;
        double d2;
        double d3 = (double)this.getStrokeWidth() / 8.0;
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        if ((d2 = this.headSize / 8.0) < 1.0) {
            d2 = 1.0;
        }
        if ((d = d3 * d2) < 1.0) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public void drawPixels(ImageProcessor imageProcessor) {
        ShapeRoi shapeRoi = this.getShapeRoi();
        ShapeRoi shapeRoi2 = null;
        if (this.doubleHeaded) {
            this.flipEnds();
            shapeRoi2 = this.getShapeRoi();
            this.flipEnds();
        }
        if (this.outline) {
            int n = imageProcessor.getLineWidth();
            imageProcessor.setLineWidth((int)Math.round(this.getOutlineWidth()));
            shapeRoi.drawPixels(imageProcessor);
            if (this.doubleHeaded) {
                shapeRoi2.drawPixels(imageProcessor);
            }
            imageProcessor.setLineWidth(n);
        } else {
            imageProcessor.fill(shapeRoi);
            if (this.doubleHeaded) {
                imageProcessor.fill(shapeRoi2);
            }
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.getShapeRoi().contains(n, n2);
    }

    @Override
    public Rectangle getBounds() {
        return this.getShapeRoi().getBounds();
    }

    @Override
    protected void handleMouseDown(int n, int n2) {
        super.handleMouseDown(n, n2);
        this.startxd = this.ic != null ? this.ic.offScreenXD(n) : (double)n;
        this.startyd = this.ic != null ? this.ic.offScreenYD(n2) : (double)n2;
    }

    @Override
    protected int clipRectMargin() {
        double d = this.getMagnification();
        double d2 = this.getStrokeWidth();
        double d3 = 8.0 + 10.0 * d2 * d * 0.5;
        return (int)Math.max(d3 * 2.0, this.headSize);
    }

    @Override
    public boolean isDrawingTool() {
        return true;
    }

    public static void setDefaultWidth(double d) {
        defaultWidth = (float)d;
    }

    public static double getDefaultWidth() {
        return defaultWidth;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public static void setDefaultStyle(int n) {
        defaultStyle = n;
    }

    public static int getDefaultStyle() {
        return defaultStyle;
    }

    public void setHeadSize(double d) {
        this.headSize = d;
    }

    public double getHeadSize() {
        return this.headSize;
    }

    public static void setDefaultHeadSize(double d) {
        defaultHeadSize = d;
    }

    public static double getDefaultHeadSize() {
        return defaultHeadSize;
    }

    public void setDoubleHeaded(boolean bl) {
        this.doubleHeaded = bl;
    }

    public boolean getDoubleHeaded() {
        return this.doubleHeaded;
    }

    public static void setDefaultDoubleHeaded(boolean bl) {
        defaultDoubleHeaded = bl;
    }

    public static boolean getDefaultDoubleHeaded() {
        return defaultDoubleHeaded;
    }

    public void setOutline(boolean bl) {
        this.outline = bl;
    }

    public boolean getOutline() {
        return this.outline;
    }

    public static void setDefaultOutline(boolean bl) {
        defaultOutline = bl;
    }

    public static boolean getDefaultOutline() {
        return defaultOutline;
    }

    static {
        if (defaultStyle < 0 || defaultStyle > 3) {
            defaultStyle = 0;
        }
    }
}

