/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import java.awt.Graphics;
import java.awt.Rectangle;

public class EllipseRoi
extends PolygonRoi {
    private static final int vertices = 72;
    private static double defaultRatio = 0.6;
    private double xstart;
    private double ystart;
    private double aspectRatio = defaultRatio;
    private int[] handle = new int[]{0, 18, 36, 54};

    public EllipseRoi(double d, double d2, double d3, double d4, double d5) {
        super(new float[72], new float[72], 72, 3);
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (d5 > 1.0) {
            d5 = 1.0;
        }
        this.aspectRatio = d5;
        this.makeEllipse(d, d2, d3, d4);
        this.state = 3;
    }

    public EllipseRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = 3;
        this.xstart = this.ic.offScreenX(n);
        this.ystart = this.ic.offScreenY(n2);
    }

    @Override
    public void draw(Graphics graphics) {
        super.draw(graphics);
        int n = 2;
        if (!this.overlay) {
            this.mag = this.ic != null ? this.ic.getMagnification() : 1.0;
            for (int i = 0; i < this.handle.length; ++i) {
                this.drawHandle(graphics, this.xp2[this.handle[i]] - n, this.yp2[this.handle[i]] - n);
            }
        }
    }

    @Override
    protected void grow(int n, int n2) {
        double d = this.xpf[this.handle[2]] + (float)this.x;
        double d2 = this.ypf[this.handle[2]] + (float)this.y;
        double d3 = this.ic.offScreenXD(n);
        double d4 = this.ic.offScreenYD(n2);
        this.makeEllipse(d, d2, d3, d4);
        this.imp.draw();
    }

    void makeEllipse(double d, double d2, double d3, double d4) {
        double d5 = (d + d3) / 2.0;
        double d6 = (d2 + d4) / 2.0;
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = d9 * this.aspectRatio;
        double d11 = Math.atan2(d8, d7);
        double d12 = d11 * 180.0 / Math.PI;
        this.nPoints = 0;
        for (int i = 0; i < 72; ++i) {
            double d13 = (double)i * 360.0 / 72.0;
            double d14 = d13 / 180.0 * Math.PI;
            d7 = Math.cos(d14) * d9 / 2.0;
            d8 = Math.sin(d14) * d10 / 2.0;
            double d15 = Math.atan2(d8, d7);
            double d16 = Math.sqrt(d7 * d7 + d8 * d8);
            double d17 = d15 + d12 / 180.0 * Math.PI;
            double d18 = Math.cos(d17) * d16;
            double d19 = Math.sin(d17) * d16;
            this.xpf[this.nPoints] = (float)(d5 + d18);
            this.ypf[this.nPoints] = (float)(d6 + d19);
            ++this.nPoints;
        }
        this.makePolygonRelative();
        this.cachedMask = null;
    }

    void makePolygonRelative() {
        FloatPolygon floatPolygon = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
        Rectangle rectangle = floatPolygon.getBounds();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        for (int i = 0; i < this.nPoints; ++i) {
            this.xpf[i] = this.xpf[i] - (float)this.x;
            this.ypf[i] = this.ypf[i] - (float)this.y;
        }
    }

    @Override
    protected void handleMouseUp(int n, int n2) {
        if (this.state == 0) {
            this.addOffset();
            this.finishPolygon();
            if (Recorder.record) {
                double d = this.xpf[this.handle[2]] + (float)this.x;
                double d2 = this.ypf[this.handle[2]] + (float)this.y;
                double d3 = this.xpf[this.handle[0]] + (float)this.x;
                double d4 = this.ypf[this.handle[0]] + (float)this.y;
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("imp.setRoi(new EllipseRoi(" + d + ", " + d2 + ", " + d3 + ", " + d4 + ", " + IJ.d2s(this.aspectRatio, 2) + "));");
                } else {
                    Recorder.record("makeEllipse", (int)d, (int)d2, (int)d3, (int)d4, this.aspectRatio);
                }
            }
        }
        this.state = 3;
    }

    @Override
    protected void moveHandle(int n, int n2) {
        double d = this.ic.offScreenXD(n);
        double d2 = this.ic.offScreenYD(n2);
        double d3 = this.xpf[this.handle[2]] + (float)this.x;
        double d4 = this.ypf[this.handle[2]] + (float)this.y;
        double d5 = this.xpf[this.handle[0]] + (float)this.x;
        double d6 = this.ypf[this.handle[0]] + (float)this.y;
        switch (this.activeHandle) {
            case 0: {
                d5 = d;
                d6 = d2;
                break;
            }
            case 1: {
                double d7 = (double)(this.xpf[this.handle[3]] + (float)this.x) - d;
                double d8 = (double)(this.ypf[this.handle[3]] + (float)this.y) - d2;
                this.updateRatio(Math.sqrt(d7 * d7 + d8 * d8), d3, d4, d5, d6);
                break;
            }
            case 2: {
                d3 = d;
                d4 = d2;
                break;
            }
            case 3: {
                double d9 = (double)(this.xpf[this.handle[1]] + (float)this.x) - d;
                double d10 = (double)(this.ypf[this.handle[1]] + (float)this.y) - d2;
                this.updateRatio(Math.sqrt(d9 * d9 + d10 * d10), d3, d4, d5, d6);
            }
        }
        this.makeEllipse(d3, d4, d5, d6);
        this.imp.draw();
    }

    void updateRatio(double d, double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        this.aspectRatio = d / d8;
        if (this.aspectRatio > 1.0) {
            this.aspectRatio = 1.0;
        }
        defaultRatio = this.aspectRatio;
    }

    @Override
    public int isHandle(int n, int n2) {
        int n3 = 10;
        int n4 = n3 / 2;
        int n5 = -1;
        for (int i = 0; i < this.handle.length; ++i) {
            int n6 = this.xp2[this.handle[i]] - n4;
            int n7 = this.yp2[this.handle[i]] - n4;
            if (n < n6 || n > n6 + n3 || n2 < n7 || n2 > n7 + n3) continue;
            n5 = i;
            break;
        }
        return n5;
    }

    @Override
    public double getLength() {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = 1.0;
        if (this.imp != null) {
            Calibration calibration = this.imp.getCalibration();
            d4 = calibration.pixelWidth * calibration.pixelWidth;
            d5 = calibration.pixelHeight * calibration.pixelHeight;
        }
        for (int i = 0; i < this.nPoints - 1; ++i) {
            d2 = this.xpf[i + 1] - this.xpf[i];
            d = this.ypf[i + 1] - this.ypf[i];
            d3 += Math.sqrt(d2 * d2 * d4 + d * d * d5);
        }
        d2 = this.xpf[0] - this.xpf[this.nPoints - 1];
        d = this.ypf[0] - this.ypf[this.nPoints - 1];
        return d3 += Math.sqrt(d2 * d2 * d4 + d * d * d5);
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.xpf[this.handle[2]] + (float)this.x, this.ypf[this.handle[2]] + (float)this.y, this.xpf[this.handle[0]] + (float)this.x, this.ypf[this.handle[0]] + (float)this.y, this.aspectRatio};
        return dArray;
    }

    @Override
    public double[] getFeretValues() {
        Object object;
        double[] dArray = super.getFeretValues();
        double d = 1.0;
        double d2 = 1.0;
        if (this.imp != null) {
            object = this.imp.getCalibration();
            d = object.pixelWidth;
            d2 = object.pixelHeight;
        }
        object = this.getParams();
        double d3 = (object[2] - object[0]) * d;
        double d4 = (object[3] - object[1]) * d2;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = d5 * object[4];
        dArray[0] = d5;
        dArray[2] = d == d2 ? d6 : dArray[2];
        return dArray;
    }
}

