/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Roi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;

public class Overlay {
    private Vector list = new Vector();
    private boolean label;
    private boolean drawNames;
    private boolean drawBackgrounds;
    private Color labelColor;
    private Font labelFont;

    public Overlay() {
    }

    public Overlay(Roi roi) {
        this.list.add(roi);
    }

    public void add(Roi roi) {
        this.list.add(roi);
    }

    public void addElement(Roi roi) {
        this.list.add(roi);
    }

    public void remove(int n) {
        this.list.remove(n);
    }

    public void remove(Roi roi) {
        this.list.remove(roi);
    }

    public void clear() {
        this.list.clear();
    }

    public Roi get(int n) {
        return (Roi)this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    public Roi[] toArray() {
        Roi[] roiArray = new Roi[this.list.size()];
        return this.list.toArray(roiArray);
    }

    public void setStrokeColor(Color color) {
        Roi[] roiArray = this.toArray();
        for (int i = 0; i < roiArray.length; ++i) {
            roiArray[i].setStrokeColor(color);
        }
    }

    public void setFillColor(Color color) {
        Roi[] roiArray = this.toArray();
        for (int i = 0; i < roiArray.length; ++i) {
            roiArray[i].setFillColor(color);
        }
    }

    public void translate(int n, int n2) {
        Roi[] roiArray = this.toArray();
        for (int i = 0; i < roiArray.length; ++i) {
            Rectangle rectangle = roiArray[i].getBounds();
            roiArray[i].setLocation(rectangle.x + n, rectangle.y + n2);
        }
    }

    public Overlay duplicate() {
        Roi[] roiArray = this.toArray();
        Overlay overlay = new Overlay();
        for (int i = 0; i < roiArray.length; ++i) {
            overlay.add((Roi)roiArray[i].clone());
        }
        overlay.drawLabels(this.label);
        overlay.drawNames(this.drawNames);
        overlay.drawBackgrounds(this.drawBackgrounds);
        overlay.setLabelColor(this.labelColor);
        overlay.setLabelFont(this.labelFont);
        return overlay;
    }

    public String toString() {
        return this.list.toString();
    }

    public void drawLabels(boolean bl) {
        this.label = bl;
    }

    public boolean getDrawLabels() {
        return this.label;
    }

    public void drawNames(boolean bl) {
        this.drawNames = bl;
    }

    public boolean getDrawNames() {
        return this.drawNames;
    }

    public void drawBackgrounds(boolean bl) {
        this.drawBackgrounds = bl;
    }

    public boolean getDrawBackgrounds() {
        return this.drawBackgrounds;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    void setVector(Vector vector) {
        this.list = vector;
    }

    Vector getVector() {
        return this.list;
    }
}

