/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Plot {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int DOT = 6;
    public static final int LINE = 2;
    public static final int X_NUMBERS = 1;
    public static final int Y_NUMBERS = 2;
    public static final int X_TICKS = 4;
    public static final int Y_TICKS = 8;
    public static final int X_GRID = 16;
    public static final int Y_GRID = 32;
    public static final int X_FORCE2GRID = 64;
    public static final int Y_FORCE2GRID = 128;
    public static final int DEFAULT_FLAGS = 51;
    public static final int LEFT_MARGIN = 60;
    public static final int RIGHT_MARGIN = 18;
    public static final int TOP_MARGIN = 15;
    public static final int BOTTOM_MARGIN = 40;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final int MAX_INTERVALS = 12;
    private static final int MIN_X_GRIDWIDTH = 60;
    private static final int MIN_Y_GRIDWIDTH = 40;
    private static final int TICK_LENGTH = 3;
    private final Color gridColor = new Color(0xC0C0C0);
    private int frameWidth;
    private int frameHeight;
    Rectangle frame = null;
    float[] xValues;
    float[] yValues;
    float[] errorBars;
    int nPoints;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    private double xScale;
    private double yScale;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private int flags;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private int lineWidth = 1;
    private int markSize = 5;
    private ImageProcessor ip;
    private String title;
    private boolean initialized;
    private boolean plotDrawn;
    private int plotWidth = PlotWindow.plotWidth;
    private int plotHeight = PlotWindow.plotHeight;
    private boolean multiplePlots;
    private boolean drawPending;
    private int sourceImageID;
    ArrayList storedData;

    public Plot(String string, String string2, String string3, float[] fArray, float[] fArray2, int n) {
        this.title = string;
        this.xLabel = string2;
        this.yLabel = string3;
        this.flags = n;
        this.storedData = new ArrayList();
        if (fArray == null || fArray2 == null) {
            fArray = new float[1];
            fArray2 = new float[1];
            fArray[0] = -1.0f;
            fArray2[0] = -1.0f;
        } else {
            this.storeData(fArray, fArray2);
        }
        this.xValues = fArray;
        this.yValues = fArray2;
        double[] dArray = Tools.getMinMax(fArray);
        this.xMin = dArray[0];
        this.xMax = dArray[1];
        dArray = Tools.getMinMax(fArray2);
        this.yMin = dArray[0];
        this.yMax = dArray[1];
        this.fixedYScale = false;
        this.nPoints = fArray.length;
        this.drawPending = true;
    }

    public Plot(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        this(string, string2, string3, fArray, fArray2, 51);
    }

    public Plot(String string, String string2, String string3, double[] dArray, double[] dArray2, int n) {
        this(string, string2, string3, dArray != null ? Tools.toFloat(dArray) : null, dArray2 != null ? Tools.toFloat(dArray2) : null, n);
    }

    public Plot(String string, String string2, String string3, double[] dArray, double[] dArray2) {
        this(string, string2, string3, dArray != null ? Tools.toFloat(dArray) : null, dArray2 != null ? Tools.toFloat(dArray2) : null, 51);
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.xMax = d2;
        this.yMin = d3;
        this.yMax = d4;
        this.fixedYScale = true;
        if (this.initialized) {
            this.ip.setColor(Color.white);
            this.ip.resetRoi();
            this.ip.fill();
            this.ip.setColor(Color.black);
            this.setScaleAndDrawAxisLabels();
        }
    }

    public void setSize(int n, int n2) {
        if (!this.initialized && n > 98 && n2 > 75) {
            this.plotWidth = n - 60 - 18;
            this.plotHeight = n2 - 15 - 40;
        }
    }

    public void setFrameSize(int n, int n2) {
        this.plotWidth = n;
        this.plotHeight = n2;
    }

    public void addPoints(float[] fArray, float[] fArray2, int n) {
        this.setup();
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.ip.setClipRect(this.frame);
                for (int i = 0; i < fArray.length; ++i) {
                    int n2 = 60 + (int)(((double)fArray[i] - this.xMin) * this.xScale);
                    int n3 = 15 + this.frameHeight - (int)(((double)fArray2[i] - this.yMin) * this.yScale);
                    this.drawShape(n, n2, n3, this.markSize);
                }
                this.ip.setClipRect(null);
                break;
            }
            case 2: {
                this.drawFloatPolyline(this.ip, fArray, fArray2, fArray.length);
            }
        }
        this.multiplePlots = true;
        if (this.xValues.length == 1) {
            this.xValues = fArray;
            this.yValues = fArray2;
            this.nPoints = fArray.length;
            this.drawPending = false;
        }
        this.storeData(fArray, fArray2);
    }

    public void addPoints(double[] dArray, double[] dArray2, int n) {
        this.addPoints(Tools.toFloat(dArray), Tools.toFloat(dArray2), n);
    }

    void drawShape(int n, int n2, int n3, int n4) {
        int n5 = n2 - n4 / 2;
        int n6 = n3 - n4 / 2;
        switch (n) {
            case 1: {
                this.ip.drawLine(n5, n6, n5 + n4, n6 + n4);
                this.ip.drawLine(n5 + n4, n6, n5, n6 + n4);
                break;
            }
            case 3: {
                this.ip.drawLine(n5, n6, n5 + n4, n6);
                this.ip.drawLine(n5 + n4, n6, n5 + n4, n6 + n4);
                this.ip.drawLine(n5 + n4, n6 + n4, n5, n6 + n4);
                this.ip.drawLine(n5, n6 + n4, n5, n6);
                break;
            }
            case 4: {
                this.ip.drawLine(n2, n6, n5 + n4, n6 + n4);
                this.ip.drawLine(n5 + n4, n6 + n4, n5, n6 + n4);
                this.ip.drawLine(n5, n6 + n4, n2, n6);
                break;
            }
            case 5: {
                this.ip.drawLine(n5, n3, n5 + n4, n3);
                this.ip.drawLine(n2, n6, n2, n6 + n4);
                break;
            }
            case 6: {
                this.ip.drawDot(n2, n3);
                break;
            }
            default: {
                this.ip.drawLine(n2 - 1, n3 - 2, n2 + 1, n3 - 2);
                this.ip.drawLine(n2 - 1, n3 + 2, n2 + 1, n3 + 2);
                this.ip.drawLine(n2 + 2, n3 + 1, n2 + 2, n3 - 1);
                this.ip.drawLine(n2 - 2, n3 + 1, n2 - 2, n3 - 1);
            }
        }
    }

    public void addErrorBars(float[] fArray) {
        if (fArray.length != this.nPoints) {
            throw new IllegalArgumentException("errorBars.length != npoints");
        }
        this.errorBars = fArray;
    }

    public void addErrorBars(double[] dArray) {
        this.addErrorBars(Tools.toFloat(dArray));
    }

    public void addLabel(double d, double d2, String string) {
        this.setup();
        int n = 60 + (int)(d * (double)this.frameWidth);
        int n2 = 15 + (int)(d2 * (double)this.frameHeight);
        this.ip.drawString(string, n, n2);
    }

    public void setJustification(int n) {
        this.setup();
        this.ip.setJustification(n);
    }

    public void setColor(Color color) {
        this.setup();
        if (!(this.ip instanceof ColorProcessor)) {
            this.ip = this.ip.convertToRGB();
            this.ip.setLineWidth(this.lineWidth);
            this.ip.setFont(this.font);
            this.ip.setAntialiasedText(true);
        }
        this.ip.setColor(color);
    }

    public void setLineWidth(int n) {
        if (n < 1) {
            n = 1;
        }
        this.setup();
        this.ip.setLineWidth(n);
        this.lineWidth = n;
        this.markSize = n == 1 ? 5 : 7;
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.setup();
        int n = 60 + (int)Math.round((d - this.xMin) * this.xScale);
        int n2 = 15 + this.frameHeight - (int)Math.round((d2 - this.yMin) * this.yScale);
        int n3 = 60 + (int)Math.round((d3 - this.xMin) * this.xScale);
        int n4 = 15 + this.frameHeight - (int)Math.round((d4 - this.yMin) * this.yScale);
        this.ip.drawLine(n, n2, n3, n4);
    }

    public void changeFont(Font font) {
        this.setup();
        this.ip.setFont(font);
        this.font = font;
    }

    void setup() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.createImage();
        this.ip.setColor(Color.black);
        if (this.lineWidth > 3) {
            this.lineWidth = 3;
        }
        this.ip.setLineWidth(this.lineWidth);
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = this.plotWidth;
            this.frameHeight = this.plotHeight;
        }
        this.frame = new Rectangle(60, 15, this.frameWidth, this.frameHeight);
        this.setScaleAndDrawAxisLabels();
    }

    void setScaleAndDrawAxisLabels() {
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
        if (PlotWindow.noGridLines) {
            this.drawAxisLabels();
        } else {
            this.drawTicksEtc();
        }
    }

    void drawAxisLabels() {
        int n = this.getDigits(this.yMin, this.yMax);
        String string = IJ.d2s(this.yMax, n);
        int n2 = this.ip.getStringWidth(string);
        if (n2 + 4 > 60) {
            this.ip.drawString(string, 4, 11);
        } else {
            this.ip.drawString(string, 60 - this.ip.getStringWidth(string) - 4, 25);
        }
        string = IJ.d2s(this.yMin, n);
        n2 = this.ip.getStringWidth(string);
        if (n2 + 4 > 60) {
            this.ip.drawString(string, 4, 15 + this.frame.height);
        } else {
            this.ip.drawString(string, 60 - this.ip.getStringWidth(string) - 4, 15 + this.frame.height);
        }
        FontMetrics fontMetrics = this.ip.getFontMetrics();
        int n3 = 60;
        int n4 = 15 + this.frame.height + fontMetrics.getAscent() + 6;
        n = this.getDigits(this.xMin, this.xMax);
        this.ip.drawString(IJ.d2s(this.xMin, n), n3, n4);
        string = IJ.d2s(this.xMax, n);
        this.ip.drawString(string, n3 + this.frame.width - this.ip.getStringWidth(string) + 6, n4);
        this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, n4 + 3);
        this.drawYLabel(this.yLabel, 56, 15, this.frame.height, fontMetrics);
    }

    void drawTicksEtc() {
        String string;
        int n;
        double d;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.ip.getFontMetrics().getAscent();
        int n9 = this.ip.getFontMetrics().getMaxAscent();
        if ((this.flags & 0x15) != 0) {
            int n10;
            double d2 = Math.abs((double)Math.max(this.frame.width / 12, 60) / this.xScale);
            d2 = this.niceNumber(d2);
            if ((this.flags & 0x40) != 0) {
                n10 = (int)Math.floor(Math.min(this.xMin, this.xMax) / d2 + 1.0E-10);
                n7 = (int)Math.ceil(Math.max(this.xMin, this.xMax) / d2 - 1.0E-10);
                this.xMin = (double)n10 * d2;
                this.xMax = (double)n7 * d2;
                this.xScale = (double)this.frame.width / (this.xMax - this.xMin);
            } else {
                n10 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / d2 - 1.0E-10);
                n7 = (int)Math.floor(Math.max(this.xMin, this.xMax) / d2 + 1.0E-10);
            }
            n6 = -((int)Math.floor(Math.log(d2) / Math.log(10.0) + 1.0E-6));
            if (n6 < 0) {
                n6 = 0;
            }
            if (n6 > 5) {
                n6 = -3;
            }
            n5 = 15;
            n4 = 15 + this.frame.height;
            n3 = n4 + n8 + 7;
            for (n2 = 0; n2 <= n7 - n10; ++n2) {
                d = (double)(n2 + n10) * d2;
                n = (int)Math.round((d - this.xMin) * this.xScale) + 60;
                if ((this.flags & 0x10) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(n, n5, n, n4);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 4) != 0) {
                    this.ip.drawLine(n, n5, n, n5 + 3);
                    this.ip.drawLine(n, n4, n, n4 - 3);
                }
                if ((this.flags & 1) == 0) continue;
                string = IJ.d2s(d, n6);
                this.ip.drawString(string, n - this.ip.getStringWidth(string) / 2, n3);
            }
        }
        int n11 = 0;
        if ((this.flags & 0x2A) != 0) {
            double d3 = Math.abs((double)Math.max(this.frame.width / 12, 40) / this.yScale);
            d3 = this.niceNumber(d3);
            if ((this.flags & 0x40) != 0) {
                n7 = (int)Math.floor(Math.min(this.yMin, this.yMax) / d3 + 1.0E-10);
                n6 = (int)Math.ceil(Math.max(this.yMin, this.yMax) / d3 - 1.0E-10);
                this.yMin = (double)n7 * d3;
                this.yMax = (double)n6 * d3;
                this.yScale = (double)this.frame.height / (this.yMax - this.yMin);
            } else {
                n7 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / d3 - 1.0E-10);
                n6 = (int)Math.floor(Math.max(this.yMin, this.yMax) / d3 + 1.0E-10);
            }
            n5 = -((int)Math.floor(Math.log(d3) / Math.log(10.0) + 1.0E-6));
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > 5) {
                n5 = -3;
            }
            n4 = 60;
            n3 = 60 + this.frame.width;
            for (n2 = 0; n2 <= n6 - n7; ++n2) {
                d = (double)(n2 + n7) * d3;
                n = 15 + this.frame.height - (int)Math.round((d - this.yMin) * this.yScale);
                if ((this.flags & 0x20) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(n4, n, n3, n);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 8) != 0) {
                    this.ip.drawLine(n4, n, n4 + 3, n);
                    this.ip.drawLine(n3, n, n3 - 3, n);
                }
                if ((this.flags & 2) == 0) continue;
                string = IJ.d2s(d, n5);
                int n12 = this.ip.getStringWidth(string);
                if (n12 > n11) {
                    n11 = n12;
                }
                this.ip.drawString(string, 60 - n12 - 4, n + n9 / 2 + 1);
            }
        }
        if ((this.flags & 2) == 0) {
            int n13 = this.getDigits(this.yMin, this.yMax);
            String string2 = IJ.d2s(this.yMax, n13);
            n7 = this.ip.getStringWidth(string2);
            if (n7 + 4 > 60) {
                this.ip.drawString(string2, 4, 11);
            } else {
                this.ip.drawString(string2, 60 - this.ip.getStringWidth(string2) - 4, 25);
            }
            string2 = IJ.d2s(this.yMin, n13);
            n7 = this.ip.getStringWidth(string2);
            if (n7 + 4 > 60) {
                this.ip.drawString(string2, 4, 15 + this.frame.height);
            } else {
                this.ip.drawString(string2, 60 - this.ip.getStringWidth(string2) - 4, 15 + this.frame.height);
            }
        }
        FontMetrics fontMetrics = this.ip.getFontMetrics();
        int n14 = 60;
        n7 = 15 + this.frame.height + fontMetrics.getAscent() + 6;
        if ((this.flags & 1) == 0) {
            n6 = this.getDigits(this.xMin, this.xMax);
            this.ip.drawString(IJ.d2s(this.xMin, n6), n14, n7);
            String string3 = IJ.d2s(this.xMax, n6);
            this.ip.drawString(string3, n14 + this.frame.width - this.ip.getStringWidth(string3) + 6, n7);
        } else {
            n7 += fontMetrics.getAscent();
        }
        this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, n7 + 6);
        this.drawYLabel(this.yLabel, 60 - n11 - 4, 15, this.frame.height, fontMetrics);
    }

    double niceNumber(double d) {
        double d2 = Math.pow(10.0, Math.floor(Math.log(d) / Math.log(10.0) - 1.0E-6));
        if (d > 5.0000001 * d2) {
            return 10.0 * d2;
        }
        if (d > 2.0000001 * d2) {
            return 5.0 * d2;
        }
        return 2.0 * d2;
    }

    void createImage() {
        if (this.ip != null) {
            return;
        }
        int n = this.plotWidth + 60 + 18;
        int n2 = this.plotHeight + 15 + 40;
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            byArray[i] = -1;
        }
        this.ip = new ByteProcessor(n, n2, byArray, null);
    }

    int getDigits(double d, double d2) {
        if ((double)Math.round(d) == d && (double)Math.round(d2) == d2) {
            return 0;
        }
        double d3 = (d = Math.abs(d)) < (d2 = Math.abs(d2)) && d > 0.0 ? d : d2;
        double d4 = Math.abs(d2 - d);
        if (d4 > 0.0 && d4 < d3) {
            d3 = d4;
        }
        int n = 1;
        if (d3 < 10.0) {
            n = 2;
        }
        if (d3 < 0.01) {
            n = 3;
        }
        if (d3 < 0.001) {
            n = 4;
        }
        if (d3 < 1.0E-4) {
            n = -3;
        }
        return n;
    }

    public void draw() {
        if (this.plotDrawn) {
            return;
        }
        this.plotDrawn = true;
        this.createImage();
        this.setup();
        if (this.drawPending) {
            this.drawFloatPolyline(this.ip, this.xValues, this.yValues, this.nPoints);
            if (this.errorBars != null) {
                int[] nArray = new int[2];
                int[] nArray2 = new int[2];
                for (int i = 0; i < this.nPoints; ++i) {
                    nArray[0] = nArray[1] = 60 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
                    nArray2[0] = 15 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin - (double)this.errorBars[i]) * this.yScale);
                    nArray2[1] = 15 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin + (double)this.errorBars[i]) * this.yScale);
                    this.drawPolyline(this.ip, nArray, nArray2, 2, false);
                }
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        if (this.lineWidth > 5) {
            this.ip.setLineWidth(5);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        this.ip.setLineWidth(this.lineWidth);
    }

    void drawPolyline(ImageProcessor imageProcessor, int[] nArray, int[] nArray2, int n, boolean bl) {
        if (bl) {
            imageProcessor.setClipRect(this.frame);
        }
        imageProcessor.moveTo(nArray[0], nArray2[0]);
        for (int i = 0; i < n; ++i) {
            imageProcessor.lineTo(nArray[i], nArray2[i]);
        }
        if (bl) {
            imageProcessor.setClipRect(null);
        }
    }

    void drawFloatPolyline(ImageProcessor imageProcessor, float[] fArray, float[] fArray2, int n) {
        if (fArray == null || fArray.length == 0) {
            return;
        }
        imageProcessor.setClipRect(this.frame);
        int n2 = 60 + (int)(((double)fArray[0] - this.xMin) * this.xScale);
        int n3 = 15 + this.frame.height - (int)(((double)fArray2[0] - this.yMin) * this.yScale);
        boolean bl = Float.isNaN(fArray2[0]);
        for (int i = 1; i < n; ++i) {
            int n4 = n2;
            int n5 = n3;
            boolean bl2 = bl;
            n2 = 60 + (int)(((double)fArray[i] - this.xMin) * this.xScale);
            n3 = 15 + this.frame.height - (int)(((double)fArray2[i] - this.yMin) * this.yScale);
            bl = Float.isNaN(fArray2[i]);
            if (bl2 || bl) continue;
            imageProcessor.drawLine(n4, n5, n2, n3);
        }
        imageProcessor.setClipRect(null);
    }

    void drawYLabel(String string, int n, int n2, int n3, FontMetrics fontMetrics) {
        if (string.equals("")) {
            return;
        }
        int n4 = fontMetrics.stringWidth(string) + 5;
        int n5 = fontMetrics.getHeight() + 5;
        ImageProcessor imageProcessor = new ByteProcessor(n4, n5);
        ((ImageProcessor)imageProcessor).setColor(Color.white);
        imageProcessor.fill();
        ((ImageProcessor)imageProcessor).setColor(Color.black);
        imageProcessor.setFont(this.font);
        imageProcessor.setAntialiasedText(true);
        int n6 = fontMetrics.getDescent();
        imageProcessor.drawString(string, 0, n5 - n6);
        imageProcessor = imageProcessor.rotateLeft();
        int n7 = n2 + (n3 - this.ip.getStringWidth(string)) / 2;
        if (n7 < n2) {
            n7 = n2;
        }
        int n8 = Math.max(n - n5, 0);
        this.ip.insert(imageProcessor, n8, n7);
    }

    ImageProcessor getBlankProcessor() {
        this.createImage();
        return this.ip;
    }

    String getCoordinates(int n, int n2) {
        String string = "";
        if (!this.frame.contains(n, n2)) {
            return string;
        }
        if (this.fixedYScale || this.multiplePlots) {
            double d = (double)(n - 60) / this.xScale + this.xMin;
            double d2 = (double)(15 + this.frameHeight - n2) / this.yScale + this.yMin;
            string = "X=" + IJ.d2s(d, this.getDigits(d, d)) + ", Y=" + IJ.d2s(d2, this.getDigits(d2, d2));
        } else {
            int n3 = (int)((double)(n - this.frame.x) / ((double)this.frame.width / (double)this.nPoints));
            if (n3 > 0 && n3 < this.nPoints) {
                double d = this.xValues[n3];
                double d3 = this.yValues[n3];
                string = "X=" + IJ.d2s(d, this.getDigits(d, d)) + ", Y=" + IJ.d2s(d3, this.getDigits(d3, d3));
            }
        }
        return string;
    }

    public ImageProcessor getProcessor() {
        this.draw();
        return this.ip;
    }

    public ImagePlus getImagePlus() {
        this.draw();
        ImagePlus imagePlus = new ImagePlus(this.title, this.ip);
        Calibration calibration = imagePlus.getCalibration();
        calibration.xOrigin = 60.0 - this.xMin * this.xScale;
        calibration.yOrigin = (double)(15 + this.frameHeight) + this.yMin * this.yScale;
        calibration.pixelWidth = 1.0 / this.xScale;
        calibration.pixelHeight = 1.0 / this.yScale;
        calibration.setInvertY(true);
        return imagePlus;
    }

    public PlotWindow show() {
        this.draw();
        if (Prefs.useInvertingLut && this.ip instanceof ByteProcessor && !Interpreter.isBatchMode() && IJ.getInstance() != null) {
            this.ip.invertLut();
            this.ip.invert();
        }
        if (IJ.macroRunning() && IJ.getInstance() == null || Interpreter.isBatchMode()) {
            ImagePlus imagePlus = new ImagePlus(this.title, this.ip);
            WindowManager.setTempCurrentImage(imagePlus);
            imagePlus.setProperty("XValues", this.xValues);
            imagePlus.setProperty("YValues", this.yValues);
            Interpreter.addBatchModeImage(imagePlus);
            return null;
        }
        ImageWindow.centerNextImage();
        return new PlotWindow(this);
    }

    private void storeData(float[] fArray, float[] fArray2) {
        this.storedData.add(fArray);
        this.storedData.add(fArray2);
    }

    void setSourceImageID(int n) {
        this.sourceImageID = n;
    }

    int getSourceImageID() {
        return this.sourceImageID;
    }
}

