/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import java.awt.Point;
import java.awt.Polygon;

class RoiBrush
implements Runnable {
    static int ADD = 0;
    static int SUBTRACT = 1;
    static int leftClick = 16;
    static int alt = 9;
    static int shift = 1;
    private Polygon poly;
    private Point previousP;
    private int mode = ADD;

    RoiBrush() {
        Thread thread = new Thread((Runnable)this, "RoiBrush");
        thread.start();
    }

    @Override
    public void run() {
        int n = Toolbar.getBrushSize();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi != null && !roi.isArea()) {
            imagePlus.killRoi();
        }
        Point point = imageCanvas.getCursorLoc();
        if (roi != null && !roi.contains(point.x, point.y)) {
            this.mode = SUBTRACT;
        }
        while (true) {
            if ((point = imageCanvas.getCursorLoc()).equals(this.previousP)) {
                IJ.wait(1);
                continue;
            }
            this.previousP = point;
            int n2 = imageCanvas.getModifiers();
            if ((n2 & leftClick) == 0) {
                return;
            }
            if ((n2 & shift) != 0) {
                this.mode = ADD;
            } else if ((n2 & alt) != 0) {
                this.mode = SUBTRACT;
            }
            if (this.mode == ADD) {
                this.addCircle(imagePlus, point.x, point.y, n);
                continue;
            }
            this.subtractCircle(imagePlus, point.x, point.y, n);
        }
    }

    void addCircle(ImagePlus imagePlus, int n, int n2, int n3) {
        Roi roi = imagePlus.getRoi();
        Roi roi2 = roi;
        if (roi2 != null) {
            if (!(roi2 instanceof ShapeRoi)) {
                roi2 = new ShapeRoi(roi2);
            }
            ((ShapeRoi)roi2).or(this.getCircularRoi(n, n2, n3));
            roi2.copyAttributes(roi);
        } else {
            roi2 = new OvalRoi(n - n3 / 2, n2 - n3 / 2, n3, n3);
        }
        imagePlus.setRoi(roi2);
    }

    void subtractCircle(ImagePlus imagePlus, int n, int n2, int n3) {
        Roi roi = imagePlus.getRoi();
        Roi roi2 = roi;
        if (roi2 != null) {
            if (!(roi2 instanceof ShapeRoi)) {
                roi2 = new ShapeRoi(roi2);
            }
            ((ShapeRoi)roi2).not(this.getCircularRoi(n, n2, n3));
            roi2.copyAttributes(roi);
            imagePlus.setRoi(roi2);
        }
    }

    ShapeRoi getCircularRoi(int n, int n2, int n3) {
        if (this.poly == null) {
            OvalRoi ovalRoi = new OvalRoi(n - n3 / 2, n2 - n3 / 2, n3, n3);
            this.poly = ((Roi)ovalRoi).getPolygon();
            int n4 = 0;
            while (n4 < this.poly.npoints) {
                int n5 = n4;
                this.poly.xpoints[n5] = this.poly.xpoints[n5] - n;
                int n6 = n4++;
                this.poly.ypoints[n6] = this.poly.ypoints[n6] - n2;
            }
        }
        return new ShapeRoi(n, n2, this.poly);
    }
}

