/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.process.ImageProcessor;
import java.awt.Polygon;

public class Wand {
    public static final int FOUR_CONNECTED = 4;
    public static final int EIGHT_CONNECTED = 8;
    public static final int LEGACY_MODE = 1;
    public int npoints;
    private int maxPoints = 1000;
    public int[] xpoints = new int[this.maxPoints];
    public int[] ypoints = new int[this.maxPoints];
    private static final int THRESHOLDED_MODE = 256;
    private ImageProcessor ip;
    private byte[] bpixels;
    private int[] cpixels;
    private short[] spixels;
    private float[] fpixels;
    private int width;
    private int height;
    private float lowerThreshold;
    private float upperThreshold;
    private int xmin;
    private boolean exactPixelValue;
    private static boolean allPoints;

    public Wand(ImageProcessor imageProcessor) {
        this.ip = imageProcessor;
        Object object = imageProcessor.getPixels();
        if (object instanceof byte[]) {
            this.bpixels = (byte[])object;
        } else if (object instanceof int[]) {
            this.cpixels = (int[])object;
        } else if (object instanceof short[]) {
            this.spixels = (short[])object;
        } else if (object instanceof float[]) {
            this.fpixels = (float[])object;
        }
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
    }

    public void autoOutline(int n, int n2, double d, double d2, int n3) {
        this.lowerThreshold = (float)d;
        this.upperThreshold = (float)d2;
        this.autoOutline(n, n2, 0.0, n3 | 0x100);
    }

    public void autoOutline(int n, int n2, double d, double d2) {
        this.autoOutline(n, n2, d, d2, 257);
    }

    public void autoOutline(int n, int n2, int n3, int n4) {
        this.autoOutline(n, n2, n3, n4, 257);
    }

    public void autoOutline(int n, int n2) {
        this.autoOutline(n, n2, 0.0, 1);
    }

    public void autoOutline(int n, int n2, double d, int n3) {
        int n4;
        int n5;
        int n6;
        boolean bl;
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return;
        }
        if (this.fpixels != null && Float.isNaN(this.getPixel(n, n2))) {
            return;
        }
        this.exactPixelValue = d == 0.0;
        boolean bl2 = (n3 & 0x100) != 0;
        boolean bl3 = bl = (n3 & 1) != 0 && d == 0.0;
        if (!bl2) {
            double d2 = this.getPixel(n, n2);
            this.lowerThreshold = (float)(d2 - d);
            this.upperThreshold = (float)(d2 + d);
        }
        if (this.inside(n6 = n, n5 = n2)) {
            n4 = n6;
            while (this.inside(++n6, n5)) {
            }
        } else {
            do {
                if (++n6 < this.width) continue;
                return;
            } while (!this.inside(n6, n5));
            n4 = n6;
        }
        boolean bl4 = bl ? !bl2 && !this.isLine(n6, n5) : (n3 & 4) != 0;
        boolean bl5 = true;
        while (true) {
            boolean bl6 = this.traceEdge(n6, n5, bl4);
            if (bl) {
                return;
            }
            if (bl6) {
                Polygon polygon;
                if (bl5) {
                    return;
                }
                if (this.xmin <= n4 && (polygon = new Polygon(this.xpoints, this.ypoints, this.npoints)).contains(n4, n2)) {
                    return;
                }
            }
            bl5 = false;
            if (!this.inside(n6, n5)) {
                do {
                    if (++n6 <= this.width) continue;
                    throw new RuntimeException("Wand Malfunction");
                } while (!this.inside(n6, n5));
            }
            while (this.inside(++n6, n5)) {
            }
        }
    }

    private boolean traceEdge(int n, int n2, boolean bl) {
        int n3;
        this.npoints = 0;
        this.xmin = this.width;
        if (this.inside(n, n2)) {
            n3 = 1;
        } else {
            n3 = 3;
            ++n2;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        do {
            int n7;
            if (bl) {
                n7 = n6;
                while (this.inside(n4, n5, n7) && ++n7 < n6 + 2) {
                }
                --n7;
            } else {
                n7 = n6 + 1;
                while (!this.inside(n4, n5, n7) && --n7 >= n6) {
                }
            }
            if (allPoints || n7 != n6) {
                this.addPoint(n4, n5);
            }
            switch (n7 & 3) {
                case 0: {
                    ++n4;
                    break;
                }
                case 1: {
                    --n5;
                    break;
                }
                case 2: {
                    --n4;
                    break;
                }
                case 3: {
                    ++n5;
                }
            }
            n6 = n7;
        } while (n4 != n || n5 != n2 || (n6 & 3) != n3);
        if (allPoints || this.xpoints[0] != n4) {
            this.addPoint(n4, n5);
        }
        return n6 <= 0;
    }

    private void addPoint(int n, int n2) {
        if (this.npoints == this.maxPoints) {
            int[] nArray = new int[this.maxPoints * 2];
            int[] nArray2 = new int[this.maxPoints * 2];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.maxPoints);
            System.arraycopy(this.ypoints, 0, nArray2, 0, this.maxPoints);
            this.xpoints = nArray;
            this.ypoints = nArray2;
            this.maxPoints *= 2;
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.xmin > n) {
            this.xmin = n;
        }
    }

    private boolean inside(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        float f = this.getPixel(n, n2);
        return f >= this.lowerThreshold && f <= this.upperThreshold;
    }

    private boolean inside(int n, int n2, int n3) {
        switch (n3 & 3) {
            case 0: {
                return this.inside(n, n2);
            }
            case 1: {
                return this.inside(n, n2 - 1);
            }
            case 2: {
                return this.inside(n - 1, n2 - 1);
            }
            case 3: {
                return this.inside(n - 1, n2);
            }
        }
        return false;
    }

    private float getPixel(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return Float.NaN;
        }
        if (this.bpixels != null) {
            return this.bpixels[n2 * this.width + n] & 0xFF;
        }
        if (this.spixels != null) {
            return this.spixels[n2 * this.width + n] & 0xFFFF;
        }
        if (this.fpixels != null) {
            return this.fpixels[n2 * this.width + n];
        }
        if (this.exactPixelValue) {
            return this.cpixels[n2 * this.width + n] & 0xFFFFFF;
        }
        return this.ip.getPixelValue(n, n2);
    }

    private boolean isLine(int n, int n2) {
        int n3;
        int n4;
        int n5 = 5;
        int n6 = n;
        int n7 = n + 2 * n5;
        if (n7 >= this.width) {
            n7 = this.width - 1;
        }
        if ((n4 = n2 - n5) < 0) {
            n4 = 0;
        }
        if ((n3 = n2 + n5) >= this.height) {
            n3 = this.height - 1;
        }
        int n8 = 0;
        int n9 = 0;
        for (int i = n6; i <= n7; ++i) {
            for (int j = n4; j <= n3; ++j) {
                ++n8;
                if (!this.inside(i, j)) continue;
                ++n9;
            }
        }
        if (IJ.debugMode) {
            IJ.log(((double)n9 / (double)n8 < 0.25 ? "line " : "blob ") + n9 + " " + n8 + " " + IJ.d2s((double)n9 / (double)n8));
        }
        return (double)n9 / (double)n8 < 0.25;
    }

    public static void setAllPoints(boolean bl) {
        allPoints = bl;
    }

    public static boolean allPoints() {
        return allPoints;
    }
}

