/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.Opener;
import ij.io.RandomAccessStream;
import ij.io.RoiDecoder;
import ij.measure.Calibration;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;
    private static boolean showConflictMessage = true;
    private double minValue;
    private double maxValue;
    private static boolean silentMode;

    public FileOpener(FileInfo fileInfo) {
        this.fi = fileInfo;
        if (fileInfo != null) {
            this.width = fileInfo.width;
            this.height = fileInfo.height;
        }
        if (IJ.debugMode) {
            IJ.log("FileInfo: " + fileInfo);
        }
    }

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean bl) {
        ImagePlus imagePlus = null;
        Object var4_3 = null;
        ColorModel colorModel = this.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(colorModel, bl);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, (byte[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, byteProcessor);
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height, (short[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, shortProcessor);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 16: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                FloatProcessor floatProcessor = new FloatProcessor(this.width, this.height, (float[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, floatProcessor);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 18: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ColorProcessor colorProcessor = new ColorProcessor(this.width, this.height, (int[])object);
                imagePlus = new ImagePlus(this.fi.fileName, colorProcessor);
                break;
            }
            case 12: 
            case 17: {
                boolean bl2 = this.fi.fileType == 17;
                Object[] objectArray = (Object[])this.readPixels(this.fi);
                if (objectArray == null) {
                    return null;
                }
                ImageStack imageStack = new ImageStack(this.width, this.height);
                imageStack.addSlice("Red", objectArray[0]);
                imageStack.addSlice("Green", objectArray[1]);
                imageStack.addSlice("Blue", objectArray[2]);
                imagePlus = new ImagePlus(this.fi.fileName, imageStack);
                imagePlus.setDimensions(3, 1, 1);
                if (bl2) {
                    imagePlus.getProcessor().resetMinAndMax();
                }
                imagePlus.setFileInfo(this.fi);
                int n = 1;
                if (this.fi.description != null) {
                    if (this.fi.description.indexOf("mode=color") != -1) {
                        n = 2;
                    } else if (this.fi.description.indexOf("mode=gray") != -1) {
                        n = 3;
                    }
                }
                imagePlus = new CompositeImage(imagePlus, n);
                if (bl2 || this.fi.displayRanges != null) break;
                for (int i = 1; i <= 3; ++i) {
                    imagePlus.setPosition(i, 1, 1);
                    imagePlus.setDisplayRange(this.minValue, this.maxValue);
                }
                imagePlus.setPosition(1, 1, 1);
            }
        }
        imagePlus.setFileInfo(this.fi);
        this.setCalibration(imagePlus);
        if (this.fi.info != null) {
            imagePlus.setProperty("Info", this.fi.info);
        }
        if (this.fi.sliceLabels != null && this.fi.sliceLabels.length == 1 && this.fi.sliceLabels[0] != null) {
            imagePlus.setProperty("Label", this.fi.sliceLabels[0]);
        }
        if (this.fi.roi != null) {
            imagePlus.setRoi(RoiDecoder.openFromByteArray(this.fi.roi));
        }
        if (this.fi.overlay != null) {
            this.setOverlay(imagePlus, this.fi.overlay);
        }
        if (bl) {
            imagePlus.show();
        }
        return imagePlus;
    }

    void setOverlay(ImagePlus imagePlus, byte[][] byArray) {
        Overlay overlay = new Overlay();
        for (int i = 0; i < byArray.length; ++i) {
            Roi roi = RoiDecoder.openFromByteArray(byArray[i]);
            if (i == 0) {
                Overlay overlay2 = roi.getPrototypeOverlay();
                overlay.drawLabels(overlay2.getDrawLabels());
                overlay.drawNames(overlay2.getDrawNames());
                overlay.drawBackgrounds(overlay2.getDrawBackgrounds());
                overlay.setLabelColor(overlay2.getLabelColor());
                overlay.setLabelFont(overlay2.getLabelFont());
            }
            overlay.add(roi);
        }
        imagePlus.setOverlay(overlay);
    }

    ImagePlus openStack(ColorModel colorModel, boolean bl) {
        Object object;
        ImageStack imageStack = new ImageStack(this.fi.width, this.fi.height, colorModel);
        long l = this.fi.getOffset();
        try {
            ImageReader imageReader = new ImageReader(this.fi);
            object = this.createInputStream(this.fi);
            if (object == null) {
                return null;
            }
            IJ.resetEscape();
            for (int i = 1; i <= this.fi.nImages; ++i) {
                if (!silentMode) {
                    IJ.showStatus("Reading: " + i + "/" + this.fi.nImages);
                }
                if (IJ.escapePressed()) {
                    IJ.beep();
                    IJ.showProgress(1.0);
                    silentMode = false;
                    return null;
                }
                Object object2 = imageReader.readPixels((InputStream)object, l);
                if (object2 == null) break;
                imageStack.addSlice(null, object2);
                l = this.fi.gapBetweenImages;
                if (silentMode) continue;
                IJ.showProgress(i, this.fi.nImages);
            }
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            IJ.log("" + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(this.fi.fileName);
            imageStack.trim();
        }
        if (!silentMode) {
            IJ.showProgress(1.0);
        }
        if (imageStack.getSize() == 0) {
            return null;
        }
        if (this.fi.sliceLabels != null && this.fi.sliceLabels.length <= imageStack.getSize()) {
            for (int i = 0; i < this.fi.sliceLabels.length; ++i) {
                imageStack.setSliceLabel(this.fi.sliceLabels[i], i + 1);
            }
        }
        ImagePlus imagePlus = new ImagePlus(this.fi.fileName, imageStack);
        if (this.fi.info != null) {
            imagePlus.setProperty("Info", this.fi.info);
        }
        if (this.fi.roi != null) {
            imagePlus.setRoi(RoiDecoder.openFromByteArray(this.fi.roi));
        }
        if (this.fi.overlay != null) {
            this.setOverlay(imagePlus, this.fi.overlay);
        }
        if (bl) {
            imagePlus.show();
        }
        imagePlus.setFileInfo(this.fi);
        this.setCalibration(imagePlus);
        object = imagePlus.getProcessor();
        if (((ImageProcessor)object).getMin() == ((ImageProcessor)object).getMax()) {
            this.setStackDisplayRange(imagePlus);
        }
        if (!silentMode) {
            IJ.showProgress(1.0);
        }
        return imagePlus;
    }

    void setStackDisplayRange(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = imageStack.getSize();
        for (int i = 1; i <= n; ++i) {
            if (!silentMode) {
                IJ.showStatus("Calculating stack min and max: " + i + "/" + n);
            }
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            imageProcessor.resetMinAndMax();
            if (imageProcessor.getMin() < d) {
                d = imageProcessor.getMin();
            }
            if (!(imageProcessor.getMax() > d2)) continue;
            d2 = imageProcessor.getMax();
        }
        imagePlus.getProcessor().setMinAndMax(d, d2);
        imagePlus.updateAndDraw();
    }

    public void revertToSaved(ImagePlus imagePlus) {
        String string = this.fi.directory + this.fi.fileName;
        if (this.fi.fileFormat == 3) {
            Image image = Toolkit.getDefaultToolkit().createImage(string);
            imagePlus.setImage(image);
            if (imagePlus.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imagePlus);
            }
            return;
        }
        if (this.fi.fileFormat == 6) {
            ImagePlus imagePlus2 = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", string);
            if (imagePlus2 != null) {
                imagePlus.setProcessor(null, imagePlus2.getProcessor());
            }
            if (this.fi.fileType == 2 || this.fi.fileType == 4) {
                ThresholdAdjuster.update();
            }
            return;
        }
        if (this.fi.fileFormat == 5) {
            ImagePlus imagePlus3 = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP_Reader", string);
            if (imagePlus3 != null) {
                imagePlus.setProcessor(null, imagePlus3.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 8) {
            ImagePlus imagePlus4 = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", string);
            if (imagePlus4 != null) {
                imagePlus.setProcessor(null, imagePlus4.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 4) {
            ImagePlus imagePlus5 = (ImagePlus)IJ.runPlugIn("ij.plugin.FITS_Reader", string);
            if (imagePlus5 != null) {
                imagePlus.setProcessor(null, imagePlus5.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 7) {
            ImagePlus imagePlus6 = new Opener().openZip(string);
            if (imagePlus6 != null) {
                imagePlus.setProcessor(null, imagePlus6.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 9) {
            ImagePlus imagePlus7 = new Opener().openUsingImageIO(string);
            if (imagePlus7 != null) {
                imagePlus.setProcessor(null, imagePlus7.getProcessor());
            }
            return;
        }
        if (this.fi.nImages > 1) {
            return;
        }
        if (this.fi.url == null || this.fi.url.equals("")) {
            IJ.showStatus("Loading: " + string);
        } else {
            IJ.showStatus("Loading: " + this.fi.url + this.fi.fileName);
        }
        Object object = this.readPixels(this.fi);
        if (object == null) {
            return;
        }
        ColorModel colorModel = this.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, (byte[])object, colorModel);
                imagePlus.setProcessor(null, byteProcessor);
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height, (short[])object, colorModel);
                imagePlus.setProcessor(null, shortProcessor);
                break;
            }
            case 3: 
            case 4: {
                FloatProcessor floatProcessor = new FloatProcessor(this.width, this.height, (float[])object, colorModel);
                imagePlus.setProcessor(null, floatProcessor);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])object, 0, this.width));
                imagePlus.setImage(image);
            }
        }
    }

    void setCalibration(ImagePlus imagePlus) {
        int n;
        int n2;
        if (this.fi.fileType == 1) {
            if (IJ.debugMode) {
                IJ.log("16-bit signed");
            }
            imagePlus.getLocalCalibration().setSigned16BitCalibration();
        }
        Properties properties = this.decodeDescriptionString(this.fi);
        Calibration calibration = imagePlus.getCalibration();
        boolean bl = false;
        if (this.fi.pixelWidth > 0.0 && this.fi.unit != null) {
            calibration.pixelWidth = this.fi.pixelWidth;
            calibration.pixelHeight = this.fi.pixelHeight;
            calibration.pixelDepth = this.fi.pixelDepth;
            calibration.setUnit(this.fi.unit);
            bl = true;
        }
        if (this.fi.valueUnit != null && ((n2 = this.fi.calibrationFunction) >= 0 && n2 <= 10 && this.fi.coefficients != null || n2 == 21)) {
            boolean bl2 = properties != null && properties.getProperty("zeroclip", "false").equals("true");
            calibration.setFunction(n2, this.fi.coefficients, this.fi.valueUnit, bl2);
            bl = true;
        }
        if (bl) {
            this.checkForCalibrationConflict(imagePlus, calibration);
        }
        if (this.fi.frameInterval != 0.0) {
            calibration.frameInterval = this.fi.frameInterval;
        }
        if (properties == null) {
            return;
        }
        calibration.xOrigin = this.getDouble(properties, "xorigin");
        calibration.yOrigin = this.getDouble(properties, "yorigin");
        calibration.zOrigin = this.getDouble(properties, "zorigin");
        calibration.info = properties.getProperty("info");
        calibration.fps = this.getDouble(properties, "fps");
        calibration.loop = this.getBoolean(properties, "loop");
        calibration.frameInterval = this.getDouble(properties, "finterval");
        calibration.setTimeUnit(properties.getProperty("tunit", "sec"));
        double d = this.getDouble(properties, "min");
        double d2 = this.getDouble(properties, "max");
        if (d != 0.0 || d2 != 0.0) {
            n = imagePlus.getType();
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (n == 0 || n == 3) {
                imageProcessor.setMinAndMax(d, d2);
            } else if (!(n != 1 && n != 2 || imageProcessor.getMin() == d && imageProcessor.getMax() == d2)) {
                imageProcessor.setMinAndMax(d, d2);
            }
        }
        if ((n = imagePlus.getStackSize()) > 1) {
            int n3 = (int)this.getDouble(properties, "channels");
            int n4 = (int)this.getDouble(properties, "slices");
            int n5 = (int)this.getDouble(properties, "frames");
            if (n3 == 0) {
                n3 = 1;
            }
            if (n4 == 0) {
                n4 = 1;
            }
            if (n5 == 0) {
                n5 = 1;
            }
            if (n3 * n4 * n5 == n) {
                imagePlus.setDimensions(n3, n4, n5);
                if (this.getBoolean(properties, "hyperstack")) {
                    imagePlus.setOpenAsHyperStack(true);
                }
            }
        }
    }

    void checkForCalibrationConflict(ImagePlus imagePlus, Calibration calibration) {
        boolean bl;
        Calibration calibration2 = imagePlus.getGlobalCalibration();
        if (calibration2 == null || !showConflictMessage || IJ.isMacro()) {
            return;
        }
        if (calibration.pixelWidth == calibration2.pixelWidth && calibration.getUnit().equals(calibration2.getUnit())) {
            return;
        }
        GenericDialog genericDialog = new GenericDialog(imagePlus.getTitle());
        genericDialog.addMessage("The calibration of this image conflicts\nwith the current global calibration.");
        genericDialog.addCheckbox("Disable_Global Calibration", true);
        genericDialog.addCheckbox("Disable_these Messages", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl2 = genericDialog.getNextBoolean();
        if (bl2) {
            imagePlus.setGlobalCalibration(null);
            imagePlus.setCalibration(calibration);
            WindowManager.repaintImageWindows();
        }
        if (bl = genericDialog.getNextBoolean()) {
            showConflictMessage = false;
        }
    }

    public ColorModel createColorModel(FileInfo fileInfo) {
        if (fileInfo.fileType == 5 && fileInfo.lutSize > 0) {
            return new IndexColorModel(8, fileInfo.lutSize, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fileInfo.whiteIsZero);
    }

    public InputStream createInputStream(FileInfo fileInfo) throws IOException, MalformedURLException {
        boolean bl;
        InputStream inputStream = null;
        boolean bl2 = bl = fileInfo.fileName != null && (fileInfo.fileName.endsWith(".gz") || fileInfo.fileName.endsWith(".GZ"));
        if (fileInfo.inputStream != null) {
            inputStream = fileInfo.inputStream;
        } else if (fileInfo.url != null && !fileInfo.url.equals("")) {
            inputStream = new URL(fileInfo.url + fileInfo.fileName).openStream();
        } else {
            if (fileInfo.directory.length() > 0 && !fileInfo.directory.endsWith(Prefs.separator)) {
                fileInfo.directory = fileInfo.directory + Prefs.separator;
            }
            File file = new File(fileInfo.directory + fileInfo.fileName);
            if (bl) {
                fileInfo.compression = 0;
            }
            inputStream = file == null || !file.exists() || file.isDirectory() || !FileOpener.validateFileInfo(file, fileInfo) ? null : new FileInputStream(file);
        }
        if (inputStream != null) {
            if (fileInfo.compression >= 2) {
                inputStream = new RandomAccessStream(inputStream);
            } else if (bl) {
                inputStream = new GZIPInputStream(inputStream, 50000);
            }
        }
        return inputStream;
    }

    static boolean validateFileInfo(File file, FileInfo fileInfo) {
        long l = fileInfo.getOffset();
        long l2 = 0L;
        if (fileInfo.width <= 0 || fileInfo.height <= 0) {
            FileOpener.error("Width or height <= 0.", fileInfo, l, l2);
            return false;
        }
        if (l >= 0L && l < 1000L) {
            return true;
        }
        if (l < 0L) {
            FileOpener.error("Offset is negative.", fileInfo, l, l2);
            return false;
        }
        if (fileInfo.fileType == 8 || fileInfo.compression != 1) {
            return true;
        }
        l2 = file.length();
        long l3 = fileInfo.width * fileInfo.height * fileInfo.getBytesPerPixel();
        long l4 = l3 = fileInfo.nImages > 1 ? l3 : l3 / 4L;
        if (fileInfo.height == 1) {
            l3 = 0L;
        }
        if (l + l3 > l2) {
            FileOpener.error("Offset + image size > file length.", fileInfo, l, l2);
            return false;
        }
        return true;
    }

    static void error(String string, FileInfo fileInfo, long l, long l2) {
        String string2 = "FileInfo parameter error. \n" + string + "\n \n" + "  Width: " + fileInfo.width + "\n" + "  Height: " + fileInfo.height + "\n" + "  Offset: " + l + "\n" + "  Bytes/pixel: " + fileInfo.getBytesPerPixel() + "\n" + (l2 > 0L ? "  File length: " + l2 + "\n" : "");
        if (silentMode) {
            IJ.log("Error opening " + fileInfo.directory + fileInfo.fileName);
            IJ.log(string2);
        } else {
            IJ.error("FileOpener", string2);
        }
    }

    Object readPixels(FileInfo fileInfo) {
        Object object;
        block3: {
            object = null;
            try {
                InputStream inputStream = this.createInputStream(fileInfo);
                if (inputStream == null) {
                    return null;
                }
                ImageReader imageReader = new ImageReader(fileInfo);
                object = imageReader.readPixels(inputStream);
                this.minValue = imageReader.min;
                this.maxValue = imageReader.max;
                inputStream.close();
            }
            catch (Exception exception) {
                if ("Macro canceled".equals(exception.getMessage())) break block3;
                IJ.handleException(exception);
            }
        }
        return object;
    }

    public Properties decodeDescriptionString(FileInfo fileInfo) {
        String string;
        double d;
        int n;
        if (fileInfo.description == null || fileInfo.description.length() < 7) {
            return null;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(fileInfo.description).replace('\n', ' '));
        }
        if (!fileInfo.description.startsWith("ImageJ")) {
            return null;
        }
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileInfo.description.getBytes());
        try {
            properties.load(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            return null;
        }
        fileInfo.unit = properties.getProperty("unit", "");
        Double d2 = this.getNumber(properties, "cf");
        if (d2 != null) {
            fileInfo.calibrationFunction = d2.intValue();
        }
        double[] dArray = new double[5];
        int n2 = 0;
        for (n = 0; n < 5 && (d2 = this.getNumber(properties, "c" + n)) != null; ++n) {
            dArray[n] = d2;
            ++n2;
        }
        if (n2 >= 2) {
            fileInfo.coefficients = new double[n2];
            for (n = 0; n < n2; ++n) {
                fileInfo.coefficients[n] = dArray[n];
            }
        }
        fileInfo.valueUnit = properties.getProperty("vunit");
        d2 = this.getNumber(properties, "images");
        if (d2 != null && d2 > 1.0) {
            fileInfo.nImages = (int)d2.doubleValue();
        }
        if (fileInfo.nImages > 1 && (d = this.getDouble(properties, "spacing")) != 0.0) {
            if (d < 0.0) {
                d = -d;
            }
            fileInfo.pixelDepth = d;
        }
        if ((string = properties.getProperty("name")) != null) {
            fileInfo.fileName = string;
        }
        return properties;
    }

    private Double getNumber(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private double getDouble(Properties properties, String string) {
        Double d = this.getNumber(properties, string);
        return d != null ? d : 0.0;
    }

    private boolean getBoolean(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        return string2 != null && string2.equals("true");
    }

    public static void setShowConflictMessage(boolean bl) {
        showConflictMessage = bl;
    }

    static void setSilentMode(boolean bl) {
        silentMode = bl;
    }
}

