/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class PluginClassLoader
extends URLClassLoader {
    protected String path;

    public PluginClassLoader(String string) {
        super(new URL[0], IJ.class.getClassLoader());
        this.init(string);
    }

    public PluginClassLoader(String string, boolean bl) {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        this.init(string);
    }

    void init(String string) {
        this.path = string;
        File file = new File(string);
        try {
            this.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            IJ.log("PluginClassLoader: " + malformedURLException);
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".rsrc")) continue;
            file = new File(string, stringArray[i]);
            if (file.isDirectory()) {
                try {
                    this.addURL(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    IJ.log("PluginClassLoader: " + malformedURLException);
                }
                String[] stringArray2 = file.list();
                if (stringArray2 == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    File file2 = new File(file, stringArray2[j]);
                    if (!file2.isFile()) continue;
                    this.addJAR(file2);
                }
                continue;
            }
            this.addJAR(file);
        }
    }

    private void addJAR(File file) {
        if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                IJ.log("PluginClassLoader: " + malformedURLException);
            }
        }
    }
}

