/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public final class RandomAccessStream
extends InputStream {
    private static final int BLOCK_SIZE = 512;
    private static final int BLOCK_MASK = 511;
    private static final int BLOCK_SHIFT = 9;
    private InputStream src;
    private RandomAccessFile ras;
    private long pointer;
    private Vector data;
    private int length;
    private boolean foundEOS;

    public RandomAccessStream(InputStream inputStream) {
        this.pointer = 0L;
        this.data = new Vector();
        this.length = 0;
        this.foundEOS = false;
        this.src = inputStream;
    }

    public RandomAccessStream(RandomAccessFile randomAccessFile) {
        this.ras = randomAccessFile;
    }

    public int getFilePointer() throws IOException {
        if (this.ras != null) {
            return (int)this.ras.getFilePointer();
        }
        return (int)this.pointer;
    }

    public long getLongFilePointer() throws IOException {
        if (this.ras != null) {
            return this.ras.getFilePointer();
        }
        return this.pointer;
    }

    @Override
    public int read() throws IOException {
        if (this.ras != null) {
            return this.ras.read();
        }
        long l = this.pointer + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            byte[] byArray = (byte[])this.data.elementAt((int)(this.pointer >> 9));
            return byArray[(int)(this.pointer++ & 0x1FFL)] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.ras != null) {
            return this.ras.read(byArray, n, n2);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)n2);
        if (l <= this.pointer) {
            return -1;
        }
        byte[] byArray2 = (byte[])this.data.elementAt((int)(this.pointer >> 9));
        int n3 = Math.min(n2, 512 - (int)(this.pointer & 0x1FFL));
        System.arraycopy(byArray2, (int)(this.pointer & 0x1FFL), byArray, n, n3);
        this.pointer += (long)n3;
        return n3;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, byArray.length);
    }

    public final void readFully(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        while ((n2 = this.read(byArray, n3, n - n3)) >= 0 && (n3 += n2) < n) {
        }
    }

    private long readUntil(long l) throws IOException {
        int n;
        if (l < (long)this.length) {
            return l;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int n2 = (int)(l >> 9);
        for (int i = n = this.length >> 9; i <= n2; ++i) {
            byte[] byArray = new byte[512];
            this.data.addElement(byArray);
            int n3 = 512;
            int n4 = 0;
            while (n3 > 0) {
                int n5 = this.src.read(byArray, n4, n3);
                if (n5 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                n4 += n5;
                n3 -= n5;
                this.length += n5;
            }
        }
        return this.length;
    }

    public void seek(long l) throws IOException {
        if (this.ras != null) {
            this.ras.seek(l);
            return;
        }
        this.pointer = l < 0L ? 0L : l;
    }

    public void seek(int n) throws IOException {
        long l = (long)n & 0xFFFFFFFFL;
        if (this.ras != null) {
            this.ras.seek(l);
            return;
        }
        this.pointer = l < 0L ? 0L : l;
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void close() throws IOException {
        if (this.ras != null) {
            this.ras.close();
        } else {
            this.data.removeAllElements();
            this.src.close();
        }
    }
}

