/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Functions;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.ReturnException;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.macro.Variable;
import ij.measure.ResultsTable;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.ColorProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Vector;

public class Interpreter
implements MacroConstants {
    public static final int NONE = 0;
    public static final int STEP = 1;
    public static final int TRACE = 2;
    public static final int FAST_TRACE = 3;
    public static final int RUN = 4;
    public static final int RUN_TO_CARET = 5;
    static final int STACK_SIZE = 1000;
    static final int MAX_ARGS = 20;
    int pc;
    int token;
    int tokenAddress;
    double tokenValue;
    String tokenString;
    boolean looseSyntax = true;
    int lineNumber;
    boolean statusUpdated;
    boolean showingProgress;
    boolean keysSet;
    boolean checkingType;
    int prefixValue;
    Variable[] stack;
    int topOfStack = -1;
    int topOfGlobals = -1;
    int startOfLocals = 0;
    static Interpreter instance;
    static Interpreter previousInstance;
    public static boolean batchMode;
    static Vector imageTable;
    boolean done;
    Program pgm;
    Functions func;
    boolean inFunction;
    String macroName;
    String argument;
    String returnValue;
    boolean calledMacro;
    double[] rgbWeights;
    boolean inPrint;
    static String additionalFunctions;
    Editor editor;
    int debugMode = 0;
    boolean showDebugFunctions;
    static boolean showVariables;
    boolean wasError;
    ReturnException returnException;

    public void run(String string) {
        if (additionalFunctions != null) {
            string = !string.endsWith("\n") && !additionalFunctions.startsWith("\n") ? string + "\n" + additionalFunctions : string + additionalFunctions;
        }
        Tokenizer tokenizer = new Tokenizer();
        Program program = tokenizer.tokenize(string);
        if (program.hasVars && program.hasFunctions) {
            this.saveGlobals2(program);
        }
        this.run(program);
    }

    public String run(String string, String string2) {
        this.argument = string2;
        this.calledMacro = true;
        if (IJ.getInstance() == null) {
            Interpreter.setBatchMode(true);
        }
        Interpreter interpreter = instance;
        this.run(string);
        instance = interpreter;
        return this.returnValue;
    }

    public void run(Program program) {
        this.pgm = program;
        this.pc = -1;
        instance = this;
        if (!this.calledMacro) {
            batchMode = false;
            imageTable = null;
        }
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, program);
        }
        this.func.plot = null;
        this.doStatements();
        this.finishUp();
    }

    public void run(int n) {
        this.topOfStack = this.topOfGlobals;
        this.done = false;
        this.pc = n - 1;
        this.doStatements();
    }

    public void runMacro(Program program, int n, String string) {
        this.calledMacro = true;
        this.pgm = program;
        this.macroName = string;
        this.pc = n - 1;
        previousInstance = instance;
        instance = this;
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, program);
        }
        this.func.plot = null;
        if (n == 0) {
            this.doStatements();
        } else {
            this.doBlock();
        }
        this.finishUp();
        Recorder.recordInMacros = false;
    }

    public void saveGlobals(Program program) {
        this.saveGlobals2(program);
    }

    void saveGlobals2(Program program) {
        this.pgm = program;
        this.pc = -1;
        instance = this;
        this.func = new Functions(this, program);
        block5: while (!this.done) {
            this.getToken();
            switch (this.token) {
                case 201: {
                    this.doVar();
                    continue block5;
                }
                case 200: {
                    this.skipMacro();
                    continue block5;
                }
                case 207: {
                    this.skipFunction();
                    continue block5;
                }
            }
        }
        instance = null;
        program.saveGlobals(this);
        this.pc = -1;
        this.topOfStack = -1;
        this.done = false;
    }

    final void getToken() {
        if (this.done) {
            return;
        }
        this.token = this.pgm.code[++this.pc];
        if (this.token <= 127) {
            return;
        }
        this.tokenAddress = this.token >> 12;
        this.token &= 0xFFF;
        Symbol symbol = this.pgm.table[this.tokenAddress];
        this.tokenString = symbol.str;
        this.tokenValue = symbol.value;
        this.done = this.token == 128;
    }

    final int nextToken() {
        return this.pgm.code[this.pc + 1] & 0xFFF;
    }

    final int nextNextToken() {
        return this.pgm.code[this.pc + 2] & 0xFFF;
    }

    final void putTokenBack() {
        --this.pc;
        if (this.pc < 0) {
            this.pc = -1;
        }
    }

    void doStatements() {
        while (!this.done) {
            this.doStatement();
        }
    }

    final void doStatement() {
        this.getToken();
        if (this.debugMode != 0 && this.editor != null && !this.done && this.token != 59 && this.token != 207) {
            this.editor.debug(this, this.debugMode);
        }
        switch (this.token) {
            case 201: {
                this.doVar();
                break;
            }
            case 134: {
                this.func.doFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                this.runUserFunction();
                break;
            }
            case 208: {
                this.doReturn();
                break;
            }
            case 129: {
                this.doAssignment();
                break;
            }
            case 202: {
                this.doIf();
                return;
            }
            case 203: {
                this.error("Else without if");
                return;
            }
            case 206: {
                this.doFor();
                return;
            }
            case 204: {
                this.doWhile();
                return;
            }
            case 205: {
                this.doDo();
                return;
            }
            case 200: {
                this.runFirstMacro();
                return;
            }
            case 207: {
                this.skipFunction();
                return;
            }
            case 59: {
                return;
            }
            case 123: {
                this.putTokenBack();
                this.doBlock();
                return;
            }
            case 40: 
            case 130: 
            case 133: 
            case 135: 
            case 136: {
                this.putTokenBack();
                this.inPrint = true;
                String string = this.getString();
                this.inPrint = false;
                if (string != null && string.length() > 0 && !string.equals("NaN") && !string.equals("[aborted]")) {
                    IJ.log(string);
                }
                return;
            }
            case 137: {
                this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 128: {
                break;
            }
            default: {
                this.error("Statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
        if (!this.looseSyntax) {
            this.getToken();
            if (this.token != 59 && !this.done) {
                this.error("';' expected");
            }
        }
    }

    Variable runUserFunction() {
        int n = (int)this.tokenValue;
        int n2 = this.startOfLocals;
        this.startOfLocals = this.topOfStack + 1;
        int n3 = this.topOfStack;
        int n4 = this.pushArgs();
        int n5 = this.pc;
        Variable variable = null;
        this.pc = n;
        this.setupArgs(n4);
        boolean bl = this.inFunction;
        this.inFunction = true;
        try {
            this.doBlock();
        }
        catch (ReturnException returnException) {
            variable = new Variable(0, returnException.value, returnException.str, returnException.array);
        }
        this.inFunction = bl;
        this.pc = n5;
        this.trimStack(n3, n2);
        return variable;
    }

    int pushArgs() {
        int n;
        this.getLeftParen();
        int n2 = 0;
        Variable[] variableArray = new Variable[20];
        if (this.nextToken() != 41) {
            do {
                Variable variable;
                int n3;
                if (n2 == 20) {
                    this.error("Too many arguments");
                }
                n = this.nextToken();
                int n4 = this.pgm.code[this.pc + 2] & 0xFF;
                if (n == 133 || n == 136) {
                    variableArray[n2] = new Variable(0, 0.0, this.getString());
                } else if (n == 138) {
                    n3 = this.pc;
                    this.getToken();
                    boolean bl = this.isSimpleFunctionCall(false);
                    this.pc = n3;
                    if (bl) {
                        this.getToken();
                        variable = this.runUserFunction();
                        if (variable == null) {
                            this.error("No return value");
                        }
                        variableArray[n2] = variable;
                    } else {
                        variableArray[n2] = new Variable(0, this.getExpression(), null);
                    }
                } else if (n == 129 && (n4 == 44 || n4 == 41)) {
                    double d = 0.0;
                    Variable[] variableArray2 = null;
                    String string = null;
                    this.getToken();
                    variable = this.lookupVariable();
                    if (variable != null) {
                        int n5 = variable.getType();
                        if (n5 == 0) {
                            d = variable.getValue();
                        } else if (n5 == 1) {
                            variableArray2 = variable.getArray();
                        } else {
                            string = variable.getString();
                        }
                    }
                    variableArray[n2] = new Variable(0, d, string, variableArray2);
                } else if (n == 129 && n4 == 91) {
                    n3 = this.pc;
                    this.getToken();
                    Variable variable2 = this.lookupVariable();
                    variable2 = this.getArrayElement(variable2);
                    if (variable2.getString() != null) {
                        variableArray[n2] = new Variable(0, 0.0, variable2.getString(), null);
                    } else {
                        this.pc = n3;
                        variableArray[n2] = new Variable(0, this.getExpression(), null);
                    }
                } else {
                    variableArray[n2] = new Variable(0, this.getExpression(), null);
                }
                ++n2;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        n = n2;
        while (n2 > 0) {
            this.push(variableArray[--n2], this);
        }
        this.getRightParen();
        return n;
    }

    void setupArgs(int n) {
        this.getLeftParen();
        int n2 = this.topOfStack;
        int n3 = n;
        if (this.nextToken() != 41) {
            do {
                this.getToken();
                if (n2 >= 0) {
                    this.stack[n2].symTabIndex = this.tokenAddress;
                }
                --n2;
                --n3;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        if (n3 != 0) {
            this.error(n + " argument" + (n == 1 ? "" : "s") + " expected");
        }
        this.getRightParen();
    }

    void doReturn() {
        double d = 0.0;
        String string = null;
        Variable[] variableArray = null;
        this.getToken();
        if (this.token != 59) {
            Variable variable;
            boolean bl;
            boolean bl2 = this.token == 133 || this.token == 136;
            boolean bl3 = bl = this.token == 137;
            if (this.token == 129 && (variable = this.lookupLocalVariable(this.tokenAddress)) != null && this.nextToken() == 59) {
                variableArray = variable.getArray();
                bl2 = variable.getString() != null;
            }
            this.putTokenBack();
            if (bl2) {
                string = this.getString();
            } else if (bl) {
                this.getToken();
                variableArray = this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
            } else if (variableArray == null) {
                d = this.getExpression();
            }
        }
        if (this.inFunction) {
            if (this.returnException == null) {
                this.returnException = new ReturnException();
            }
            this.returnException.value = d;
            this.returnException.str = string;
            this.returnException.array = variableArray;
            throw this.returnException;
        }
        this.finishUp();
        if (d != 0.0 || variableArray != null) {
            this.error("Macros can only return strings");
        }
        this.returnValue = string;
        this.done = true;
    }

    void doFor() {
        boolean bl = this.looseSyntax;
        this.looseSyntax = false;
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
        this.getToken();
        if (this.token != 201) {
            this.putTokenBack();
        }
        do {
            if (this.nextToken() != 59) {
                this.getAssignmentExpression();
            }
            this.getToken();
        } while (this.token == 44);
        if (this.token != 59) {
            this.error("';' expected");
        }
        int n = this.pc;
        int n2 = 0;
        double d = 1.0;
        while (true) {
            if (this.pgm.code[this.pc + 1] != 59) {
                d = this.getLogicalExpression();
            }
            if (n2 == 0) {
                this.checkBoolean(d);
            }
            this.getToken();
            if (this.token != 59) {
                this.error("';' expected");
            }
            int n3 = this.pc;
            if (n2 != 0) {
                this.pc = n2;
            } else {
                while (this.token != 41) {
                    this.getToken();
                    if (this.token != 123 && this.token != 59 && this.token != 40 && !this.done) continue;
                    this.error("')' expected");
                }
            }
            n2 = this.pc;
            if (d != 1.0) break;
            this.doStatement();
            this.pc = n3;
            do {
                if (this.nextToken() != 41) {
                    this.getAssignmentExpression();
                }
                this.getToken();
            } while (this.token == 44);
            this.pc = n;
        }
        this.skipStatement();
        this.looseSyntax = bl;
    }

    void doWhile() {
        boolean bl;
        this.looseSyntax = false;
        int n = this.pc;
        do {
            this.pc = n;
            bl = this.getBoolean();
            if (bl) {
                this.doStatement();
                continue;
            }
            this.skipStatement();
        } while (bl && !this.done);
    }

    void doDo() {
        boolean bl;
        this.looseSyntax = false;
        int n = this.pc;
        do {
            this.doStatement();
            this.getToken();
            if (this.token != 204) {
                this.error("'while' expected");
            }
            if (!(bl = this.getBoolean())) continue;
            this.pc = n;
        } while (bl && !this.done);
    }

    final void doBlock() {
        this.getToken();
        if (this.token != 123) {
            this.error("'{' expected");
        }
        while (!this.done) {
            this.getToken();
            if (this.token == 125) break;
            this.putTokenBack();
            this.doStatement();
        }
        if (this.token != 125) {
            this.error("'}' expected");
        }
    }

    final void skipStatement() {
        this.getToken();
        switch (this.token) {
            case 1: 
            case 40: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 201: 
            case 208: {
                this.skipSimpleStatement();
                break;
            }
            case 202: {
                this.skipParens();
                this.skipStatement();
                this.getToken();
                if (this.token == 203) {
                    this.skipStatement();
                    break;
                }
                this.putTokenBack();
                break;
            }
            case 206: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 204: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 205: {
                this.skipStatement();
                this.getToken();
                this.skipParens();
                break;
            }
            case 59: {
                break;
            }
            case 123: {
                this.putTokenBack();
                this.skipBlock();
                break;
            }
            default: {
                this.error("Skipped statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
    }

    final void skipBlock() {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 123) {
                ++n;
                continue;
            }
            if (this.token == 125) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("'}' expected");
            return;
        } while (n > 0);
    }

    final void skipParens() {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++n;
                continue;
            }
            if (this.token == 41) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
            return;
        } while (n > 0);
    }

    final void skipSimpleStatement() {
        boolean bl = this.done;
        this.getToken();
        while (!bl && !this.done) {
            if (this.token == 59) {
                bl = true;
                continue;
            }
            if (this.token == 203 || this.token == 134 && this.pgm.code[this.pc - 1] != 46) {
                this.error("';' expected");
                continue;
            }
            this.getToken();
        }
    }

    void skipFunction() {
        this.getToken();
        this.skipParens();
        this.skipBlock();
    }

    void runFirstMacro() {
        this.getToken();
        this.doBlock();
        this.done = true;
        this.finishUp();
    }

    void skipMacro() {
        this.getToken();
        this.skipBlock();
    }

    final void doAssignment() {
        int n = this.pgm.code[this.pc + 1] & 0xFF;
        if (n == 91) {
            this.doArrayElementAssignment();
            return;
        }
        int n2 = this.getExpressionType();
        switch (n2) {
            case 2: {
                this.doStringAssignment();
                break;
            }
            case 1: {
                this.doArrayAssignment();
                break;
            }
            case 138: {
                this.doUserFunctionAssignment();
                break;
            }
            case 136: {
                this.doNumericStringAssignment();
                break;
            }
            default: {
                this.putTokenBack();
                this.getAssignmentExpression();
            }
        }
    }

    int getExpressionType() {
        int n = this.pgm.code[this.pc + 2];
        int n2 = n & 0xFF;
        if (n2 == 133) {
            return 2;
        }
        if (n2 == 136) {
            int n3 = n >> 12;
            int n4 = this.pgm.table[n3].type;
            if (n4 == 2017) {
                int n5 = this.pgm.code[this.pc + 4];
                String string = this.pgm.table[n5 >> 12].str;
                if (string.equals("getNumber") || string.equals("getCheckbox")) {
                    return 136;
                }
            } else if (n4 == 2019) {
                int n6 = this.pgm.code[this.pc + 4];
                String string = this.pgm.table[n6 >> 12].str;
                if (string.equals("exists") || string.equals("isDirectory") || string.equals("length") || string.equals("getLength") || string.equals("rename") || string.equals("delete")) {
                    return 136;
                }
            } else if (n4 == 2027) {
                int n7 = this.pgm.code[this.pc + 4];
                String string = this.pgm.table[n7 >> 12].str;
                if (string.equals("getValue")) {
                    return 136;
                }
            }
            return 2;
        }
        if (n2 == 137) {
            return 1;
        }
        if (n2 == 138) {
            return 138;
        }
        if (n2 != 129) {
            return 0;
        }
        Variable variable = this.lookupVariable(n >> 12);
        if (variable == null) {
            return 0;
        }
        int n8 = variable.getType();
        if (n8 != 1) {
            return n8;
        }
        if (this.pgm.code[this.pc + 3] == 46) {
            return 0;
        }
        if (this.pgm.code[this.pc + 3] != 91) {
            return 1;
        }
        int n9 = this.pc;
        this.getToken();
        this.getToken();
        this.checkingType = true;
        int n10 = this.getIndex();
        this.checkingType = false;
        this.pc = n9 - 1;
        this.getToken();
        Variable[] variableArray = variable.getArray();
        if (n10 < 0 || n10 >= variableArray.length) {
            return 0;
        }
        return variableArray[n10].getType();
    }

    final void doNumericStringAssignment() {
        this.putTokenBack();
        this.getToken();
        Variable variable = this.lookupLocalVariable(this.tokenAddress);
        if (variable == null) {
            variable = this.push(this.tokenAddress, 0.0, null, this);
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
        }
        variable.setValue(this.getExpression());
    }

    final void doArrayElementAssignment() {
        int n;
        int n2;
        Variable variable = this.lookupLocalVariable(this.tokenAddress);
        if (variable == null) {
            this.error("Undefined identifier");
        }
        if (this.pgm.code[this.pc + 5] == 59 && (this.pgm.code[this.pc + 4] == 1 || this.pgm.code[this.pc + 4] == 2)) {
            this.putTokenBack();
            this.getFactor();
            return;
        }
        int n3 = this.getIndex();
        int n4 = this.getExpressionType();
        if (n4 == 1) {
            this.error("Arrays of arrays not supported");
        }
        this.getToken();
        int n5 = this.token;
        if (n5 != 61 && n5 != 9 && n5 != 10 && n5 != 11 && n5 != 12) {
            this.error("'=', '+=', '-=', '*=' or '/=' expected");
            return;
        }
        if (n5 != 61 && (n4 == 2 || n4 == 1)) {
            this.error("'=' expected");
            return;
        }
        Variable[] variableArray = variable.getArray();
        if (variableArray == null) {
            this.error("Array expected");
        }
        if (n3 < 0) {
            this.error("Negative index");
        }
        if (n3 >= variableArray.length) {
            Variable[] variableArray2 = new Variable[n3 + variableArray.length / 2 + 1];
            n2 = variableArray.length > 0 && variableArray[0].getString() != null ? 1 : 0;
            for (int i = 0; i < variableArray2.length; ++i) {
                if (i < variableArray.length) {
                    variableArray2[i] = variableArray[i];
                    continue;
                }
                variableArray2[i] = new Variable(Double.NaN);
                if (n2 == 0) continue;
                variableArray2[i].setString("undefined");
            }
            variable.setArray(variableArray2);
            variable.setArraySize(n3 + 1);
            variableArray = variable.getArray();
        }
        if (n3 + 1 > (n = variable.getArraySize())) {
            variable.setArraySize(n3 + 1);
        }
        n2 = this.nextToken();
        block0 : switch (n4) {
            case 2: {
                variableArray[n3].setString(this.getString());
                break;
            }
            case 1: {
                this.getToken();
                if (this.token != 137) break;
                variableArray[n3].setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
                break;
            }
            default: {
                switch (n5) {
                    case 61: {
                        variableArray[n3].setValue(this.getExpression());
                        break block0;
                    }
                    case 9: {
                        variableArray[n3].setValue(variableArray[n3].getValue() + this.getExpression());
                        break block0;
                    }
                    case 10: {
                        variableArray[n3].setValue(variableArray[n3].getValue() - this.getExpression());
                        break block0;
                    }
                    case 11: {
                        variableArray[n3].setValue(variableArray[n3].getValue() * this.getExpression());
                        break block0;
                    }
                    case 12: {
                        variableArray[n3].setValue(variableArray[n3].getValue() / this.getExpression());
                    }
                }
            }
        }
    }

    final void doUserFunctionAssignment() {
        this.putTokenBack();
        int n = this.pc;
        this.getToken();
        this.getToken();
        this.getToken();
        boolean bl = this.isSimpleFunctionCall(true);
        this.pc = n;
        if (!bl) {
            this.getAssignmentExpression();
        } else {
            this.getToken();
            Variable variable = this.lookupLocalVariable(this.tokenAddress);
            if (variable == null) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            if (this.token != 61) {
                this.error("'=' expected");
            }
            this.getToken();
            Variable variable2 = this.runUserFunction();
            if (variable2 == null) {
                this.error("No return value");
            }
            if (this.done) {
                return;
            }
            int n2 = variable2.getType();
            if (n2 == 0) {
                variable.setValue(variable2.getValue());
            } else if (n2 == 1) {
                variable.setArray(variable2.getArray());
            } else {
                variable.setString(variable2.getString());
            }
        }
    }

    boolean isSimpleFunctionCall(boolean bl) {
        int n = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++n;
                continue;
            }
            if (this.token == 41) {
                --n;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
        } while (n > 0);
        this.getToken();
        if (bl) {
            return this.token == 59;
        }
        return this.token == 44 || this.token == 41;
    }

    final void doStringAssignment() {
        Variable variable = this.lookupLocalVariable(this.tokenAddress);
        if (variable == null) {
            if (this.nextToken() == 61) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token == 61) {
            variable.setString(this.getString());
        } else if (this.token == 9) {
            variable.setString(variable.getString() + this.getString());
        } else {
            this.error("'=' or '+=' expected");
        }
    }

    final void doArrayAssignment() {
        Variable variable = this.lookupLocalVariable(this.tokenAddress);
        if (variable == null) {
            if (this.nextToken() == 61) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
            return;
        }
        this.getToken();
        if (this.token == 137) {
            variable.setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
        } else if (this.token == 129) {
            Variable variable2 = this.lookupVariable();
            variable.setArray(variable2.getArray());
        } else {
            this.error("Array expected");
        }
    }

    final void doIf() {
        this.looseSyntax = false;
        boolean bl = this.getBoolean();
        if (bl) {
            this.doStatement();
        } else {
            this.skipStatement();
        }
        int n = this.nextToken();
        if (n == 59) {
            this.getToken();
            n = this.nextToken();
        }
        if (n == 203) {
            this.getToken();
            if (bl) {
                this.skipStatement();
            } else {
                this.doStatement();
            }
        }
    }

    final boolean getBoolean() {
        this.getLeftParen();
        double d = this.getLogicalExpression();
        this.checkBoolean(d);
        this.getRightParen();
        return d != 0.0;
    }

    final double getLogicalExpression() {
        double d = this.getBooleanExpression();
        int n = this.nextToken();
        if (n != 13 && n != 14) {
            return d;
        }
        this.checkBoolean(d);
        this.getToken();
        int n2 = this.token;
        double d2 = this.getLogicalExpression();
        this.checkBoolean(d2);
        if (n2 == 13) {
            return (int)d & (int)d2;
        }
        if (n2 == 14) {
            return (int)d | (int)d2;
        }
        return d;
    }

    final double getBooleanExpression() {
        double d = 0.0;
        String string = null;
        int n = this.pgm.code[this.pc + 1];
        int n2 = n & 0xFFF;
        if (n2 == 133 || n2 == 136 || this.isString(n)) {
            string = this.getString();
        } else {
            d = this.getExpression();
        }
        n = this.nextToken();
        if (n >= 3 && n <= 8) {
            this.getToken();
            int n3 = this.token;
            if (string != null) {
                return this.compareStrings(string, this.getString(), n3);
            }
            double d2 = this.getExpression();
            switch (n3) {
                case 3: {
                    d = d == d2 ? 1.0 : 0.0;
                    break;
                }
                case 4: {
                    d = d != d2 ? 1.0 : 0.0;
                    break;
                }
                case 5: {
                    d = d > d2 ? 1.0 : 0.0;
                    break;
                }
                case 6: {
                    d = d >= d2 ? 1.0 : 0.0;
                    break;
                }
                case 7: {
                    d = d < d2 ? 1.0 : 0.0;
                    break;
                }
                case 8: {
                    d = d <= d2 ? 1.0 : 0.0;
                }
            }
        } else if (string != null) {
            d = Tools.parseDouble(string, 0.0);
        }
        return d;
    }

    boolean isString(int n) {
        Variable[] variableArray;
        if ((n & 0xFFF) != 129) {
            return false;
        }
        Variable variable = this.lookupVariable(n >> 12);
        if (variable == null) {
            return false;
        }
        if (this.pgm.code[this.pc + 2] == 91 && (variableArray = variable.getArray()) != null && variableArray.length > 0) {
            return variableArray[0].getType() == 2;
        }
        return variable.getType() == 2;
    }

    double compareStrings(String string, String string2, int n) {
        int n2 = string.compareToIgnoreCase(string2);
        double d = 0.0;
        switch (n) {
            case 3: {
                d = n2 == 0 ? 1.0 : 0.0;
                break;
            }
            case 4: {
                d = n2 != 0 ? 1.0 : 0.0;
                break;
            }
            case 5: {
                d = n2 > 0 ? 1.0 : 0.0;
                break;
            }
            case 6: {
                d = n2 >= 0 ? 1.0 : 0.0;
                break;
            }
            case 7: {
                d = n2 < 0 ? 1.0 : 0.0;
                break;
            }
            case 8: {
                d = n2 <= 0 ? 1.0 : 0.0;
            }
        }
        return d;
    }

    final double getAssignmentExpression() {
        int n = this.pgm.code[this.pc + 2];
        if ((this.pgm.code[this.pc + 1] & 0xFF) == 129 && (n == 61 || n == 9 || n == 10 || n == 11 || n == 12)) {
            this.getToken();
            Variable variable = this.lookupLocalVariable(this.tokenAddress);
            if (variable == null) {
                variable = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            double d = 0.0;
            if (this.token == 61) {
                d = this.getAssignmentExpression();
            } else {
                d = variable.getValue();
                switch (this.token) {
                    case 9: {
                        d += this.getAssignmentExpression();
                        break;
                    }
                    case 10: {
                        d -= this.getAssignmentExpression();
                        break;
                    }
                    case 11: {
                        d *= this.getAssignmentExpression();
                        break;
                    }
                    case 12: {
                        d /= this.getAssignmentExpression();
                    }
                }
            }
            variable.setValue(d);
            return d;
        }
        return this.getLogicalExpression();
    }

    final void checkBoolean(double d) {
        if (d != 0.0 && d != 1.0) {
            this.error("Boolean expression expected");
        }
    }

    void doVar() {
        this.getToken();
        while (this.token == 129) {
            if (this.nextToken() == 61) {
                this.doAssignment();
            } else {
                Variable variable = this.lookupVariable(this.tokenAddress);
                if (variable == null) {
                    this.push(this.tokenAddress, 0.0, null, this);
                }
            }
            this.getToken();
            if (this.token == 44) {
                this.getToken();
                continue;
            }
            this.putTokenBack();
            break;
        }
    }

    final void getLeftParen() {
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
    }

    final void getRightParen() {
        this.getToken();
        if (this.token != 41) {
            this.error("')' expected");
        }
    }

    final void getParens() {
        if (this.nextToken() == 40) {
            this.getLeftParen();
            this.getRightParen();
        }
    }

    final void getComma() {
        this.getToken();
        if (this.token != 44) {
            if (this.looseSyntax) {
                this.putTokenBack();
            } else {
                this.error("',' expected");
            }
        }
    }

    void error(String string) {
        boolean bl = !this.done;
        String[] stringArray = bl ? this.getVariables() : null;
        this.token = 128;
        this.tokenString = "";
        IJ.showStatus("");
        IJ.showProgress(0, 0);
        batchMode = false;
        imageTable = null;
        WindowManager.setTempCurrentImage(null);
        this.wasError = true;
        instance = null;
        if (bl) {
            String string2 = this.getErrorLine();
            this.done = true;
            if (string2.length() > 120) {
                string2 = string2.substring(0, 119) + "...";
            }
            this.showError("Macro Error", string + " in line " + this.lineNumber + ".\n \n" + string2, stringArray);
            throw new RuntimeException("Macro canceled");
        }
        this.done = true;
    }

    void showError(String string, String string2, String[] stringArray) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.setInsets(6, 5, 0);
        genericDialog.addMessage(string2);
        genericDialog.setInsets(15, 30, 5);
        genericDialog.addCheckbox("Show \"Debug\" Window", showVariables);
        genericDialog.hideCancelButton();
        genericDialog.showDialog();
        showVariables = genericDialog.getNextBoolean();
        if (!genericDialog.wasCanceled() && showVariables) {
            this.updateDebugWindow(stringArray, null);
        }
    }

    public TextWindow updateDebugWindow(String[] stringArray, TextWindow textWindow) {
        int n;
        Container container;
        if (textWindow == null && (container = WindowManager.getFrame("Debug")) != null && container instanceof TextWindow) {
            textWindow = (TextWindow)container;
            textWindow.toFront();
        }
        if (textWindow == null) {
            textWindow = new TextWindow("Debug", "Name\tValue", "", 300, 400);
        }
        container = textWindow.getTextPanel();
        int n2 = stringArray.length;
        if (n2 == 0) {
            ((TextPanel)container).clear();
            return textWindow;
        }
        int n3 = ((TextPanel)container).getLineCount();
        for (n = 0; n < n3; ++n) {
            if (n < n2) {
                ((TextPanel)container).setLine(n, stringArray[n]);
                continue;
            }
            ((TextPanel)container).setLine(n, "");
        }
        for (n = n3; n < n2; ++n) {
            textWindow.append(stringArray[n]);
        }
        return textWindow;
    }

    String getErrorLine() {
        int n = this.pc;
        this.lineNumber = this.pgm.lineNumbers[this.pc];
        while (this.pc >= 0 && this.lineNumber == this.pgm.lineNumbers[this.pc]) {
            --this.pc;
        }
        if (this.lineNumber <= 1) {
            this.pc = -1;
        }
        String string = "";
        this.getToken();
        while (!this.done && this.lineNumber == this.pgm.lineNumbers[this.pc]) {
            String string2 = this.pgm.decodeToken(this.token, this.tokenAddress);
            if (this.pc == n) {
                string2 = "<" + string2 + ">";
            }
            string = string + string2 + " ";
            this.getToken();
        }
        return string;
    }

    final String getString() {
        String string = this.getStringTerm();
        while (true) {
            this.getToken();
            if (this.token != 43) break;
            string = string + this.getStringTerm();
        }
        this.putTokenBack();
        return string;
    }

    final String getStringTerm() {
        String string;
        this.getToken();
        switch (this.token) {
            case 133: {
                string = this.tokenString;
                break;
            }
            case 136: {
                string = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                Variable variable = this.runUserFunction();
                if (variable == null) {
                    this.error("No return value");
                }
                if ((string = variable.getString()) != null) break;
                double d = variable.getValue();
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                break;
            }
            case 129: {
                string = this.lookupStringVariable();
                if (string != null) break;
            }
            default: {
                this.putTokenBack();
                double d = this.getStringExpression();
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                if (!this.inPrint || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d == Double.NaN || string.length() - string.indexOf(46) <= 6 || string.indexOf(69) != -1) break;
                string = IJ.d2s(d, 4);
            }
        }
        return string;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.tokenAddress];
        return symbol.type == 2000;
    }

    final double getExpression() {
        double d = this.getTerm();
        while (true) {
            int n;
            if ((n = this.nextToken()) == 43) {
                this.getToken();
                d += this.getTerm();
                continue;
            }
            if (n != 45) break;
            this.getToken();
            d -= this.getTerm();
        }
        return d;
    }

    final double getTerm() {
        double d = this.getFactor();
        boolean bl = false;
        block10: while (!bl) {
            int n = this.nextToken();
            switch (n) {
                case 42: {
                    this.getToken();
                    d *= this.getFactor();
                    continue block10;
                }
                case 47: {
                    this.getToken();
                    d /= this.getFactor();
                    continue block10;
                }
                case 37: {
                    this.getToken();
                    d %= this.getFactor();
                    continue block10;
                }
                case 38: {
                    this.getToken();
                    d = (int)d & (int)this.getFactor();
                    continue block10;
                }
                case 124: {
                    this.getToken();
                    d = (int)d | (int)this.getFactor();
                    continue block10;
                }
                case 94: {
                    this.getToken();
                    d = (int)d ^ (int)this.getFactor();
                    continue block10;
                }
                case 15: {
                    this.getToken();
                    d = (int)d >> (int)this.getFactor();
                    continue block10;
                }
                case 16: {
                    this.getToken();
                    d = (int)d << (int)this.getFactor();
                    continue block10;
                }
            }
            bl = true;
        }
        return d;
    }

    final double getFactor() {
        double d = 0.0;
        Variable variable = null;
        this.getToken();
        switch (this.token) {
            case 130: {
                d = this.tokenValue;
                break;
            }
            case 135: {
                d = this.func.getFunctionValue(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 136: {
                String string = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                d = Tools.parseDouble(string);
                if ("NaN".equals(string)) {
                    d = Double.NaN;
                    break;
                }
                if (!Double.isNaN(d)) break;
                this.error("Numeric value expected");
                break;
            }
            case 138: {
                variable = this.runUserFunction();
                if (variable == null) {
                    this.error("No return value");
                }
                if (this.done) {
                    d = 0.0;
                    break;
                }
                if (variable.getString() != null) {
                    this.error("Numeric return value expected");
                    break;
                }
                d = variable.getValue();
                break;
            }
            case 209: {
                d = 1.0;
                break;
            }
            case 210: {
                d = 0.0;
                break;
            }
            case 211: {
                d = Math.PI;
                break;
            }
            case 212: {
                d = Double.NaN;
                break;
            }
            case 129: {
                variable = this.lookupVariable();
                if (variable == null) {
                    return 0.0;
                }
                int n = this.nextToken();
                if (n == 91) {
                    variable = this.getArrayElement(variable);
                    d = variable.getValue();
                    n = this.nextToken();
                } else if (n == 46) {
                    d = this.getArrayLength(variable);
                    n = this.nextToken();
                } else {
                    if (this.prefixValue != 0 && !this.checkingType) {
                        variable.setValue(variable.getValue() + (double)this.prefixValue);
                        this.prefixValue = 0;
                    }
                    d = variable.getValue();
                }
                if (n != 1 && n != 2) break;
                this.getToken();
                if (this.token == 1) {
                    variable.setValue(variable.getValue() + (double)(!this.checkingType ? 1 : 0));
                    break;
                }
                variable.setValue(variable.getValue() - (double)(!this.checkingType ? 1 : 0));
                break;
            }
            case 40: {
                d = this.getLogicalExpression();
                this.getRightParen();
                break;
            }
            case 1: {
                this.prefixValue = 1;
                d = this.getFactor();
                break;
            }
            case 2: {
                this.prefixValue = -1;
                d = this.getFactor();
                break;
            }
            case 33: {
                d = this.getFactor();
                if (d == 0.0 || d == 1.0) {
                    d = d == 0.0 ? 1.0 : 0.0;
                    break;
                }
                this.error("Boolean expected");
                break;
            }
            case 45: {
                d = -this.getFactor();
                break;
            }
            case 126: {
                d = ~((int)this.getFactor());
                break;
            }
            default: {
                this.error("Number or numeric function expected");
            }
        }
        return d;
    }

    final Variable getArrayElement(Variable variable) {
        int n = this.getIndex();
        Variable[] variableArray = variable.getArray();
        if (variableArray == null) {
            this.error("Array expected");
        }
        if (n < 0 || n >= variableArray.length) {
            this.error("Index (" + n + ") out of 0-" + (variableArray.length - 1) + " range");
        }
        return variableArray[n];
    }

    final double getArrayLength(Variable variable) {
        this.getToken();
        this.getToken();
        if (this.token != 129 || !this.tokenString.equals("length")) {
            this.error("'length' expected");
        }
        if (variable.getArray() == null) {
            this.error("Array expected");
        }
        return variable.getArraySize();
    }

    final double getStringExpression() {
        double d;
        block4: {
            d = this.getTerm();
            while (true) {
                this.getToken();
                if (this.token == 43) {
                    Variable variable;
                    this.getToken();
                    if (this.token == 133 || this.token == 136) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block4;
                    }
                    if (this.token == 129 && (variable = this.lookupVariable(this.tokenAddress)) != null && variable.getString() != null) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block4;
                    }
                    this.putTokenBack();
                    d += this.getTerm();
                    continue;
                }
                if (this.token != 45) break;
                d -= this.getTerm();
            }
            this.putTokenBack();
        }
        return d;
    }

    final Variable lookupLocalVariable(int n) {
        int n2;
        Variable variable = null;
        for (n2 = this.topOfStack; n2 >= this.startOfLocals; --n2) {
            if (this.stack[n2].symTabIndex != n) continue;
            variable = this.stack[n2];
            break;
        }
        if (variable == null) {
            for (n2 = this.topOfGlobals; n2 >= 0; --n2) {
                if (this.stack[n2].symTabIndex != n) continue;
                variable = this.stack[n2];
                break;
            }
        }
        return variable;
    }

    final Variable lookupVariable(int n) {
        Variable variable = null;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stack[i].symTabIndex != n) continue;
            variable = this.stack[i];
            break;
        }
        return variable;
    }

    Variable push(Variable variable, Interpreter interpreter) {
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interpreter.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = variable;
        return variable;
    }

    void pushGlobals() {
        if (this.pgm.globals == null) {
            return;
        }
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        for (int i = 0; i < this.pgm.globals.length; ++i) {
            ++this.topOfStack;
            this.stack[this.topOfStack] = this.pgm.globals[i];
        }
        this.topOfGlobals = this.topOfStack;
    }

    Variable push(int n, double d, String string, Interpreter interpreter) {
        Variable variable = new Variable(n, d, string);
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interpreter.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = variable;
        return variable;
    }

    void trimStack(int n, int n2) {
        for (int i = n + 1; i <= this.topOfStack; ++i) {
            this.stack[i] = null;
        }
        this.topOfStack = n;
        this.startOfLocals = n2;
    }

    final Variable lookupVariable() {
        Variable variable = null;
        if (this.stack == null) {
            this.undefined();
            return variable;
        }
        boolean bl = false;
        for (int i = this.topOfStack; i >= 0; --i) {
            variable = this.stack[i];
            if (variable.symTabIndex != this.tokenAddress) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.undefined();
        }
        return variable;
    }

    final String lookupStringVariable() {
        if (this.stack == null) {
            this.undefined();
            return "";
        }
        boolean bl = false;
        String string = null;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stack[i].symTabIndex != this.tokenAddress) continue;
            Variable variable = this.stack[i];
            bl = true;
            int n = this.nextToken();
            if (n == 91) {
                int n2 = this.pc;
                int n3 = this.getIndex();
                Variable[] variableArray = variable.getArray();
                if (variableArray == null) {
                    this.error("Array expected");
                }
                if (n3 < 0 || n3 >= variableArray.length) {
                    this.error("Index (" + n3 + ") out of 0-" + (variableArray.length - 1) + " range");
                }
                if ((string = variableArray[n3].getString()) != null) break;
                this.pc = n2 - 1;
                this.getToken();
                break;
            }
            if (n == 46) {
                string = null;
                break;
            }
            if (variable.getArray() != null) {
                this.getToken();
                this.error("'[' or '.' expected");
            }
            string = variable.getString();
            break;
        }
        if (!bl) {
            this.undefined();
        }
        return string;
    }

    int getIndex() {
        this.getToken();
        if (this.token != 91) {
            this.error("'['expected");
        }
        int n = (int)this.getExpression();
        this.getToken();
        if (this.token != 93) {
            this.error("']' expected");
        }
        return n;
    }

    void undefined() {
        if (this.nextToken() == 40) {
            this.error("Undefined identifier");
        } else {
            this.error("Undefined variable");
        }
    }

    void dump() {
        this.getParens();
        if (!this.done) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
            this.dumpStack();
        }
    }

    void dumpStack() {
        IJ.log("");
        IJ.log("Stack");
        if (this.stack != null) {
            for (int i = this.topOfStack; i >= 0; --i) {
                IJ.log(i + " " + this.pgm.table[this.stack[i].symTabIndex].str + " " + this.stack[i]);
            }
        }
    }

    void finishUp() {
        ResultsTable resultsTable;
        this.func.updateDisplay();
        instance = null;
        if (!this.calledMacro) {
            if (batchMode) {
                this.showingProgress = true;
            }
            batchMode = false;
            imageTable = null;
            WindowManager.setTempCurrentImage(null);
        }
        if (this.func.plot != null) {
            this.func.plot.show();
            this.func.plot = null;
        }
        if (this.showingProgress) {
            IJ.showProgress(0, 0);
        }
        if (this.keysSet) {
            IJ.setKeyUp(18);
            IJ.setKeyUp(16);
            IJ.setKeyUp(32);
        }
        if (this.rgbWeights != null) {
            ColorProcessor.setWeightingFactors(this.rgbWeights[0], this.rgbWeights[1], this.rgbWeights[2]);
        }
        if (this.func.writer != null) {
            this.func.writer.close();
        }
        this.func.roiManager = null;
        if (this.func.resultsPending && (resultsTable = ResultsTable.getResultsTable()) != null && resultsTable.getCounter() > 0) {
            resultsTable.show("Results");
        }
    }

    public static void abort() {
        if (instance != null) {
            instance.abortMacro();
        }
    }

    static void abortPrevious() {
        if (previousInstance != null) {
            previousInstance.abortMacro();
            IJ.beep();
            previousInstance = null;
        }
    }

    public static void abort(Interpreter interpreter) {
        if (interpreter != null) {
            interpreter.abortMacro();
        }
    }

    public void abortMacro() {
        if (!this.calledMacro) {
            batchMode = false;
            imageTable = null;
        }
        this.done = true;
        if (this.func != null && (this.macroName == null || this.macroName.indexOf(" Tool") == -1)) {
            this.func.abortDialog();
        }
        IJ.showStatus("Macro aborted");
    }

    public static Interpreter getInstance() {
        return instance;
    }

    static void setBatchMode(boolean bl) {
        batchMode = bl;
        if (!bl) {
            imageTable = null;
        }
    }

    public static boolean isBatchMode() {
        return batchMode;
    }

    public static void addBatchModeImage(ImagePlus imagePlus) {
        if (!batchMode || imagePlus == null) {
            return;
        }
        if (imageTable == null) {
            imageTable = new Vector();
        }
        imageTable.addElement(imagePlus);
    }

    public static void removeBatchModeImage(ImagePlus imagePlus) {
        int n;
        if (imageTable != null && imagePlus != null && (n = imageTable.indexOf(imagePlus)) != -1) {
            imageTable.removeElementAt(n);
        }
    }

    public static int[] getBatchModeImageIDs() {
        if (!batchMode || imageTable == null) {
            return new int[0];
        }
        int n = imageTable.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ImagePlus imagePlus = (ImagePlus)imageTable.elementAt(i);
            nArray[i] = imagePlus.getID();
        }
        return nArray;
    }

    public static int getBatchModeImageCount() {
        if (!batchMode || imageTable == null) {
            return 0;
        }
        return imageTable.size();
    }

    public static ImagePlus getBatchModeImage(int n) {
        if (!batchMode || imageTable == null) {
            return null;
        }
        Enumeration enumeration = imageTable.elements();
        while (enumeration.hasMoreElements()) {
            ImagePlus imagePlus = (ImagePlus)enumeration.nextElement();
            if (n != imagePlus.getID()) continue;
            return imagePlus;
        }
        return null;
    }

    public static ImagePlus getLastBatchModeImage() {
        if (!batchMode || imageTable == null) {
            return null;
        }
        int n = imageTable.size();
        if (n == 0) {
            return null;
        }
        return (ImagePlus)imageTable.elementAt(n - 1);
    }

    public static void setAdditionalFunctions(String string) {
        additionalFunctions = string;
    }

    public static String getAdditionalFunctions() {
        return additionalFunctions;
    }

    public static RoiManager getBatchModeRoiManager() {
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter != null && Interpreter.isBatchMode() && RoiManager.getInstance() == null) {
            if (interpreter.func.roiManager == null) {
                interpreter.func.roiManager = new RoiManager(true);
            }
            return interpreter.func.roiManager;
        }
        return null;
    }

    public static boolean isBatchModeRoiManager() {
        Interpreter interpreter = Interpreter.getInstance();
        return interpreter != null && Interpreter.isBatchMode() && interpreter.func.roiManager != null;
    }

    public void setEditor(Editor editor) {
        if (editor != null && this.editor == null) {
            editor.fixLineEndings();
        }
        this.editor = editor;
        this.debugMode = editor != null ? 1 : 0;
    }

    public void setDebugMode(int n) {
        this.debugMode = n;
    }

    public int getLineNumber() {
        return this.pgm.lineNumbers[this.pc];
    }

    public String[] getVariables() {
        String string;
        int n = WindowManager.getImageCount();
        if (n > 0) {
            this.showDebugFunctions = true;
        }
        int n2 = this.showDebugFunctions ? 3 : 0;
        String[] stringArray = new String[this.topOfStack + 1 + n2];
        if (this.showDebugFunctions) {
            ImagePlus imagePlus;
            string = null;
            if (n > 0 && (imagePlus = WindowManager.getCurrentImage()) != null) {
                string = imagePlus.getTitle();
            }
            if (this.debugMode == 1) {
                System.gc();
            }
            stringArray[0] = "FreeMemory()\t" + IJ.freeMemory();
            stringArray[1] = "nImages()\t" + n;
            stringArray[2] = "getTitle()\t" + (string != null ? "\"" + string + "\"" : "");
        }
        int n3 = n2;
        for (int i = 0; i <= this.topOfStack; ++i) {
            string = this.pgm.table[this.stack[i].symTabIndex].str;
            if (i <= this.topOfGlobals) {
                string = string + " (g)";
            }
            stringArray[n3++] = string + "\t" + this.stack[i];
        }
        return stringArray;
    }

    public boolean done() {
        return this.done;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean wasError() {
        return this.wasError;
    }

    public void setVariable(String string, double d) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int n = this.stack[i].symTabIndex;
            if (!this.pgm.table[n].str.equals(string)) continue;
            this.stack[i].setValue(d);
            break;
        }
    }

    public double getVariable(String string) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int n = this.stack[i].symTabIndex;
            if (!this.pgm.table[n].str.equals(string)) continue;
            return this.stack[i].getValue();
        }
        return Double.NaN;
    }

    public double getVariable2(String string) {
        for (int i = this.topOfStack; i >= 0; --i) {
            int n = this.stack[i].symTabIndex;
            if (!this.pgm.table[n].str.equals(string)) continue;
            return this.stack[i].getValue();
        }
        return Double.NaN;
    }

    public String getStringVariable(String string) {
        for (int i = this.topOfStack; i >= 0; --i) {
            int n = this.stack[i].symTabIndex;
            if (!this.pgm.table[n].str.equals(string)) continue;
            return this.stack[i].getString();
        }
        return null;
    }

    public String getVariableAsString(String string) {
        double d;
        String string2 = this.getStringVariable(string);
        if (string2 == null && !Double.isNaN(d = this.getVariable2(string))) {
            string2 = "" + d;
        }
        return string2;
    }
}

