/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.imageio.ImageIO;

public class AVI_Reader
extends VirtualStack
implements PlugIn {
    private static final int FOURCC_RIFF = 1179011410;
    private static final int FOURCC_AVI = 541677121;
    private static final int FOURCC_LIST = 1414744396;
    private static final int FOURCC_hdrl = 1819436136;
    private static final int FOURCC_avih = 1751742049;
    private static final int FOURCC_strl = 1819440243;
    private static final int FOURCC_strh = 1752331379;
    private static final int FOURCC_strf = 1718776947;
    private static final int FOURCC_movi = 1769369453;
    private static final int FOURCC_rec = 543384946;
    private static final int FOURCC_JUNK = 1263424842;
    private static final int FOURCC_vids = 1935960438;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static final int NO_COMPRESSION = 0;
    private static final int NO_COMPRESSION_RGB = 541214546;
    private static final int NO_COMPRESSION_RAW = 542589266;
    private static final int NO_COMPRESSION_Y800 = 808466521;
    private static final int NO_COMPRESSION_Y8 = 538982489;
    private static final int NO_COMPRESSION_GREY = 1497715271;
    private static final int NO_COMPRESSION_Y16 = 540422489;
    private static final int NO_COMPRESSION_MIL = 541870413;
    private static final int AYUV_COMPRESSION = 1448433985;
    private static final int UYVY_COMPRESSION = 0x59565955;
    private static final int Y422_COMPRESSION = 1447975253;
    private static final int UYNV_COMPRESSION = 842151001;
    private static final int CYUV_COMPRESSION = 1987410275;
    private static final int V422_COMPRESSION = 842150998;
    private static final int YUY2_COMPRESSION = 844715353;
    private static final int YUNV_COMPRESSION = 1447974233;
    private static final int YUYV_COMPRESSION = 0x56595559;
    private static final int YVYU_COMPRESSION = 0x55595659;
    private static final int JPEG_COMPRESSION = 1734701162;
    private static final int JPEG_COMPRESSION2 = 1195724874;
    private static final int JPEG_COMPRESSION3 = 4;
    private static final int MJPG_COMPRESSION = 1196444237;
    private static final int PNG_COMPRESSION = 543649392;
    private static final int PNG_COMPRESSION2 = 541544016;
    private static final int PNG_COMPRESSION3 = 5;
    private static final int BITMASK24 = 65536;
    private static final long SIZE_MASK = 0xFFFFFFFFL;
    private static int firstFrameNumber = 1;
    private static int lastFrameNumber = 0;
    private static boolean convertToGray;
    private static boolean flipVertical;
    private static boolean isVirtual;
    private RandomAccessFile raFile;
    private String raFilePath;
    private boolean headerOK = false;
    private int streamNumber;
    private long fileSize = 0L;
    private int paddingGranularity = 2;
    private int dataCompression;
    private int scanLineSize;
    private boolean dataTopDown;
    private ColorModel cm;
    private boolean variableLength;
    private Vector frameInfos;
    private ImageStack stack;
    private ImagePlus imp;
    private boolean verbose = IJ.debugMode;
    private long startTime;
    private int dwMicroSecPerFrame;
    private int dwMaxBytesPerSec;
    private int dwReserved1;
    private int dwFlags;
    private int dwTotalFrames;
    private int dwInitialFrames;
    private int dwStreams;
    private int dwSuggestedBufferSize;
    private int dwWidth;
    private int dwHeight;
    private int fccStreamHandler;
    private int dwStreamFlags;
    private int dwPriorityLanguage;
    private int dwStreamInitialFrames;
    private int dwStreamScale;
    private int dwStreamRate;
    private int dwStreamStart;
    private int dwStreamLength;
    private int dwStreamSuggestedBufferSize;
    private int dwStreamQuality;
    private int dwStreamSampleSize;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private short biPlanes;
    private short biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;

    @Override
    public void run(String string) {
        Object object;
        OpenDialog openDialog = new OpenDialog("Select AVI File", string);
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        String string3 = openDialog.getDirectory();
        String string4 = string3 + string2;
        try {
            this.openAndReadHeader(string4);
        }
        catch (Exception exception) {
            IJ.showMessage("AVI Reader", this.exceptionMessage(exception));
            return;
        }
        if (!this.showDialog(string2)) {
            return;
        }
        try {
            object = this.makeStack(string4, firstFrameNumber, lastFrameNumber, isVirtual, convertToGray, flipVertical);
        }
        catch (Exception exception) {
            IJ.showMessage("AVI Reader", this.exceptionMessage(exception));
            return;
        }
        if (this.stack == null) {
            return;
        }
        if (this.stack.getSize() == 0) {
            object = "";
            if (firstFrameNumber > 1 || lastFrameNumber != 0) {
                object = "\nin Range " + firstFrameNumber + (lastFrameNumber > 0 ? " - " + lastFrameNumber : " - end");
            }
            IJ.showMessage("AVI Reader", "Error: No Frames Found" + (String)object);
            return;
        }
        this.imp = new ImagePlus(string2, this.stack);
        if (this.imp.getBitDepth() == 16) {
            this.imp.getProcessor().resetMinAndMax();
        }
        this.setFramesPerSecond(this.imp);
        object = new FileInfo();
        ((FileInfo)object).fileName = string2;
        ((FileInfo)object).directory = string3;
        this.imp.setFileInfo((FileInfo)object);
        if (string.equals("")) {
            this.imp.show();
        }
        IJ.showTime(this.imp, this.startTime, "Read AVI in ", this.stack.getSize());
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageStack makeStack(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        firstFrameNumber = n;
        lastFrameNumber = n2;
        isVirtual = bl;
        convertToGray = bl2;
        flipVertical = bl3;
        String string2 = null;
        IJ.showProgress(0.001);
        try {
            this.readAVI(string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.stack.trim();
            IJ.showMessage("AVI Reader", "Out of memory.  " + this.stack.getSize() + " of " + this.dwTotalFrames + " frames will be opened.");
        }
        catch (Exception exception) {
            string2 = this.exceptionMessage(exception);
        }
        finally {
            try {
                this.raFile.close();
                if (this.verbose) {
                    IJ.log("File closed.");
                }
            }
            catch (Exception exception) {}
            IJ.showProgress(1.0);
        }
        if (string2 != null) {
            throw new RuntimeException(string2);
        }
        if (bl && this.frameInfos != null) {
            this.stack = this;
        }
        if (this.stack != null && this.cm != null) {
            this.stack.setColorModel(this.cm);
        }
        return this.stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ImageProcessor getProcessor(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0 || this.raFilePath == null) {
            return null;
        }
        if (n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        Object object = null;
        RandomAccessFile randomAccessFile = null;
        String string = null;
        try {
            randomAccessFile = new RandomAccessFile(new File(this.raFilePath), "r");
            long[] lArray = (long[])this.frameInfos.get(n - 1);
            object = this.readFrame(randomAccessFile, lArray[0], (int)lArray[1]);
        }
        catch (Exception exception) {
            string = this.exceptionMessage(exception);
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {}
        }
        if (string != null) {
            throw new RuntimeException(string);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new ByteProcessor(this.dwWidth, this.biHeight, (byte[])object, this.cm);
        }
        if (object instanceof short[]) {
            return new ShortProcessor(this.dwWidth, this.biHeight, (short[])object, this.cm);
        }
        return new ColorProcessor(this.dwWidth, this.biHeight, (int[])object);
    }

    @Override
    public int getWidth() {
        return this.dwWidth;
    }

    @Override
    public int getHeight() {
        return this.biHeight;
    }

    @Override
    public int getSize() {
        if (this.frameInfos == null) {
            return 0;
        }
        return this.frameInfos.size();
    }

    @Override
    public String getSliceLabel(int n) {
        if (this.frameInfos == null || n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("No Virtual Stack or argument out of range: " + n);
        }
        return this.frameLabel(((long[])this.frameInfos.get(n - 1))[2]);
    }

    @Override
    public void deleteSlice(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0) {
            return;
        }
        if (n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        this.frameInfos.removeElementAt(n - 1);
    }

    private boolean showDialog(String string) {
        if (lastFrameNumber != -1) {
            lastFrameNumber = this.dwTotalFrames;
        }
        if (IJ.macroRunning()) {
            firstFrameNumber = 1;
            lastFrameNumber = this.dwTotalFrames;
        }
        GenericDialog genericDialog = new GenericDialog("AVI Reader");
        genericDialog.addNumericField("First Frame: ", firstFrameNumber, 0);
        genericDialog.addNumericField("Last Frame: ", lastFrameNumber, 0, 6, "");
        genericDialog.addCheckbox("Use Virtual Stack", isVirtual);
        genericDialog.addCheckbox("Convert to Grayscale", convertToGray);
        genericDialog.addCheckbox("Flip Vertical", flipVertical);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        firstFrameNumber = (int)genericDialog.getNextNumber();
        lastFrameNumber = (int)genericDialog.getNextNumber();
        isVirtual = genericDialog.getNextBoolean();
        convertToGray = genericDialog.getNextBoolean();
        flipVertical = genericDialog.getNextBoolean();
        IJ.register(this.getClass());
        return true;
    }

    private void readAVI(String string) throws Exception, IOException {
        if (!this.headerOK) {
            this.openAndReadHeader(string);
        }
        this.startTime += System.currentTimeMillis();
        this.findFourccAndRead(1769369453, true, this.fileSize, true);
    }

    private void openAndReadHeader(String string) throws Exception, IOException {
        this.startTime = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log("OPEN AND READ AVI FILE HEADER " + this.timeString());
        }
        File file = new File(string);
        this.raFile = new RandomAccessFile(file, "r");
        this.raFilePath = string;
        this.fileSize = this.raFile.length();
        int n = this.readInt();
        if (this.verbose) {
            IJ.log("File header: File type='" + this.fourccString(n) + "' (should be 'RIFF')" + this.timeString());
        }
        if (n != 1179011410) {
            throw new Exception("Not an AVI file.");
        }
        this.readInt();
        int n2 = this.readInt();
        if (this.verbose) {
            IJ.log("File header: RIFF type='" + this.fourccString(n2) + "' (should be 'AVI ')");
        }
        if (n2 != 541677121) {
            throw new Exception("Not an AVI file.");
        }
        this.findFourccAndRead(1819436136, true, this.fileSize, true);
        this.startTime -= System.currentTimeMillis();
        this.headerOK = true;
    }

    private long findFourccAndRead(int n, boolean bl, long l, boolean bl2) throws Exception, IOException {
        long l2;
        boolean bl3 = false;
        do {
            int n2;
            if ((n2 = this.readType(l)) == 0) {
                if (bl2) {
                    throw new Exception("Required item '" + this.fourccString(n) + "' not found");
                }
                return -1L;
            }
            long l3 = (long)this.readInt() & 0xFFFFFFFFL;
            l2 = this.raFile.getFilePointer() + l3;
            boolean bl4 = false;
            if (bl && n2 == 1414744396) {
                bl4 = true;
                n2 = this.readInt();
            }
            if (this.verbose) {
                IJ.log("Searching for '" + this.fourccString(n) + "', found " + (bl4 ? "LIST '" : "'") + this.fourccString(n2) + "' " + this.posSizeString(l2 - l3, l3));
            }
            if (n2 == n) {
                bl3 = this.readContents(n, l2);
            } else if (this.verbose) {
                IJ.log("Discarded '" + this.fourccString(n2) + "': Contents does not fit");
            }
            this.raFile.seek(l2);
            if (!bl3) continue;
            return l2;
        } while (!bl3);
        return l2;
    }

    private boolean readContents(int n, long l) throws Exception, IOException {
        switch (n) {
            case 1819436136: {
                this.findFourccAndRead(1751742049, false, l, true);
                this.findFourccAndRead(1819440243, true, l, true);
                return true;
            }
            case 1751742049: {
                this.readAviHeader();
                return true;
            }
            case 1819440243: {
                long l2 = this.findFourccAndRead(1752331379, false, l, false);
                if (l2 < 0L) {
                    return false;
                }
                this.findFourccAndRead(1718776947, false, l, true);
                return true;
            }
            case 1752331379: {
                int n2 = this.readInt();
                if (n2 != 1935960438) {
                    if (this.verbose) {
                        IJ.log("Non-video Stream '" + this.fourccString(n2) + " skipped");
                    }
                    ++this.streamNumber;
                    return false;
                }
                this.readStreamHeader();
                return true;
            }
            case 1718776947: {
                this.readBitMapInfo(l);
                return true;
            }
            case 1769369453: {
                this.readMovieData(l);
                return true;
            }
        }
        throw new Exception("Program error, type " + this.fourccString(n));
    }

    void readAviHeader() throws Exception, IOException {
        this.dwMicroSecPerFrame = this.readInt();
        this.dwMaxBytesPerSec = this.readInt();
        this.dwReserved1 = this.readInt();
        this.dwFlags = this.readInt();
        this.dwTotalFrames = this.readInt();
        this.dwInitialFrames = this.readInt();
        this.dwStreams = this.readInt();
        this.dwSuggestedBufferSize = this.readInt();
        this.dwWidth = this.readInt();
        this.dwHeight = this.readInt();
        if (this.verbose) {
            IJ.log("AVI HEADER (avih):" + this.timeString());
            IJ.log("   dwMicroSecPerFrame=" + this.dwMicroSecPerFrame);
            IJ.log("   dwMaxBytesPerSec=" + this.dwMaxBytesPerSec);
            IJ.log("   dwReserved1=" + this.dwReserved1);
            IJ.log("   dwFlags=" + this.dwFlags);
            IJ.log("   dwTotalFrames=" + this.dwTotalFrames);
            IJ.log("   dwInitialFrames=" + this.dwInitialFrames);
            IJ.log("   dwStreams=" + this.dwStreams);
            IJ.log("   dwSuggestedBufferSize=" + this.dwSuggestedBufferSize);
            IJ.log("   dwWidth=" + this.dwWidth);
            IJ.log("   dwHeight=" + this.dwHeight);
        }
    }

    void readStreamHeader() throws Exception, IOException {
        this.fccStreamHandler = this.readInt();
        this.dwStreamFlags = this.readInt();
        this.dwPriorityLanguage = this.readInt();
        this.dwStreamInitialFrames = this.readInt();
        this.dwStreamScale = this.readInt();
        this.dwStreamRate = this.readInt();
        this.dwStreamStart = this.readInt();
        this.dwStreamLength = this.readInt();
        this.dwStreamSuggestedBufferSize = this.readInt();
        this.dwStreamQuality = this.readInt();
        this.dwStreamSampleSize = this.readInt();
        if (this.verbose) {
            IJ.log("VIDEO STREAM HEADER (strh):");
            IJ.log("   fccStreamHandler='" + this.fourccString(this.fccStreamHandler) + "'");
            IJ.log("   dwStreamFlags=" + this.dwStreamFlags);
            IJ.log("   wPriority,wLanguage=" + this.dwPriorityLanguage);
            IJ.log("   dwStreamInitialFrames=" + this.dwStreamInitialFrames);
            IJ.log("   dwStreamScale=" + this.dwStreamScale);
            IJ.log("   dwStreamRate=" + this.dwStreamRate);
            IJ.log("   dwStreamStart=" + this.dwStreamStart);
            IJ.log("   dwStreamLength=" + this.dwStreamLength);
            IJ.log("   dwStreamSuggestedBufferSize=" + this.dwStreamSuggestedBufferSize);
            IJ.log("   dwStreamQuality=" + this.dwStreamQuality);
            IJ.log("   dwStreamSampleSize=" + this.dwStreamSampleSize);
        }
        if (this.dwStreamSampleSize > 1) {
            throw new Exception("Video stream with " + this.dwStreamSampleSize + " (more than 1) frames/chunk not supported");
        }
    }

    void readBitMapInfo(long l) throws Exception, IOException {
        int n;
        this.biSize = this.readInt();
        this.biWidth = this.readInt();
        this.biHeight = this.readInt();
        this.biPlanes = this.readShort();
        this.biBitCount = this.readShort();
        this.biCompression = this.readInt();
        this.biSizeImage = this.readInt();
        this.biXPelsPerMeter = this.readInt();
        this.biYPelsPerMeter = this.readInt();
        this.biClrUsed = this.readInt();
        this.biClrImportant = this.readInt();
        if (this.verbose) {
            IJ.log("   biSize=" + this.biSize);
            IJ.log("   biWidth=" + this.biWidth);
            IJ.log("   biHeight=" + this.biHeight);
            IJ.log("   biPlanes=" + this.biPlanes);
            IJ.log("   biBitCount=" + this.biBitCount);
            IJ.log("   biCompression=0x" + Integer.toHexString(this.biCompression) + " '" + this.fourccString(this.biCompression) + "'");
            IJ.log("   biSizeImage=" + this.biSizeImage);
            IJ.log("   biXPelsPerMeter=" + this.biXPelsPerMeter);
            IJ.log("   biYPelsPerMeter=" + this.biYPelsPerMeter);
            IJ.log("   biClrUsed=" + this.biClrUsed);
            IJ.log("   biClrImportant=" + this.biClrImportant);
        }
        int n2 = 0;
        boolean bl = false;
        switch (this.biCompression) {
            case 0: 
            case 541214546: 
            case 542589266: {
                this.dataCompression = 0;
                this.dataTopDown = this.biHeight < 0;
                n2 = 65576;
                bl = this.biBitCount <= 8;
                break;
            }
            case 538982489: 
            case 808466521: 
            case 1497715271: {
                this.dataTopDown = true;
                this.dataCompression = 0;
                n2 = 8;
                break;
            }
            case 540422489: 
            case 541870413: {
                this.dataCompression = 0;
                n2 = 16;
                break;
            }
            case 1448433985: {
                this.dataCompression = 1448433985;
                n2 = 32;
                break;
            }
            case 842151001: 
            case 0x59565955: {
                this.dataTopDown = true;
            }
            case 842150998: 
            case 1987410275: {
                this.dataCompression = 0x59565955;
                n2 = 16;
                break;
            }
            case 844715353: 
            case 1447974233: 
            case 0x56595559: {
                this.dataTopDown = true;
                this.dataCompression = 844715353;
                n2 = 16;
                break;
            }
            case 0x55595659: {
                this.dataTopDown = true;
                this.dataCompression = 0x55595659;
                n2 = 16;
                break;
            }
            case 4: 
            case 1195724874: 
            case 1196444237: 
            case 1734701162: {
                this.dataCompression = 1734701162;
                this.variableLength = true;
                break;
            }
            case 5: 
            case 541544016: 
            case 543649392: {
                this.variableLength = true;
                this.dataCompression = 543649392;
                break;
            }
            default: {
                throw new Exception("Unsupported compression: " + Integer.toHexString(this.biCompression) + (this.biCompression >= 0x20202020 ? " '" + this.fourccString(this.biCompression) + "'" : ""));
            }
        }
        int n3 = n = this.biBitCount == 24 ? 65536 : (int)this.biBitCount;
        if (n2 != 0 && (n & n2) == 0) {
            throw new Exception("Unsupported: " + this.biBitCount + " bits/pixel for compression '" + this.fourccString(this.biCompression) + "'");
        }
        if (this.biHeight < 0) {
            this.biHeight = -this.biHeight;
        }
        this.scanLineSize = (this.biWidth * this.biBitCount + 31) / 32 * 4;
        if (bl && this.biClrUsed == 0) {
            this.biClrUsed = 1 << this.biBitCount;
        }
        if (this.verbose) {
            IJ.log("   > data compression=0x" + Integer.toHexString(this.dataCompression) + " '" + this.fourccString(this.dataCompression) + "'");
            IJ.log("   > palette colors=" + this.biClrUsed);
            IJ.log("   > scan line size=" + this.scanLineSize);
            IJ.log("   > data top down=" + this.dataTopDown);
        }
        if (bl) {
            long l2 = l - this.raFile.getFilePointer();
            if (this.verbose) {
                IJ.log("   Reading " + this.biClrUsed + " Palette colors: " + this.posSizeString(l2));
            }
            if (l2 < (long)(this.biClrUsed * 4)) {
                throw new Exception("Not enough data (" + l2 + ") for palette of size " + this.biClrUsed * 4);
            }
            byte[] byArray = new byte[this.biClrUsed];
            byte[] byArray2 = new byte[this.biClrUsed];
            byte[] byArray3 = new byte[this.biClrUsed];
            for (int i = 0; i < this.biClrUsed; ++i) {
                byArray3[i] = this.raFile.readByte();
                byArray2[i] = this.raFile.readByte();
                byArray[i] = this.raFile.readByte();
                this.raFile.readByte();
            }
            this.cm = new IndexColorModel((int)this.biBitCount, this.biClrUsed, byArray, byArray2, byArray3);
        }
    }

    void readMovieData(long l) throws Exception, IOException {
        int n;
        if (this.verbose) {
            IJ.log("MOVIE DATA " + this.posSizeString(l - this.raFile.getFilePointer()) + this.timeString());
        }
        int n2 = 1650733104 + (this.streamNumber << 8);
        int n3 = 1667510320 + (this.streamNumber << 8);
        if (this.verbose) {
            IJ.log("Searching for stream " + this.streamNumber + ": '" + this.fourccString(n2) + "' or '" + this.fourccString(n3) + "' chunks");
        }
        int n4 = Integer.MAX_VALUE;
        if (lastFrameNumber > 0) {
            n4 = lastFrameNumber;
        }
        if (lastFrameNumber < 0 && this.dwTotalFrames > 0) {
            n4 = this.dwTotalFrames + lastFrameNumber;
        }
        if (isVirtual) {
            this.frameInfos = new Vector(100);
        } else {
            this.stack = new ImageStack(this.dwWidth, this.biHeight);
        }
        int n5 = 1;
        while ((n = this.readType(l)) != 0) {
            long l2 = (long)this.readInt() & 0xFFFFFFFFL;
            long l3 = this.raFile.getFilePointer();
            long l4 = l3 + l2;
            if ((n == n2 || n == n3) && l2 > 0L) {
                this.updateProgress();
                if (this.verbose) {
                    IJ.log("movie data '" + this.fourccString(n) + "' " + this.posSizeString(l2) + this.timeString());
                }
                if (n5 >= firstFrameNumber) {
                    if (isVirtual) {
                        this.frameInfos.add(new long[]{l3, l2, n5 * this.dwMicroSecPerFrame});
                    } else {
                        Object object = this.readFrame(this.raFile, l3, (int)l2);
                        String string = this.frameLabel(n5 * this.dwMicroSecPerFrame);
                        this.stack.addSlice(string, object);
                    }
                }
                if (++n5 > n4) {
                    break;
                }
            } else if (this.verbose) {
                IJ.log("skipped '" + this.fourccString(n) + "' " + this.posSizeString(l2));
            }
            if (l4 > l) break;
            this.raFile.seek(l4);
        }
    }

    private Object readFrame(RandomAccessFile randomAccessFile, long l, int n) throws Exception, IOException {
        randomAccessFile.seek(l);
        if (this.variableLength) {
            return this.readCompressedFrame(randomAccessFile, n);
        }
        return this.readFixedLengthFrame(randomAccessFile, n);
    }

    private Object readCompressedFrame(RandomAccessFile randomAccessFile, int n) throws Exception, IOException {
        raInputStream raInputStream2 = new raInputStream(randomAccessFile, n, this.biCompression == 1196444237);
        BufferedImage bufferedImage = ImageIO.read(raInputStream2);
        int n2 = bufferedImage.getType();
        ImageProcessor imageProcessor = null;
        if (n2 == 10) {
            imageProcessor = new ByteProcessor(bufferedImage);
        } else if (n2 == 13) {
            this.cm = bufferedImage.getColorModel();
            imageProcessor = new ByteProcessor((Image)bufferedImage);
        } else {
            imageProcessor = new ColorProcessor(bufferedImage);
        }
        if (convertToGray) {
            imageProcessor = imageProcessor.convertToByte(false);
        }
        if (flipVertical) {
            ((ImageProcessor)imageProcessor).flipVertical();
        }
        return ((ImageProcessor)imageProcessor).getPixels();
    }

    private Object readFixedLengthFrame(RandomAccessFile randomAccessFile, int n) throws Exception, IOException {
        if (n < this.scanLineSize * this.biHeight) {
            throw new Exception("Data chunk size " + n + " too short (" + this.scanLineSize * this.biHeight + " required)");
        }
        byte[] byArray = new byte[n];
        int n2 = randomAccessFile.read(byArray, 0, n);
        if (n2 < byArray.length) {
            throw new Exception("Frame ended prematurely after " + n2 + " bytes");
        }
        boolean bl = flipVertical ? !this.dataTopDown : this.dataTopDown;
        Object[] objectArray = null;
        byte[] byArray2 = null;
        int[] nArray = null;
        short[] sArray = null;
        if (this.biBitCount <= 8 || convertToGray) {
            objectArray = byArray2 = new byte[this.dwWidth * this.biHeight];
        } else if (this.biBitCount == 16 && this.dataCompression == 0) {
            sArray = new short[this.dwWidth * this.biHeight];
            objectArray = sArray;
        } else {
            nArray = new int[this.dwWidth * this.biHeight];
            objectArray = nArray;
        }
        int n3 = bl ? 0 : (this.biHeight - 1) * this.dwWidth;
        int n4 = 0;
        for (int i = this.biHeight - 1; i >= 0; --i) {
            if (this.biBitCount <= 8) {
                this.unpack8bit(byArray, n4, byArray2, n3, this.dwWidth);
            } else if (convertToGray) {
                this.unpackGray(byArray, n4, byArray2, n3, this.dwWidth);
            } else if (this.biBitCount == 16 && this.dataCompression == 0) {
                this.unpackShort(byArray, n4, sArray, n3, this.dwWidth);
            } else {
                this.unpack(byArray, n4, nArray, n3, this.dwWidth);
            }
            n4 += this.scanLineSize;
            n3 += bl ? this.dwWidth : -this.dwWidth;
        }
        return objectArray;
    }

    void unpack8bit(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray2[n2 + i] = byArray[n + i];
        }
    }

    void unpackGray(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        if (this.dataCompression == 0) {
            for (int i = 0; i < n3; ++i) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                if (this.biBitCount == 32) {
                    ++n5;
                }
                byArray2[n4++] = (byte)(n6 * 934 + n7 * 4809 + n8 * 2449 + 4096 >> 13);
            }
        } else {
            if (this.dataCompression == 0x59565955 || this.dataCompression == 1448433985) {
                ++n5;
            }
            int n9 = this.dataCompression == 1448433985 ? 4 : 2;
            for (int i = 0; i < n3; ++i) {
                byArray2[n4++] = byArray[n5];
                n5 += n9;
            }
        }
    }

    void unpackShort(byte[] byArray, int n, short[] sArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        for (int i = 0; i < n3; ++i) {
            sArray[n4++] = (short)(byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8);
        }
    }

    void unpack(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        switch (this.dataCompression) {
            case 0: {
                for (int i = 0; i < n3; ++i) {
                    int n6 = byArray[n5++] & 0xFF;
                    int n7 = (byArray[n5++] & 0xFF) << 8;
                    int n8 = (byArray[n5++] & 0xFF) << 16;
                    if (this.biBitCount == 32) {
                        ++n5;
                    }
                    nArray[n4++] = 0xFF000000 | n6 | n7 | n8;
                }
                break;
            }
            case 844715353: {
                for (int i = 0; i < n3 / 2; ++i) {
                    int n9 = byArray[n5++] & 0xFF;
                    int n10 = byArray[n5++] ^ 0xFFFFFF80;
                    int n11 = byArray[n5++] & 0xFF;
                    int n12 = byArray[n5++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(n9, n10, n12, nArray, n4++);
                    this.writeRGBfromYUV(n11, n10, n12, nArray, n4++);
                }
                break;
            }
            case 0x59565955: {
                for (int i = 0; i < n3 / 2; ++i) {
                    int n13 = byArray[n5++] ^ 0xFFFFFF80;
                    int n14 = byArray[n5++] & 0xFF;
                    int n15 = byArray[n5++] ^ 0xFFFFFF80;
                    int n16 = byArray[n5++] & 0xFF;
                    this.writeRGBfromYUV(n14, n13, n15, nArray, n4++);
                    this.writeRGBfromYUV(n16, n13, n15, nArray, n4++);
                }
                break;
            }
            case 0x55595659: {
                for (int i = 0; i < n3 / 2; ++i) {
                    int n17 = byArray[n5++] & 0xFF;
                    int n18 = byArray[n5++] ^ 0xFFFFFF80;
                    int n19 = byArray[n5++] & 0xFF;
                    int n20 = byArray[n5++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(n17, n20, n18, nArray, n4++);
                    this.writeRGBfromYUV(n19, n20, n18, nArray, n4++);
                }
                break;
            }
            case 1448433985: {
                for (int i = 0; i < n3; ++i) {
                    int n21 = ++n5;
                    int n22 = byArray[n21] & 0xFF;
                    int n23 = ++n5;
                    int n24 = byArray[n23] ^ 0xFFFFFF80;
                    int n25 = ++n5;
                    ++n5;
                    int n26 = byArray[n25] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(n22, n26, n24, nArray, n4++);
                }
                break;
            }
        }
    }

    void writeRGBfromYUV(int n, int n2, int n3, int[] nArray, int n4) {
        int n5 = 9535 * n + 13074 * n3 - 148464 >> 13;
        int n6 = 9535 * n - 6660 * n3 - 3203 * n2 - 148464 >> 13;
        int n7 = 9535 * n + 16531 * n2 - 148464 >> 13;
        if (n5 > 255) {
            n5 = 255;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 > 255) {
            n7 = 255;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        nArray[n4] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
    }

    int readInt() throws IOException {
        int n = 0;
        for (int i = 0; i < 32; i += 8) {
            n |= (this.raFile.readByte() & 0xFF) << i;
        }
        return n;
    }

    short readShort() throws IOException {
        int n = this.raFile.readByte() & 0xFF;
        int n2 = this.raFile.readByte() & 0xFF;
        return (short)(n2 << 8 | n);
    }

    private int readType(long l) throws IOException {
        while (true) {
            long l2;
            if ((l2 = this.raFile.getFilePointer()) % (long)this.paddingGranularity != 0L) {
                l2 = (l2 / (long)this.paddingGranularity + 1L) * (long)this.paddingGranularity;
                this.raFile.seek(l2);
            }
            if (l2 >= l) {
                return 0;
            }
            int n = this.readInt();
            if (n != 1263424842) {
                return n;
            }
            long l3 = (long)this.readInt() & 0xFFFFFFFFL;
            if (this.verbose) {
                IJ.log("Skip JUNK: " + this.posSizeString(l3));
            }
            this.raFile.seek(this.raFile.getFilePointer() + l3);
        }
    }

    private void setFramesPerSecond(ImagePlus imagePlus) {
        if (this.dwMicroSecPerFrame < 1000 && this.dwStreamRate > 0) {
            this.dwMicroSecPerFrame = (int)((double)this.dwStreamScale * 1000000.0 / (double)this.dwStreamRate);
        }
        if (this.dwMicroSecPerFrame >= 1000) {
            imagePlus.getCalibration().fps = 1000000.0 / (double)this.dwMicroSecPerFrame;
        }
    }

    private String frameLabel(long l) {
        return IJ.d2s((double)l / 1000000.0) + " s";
    }

    private String posSizeString(long l) throws IOException {
        return this.posSizeString(this.raFile.getFilePointer(), l);
    }

    private String posSizeString(long l, long l2) throws IOException {
        return "0x" + Long.toHexString(l) + "-0x" + Long.toHexString(l + l2 - 1L) + " (" + l2 + " Bytes)";
    }

    private String timeString() {
        return " (t=" + (System.currentTimeMillis() - this.startTime) + " ms)";
    }

    private String fourccString(int n) {
        String string = "";
        for (int i = 0; i < 4; ++i) {
            int n2 = n & 0xFF;
            string = string + Character.toString((char)n2);
            n >>= 8;
        }
        return string;
    }

    private String exceptionMessage(Exception exception) {
        String string = exception.getClass() == Exception.class ? exception.getMessage() : exception + "\n" + exception.getStackTrace()[0] + "\n" + exception.getStackTrace()[1];
        if (string.indexOf("Huffman table") != -1) {
            return "Cannot open M_JPEG AVIs that are missing Huffman tables";
        }
        return "An error occurred reading the file.\n \n" + string;
    }

    void updateProgress() throws IOException {
        IJ.showProgress((double)this.raFile.getFilePointer() / (double)this.fileSize);
    }

    class raInputStream
    extends InputStream {
        RandomAccessFile rFile;
        int readableSize;
        boolean fixMJPG;

        raInputStream(RandomAccessFile randomAccessFile, int n, boolean bl) {
            this.rFile = randomAccessFile;
            this.readableSize = n;
            this.fixMJPG = bl;
        }

        @Override
        public int available() {
            return this.readableSize;
        }

        @Override
        public int read() throws IOException {
            this.fixMJPG = false;
            return this.rFile.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.rFile.read(byArray, n, n2);
            if (this.fixMJPG) {
                this.doFixMJPG(byArray, n3);
                this.fixMJPG = false;
            }
            return n3;
        }

        private void doFixMJPG(byte[] byArray, int n) {
            int n2;
            if (this.readShort(byArray, 0) != 65496 || n < 6) {
                return;
            }
            int n3 = 2;
            do {
                int n4;
                if ((n4 = this.readShort(byArray, n3)) == 65498 || n4 == 65497) {
                    return;
                }
                if (n4 == 65506) {
                    byArray[n3 + 1] = -60;
                    return;
                }
                n3 += 2;
            } while ((n3 += (n2 = this.readShort(byArray, n3))) <= n - 4 && n2 >= 0);
        }

        private int readShort(byte[] byArray, int n) {
            return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        }
    }
}

