/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class ArrowToolOptions
implements PlugIn,
DialogListener {
    private String colorName;
    private static GenericDialog gd;

    @Override
    public void run(String string) {
        if (gd != null && gd.isVisible()) {
            gd.toFront();
        } else {
            this.arrowToolOptions();
        }
    }

    void arrowToolOptions() {
        if (!Toolbar.getToolName().equals("arrow")) {
            IJ.setTool("arrow");
        }
        double d = Arrow.getDefaultWidth();
        double d2 = Arrow.getDefaultHeadSize();
        Color color = Toolbar.getForegroundColor();
        this.colorName = Colors.getColorName(color, "red");
        int n = Arrow.getDefaultStyle();
        gd = new NonBlockingGenericDialog("Arrow Tool");
        gd.addSlider("Width:", 1.0, 50.0, (int)d);
        gd.addSlider("Size:", 0.0, 30.0, d2);
        gd.addChoice("Color:", Colors.colors, this.colorName);
        gd.addChoice("Style:", Arrow.styles, Arrow.styles[n]);
        gd.addCheckbox("Outline", Arrow.getDefaultOutline());
        gd.addCheckbox("Double head", Arrow.getDefaultDoubleHeaded());
        gd.addDialogListener(this);
        gd.showDialog();
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        Object object;
        double d = genericDialog.getNextNumber();
        double d2 = genericDialog.getNextNumber();
        String string = genericDialog.getNextChoice();
        int n = genericDialog.getNextChoiceIndex();
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        if (this.colorName != null && !string.equals(this.colorName)) {
            object = Colors.getColor(string, Color.black);
            Toolbar.setForegroundColor((Color)object);
        }
        this.colorName = string;
        Arrow.setDefaultWidth(d);
        Arrow.setDefaultHeadSize(d2);
        Arrow.setDefaultStyle(n);
        Arrow.setDefaultOutline(bl);
        Arrow.setDefaultDoubleHeaded(bl2);
        object = WindowManager.getCurrentImage();
        if (object == null) {
            return true;
        }
        Roi roi = ((ImagePlus)object).getRoi();
        if (roi == null) {
            return true;
        }
        if (roi instanceof Arrow) {
            Arrow arrow = (Arrow)roi;
            roi.setStrokeWidth((float)d);
            arrow.setHeadSize(d2);
            arrow.setStyle(n);
            arrow.setOutline(bl);
            arrow.setDoubleHeaded(bl2);
            ((ImagePlus)object).draw();
        }
        Prefs.set("arrow.style", n);
        Prefs.set("arrow.width", d);
        Prefs.set("arrow.size", d2);
        Prefs.set("arrow.outline", bl);
        Prefs.set("arrow.double", bl2);
        return true;
    }
}

