/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;

public class BMP_Writer
implements PlugIn {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int padWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 0;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] intBitmap;
    private byte[] byteBitmap;
    private FileOutputStream fo;
    private BufferedOutputStream bfo;
    ImagePlus imp;

    @Override
    public void run(String string) {
        IJ.showProgress(0.0);
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        try {
            this.writeImage(this.imp, string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null || string2.equals("")) {
                string2 = "" + exception;
            }
            IJ.error("BMP Writer", "An error occured writing the file.\n \n" + string2);
        }
        IJ.showProgress(1.0);
        IJ.showStatus("");
    }

    void writeImage(ImagePlus imagePlus, String string) throws Exception {
        Object object;
        if (imagePlus.getBitDepth() == 24) {
            this.biBitCount = 24;
        } else {
            this.biBitCount = 8;
            object = imagePlus.createLut();
            this.biClrUsed = ((LookUpTable)object).getMapSize();
            this.bfOffBits += this.biClrUsed * 4;
        }
        if (string == null || string.equals("")) {
            object = "Save as " + this.biBitCount + " bit BMP";
            SaveDialog saveDialog = new SaveDialog((String)object, imagePlus.getTitle(), ".bmp");
            if (saveDialog.getFileName() == null) {
                return;
            }
            string = saveDialog.getDirectory() + saveDialog.getFileName();
        }
        imagePlus.startTiming();
        this.saveBitmap(string, imagePlus.getImage(), imagePlus.getWidth(), imagePlus.getHeight());
    }

    public void saveBitmap(String string, Image image, int n, int n2) throws Exception {
        this.fo = new FileOutputStream(string);
        this.bfo = new BufferedOutputStream(this.fo);
        this.save(image, n, n2);
        this.bfo.close();
        this.fo.close();
    }

    private void save(Image image, int n, int n2) throws Exception {
        this.convertImage(image, n, n2);
        this.writeBitmapFileHeader();
        this.writeBitmapInfoHeader();
        if (this.biBitCount == 8) {
            this.writeBitmapPalette();
        }
        this.writeBitmap();
    }

    private void writeBitmapPalette() throws Exception {
        LookUpTable lookUpTable = this.imp.createLut();
        byte[] byArray = lookUpTable.getGreens();
        byte[] byArray2 = lookUpTable.getReds();
        byte[] byArray3 = lookUpTable.getBlues();
        for (int i = 0; i < lookUpTable.getMapSize(); ++i) {
            this.bfo.write(byArray3[i]);
            this.bfo.write(byArray[i]);
            this.bfo.write(byArray2[i]);
            this.bfo.write(0);
        }
    }

    private boolean convertImage(Image image, int n, int n2) {
        if (this.biBitCount == 24) {
            this.intBitmap = (int[])this.imp.getProcessor().getPixels();
        } else {
            this.byteBitmap = (byte[])this.imp.getProcessor().convertToByte(true).getPixels();
        }
        this.biWidth = n;
        this.biHeight = n2;
        int n3 = this.biBitCount == 24 ? 4 - this.biWidth * 3 % 4 : 4 - this.biWidth % 4;
        if (n3 == 4) {
            n3 = 0;
        }
        this.padWidth = this.biWidth * (this.biBitCount == 24 ? 3 : 1) + n3;
        return true;
    }

    private void writeBitmap() throws Exception {
        byte[] byArray = new byte[3];
        int n = this.biBitCount == 24 ? 4 - this.biWidth * 3 % 4 : 4 - this.biWidth % 4;
        if (n == 4) {
            n = 0;
        }
        int n2 = 0;
        for (int i = this.biHeight; i > 0; --i) {
            if (i % 20 == 0) {
                IJ.showProgress((double)(this.biHeight - i) / (double)this.biHeight);
            }
            for (int j = 0; j < this.biWidth; ++j) {
                if (this.biBitCount == 24) {
                    int n3 = this.intBitmap[(i - 1) * this.biWidth + j];
                    byArray[0] = (byte)(n3 & 0xFF);
                    byArray[1] = (byte)(n3 >> 8 & 0xFF);
                    byArray[2] = (byte)(n3 >> 16 & 0xFF);
                    this.bfo.write(byArray);
                } else {
                    this.bfo.write(this.byteBitmap[(i - 1) * this.biWidth + j]);
                }
                ++n2;
            }
            for (int j = 1; j <= n; ++j) {
                this.bfo.write(0);
            }
            n2 += n;
        }
    }

    private void writeBitmapFileHeader() throws Exception {
        this.fo.write(this.bfType);
        this.bfSize = this.bfOffBits + this.padWidth * this.biHeight;
        this.fo.write(this.intToDWord(this.bfSize));
        this.fo.write(this.intToWord(this.bfReserved1));
        this.fo.write(this.intToWord(this.bfReserved2));
        this.fo.write(this.intToDWord(this.bfOffBits));
    }

    private void writeBitmapInfoHeader() throws Exception {
        this.fo.write(this.intToDWord(this.biSize));
        this.fo.write(this.intToDWord(this.biWidth));
        this.fo.write(this.intToDWord(this.biHeight));
        this.fo.write(this.intToWord(this.biPlanes));
        this.fo.write(this.intToWord(this.biBitCount));
        this.fo.write(this.intToDWord(this.biCompression));
        this.fo.write(this.intToDWord(this.biSizeImage));
        this.fo.write(this.intToDWord(this.biXPelsPerMeter));
        this.fo.write(this.intToDWord(this.biYPelsPerMeter));
        this.fo.write(this.intToDWord(this.biClrUsed));
        this.fo.write(this.intToDWord(this.biClrImportant));
    }

    private byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }
}

