/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;

public class CanvasResizer
implements PlugIn {
    boolean zeroFill = Prefs.get("resizer.zero", false);

    @Override
    public void run(String string) {
        int n;
        int n2;
        boolean bl = false;
        ImagePlus imagePlus = IJ.getImage();
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        ImageStack imageStack = imagePlus.getStack();
        if (imageStack != null && imageStack.getSize() > 1) {
            bl = true;
        }
        String[] stringArray = new String[]{"Top-Left", "Top-Center", "Top-Right", "Center-Left", "Center", "Center-Right", "Bottom-Left", "Bottom-Center", "Bottom-Right"};
        String string2 = bl ? "Resize Stack Canvas" : "Resize Image Canvas";
        GenericDialog genericDialog = new GenericDialog(string2);
        genericDialog.addNumericField("Width:", n3, 0, 5, "pixels");
        genericDialog.addNumericField("Height:", n4, 0, 5, "pixels");
        genericDialog.addChoice("Position:", stringArray, stringArray[4]);
        genericDialog.addCheckbox("Zero Fill", this.zeroFill);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n5 = (int)genericDialog.getNextNumber();
        int n6 = (int)genericDialog.getNextNumber();
        int n7 = genericDialog.getNextChoiceIndex();
        this.zeroFill = genericDialog.getNextBoolean();
        Prefs.set("resizer.zero", this.zeroFill);
        int n8 = (n5 - n3) / 2;
        int n9 = n5 - n3;
        int n10 = (n6 - n4) / 2;
        int n11 = n6 - n4;
        switch (n7) {
            case 0: {
                n2 = 0;
                n = 0;
                break;
            }
            case 1: {
                n2 = n8;
                n = 0;
                break;
            }
            case 2: {
                n2 = n9;
                n = 0;
                break;
            }
            case 3: {
                n2 = 0;
                n = n10;
                break;
            }
            case 4: {
                n2 = n8;
                n = n10;
                break;
            }
            case 5: {
                n2 = n9;
                n = n10;
                break;
            }
            case 6: {
                n2 = 0;
                n = n11;
                break;
            }
            case 7: {
                n2 = n8;
                n = n11;
                break;
            }
            case 8: {
                n2 = n9;
                n = n11;
                break;
            }
            default: {
                n2 = n8;
                n = n10;
            }
        }
        if (bl) {
            ImageStack imageStack2 = this.expandStack(imageStack, n5, n6, n2, n);
            imagePlus.setStack(null, imageStack2);
        } else {
            if (!IJ.macroRunning()) {
                Undo.setup(4, imagePlus);
            }
            ImageProcessor imageProcessor = this.expandImage(imagePlus.getProcessor(), n5, n6, n2, n);
            imagePlus.setProcessor(null, imageProcessor);
            if (!IJ.macroRunning()) {
                Undo.setup(5, imagePlus);
            }
        }
    }

    public ImageStack expandStack(ImageStack imageStack, int n, int n2, int n3, int n4) {
        int n5 = imageStack.getSize();
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        Color color = Toolbar.getBackgroundColor();
        ImageStack imageStack2 = new ImageStack(n, n2, imageStack.getColorModel());
        for (int i = 1; i <= n5; ++i) {
            IJ.showProgress((double)i / (double)n5);
            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n, n2);
            if (this.zeroFill) {
                imageProcessor2.setValue(0.0);
            } else {
                imageProcessor2.setColor(color);
            }
            imageProcessor2.fill();
            imageProcessor2.insert(imageStack.getProcessor(i), n3, n4);
            imageStack2.addSlice(imageStack.getSliceLabel(i), imageProcessor2);
        }
        return imageStack2;
    }

    public ImageProcessor expandImage(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n, n2);
        if (this.zeroFill) {
            imageProcessor2.setValue(0.0);
        } else {
            imageProcessor2.setColor(Toolbar.getBackgroundColor());
        }
        imageProcessor2.fill();
        imageProcessor2.insert(imageProcessor, n3, n4);
        return imageProcessor2;
    }
}

