/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import java.awt.Choice;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class Colors
implements PlugIn,
ItemListener {
    public static final String[] colors = new String[]{"red", "green", "blue", "magenta", "cyan", "yellow", "orange", "black", "white"};
    private Choice fchoice;
    private Choice bchoice;
    private Choice schoice;
    private Color fc2;
    private Color bc2;
    private Color sc2;

    @Override
    public void run(String string) {
        if (string.equals("point")) {
            this.pointToolOptions();
        } else {
            this.showDialog();
        }
    }

    void showDialog() {
        Color color = Toolbar.getForegroundColor();
        String string = Colors.getColorName(color, "black");
        Color color2 = Toolbar.getBackgroundColor();
        String string2 = Colors.getColorName(color2, "white");
        Color color3 = Roi.getColor();
        String string3 = Colors.getColorName(color3, "yellow");
        GenericDialog genericDialog = new GenericDialog("Colors");
        genericDialog.addChoice("Foreground:", colors, string);
        genericDialog.addChoice("Background:", colors, string2);
        genericDialog.addChoice("Selection:", colors, string3);
        Vector vector = genericDialog.getChoices();
        this.fchoice = (Choice)vector.elementAt(0);
        this.bchoice = (Choice)vector.elementAt(1);
        this.schoice = (Choice)vector.elementAt(2);
        this.fchoice.addItemListener(this);
        this.bchoice.addItemListener(this);
        this.schoice.addItemListener(this);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            if (this.fc2 != color) {
                Toolbar.setForegroundColor(color);
            }
            if (this.bc2 != color2) {
                Toolbar.setBackgroundColor(color2);
            }
            if (this.sc2 != color3) {
                Roi.setColor(color3);
                ImagePlus imagePlus = WindowManager.getCurrentImage();
                if (imagePlus != null && imagePlus.getRoi() != null) {
                    imagePlus.draw();
                }
            }
            return;
        }
        string = genericDialog.getNextChoice();
        string2 = genericDialog.getNextChoice();
        string3 = genericDialog.getNextChoice();
        this.fc2 = Colors.getColor(string, Color.black);
        this.bc2 = Colors.getColor(string2, Color.white);
        this.sc2 = Colors.getColor(string3, Color.yellow);
        if (this.fc2 != color) {
            Toolbar.setForegroundColor(this.fc2);
        }
        if (this.bc2 != color2) {
            Toolbar.setBackgroundColor(this.bc2);
        }
        if (this.sc2 != color3) {
            Roi.setColor(this.sc2);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }

    public static String getColorName(Color color, String string) {
        if (color == null) {
            return string;
        }
        String string2 = string;
        if (color.equals(Color.red)) {
            string2 = colors[0];
        } else if (color.equals(Color.green)) {
            string2 = colors[1];
        } else if (color.equals(Color.blue)) {
            string2 = colors[2];
        } else if (color.equals(Color.magenta)) {
            string2 = colors[3];
        } else if (color.equals(Color.cyan)) {
            string2 = colors[4];
        } else if (color.equals(Color.yellow)) {
            string2 = colors[5];
        } else if (color.equals(Color.orange)) {
            string2 = colors[6];
        } else if (color.equals(Color.black)) {
            string2 = colors[7];
        } else if (color.equals(Color.white)) {
            string2 = colors[8];
        }
        return string2;
    }

    public static Color getColor(String string, Color color) {
        if (string == null) {
            return color;
        }
        Color color2 = color;
        if (string.equals(colors[0])) {
            color2 = Color.red;
        } else if (string.equals(colors[1])) {
            color2 = Color.green;
        } else if (string.equals(colors[2])) {
            color2 = Color.blue;
        } else if (string.equals(colors[3])) {
            color2 = Color.magenta;
        } else if (string.equals(colors[4])) {
            color2 = Color.cyan;
        } else if (string.equals(colors[5])) {
            color2 = Color.yellow;
        } else if (string.equals(colors[6])) {
            color2 = Color.orange;
        } else if (string.equals(colors[7])) {
            color2 = Color.black;
        } else if (string.equals(colors[8])) {
            color2 = Color.white;
        }
        return color2;
    }

    public static Color decode(String string, Color color) {
        Color color2 = Colors.getColor(string, Color.gray);
        if (color2 == Color.gray) {
            float f;
            int n;
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            if ((n = string.length()) != 6 && n != 8) {
                return color;
            }
            float f2 = f = n == 8 ? Colors.parseHex(string.substring(0, 2)) : 1.0f;
            if (n == 8) {
                string = string.substring(2);
            }
            float f3 = Colors.parseHex(string.substring(0, 2));
            float f4 = Colors.parseHex(string.substring(2, 4));
            float f5 = Colors.parseHex(string.substring(4, 6));
            color2 = new Color(f3, f4, f5, f);
        }
        return color2;
    }

    public static String hexToColor(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        String string2 = null;
        if (string.equals("ff0000")) {
            string2 = "red";
        } else if (string.equals("00ff00")) {
            string2 = "green";
        } else if (string.equals("0000ff")) {
            string2 = "blue";
        } else if (string.equals("000000")) {
            string2 = "black";
        } else if (string.equals("ffffff")) {
            string2 = "white";
        } else if (string.equals("ffff00")) {
            string2 = "yellow";
        } else if (string.equals("00ffff")) {
            string2 = "cyan";
        } else if (string.equals("ff00ff")) {
            string2 = "magenta";
        }
        return string2;
    }

    public static String colorToString(Color color) {
        String string;
        String string2;
        String string3 = string2 = color != null ? "#" + Integer.toHexString(color.getRGB()) : "none";
        if (string2.length() == 9 && string2.startsWith("#ff")) {
            string2 = "#" + string2.substring(3);
        }
        return (string = Colors.hexToColor(string2)) != null ? string : string2;
    }

    private static float parseHex(String string) {
        float f = 0.0f;
        try {
            f = Integer.parseInt(string, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f / 255.0f;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Choice choice = (Choice)itemEvent.getSource();
        String string = choice.getSelectedItem();
        Color color = Colors.getColor(string, Color.black);
        if (choice == this.fchoice) {
            Toolbar.setForegroundColor(color);
        } else if (choice == this.bchoice) {
            Toolbar.setBackgroundColor(color);
        } else if (choice == this.schoice) {
            Roi.setColor(color);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null && imagePlus.getRoi() != null) {
                imagePlus.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }

    void pointToolOptions() {
        ImagePlus imagePlus;
        boolean bl = Prefs.noPointLabels;
        Color color = Roi.getColor();
        String string = Colors.getColorName(color, "yellow");
        GenericDialog genericDialog = new GenericDialog("Point Tool");
        genericDialog.addNumericField("Mark Width:", Analyzer.markWidth, 0, 2, "pixels");
        genericDialog.addCheckbox("Auto-Measure", Prefs.pointAutoMeasure);
        genericDialog.addCheckbox("Auto-Next Slice", Prefs.pointAutoNextSlice);
        genericDialog.addCheckbox("Add to ROI Manager", Prefs.pointAddToManager);
        genericDialog.addCheckbox("Label Points", !Prefs.noPointLabels);
        genericDialog.addChoice("Selection Color:", colors, string);
        Vector vector = genericDialog.getChoices();
        this.schoice = (Choice)vector.elementAt(0);
        this.schoice.addItemListener(this);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            if (this.sc2 != color) {
                Roi.setColor(color);
                ImagePlus imagePlus2 = WindowManager.getCurrentImage();
                if (imagePlus2 != null && imagePlus2.getRoi() != null) {
                    imagePlus2.draw();
                }
                Toolbar.getInstance().repaint();
            }
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 0) {
            n = 0;
        }
        Analyzer.markWidth = n;
        Prefs.pointAutoMeasure = genericDialog.getNextBoolean();
        Prefs.pointAutoNextSlice = genericDialog.getNextBoolean();
        Prefs.pointAddToManager = genericDialog.getNextBoolean();
        Prefs.noPointLabels = !genericDialog.getNextBoolean();
        string = genericDialog.getNextChoice();
        this.sc2 = Colors.getColor(string, Color.yellow);
        if (Prefs.pointAutoNextSlice && !Prefs.pointAddToManager) {
            Prefs.pointAutoMeasure = true;
        }
        if (Prefs.noPointLabels != bl && (imagePlus = WindowManager.getCurrentImage()) != null) {
            imagePlus.draw();
        }
        if (this.sc2 != color) {
            Roi.setColor(this.sc2);
            imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }
}

