/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Frame;
import java.io.File;

public class Commands
implements PlugIn {
    @Override
    public void run(String string) {
        if (string.equals("new")) {
            new NewImage();
        } else if (string.equals("open")) {
            if (Prefs.useJFileChooser && !IJ.macroRunning()) {
                new Opener().openMultiple();
            } else {
                new Opener().open();
            }
        } else if (string.equals("close")) {
            this.close();
        } else if (string.equals("close-all")) {
            this.closeAll();
        } else if (string.equals("save")) {
            this.save();
        } else if (string.equals("ij")) {
            ImageJ imageJ = IJ.getInstance();
            if (imageJ != null) {
                imageJ.toFront();
            }
        } else if (string.equals("tab")) {
            WindowManager.putBehind();
        } else if (string.equals("quit")) {
            ImageJ imageJ = IJ.getInstance();
            if (imageJ != null) {
                imageJ.quit();
            }
        } else if (string.equals("revert")) {
            this.revert();
        } else if (string.equals("undo")) {
            this.undo();
        } else if (string.equals("startup")) {
            this.openStartupMacros();
        }
    }

    void revert() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            imagePlus.revert();
        } else {
            IJ.noImage();
        }
    }

    void save() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            if (imagePlus.getStackSize() > 1) {
                imagePlus.setIgnoreFlush(true);
                new FileSaver(imagePlus).save();
                imagePlus.setIgnoreFlush(false);
            } else {
                new FileSaver(imagePlus).save();
            }
        } else {
            IJ.noImage();
        }
    }

    void undo() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            Undo.undo();
        } else {
            IJ.noImage();
        }
    }

    void close() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Frame frame = WindowManager.getFrontWindow();
        if (frame == null || Interpreter.isBatchMode() && frame instanceof ImageWindow) {
            this.closeImage(imagePlus);
        } else if (frame instanceof PlugInFrame) {
            ((PlugInFrame)frame).close();
        } else if (frame instanceof TextWindow) {
            ((TextWindow)frame).close();
        } else {
            this.closeImage(imagePlus);
        }
    }

    void closeAll() {
        int[] nArray = WindowManager.getIDList();
        if (nArray != null) {
            Object object;
            int n;
            int n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                object = WindowManager.getImage(nArray[n]);
                if (object == null || !((ImagePlus)object).changes) continue;
                ++n2;
            }
            if (n2 > 0 && !IJ.macroRunning()) {
                GenericDialog genericDialog = new GenericDialog("Close All");
                object = null;
                String string = null;
                if (n2 == 1) {
                    object = "There is one image";
                    string = "it";
                } else {
                    object = "There are " + n2 + " images";
                    string = "they";
                }
                genericDialog.addMessage((String)object + " with unsaved changes. If you\nclick \"OK\" " + string + " will be closed without being saved.");
                genericDialog.showDialog();
                if (genericDialog.wasCanceled()) {
                    return;
                }
            }
            for (n = 0; n < nArray.length; ++n) {
                object = WindowManager.getImage(nArray[n]);
                if (object == null) continue;
                ((ImagePlus)object).changes = false;
                ((ImagePlus)object).close();
            }
        }
    }

    void closeImage(ImagePlus imagePlus) {
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        imagePlus.close();
        if (Recorder.record && !IJ.isMacro()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("imp.close();");
            } else {
                Recorder.record("close");
            }
            Recorder.setCommand(null);
        }
    }

    void openStartupMacros() {
        Applet applet = IJ.getApplet();
        if (applet != null) {
            IJ.run("URL...", "url=http://imagej.nih.gov/ij/applet/StartupMacros.txt");
        } else {
            String string = IJ.getDirectory("macros") + "/StartupMacros.txt";
            File file = new File(string);
            if (!file.exists()) {
                IJ.error("\"StartupMacros.txt\" not found in ImageJ/macros/");
            } else {
                IJ.open(string);
            }
        }
    }
}

