/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import ij.plugin.TreePanel;
import ij.util.Java2;
import ij.util.StringSorter;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ControlPanel
implements PlugIn {
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final char sep = fileSeparator.charAt(0);
    private Hashtable panels = new Hashtable();
    private Vector visiblePanels = new Vector();
    private Vector expandedNodes = new Vector();
    private String defaultArg = "";
    private boolean savePropsUponClose = true;
    private boolean propertiesChanged = true;
    private boolean closeChildPanelOnExpand = true;
    private boolean requireDoubleClick;
    private boolean quitting = true;
    Vector menus = new Vector();
    Vector allMenus = new Vector();
    Hashtable commands = new Hashtable();
    Hashtable menuCommands = new Hashtable();
    String[] pluginsArray;
    Hashtable treeCommands = new Hashtable();
    int argLength;
    private String path = null;
    private DefaultMutableTreeNode root;
    MenuItem reloadMI = null;

    public ControlPanel() {
        Java2.setSystemLookAndFeel();
    }

    @Override
    public void run(String string) {
        this.load();
    }

    synchronized void load() {
        this.commands = Menus.getCommands();
        this.pluginsArray = Menus.getPlugins();
        this.root = this.doRootFromMenus();
        if (this.root == null || this.root.getChildCount() == 0) {
            return;
        }
        this.loadProperties();
        this.restoreVisiblePanels();
        if (this.panels.isEmpty()) {
            this.newPanel(this.root);
        }
    }

    private synchronized DefaultMutableTreeNode doRootFromMenus() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("ImageJ Menus");
        if (this.argLength == 0) {
            defaultMutableTreeNode.setUserObject("Control Panel");
        }
        MenuBar menuBar = Menus.getMenuBar();
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            Menu menu = menuBar.getMenu(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(menu.getLabel());
            this.recurseSubMenu(menu, defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private void recurseSubMenu(Menu menu, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = menu.getItemCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            MenuItem menuItem = menu.getItem(i);
            String string = menuItem.getLabel();
            if (menuItem instanceof Menu) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                this.recurseSubMenu((Menu)menuItem, defaultMutableTreeNode2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            if (!(menuItem instanceof MenuItem) || string.equals("-")) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (this.treeCommands == null) {
                this.treeCommands = new Hashtable();
            }
            if (!string.equals("Reload Plugins")) continue;
            this.reloadMI = menuItem;
            this.treeCommands.put(string, "Reload Plugins From Panel");
        }
    }

    private void populateNode(Hashtable hashtable, DefaultMutableTreeNode defaultMutableTreeNode) {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        Object[] objectArray = hashtable.keys();
        while (objectArray.hasMoreElements()) {
            stringArray = (String[])objectArray.nextElement();
            vector.addElement(stringArray);
        }
        objectArray = new String[vector.size()];
        stringArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)hashtable.get(objectArray[i]);
        }
        this.populateNode(stringArray, (String[])objectArray, defaultMutableTreeNode);
    }

    private void populateNode(String[] stringArray, String[] stringArray2, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (stringArray.length == 0 || stringArray.length != stringArray2.length) {
            return;
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2 != null && i < stringArray2.length) {
                string = stringArray2[i];
            }
            this.buildTreePath(stringArray[i], string, defaultMutableTreeNode);
        }
    }

    private void buildTreePath(String string, String string2, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.buildTreePath(string, string2, null, defaultMutableTreeNode);
    }

    private void buildTreePath(String string, String string2, String string3, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string4;
        String string5 = string;
        String string6 = "";
        String string7 = fileSeparator;
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n > -1 && n2 > n) {
            string6 = string.substring(n + 1, n2);
            string5 = string.substring(0, n);
        }
        if (string5.startsWith(string4 = Menus.getPlugInsPath())) {
            string5 = string5.substring(string4.length(), string5.length());
        }
        string5 = string5.replace('.', string7.charAt(0));
        if (string6.length() > 0) {
            string5 = string5.concat(fileSeparator).concat(string6);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string5, string7);
        int n3 = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            String string8 = stringTokenizer.nextToken();
            --n3;
            if (defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getAllowsChildren()) {
                if (string8.indexOf("ControlPanel") != -1) continue;
                if (n3 == 0) {
                    if (string2 != null) {
                        string8 = string2;
                    }
                    if ((string8 = string8.replace('_', ' ')).endsWith(".class")) {
                        string8 = string8.substring(0, string8.length() - 6);
                    }
                }
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string8);
                if (n3 == 0) {
                    String string9;
                    String string10 = string9 = string3 == null ? string8 : string3;
                    if (this.treeCommands == null) {
                        this.treeCommands = new Hashtable();
                    }
                    if (!this.treeCommands.containsKey(string8)) {
                        this.treeCommands.put(string8, string9);
                    }
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                defaultMutableTreeNode = defaultMutableTreeNode2;
                continue;
            }
            boolean bl = false;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!((String)defaultMutableTreeNode2.getUserObject()).equals(string8)) continue;
                bl = true;
                defaultMutableTreeNode = defaultMutableTreeNode2;
                break;
            }
            if (bl || string8.indexOf("ControlPanel") != -1) continue;
            if (n3 == 0) {
                if (string2 != null) {
                    string8 = string2;
                }
                if ((string8 = string8.replace('_', ' ')).endsWith(".class")) {
                    string8 = string8.substring(0, string8.length() - 6);
                }
            }
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string8);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
    }

    TreePanel newPanel(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = defaultMutableTreeNode.getUserObject().equals(this.root.getUserObject());
        TreePanel treePanel = new TreePanel(defaultMutableTreeNode, this, bl);
        return treePanel;
    }

    TreePanel newPanel(DefaultMutableTreeNode defaultMutableTreeNode, Point point) {
        boolean bl = defaultMutableTreeNode.getUserObject().equals(this.root.getUserObject());
        TreePanel treePanel = new TreePanel(defaultMutableTreeNode, this, bl, point);
        return treePanel;
    }

    TreePanel newPanel(String string) {
        if (string.equals("Control_Panel.@Main")) {
            string = "Control_Panel";
        }
        string = this.key2pStr(string);
        TreePanel treePanel = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            if (!treePath.toString().equals(string)) continue;
            treePanel = this.newPanel(defaultMutableTreeNode);
        }
        return treePanel;
    }

    boolean requiresDoubleClick() {
        return this.requireDoubleClick;
    }

    void setDoubleClick(boolean bl) {
        this.requireDoubleClick = bl;
    }

    boolean hasPanelForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        return this.panels.containsKey(this.pStr2Key(treePath.toString()));
    }

    TreePanel getPanelForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        String string = treePath.toString();
        if (this.panels.containsKey(this.pStr2Key(string))) {
            return (TreePanel)this.panels.get(this.pStr2Key(string));
        }
        return null;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    Hashtable getPanels() {
        return this.panels;
    }

    Hashtable getTreeCommands() {
        return this.treeCommands;
    }

    boolean hasVisiblePanels() {
        return this.visiblePanels.size() > 0;
    }

    int getVisiblePanelsCount() {
        return this.visiblePanels.size();
    }

    void registerPanel(TreePanel treePanel) {
        String string = this.pStr2Key(treePanel.getRootPath().toString());
        this.panels.put(string, treePanel);
        this.setPanelShowingProperty(treePanel.getRootPath().toString());
        this.propertiesChanged = true;
    }

    void loadProperties() {
        if (IJ.debugMode) {
            IJ.log("CP.loadProperties");
        }
        this.visiblePanels.removeAllElements();
        this.expandedNodes.removeAllElements();
        this.panels.clear();
        Properties properties = Prefs.getControlPanelProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(".Control_Panel.")) continue;
            string = string.substring(1, string.length());
            String string2 = Prefs.get(string, null);
            if (IJ.debugMode) {
                IJ.log("  " + string + ": " + string2);
            }
            if (Character.isDigit(string2.charAt(0))) {
                this.visiblePanels.addElement(string);
                continue;
            }
            if (!string2.equals("expand")) continue;
            this.expandedNodes.addElement(string);
        }
    }

    void saveProperties() {
        if (IJ.debugMode) {
            IJ.log("CP.saveProperties: " + this.propertiesChanged);
        }
        if (this.propertiesChanged) {
            this.clearProperties();
            Enumeration enumeration = this.visiblePanels.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                TreePanel treePanel = (TreePanel)this.panels.get(string);
                if (treePanel == null) continue;
                this.recordGeometry(treePanel);
            }
            enumeration = this.expandedNodes.elements();
            while (enumeration.hasMoreElements()) {
                Prefs.set((String)enumeration.nextElement(), "expand");
            }
        }
        this.propertiesChanged = false;
    }

    void clearProperties() {
        Properties properties = Prefs.getControlPanelProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(".Control_Panel.")) continue;
            properties.remove(string);
        }
    }

    void setExpandedStateProperty(String string) {
        String string2 = this.pStr2Key(string);
        this.expandedNodes.addElement(string2);
        this.propertiesChanged = true;
    }

    boolean hasExpandedStateProperty(String string) {
        String string2 = this.pStr2Key(string);
        return this.expandedNodes.contains(string2);
    }

    void unsetExpandedStateProperty(String string) {
        String string2 = this.pStr2Key(string);
        this.expandedNodes.remove(string2);
        this.propertiesChanged = true;
    }

    void setPanelShowingProperty(String string) {
        String string2 = this.pStr2Key(string);
        if (!this.visiblePanels.contains(string2)) {
            this.visiblePanels.addElement(string2);
        }
        this.propertiesChanged = true;
    }

    void unsetPanelShowingProperty(String string) {
        String string2 = this.pStr2Key(string);
        if (this.visiblePanels.remove(string2)) {
            // empty if block
        }
    }

    boolean hasPanelShowingProperty(String string) {
        String string2 = this.pStr2Key(string);
        return this.visiblePanels.contains(string2);
    }

    void restoreVisiblePanels() {
        Object[] objectArray = new String[this.visiblePanels.size()];
        this.visiblePanels.toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.panels.containsKey(objectArray[i])) continue;
            TreePanel treePanel = this.newPanel((String)objectArray[i]);
        }
    }

    void recordGeometry(TreePanel treePanel) {
        String string = treePanel.getRootPath().toString();
        string = this.pStr2Key(string);
        JFrame jFrame = treePanel.getFrame();
        if (jFrame != null) {
            Rectangle rectangle = jFrame.getBounds();
            String string2 = new Integer(rectangle.x).toString();
            String string3 = new Integer(rectangle.y).toString();
            String string4 = new Integer(rectangle.width).toString();
            String string5 = new Integer(rectangle.height).toString();
            if (string.equals("Control_Panel")) {
                string = "Control_Panel.@Main";
            }
            String string6 = string2 + " " + string3 + " " + string4 + " " + string5;
            if (IJ.debugMode) {
                IJ.log("CP.recordGeometry: " + string + " " + string6);
            }
            Prefs.set(string, string6);
        }
    }

    void restoreGeometry(TreePanel treePanel) {
        String string;
        String string2 = treePanel.getRootPath().toString();
        if ((string2 = this.pStr2Key(string2)).equals("Control_Panel")) {
            string2 = "Control_Panel.@Main";
        }
        if (IJ.debugMode) {
            IJ.log("CP.restoreGeometry: " + string2);
        }
        if ((string = Prefs.get(string2, null)) != null) {
            int[] nArray = this.s2ints(string);
            if (nArray != null && nArray.length == 4) {
                treePanel.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else {
                Point point = treePanel.getDefaultLocation();
                if (point != null) {
                    treePanel.getFrame().setLocation((int)point.getX(), (int)point.getY());
                }
            }
        }
    }

    void closeAll(boolean bl) {
        this.quitting = bl;
        if (!this.visiblePanels.isEmpty()) {
            this.propertiesChanged = true;
            this.saveProperties();
        }
        Enumeration enumeration = this.panels.elements();
        while (enumeration.hasMoreElements()) {
            TreePanel treePanel = (TreePanel)enumeration.nextElement();
            treePanel.close();
        }
        this.quitting = true;
    }

    void showHelp() {
        IJ.showMessage("About Control Panel...", "This plugin displays a panel with ImageJ commands in a hierarchical tree structure.\n \nUsage:\n \n     Click on a leaf node to launch the corresponding ImageJ command (or plugin)\n     (double-click on X Window Systems)\n \n     Double-click on a tree branch node (folder) to expand or collapse it\n \n     Click and drag on a tree branch node (folder) to display its descendants,\n     in a separate (child) panel (\"tear-off\" mock-up)\n \n     In a child panel, use the \"Show Parent\" menu item to re-open the parent panel\n     if it was accidentally closed\n \nAuthor: Cezar M. Tigaret (c.tigaret@ucl.ac.uk)\nThis code is in the public domain.");
    }

    String pStr2Key(String string) {
        String string2 = string;
        if (string2.startsWith("[")) {
            string2 = string2.substring(string2.indexOf("[") + 1, string2.length());
        }
        if (string2.endsWith("]")) {
            string2 = string2.substring(0, string2.lastIndexOf("]"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith(" ")) {
                string4 = string4.substring(1, string4.length());
            }
            string3 = string3 + string4 + ".";
        }
        string3 = string3.substring(0, string3.length() - 1);
        string3 = string3.replace(' ', '_');
        return string3;
    }

    String key2pStr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + string3 + ", ";
        }
        string2 = string2.substring(0, string2.length() - 2);
        string2 = "[" + string2 + "]";
        string2 = string2.replace('_', ' ');
        return string2;
    }

    public int[] s2ints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return nArray;
    }
}

