/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.FolderOpener;
import ij.plugin.PlugIn;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DragAndDrop
implements PlugIn,
DropTargetListener,
Runnable {
    private Iterator iterator;
    private static boolean convertToRGB;
    private static boolean virtualStack;
    private boolean openAsVirtualStack;

    @Override
    public void run(String string) {
        ImageJ imageJ = IJ.getInstance();
        imageJ.setDropTarget(null);
        new DropTarget(imageJ, this);
        new DropTarget(Toolbar.getInstance(), this);
        new DropTarget(imageJ.getStatusBar(), this);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        DataFlavor[] dataFlavorArray = null;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            this.iterator = null;
            dataFlavorArray = transferable.getTransferDataFlavors();
            if (IJ.debugMode) {
                IJ.log("DragAndDrop.drop: " + dataFlavorArray.length + " flavors");
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                String string;
                Object object;
                if (IJ.debugMode) {
                    IJ.log("  flavor[" + i + "]: " + dataFlavorArray[i].getMimeType());
                }
                if (dataFlavorArray[i].isFlavorJavaFileListType()) {
                    object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    this.iterator = ((List)object).iterator();
                    break;
                }
                if (!dataFlavorArray[i].isFlavorTextType() || !((object = transferable.getTransferData(dataFlavorArray[i])) instanceof String)) continue;
                String string2 = object.toString().trim();
                if (IJ.isLinux() && string2.length() > 1 && string2.charAt(1) == '\u0000') {
                    string2 = this.fixLinuxString(string2);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (string2.indexOf("href=\"") != -1 || string2.indexOf("src=\"") != -1) {
                    string2 = this.parseHTML(string2);
                    if (IJ.debugMode) {
                        IJ.log("  url: " + string2);
                    }
                    arrayList.add(string2);
                    this.iterator = arrayList.iterator();
                    break;
                }
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                while (null != (string = bufferedReader.readLine())) {
                    if ((string = URLDecoder.decode(string.replaceAll("\\+", "%2b"), "UTF-8")).startsWith("file://")) {
                        string = string.substring(7);
                    }
                    if (IJ.debugMode) {
                        IJ.log("  content: " + string);
                    }
                    if (string.startsWith("http://")) {
                        arrayList.add(string2);
                        continue;
                    }
                    arrayList.add(new File(string));
                }
                this.iterator = arrayList.iterator();
                break;
            }
            if (this.iterator != null) {
                Thread thread = new Thread((Runnable)this, "DrawAndDrop");
                thread.setPriority(Math.max(thread.getPriority() - 1, 1));
                thread.start();
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        dropTargetDropEvent.dropComplete(true);
        if (dataFlavorArray == null || dataFlavorArray.length == 0) {
            if (IJ.isMacOSX()) {
                IJ.error("First drag and drop ignored. Please try again. You can avoid this\nproblem by dragging to the toolbar instead of the status bar.");
            } else {
                IJ.error("Drag and drop failed");
            }
        }
    }

    private String fixLinuxString(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < string.length(); i += 2) {
            stringBuffer.append(string.charAt(i));
        }
        return new String(stringBuffer);
    }

    private String parseHTML(String string) {
        int n;
        int n2;
        if (IJ.debugMode) {
            IJ.log("parseHTML:\n" + string);
        }
        if ((n2 = string.indexOf("src=\"")) >= 0 && (n = string.indexOf("\"", n2 + 5)) > 0) {
            return string.substring(n2 + 5, n);
        }
        n2 = string.indexOf("href=\"");
        if (n2 >= 0 && (n = string.indexOf("\"", n2 + 6)) > 0) {
            return string.substring(n2 + 6, n);
        }
        return string;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        IJ.showStatus("<<Drag and Drop>>");
        if (IJ.debugMode) {
            IJ.log("DragEnter: " + dropTargetDragEvent.getLocation());
        }
        dropTargetDragEvent.acceptDrag(1);
        this.openAsVirtualStack = false;
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (IJ.debugMode) {
            IJ.log("DragOver: " + dropTargetDragEvent.getLocation());
        }
        Point point = dropTargetDragEvent.getLocation();
        int n = IJ.getInstance().getSize().width;
        int n2 = Toolbar.getButtonSize();
        boolean bl = this.openAsVirtualStack = n - point.x <= n2;
        if (this.openAsVirtualStack) {
            IJ.showStatus("<<Open as Virtual Stack>>");
        } else {
            IJ.showStatus("<<Drag and Drop>>");
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        IJ.showStatus("");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void run() {
        Iterator iterator = this.iterator;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != null && e instanceof String) {
                this.openURL((String)e);
                continue;
            }
            this.openFile((File)e);
        }
    }

    private void openURL(String string) {
        if (IJ.debugMode) {
            IJ.log("DragAndDrop.openURL: " + string);
        }
        if (string != null) {
            IJ.open(string);
        }
    }

    public void openFile(File file) {
        block10: {
            if (IJ.debugMode) {
                IJ.log("DragAndDrop.openFile: " + file);
            }
            try {
                if (null == file) {
                    return;
                }
                String string = file.getCanonicalPath();
                if (file.exists()) {
                    if (file.isDirectory()) {
                        this.openDirectory(file, string);
                    } else {
                        if (this.openAsVirtualStack && (string.endsWith(".tif") || string.endsWith(".TIF"))) {
                            new FileInfoVirtualStack().run(string);
                        } else {
                            new Opener().openAndAddToRecent(string);
                        }
                        OpenDialog.setLastDirectory(file.getParent() + File.separator);
                        OpenDialog.setLastName(file.getName());
                    }
                } else {
                    IJ.log("File not found: " + string);
                }
            }
            catch (Throwable throwable) {
                if ("Macro canceled".equals(throwable.getMessage())) break block10;
                IJ.handleException(throwable);
            }
        }
    }

    private void openDirectory(File file, String string) {
        if (string == null) {
            return;
        }
        if (!string.endsWith(File.separator) && !string.endsWith("/")) {
            string = string + File.separator;
        }
        String[] stringArray = file.list();
        if ((stringArray = new FolderOpener().trimFileList(stringArray)) == null) {
            return;
        }
        String string2 = "Open all " + stringArray.length + " images in \"" + file.getName() + "\" as a stack?";
        GenericDialog genericDialog = new GenericDialog("Open Folder");
        genericDialog.setInsets(10, 5, 0);
        genericDialog.addMessage(string2);
        genericDialog.setInsets(15, 35, 0);
        genericDialog.addCheckbox("Convert to RGB", convertToRGB);
        genericDialog.setInsets(0, 35, 0);
        genericDialog.addCheckbox("Use Virtual Stack", virtualStack);
        genericDialog.enableYesNoCancel();
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        if (genericDialog.wasOKed()) {
            convertToRGB = genericDialog.getNextBoolean();
            virtualStack = genericDialog.getNextBoolean();
            String string3 = " sort";
            if (convertToRGB) {
                string3 = string3 + " convert_to_rgb";
            }
            if (virtualStack) {
                string3 = string3 + " use";
            }
            IJ.run("Image Sequence...", "open=[" + string + "]" + string3);
            DirectoryChooser.setDefaultDirectory(string);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                IJ.redirectErrorMessages();
                if (stringArray[i].startsWith(".")) continue;
                new Opener().open(string + stringArray[i]);
            }
        }
        IJ.register(DragAndDrop.class);
    }
}

