/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.IJEventListener;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;

public class EventListener
implements PlugIn,
IJEventListener,
ImageListener,
CommandListener {
    @Override
    public void run(String string) {
        IJ.addEventListener(this);
        Executer.addCommandListener(this);
        ImagePlus.addImageListener(this);
        IJ.log("EventListener started");
    }

    @Override
    public void eventOccurred(int n) {
        switch (n) {
            case 0: {
                String string = Integer.toHexString(Toolbar.getForegroundColor().getRGB());
                string = "#" + string.substring(2);
                IJ.log("Changed foreground color to " + string);
                break;
            }
            case 1: {
                String string = Integer.toHexString(Toolbar.getBackgroundColor().getRGB());
                string = "#" + string.substring(2);
                IJ.log("Changed background color to " + string);
                break;
            }
            case 4: {
                String string = IJ.getToolName();
                IJ.log("Switched to the " + string + (string.endsWith("Tool") ? "" : " tool"));
                break;
            }
            case 2: {
                IJ.log("Color picker closed");
                break;
            }
            case 3: {
                IJ.removeEventListener(this);
                Executer.removeCommandListener(this);
                ImagePlus.removeImageListener(this);
                IJ.showStatus("Log window closed; EventListener stopped");
            }
        }
    }

    @Override
    public void imageOpened(ImagePlus imagePlus) {
        IJ.log("Opened \"" + imagePlus.getTitle() + "\"");
    }

    @Override
    public void imageClosed(ImagePlus imagePlus) {
        IJ.log("Closed \"" + imagePlus.getTitle() + "\"");
    }

    @Override
    public void imageUpdated(ImagePlus imagePlus) {
        IJ.log("Updated \"" + imagePlus.getTitle() + "\"");
    }

    @Override
    public String commandExecuting(String string) {
        IJ.log("Executed \"" + string + "\" command");
        return string;
    }
}

