/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class FITS_Reader
extends ImagePlus
implements PlugIn {
    @Override
    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open FITS...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        IJ.showStatus("Opening: " + string2 + string3);
        FitsDecoder fitsDecoder = new FitsDecoder(string2, string3);
        FileInfo fileInfo = null;
        try {
            fileInfo = fitsDecoder.getInfo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileInfo != null && fileInfo.width > 0 && fileInfo.height > 0 && fileInfo.offset > 0) {
            Object object;
            FileOpener fileOpener = new FileOpener(fileInfo);
            ImagePlus imagePlus = fileOpener.open(false);
            if (fileInfo.nImages == 1) {
                object = imagePlus.getProcessor();
                ((ImageProcessor)object).flipVertical();
                this.setProcessor(string3, (ImageProcessor)object);
            } else {
                object = imagePlus.getStack();
                for (int i = 1; i <= ((ImageStack)object).getSize(); ++i) {
                    ((ImageStack)object).getProcessor(i).flipVertical();
                }
                this.setStack(string3, (ImageStack)object);
            }
            object = imagePlus.getCalibration();
            if (fileInfo.fileType == 1 && fitsDecoder.bscale == 1.0 && fitsDecoder.bzero == 32768.0) {
                ((Calibration)object).setFunction(20, null, "Gray Value");
            }
            this.setCalibration((Calibration)object);
            this.setProperty("Info", fitsDecoder.getHeaderInfo());
            this.setFileInfo(fileInfo);
            if (string.equals("")) {
                this.show();
            }
        } else {
            IJ.error("This does not appear to be a FITS file.");
        }
        IJ.showStatus("");
    }
}

