/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

class FolderOpenerDialog
extends GenericDialog {
    ImagePlus imp;
    int fileCount;
    boolean eightBits;
    boolean rgb;
    String[] list;
    boolean isRegex;

    public FolderOpenerDialog(String string, ImagePlus imagePlus, String[] stringArray) {
        super(string);
        this.imp = imagePlus;
        this.list = stringArray;
        this.fileCount = stringArray.length;
    }

    @Override
    protected void setup() {
        this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
        this.rgb = ((Checkbox)this.checkbox.elementAt(1)).getState();
        this.setStackInfo();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.setStackInfo();
    }

    void setStackInfo() {
        int n;
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        int n4 = this.imp.getStackSize();
        int n5 = 1;
        int n6 = this.getNumber(this.numberField.elementAt(0));
        int n7 = this.getNumber(this.numberField.elementAt(1));
        int n8 = this.getNumber(this.numberField.elementAt(2));
        double d = this.getNumber(this.numberField.elementAt(3));
        if (d < 5.0) {
            d = 5.0;
        }
        if (d > 100.0) {
            d = 100.0;
        }
        if (n6 < 1) {
            n6 = this.fileCount;
        }
        if (n7 < 1 || n7 > this.fileCount) {
            n7 = 1;
        }
        if (n7 + n6 - 1 > this.fileCount) {
            n6 = this.fileCount - n7 + 1;
        }
        if (n8 < 1) {
            n8 = 1;
        }
        TextField textField = (TextField)this.stringField.elementAt(0);
        String string = textField.getText();
        textField = (TextField)this.stringField.elementAt(1);
        String string2 = textField.getText();
        if (!string2.equals("")) {
            string = string2;
            this.isRegex = true;
        }
        if (!string.equals("") && !string.equals("*")) {
            n = 0;
            for (int i = 0; i < this.list.length; ++i) {
                if (this.isRegex && this.list[i].matches(string)) {
                    ++n;
                    continue;
                }
                if (this.list[i].indexOf(string) < 0) continue;
                ++n;
            }
            if (n < n6) {
                n6 = n;
            }
        }
        switch (this.imp.getType()) {
            case 1: {
                n5 = 2;
                break;
            }
            case 2: 
            case 4: {
                n5 = 4;
            }
        }
        if (this.eightBits) {
            n5 = 1;
        }
        if (this.rgb) {
            n5 = 4;
        }
        n2 = (int)((double)n2 * d / 100.0);
        n3 = (int)((double)n3 * d / 100.0);
        n = (this.fileCount - n7 + 1) * n4 / n8;
        if (n < 0) {
            n = 0;
        }
        if (n > n6) {
            n = n6;
        }
        double d2 = (double)n2 * (double)n3 * (double)n * (double)n5 / 1048576.0;
        ((Label)this.theLabel).setText(n2 + " x " + n3 + " x " + n + " (" + IJ.d2s(d2, 1) + "MB)");
    }

    public int getNumber(Object object) {
        Double d;
        TextField textField = (TextField)object;
        String string = textField.getText();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return (int)d.doubleValue();
        }
        return 0;
    }
}

