/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.ZProjector;

public class GroupedZProjector
implements PlugIn {
    private static int method = 0;
    private int groupSize;

    @Override
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        int n = imagePlus.getStackSize();
        if (n == 1) {
            IJ.error("Z Project", "This command requires a stack");
            return;
        }
        if (imagePlus.isHyperStack()) {
            new ZProjector().run("");
            return;
        }
        if (!this.showDialog(imagePlus)) {
            return;
        }
        ImagePlus imagePlus2 = this.groupZProject(imagePlus, method, this.groupSize);
        if (imagePlus != null) {
            imagePlus2.show();
        }
    }

    public ImagePlus groupZProject(ImagePlus imagePlus, int n, int n2) {
        if (n < 0 || n >= ZProjector.METHODS.length) {
            return null;
        }
        imagePlus.setDimensions(1, n2, imagePlus.getStackSize() / n2);
        ZProjector zProjector = new ZProjector(imagePlus);
        zProjector.setMethod(n);
        zProjector.setStartSlice(1);
        zProjector.setStopSlice(n2);
        zProjector.doHyperStackProjection(true);
        return zProjector.getProjection();
    }

    boolean showDialog(ImagePlus imagePlus) {
        int n = imagePlus.getStackSize();
        GenericDialog genericDialog = new GenericDialog("Z Project");
        genericDialog.addChoice("Projection method", ZProjector.METHODS, ZProjector.METHODS[method]);
        genericDialog.addNumericField("Group size:", n, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        method = genericDialog.getNextChoiceIndex();
        this.groupSize = (int)genericDialog.getNextNumber();
        if (this.groupSize < 1 || this.groupSize > n || n % this.groupSize != 0) {
            IJ.error("ZProject", "Group size must divide evenly into the stack size.");
            return false;
        }
        return true;
    }
}

