/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.AWTEvent;
import java.awt.Label;

public class HyperStackReducer
implements PlugIn,
DialogListener {
    ImagePlus imp;
    int channels1;
    int slices1;
    int frames1;
    int channels2;
    int slices2;
    int frames2;
    double imageSize;
    static boolean keep = true;

    public HyperStackReducer() {
    }

    public HyperStackReducer(ImagePlus imagePlus) {
        this.imp = imagePlus;
    }

    @Override
    public void run(String string) {
        this.imp = IJ.getImage();
        if (!this.imp.isHyperStack()) {
            IJ.error("Reducer", "HyperStack required");
            return;
        }
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        this.imageSize = (double)(n * n2 * this.imp.getBytesPerPixel()) / 1048576.0;
        this.channels1 = this.channels2 = this.imp.getNChannels();
        this.slices1 = this.slices2 = this.imp.getNSlices();
        this.frames1 = this.frames2 = this.imp.getNFrames();
        if (!this.showDialog()) {
            return;
        }
        String string2 = keep ? WindowManager.getUniqueName(this.imp.getTitle()) : this.imp.getTitle();
        ImagePlus imagePlus = null;
        if (keep) {
            imagePlus = IJ.createImage(string2, this.imp.getBitDepth() + "-bit", n, n2, this.channels2 * this.slices2 * this.frames2);
            if (imagePlus == null) {
                return;
            }
            imagePlus.setDimensions(this.channels2, this.slices2, this.frames2);
            imagePlus.setCalibration(this.imp.getCalibration());
            imagePlus.setOpenAsHyperStack(true);
        } else {
            imagePlus = this.imp.createHyperStack(string2, this.channels2, this.slices2, this.frames2, this.imp.getBitDepth());
        }
        this.reduce(imagePlus);
        if (this.channels2 > 1 && this.channels2 == this.imp.getNChannels() && this.imp.isComposite()) {
            int n3 = ((CompositeImage)this.imp).getMode();
            imagePlus = new CompositeImage(imagePlus, n3);
            ((CompositeImage)imagePlus).copyLuts(this.imp);
        } else {
            imagePlus.setDisplayRange(this.imp.getDisplayRangeMin(), this.imp.getDisplayRangeMax());
            if (this.imp.isComposite() && ((CompositeImage)this.imp).getMode() == 3) {
                IJ.run(imagePlus, "Grays", "");
            }
        }
        if (this.imp.getWindow() == null && !keep) {
            this.imp.setImage(imagePlus);
            return;
        }
        imagePlus.show();
        if (!keep) {
            this.imp.changes = false;
            this.imp.close();
        }
    }

    public void reduce(ImagePlus imagePlus) {
        int n = imagePlus.getNChannels();
        int n2 = imagePlus.getNSlices();
        int n3 = imagePlus.getNFrames();
        int n4 = this.imp.getChannel();
        int n5 = this.imp.getSlice();
        int n6 = this.imp.getFrame();
        boolean bl = true;
        int n7 = n * n2 * n3;
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = imagePlus.getStack();
        for (int i = 1; i <= n; ++i) {
            if (n == 1) {
                i = n4;
            }
            LUT lUT = this.imp.isComposite() ? ((CompositeImage)this.imp).getChannelLut() : null;
            this.imp.setPositionWithoutUpdate(i, 1, 1);
            ImageProcessor imageProcessor = this.imp.getProcessor();
            double d = imageProcessor.getMin();
            double d2 = imageProcessor.getMax();
            for (int j = 1; j <= n2; ++j) {
                if (n2 == 1) {
                    j = n5;
                }
                for (int k = 1; k <= n3; ++k) {
                    if (n3 == 1) {
                        k = n6;
                    }
                    this.imp.setPositionWithoutUpdate(i, j, k);
                    imageProcessor = this.imp.getProcessor();
                    int n8 = this.imp.getStackIndex(i, j, k);
                    String string = imageStack.getSliceLabel(n8);
                    int n9 = imagePlus.getStackIndex(i, j, k);
                    if (imageStack2.getPixels(n9) != null) {
                        imageStack2.getProcessor(n9).insert(imageProcessor, 0, 0);
                    } else {
                        imageStack2.setPixels(imageProcessor.getPixels(), n9);
                    }
                    imageStack2.setSliceLabel(string, n9);
                }
            }
            if (lUT != null) {
                if (imagePlus.isComposite()) {
                    ((CompositeImage)imagePlus).setChannelLut(lUT);
                } else {
                    imagePlus.getProcessor().setColorModel(lUT);
                }
            }
            imagePlus.getProcessor().setMinAndMax(d, d2);
        }
        this.imp.setPosition(n4, n5, n6);
        imagePlus.resetStack();
        imagePlus.setPosition(1, 1, 1);
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Reduce");
        genericDialog.setInsets(10, 20, 5);
        genericDialog.addMessage("Create Image With:");
        genericDialog.setInsets(0, 35, 0);
        if (this.channels1 != 1) {
            genericDialog.addCheckbox("Channels (" + this.channels1 + ")", true);
        }
        genericDialog.setInsets(0, 35, 0);
        if (this.slices1 != 1) {
            genericDialog.addCheckbox("Slices (" + this.slices1 + ")", true);
        }
        genericDialog.setInsets(0, 35, 0);
        if (this.frames1 != 1) {
            genericDialog.addCheckbox("Frames (" + this.frames1 + ")", true);
        }
        genericDialog.setInsets(5, 20, 0);
        genericDialog.addMessage(this.getNewDimensions() + "      ");
        genericDialog.setInsets(15, 20, 0);
        genericDialog.addCheckbox("Keep Source", keep);
        genericDialog.addDialogListener(this);
        genericDialog.showDialog();
        return !genericDialog.wasCanceled();
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        if (this.channels1 != 1) {
            int n = this.channels2 = genericDialog.getNextBoolean() ? this.channels1 : 1;
        }
        if (this.slices1 != 1) {
            int n = this.slices2 = genericDialog.getNextBoolean() ? this.slices1 : 1;
        }
        if (this.frames1 != 1) {
            this.frames2 = genericDialog.getNextBoolean() ? this.frames1 : 1;
        }
        keep = genericDialog.getNextBoolean();
        ((Label)genericDialog.getMessage()).setText(this.getNewDimensions());
        return true;
    }

    String getNewDimensions() {
        String string = this.channels2 + "x" + this.slices2 + "x" + this.frames2;
        string = string + " (" + (int)Math.round(this.imageSize * (double)this.channels2 * (double)this.slices2 * (double)this.frames2) + "MB)";
        return string;
    }
}

