/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.ColorPanel;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LUT_Editor
implements PlugIn,
ActionListener {
    private ImagePlus imp;
    Button openButton;
    Button saveButton;
    Button resizeButton;
    Button invertButton;
    ColorPanel colorPanel;
    int bitDepth;

    @Override
    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.showMessage("LUT Editor", "No images are open");
            return;
        }
        this.bitDepth = imagePlus.getBitDepth();
        if (this.bitDepth == 24) {
            IJ.showMessage("LUT Editor", "RGB images do not use LUTs");
            return;
        }
        if (this.bitDepth != 8) {
            imagePlus.getProcessor().resetMinAndMax();
            imagePlus.updateAndDraw();
        }
        this.colorPanel = new ColorPanel(imagePlus);
        if (this.colorPanel.getMapSize() != 256) {
            IJ.showMessage("LUT Editor", "LUT must have 256 entries");
            return;
        }
        boolean bl = Recorder.record;
        Recorder.record = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        GenericDialog genericDialog = new GenericDialog("LUT Editor");
        Panel panel = new Panel(new GridLayout(4, 1, 0, 5));
        this.openButton = new Button("Open...");
        this.openButton.addActionListener(this);
        panel.add(this.openButton);
        this.saveButton = new Button("Save...");
        this.saveButton.addActionListener(this);
        panel.add(this.saveButton);
        this.resizeButton = new Button("Set...");
        this.resizeButton.addActionListener(this);
        panel.add(this.resizeButton);
        this.invertButton = new Button("Invert...");
        this.invertButton.addActionListener(this);
        panel.add(this.invertButton);
        Panel panel2 = new Panel();
        panel2.add(this.colorPanel);
        panel2.add(panel);
        genericDialog.addPanel(panel2, 10, new Insets(10, 0, 0, 0));
        genericDialog.showDialog();
        Recorder.record = bl;
        if (genericDialog.wasCanceled()) {
            this.colorPanel.cancelLUT();
            return;
        }
        this.colorPanel.applyLUT();
    }

    void save() {
        try {
            IJ.run("LUT...");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.openButton) {
            this.colorPanel.open();
        } else if (object == this.saveButton) {
            this.save();
        } else if (object == this.resizeButton) {
            this.colorPanel.resize();
        } else if (object == this.invertButton) {
            this.colorPanel.invert();
        }
    }
}

