/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class ListVirtualStack
extends VirtualStack
implements PlugIn {
    private static boolean virtual;
    private String[] list;
    private String[] labels;
    private int nImages;
    private int imageWidth;
    private int imageHeight;

    @Override
    public void run(String string) {
        Object object;
        OpenDialog openDialog = new OpenDialog("Open Image List", string);
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        String string3 = openDialog.getDirectory();
        this.list = this.open(string3 + string2);
        if (this.list == null) {
            return;
        }
        this.nImages = this.list.length;
        this.labels = new String[this.nImages];
        if (this.list.length == 0) {
            IJ.error("Stack From List", "The file path list is empty");
            return;
        }
        if (!this.list[0].startsWith("http://") && !((File)(object = new File(this.list[0]))).exists()) {
            IJ.error("Stack From List", "The first file on the list does not exist:\n \n" + this.list[0]);
            return;
        }
        object = IJ.openImage(this.list[0]);
        if (object == null) {
            return;
        }
        this.imageWidth = ((ImagePlus)object).getWidth();
        this.imageHeight = ((ImagePlus)object).getHeight();
        this.setBitDepth(((ImagePlus)object).getBitDepth());
        ImageStack imageStack = this;
        if (!this.showDialog((ImagePlus)object)) {
            return;
        }
        if (!virtual) {
            imageStack = this.convertToRealStack((ImagePlus)object);
        }
        ImagePlus imagePlus = new ImagePlus(string2, imageStack);
        imagePlus.setCalibration(((ImagePlus)object).getCalibration());
        imagePlus.show();
    }

    boolean showDialog(ImagePlus imagePlus) {
        double d = 1.0;
        switch (imagePlus.getType()) {
            case 1: {
                d = 2.0;
                break;
            }
            case 2: 
            case 4: {
                d = 4.0;
            }
        }
        double d2 = (double)(this.imageWidth * this.imageHeight) * d / 1048576.0;
        int n = d2 * (double)this.getSize() < 10.0 ? 1 : 0;
        String string = IJ.d2s(d2 * (double)this.getSize(), n) + " MB";
        String string2 = IJ.d2s(d2, 1) + " MB";
        GenericDialog genericDialog = new GenericDialog("Open Stack From List");
        genericDialog.addCheckbox("Use Virtual Stack", virtual);
        genericDialog.addMessage("This " + this.imageWidth + "x" + this.imageHeight + "x" + this.getSize() + " stack will require " + string + ",\n or " + string2 + " if opened as a virtual stack.");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        virtual = genericDialog.getNextBoolean();
        return true;
    }

    ImageStack convertToRealStack(ImagePlus imagePlus) {
        ImageStack imageStack = new ImageStack(this.imageWidth, this.imageHeight, imagePlus.getProcessor().getColorModel());
        int n = this.getSize();
        for (int i = 1; i <= this.getSize(); ++i) {
            IJ.showProgress(i, n);
            IJ.showStatus("Opening: " + i + "/" + n);
            ImageProcessor imageProcessor = this.getProcessor(i);
            if (imageProcessor == null) continue;
            imageStack.addSlice(this.getSliceLabel(i), imageProcessor);
        }
        return imageStack;
    }

    String[] open(String string) {
        if (string.startsWith("http://")) {
            return this.openUrl(string);
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        File file = new File(string);
        try {
            Object[] objectArray;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((objectArray = bufferedReader.readLine()) != null && !objectArray.equals("") && !objectArray.startsWith(" ")) {
                vector.addElement(objectArray);
            }
            bufferedReader.close();
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            IJ.error("Open List Error \n\"" + exception.getMessage() + "\"\n");
            return null;
        }
    }

    String[] openUrl(String string) {
        String string2 = IJ.openUrlAsString(string);
        if (string2.startsWith("<Error: ")) {
            IJ.error("Stack From List", string2);
            return null;
        }
        return Tools.split(string2, "\n");
    }

    @Override
    public void deleteSlice(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nImages < 1) {
            return;
        }
        for (int i = n; i < this.nImages; ++i) {
            this.list[i - 1] = this.list[i];
        }
        this.list[this.nImages - 1] = null;
        --this.nImages;
    }

    @Override
    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        IJ.redirectErrorMessages();
        String string = this.list[n - 1];
        ImagePlus imagePlus = null;
        if (string.length() > 0) {
            imagePlus = IJ.openImage(string);
        }
        if (imagePlus != null) {
            this.labels[n - 1] = new File(this.list[n - 1]).getName() + "\n" + (String)imagePlus.getProperty("Info");
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            int n2 = this.getBitDepth();
            if (imagePlus.getBitDepth() != n2) {
                switch (n2) {
                    case 8: {
                        imageProcessor = imageProcessor.convertToByte(true);
                        break;
                    }
                    case 16: {
                        imageProcessor = imageProcessor.convertToShort(true);
                        break;
                    }
                    case 24: {
                        imageProcessor = imageProcessor.convertToRGB();
                        break;
                    }
                    case 32: {
                        imageProcessor = imageProcessor.convertToFloat();
                    }
                }
            }
            if (imageProcessor.getWidth() != this.imageWidth || imageProcessor.getHeight() != this.imageHeight) {
                imageProcessor = imageProcessor.resize(this.imageWidth, this.imageHeight);
            }
            return imageProcessor;
        }
        ImageProcessor imageProcessor = null;
        switch (this.getBitDepth()) {
            case 8: {
                imageProcessor = new ByteProcessor(this.imageWidth, this.imageHeight);
                break;
            }
            case 16: {
                imageProcessor = new ShortProcessor(this.imageWidth, this.imageHeight);
                break;
            }
            case 24: {
                imageProcessor = new ColorProcessor(this.imageWidth, this.imageHeight);
                break;
            }
            case 32: {
                imageProcessor = new FloatProcessor(this.imageWidth, this.imageHeight);
            }
        }
        return imageProcessor;
    }

    @Override
    public int getSize() {
        return this.nImages;
    }

    @Override
    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.labels[n - 1] != null) {
            return this.labels[n - 1];
        }
        return new File(this.list[n - 1]).getName();
    }

    @Override
    public int getWidth() {
        return this.imageWidth;
    }

    @Override
    public int getHeight() {
        return this.imageHeight;
    }
}

