/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class Macro_Runner
implements PlugIn {
    @Override
    public void run(String string) {
        Thread thread = Thread.currentThread();
        String string2 = thread.getName();
        if (!string2.endsWith("Macro$")) {
            thread.setName(string2 + "Macro$");
        }
        String string3 = null;
        if (string.equals("")) {
            OpenDialog openDialog = new OpenDialog("Run Macro...", string3);
            String string4 = openDialog.getDirectory();
            string = openDialog.getFileName();
            if (string != null) {
                string3 = string4 + string;
                this.runMacroFile(string3, null);
                if (Recorder.record) {
                    if (Recorder.scriptMode()) {
                        Recorder.recordCall("IJ.runMacroFile(\"" + string3 + "\");");
                    } else {
                        Recorder.record("runMacro", string3);
                    }
                }
            }
        } else if (string.startsWith("JAR:")) {
            Macro_Runner.runMacroFromJar(string.substring(4), null);
        } else if (string.startsWith("ij.jar:")) {
            this.runMacroFromIJJar(string, null);
        } else {
            string3 = Menus.getPlugInsPath() + string;
            this.runMacroFile(string3, null);
        }
    }

    public String runMacroFile(String string, String string2) {
        Object object;
        int n;
        Object object2;
        boolean bl;
        if (string.startsWith("ij.jar:")) {
            return this.runMacroFromIJJar(string, string2);
        }
        if (string.indexOf(".") == -1) {
            string = string + ".txt";
        }
        Object object3 = string;
        boolean bl2 = bl = string.startsWith("/") || string.startsWith("\\") || string.indexOf(":\\") == 1;
        if (!bl && (object2 = Menus.getMacrosPath()) != null) {
            object3 = Menus.getMacrosPath() + string;
        }
        if ((n = (int)((File)(object2 = new File((String)object3))).length()) <= 0 && !bl && ((String)object3).endsWith(".txt") && (n = (int)((File)(object2 = new File((String)(object = (Object)(((String)object3).substring(0, ((String)object3).length() - 4) + ".ijm"))))).length()) > 0) {
            object3 = object;
        }
        if (n <= 0 && !bl) {
            object2 = new File(System.getProperty("user.dir") + File.separator + string);
            n = (int)((File)object2).length();
        }
        if (n <= 0) {
            IJ.error("RunMacro", "Macro or script not found:\n \n" + (String)object3);
            return null;
        }
        try {
            object = new byte[n];
            FileInputStream fileInputStream = new FileInputStream((File)object2);
            fileInputStream.read((byte[])object, 0, n);
            String string3 = new String((byte[])object, 0, n, "ISO8859_1");
            fileInputStream.close();
            if (string.endsWith(".js")) {
                return this.runJavaScript(string3, string2);
            }
            return this.runMacro(string3, string2);
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return null;
        }
    }

    public String runMacro(String string, String string2) {
        Interpreter interpreter = new Interpreter();
        try {
            return interpreter.run(string, string2);
        }
        catch (Throwable throwable) {
            interpreter.abortMacro();
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.unlock();
            }
            String string3 = throwable.getMessage();
            if (throwable instanceof RuntimeException && string3 != null && throwable.getMessage().equals("Macro canceled")) {
                return "[aborted]";
            }
            IJ.handleException(throwable);
            return "[aborted]";
        }
    }

    public static String runMacroFromJar(String string, String string2) {
        String string3 = null;
        try {
            int n;
            ClassLoader classLoader = IJ.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                IJ.error("Macro Runner", "Unable to load \"" + string + "\" from jar file");
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string3 = stringBuffer.toString();
            inputStream.close();
        }
        catch (IOException iOException) {
            IJ.error("Macro Runner", "" + iOException);
        }
        if (string3 != null) {
            return new Macro_Runner().runMacro(string3, string2);
        }
        return null;
    }

    public String runMacroFromIJJar(String string, String string2) {
        ImageJ imageJ = IJ.getInstance();
        Class<?> clazz = imageJ != null ? imageJ.getClass() : new ImageStack().getClass();
        string = string.substring(7);
        String string3 = null;
        try {
            int n;
            InputStream inputStream = clazz.getResourceAsStream("/macros/" + string + ".txt");
            if (inputStream == null) {
                return this.runMacroFile(string, string2);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string3 = stringBuffer.toString();
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            if (string4 == null || string4.equals("")) {
                string4 = "" + iOException;
            }
            IJ.showMessage("Macro Runner", string4);
        }
        if (string3 != null) {
            return this.runMacro(string3, string2);
        }
        return null;
    }

    public String runJavaScript(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Object object = null;
        object = IJ.isJava16() && (!IJ.isMacOSX() || IJ.is64Bit()) ? IJ.runPlugIn("JavaScriptEvaluator", "") : IJ.runPlugIn("JavaScript", "");
        if (object == null) {
            IJ.error(Editor.JS_NOT_FOUND);
        }
        string = Editor.getJSPrefix(string2) + string;
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod("run", string.getClass(), string2.getClass());
            String string3 = (String)method.invoke(object, string, string2);
        }
        catch (Exception exception) {
            String string4 = "" + exception;
            if (string4.indexOf("NoSuchMethod") != 0) {
                string4 = "\"JavaScript.jar\" (http://imagej.nih.gov/ij/download/tools/JavaScript.jar)\nis outdated";
            }
            IJ.error(string4);
            return null;
        }
        return null;
    }
}

