/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PNM_Writer
implements PlugIn {
    @Override
    public void run(String string) {
        Object object;
        ImagePlus imagePlus = IJ.getImage();
        boolean bl = false;
        String string2 = null;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imagePlus.getBitDepth() == 24) {
            string2 = ".pnm";
        } else {
            if (imagePlus.getBitDepth() == 8 && imageProcessor.isInvertedLut()) {
                imageProcessor = imageProcessor.duplicate();
                imageProcessor.invert();
            }
            imageProcessor = imageProcessor.convertToByte(true);
            bl = true;
            string2 = ".pgm";
        }
        String string3 = imagePlus.getTitle();
        int n = string3.length();
        for (int i = 2; i < 5; ++i) {
            if (n <= i + 1 || string3.charAt(n - i) != '.') continue;
            string3 = string3.substring(0, n - i);
            break;
        }
        if (string == null || string.equals("")) {
            SaveDialog saveDialog = new SaveDialog("PNM Writer", string3, string2);
            object = saveDialog.getDirectory();
            String string4 = saveDialog.getFileName();
            if (string4 == null) {
                return;
            }
            string = (String)object + string4;
        }
        try {
            IJ.showStatus("Writing PNM " + string + "...");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            object = new DataOutputStream(fileOutputStream);
            int n2 = imagePlus.getWidth();
            int n3 = imagePlus.getHeight();
            ((DataOutputStream)object).writeBytes((bl ? "P5" : "P6") + "\n# Written by ImageJ PNM Writer\n" + n2 + " " + n3 + "\n255\n");
            if (bl) {
                ((DataOutputStream)object).write((byte[])imageProcessor.getPixels(), 0, n2 * n3);
            } else {
                byte[] byArray = new byte[n2 * n3 * 3];
                ColorProcessor colorProcessor = (ColorProcessor)imageProcessor;
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n4 = colorProcessor.getPixel(j, i);
                        byArray[3 * (j + n2 * i) + 0] = (byte)((n4 & 0xFF0000) >> 16);
                        byArray[3 * (j + n2 * i) + 1] = (byte)((n4 & 0xFF00) >> 8);
                        byArray[3 * (j + n2 * i) + 2] = (byte)(n4 & 0xFF);
                    }
                }
                ((DataOutputStream)object).write(byArray, 0, byArray.length);
            }
            ((DataOutputStream)object).flush();
        }
        catch (IOException iOException) {
            IJ.handleException(iOException);
        }
        IJ.showStatus("");
    }
}

