/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;

public class RGBStackConverter
implements PlugIn,
DialogListener {
    private int channels1;
    private int slices1;
    private int frames1;
    private int slices2;
    private int frames2;
    private int width;
    private int height;
    private double imageSize;
    private static boolean staticKeep = true;
    private boolean keep;

    @Override
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (!IJ.isMacro()) {
            this.keep = staticKeep;
        }
        CompositeImage compositeImage = imagePlus.isComposite() ? (CompositeImage)imagePlus : null;
        int n = imagePlus.getStackSize();
        if ((n < 2 || n > 3) && compositeImage == null) {
            IJ.error("A 2 or 3 image stack, or a HyperStack, required");
            return;
        }
        int n2 = imagePlus.getType();
        if (compositeImage == null && n2 != 0 && n2 != 1) {
            IJ.error("8-bit or 16-bit grayscale stack required");
            return;
        }
        if (!imagePlus.lock()) {
            return;
        }
        Undo.reset();
        String string2 = imagePlus.getTitle() + " (RGB)";
        if (compositeImage != null) {
            this.compositeToRGB(compositeImage, string2);
        } else if (n2 == 1) {
            this.sixteenBitsToRGB(imagePlus);
        } else {
            ImagePlus imagePlus2 = imagePlus.createImagePlus();
            imagePlus2.setStack(string2, imagePlus.getStack());
            ImageConverter imageConverter = new ImageConverter(imagePlus2);
            imageConverter.convertRGBStackToRGB();
            imagePlus2.show();
        }
        imagePlus.unlock();
    }

    void compositeToRGB(CompositeImage compositeImage, String string) {
        int n;
        int n2;
        int n3;
        int n4 = compositeImage.getNChannels();
        if (n4 == (n3 = n4 * (n2 = compositeImage.getNSlices()) * (n = compositeImage.getNFrames()))) {
            this.compositeImageToRGB(compositeImage, string);
            return;
        }
        this.width = compositeImage.getWidth();
        this.height = compositeImage.getHeight();
        this.imageSize = (double)(this.width * this.height) * 4.0 / 1048576.0;
        this.channels1 = compositeImage.getNChannels();
        this.slices1 = this.slices2 = compositeImage.getNSlices();
        this.frames1 = this.frames2 = compositeImage.getNFrames();
        int n5 = compositeImage.getChannel();
        int n6 = compositeImage.getSlice();
        int n7 = compositeImage.getFrame();
        if (!this.showDialog()) {
            return;
        }
        String string2 = this.keep ? WindowManager.getUniqueName(compositeImage.getTitle()) : compositeImage.getTitle();
        ImagePlus imagePlus = compositeImage.createHyperStack(string2, 1, this.slices2, this.frames2, 24);
        this.convertHyperstack(compositeImage, imagePlus);
        if (compositeImage.getWindow() == null && !this.keep) {
            compositeImage.setImage(imagePlus);
            return;
        }
        imagePlus.setOpenAsHyperStack(this.slices2 > 1 || this.frames2 > 1);
        imagePlus.show();
        if (!this.keep) {
            compositeImage.changes = false;
            compositeImage.close();
        }
    }

    public void convertHyperstack(ImagePlus imagePlus, ImagePlus imagePlus2) {
        int n = imagePlus2.getNSlices();
        int n2 = imagePlus2.getNFrames();
        int n3 = imagePlus.getChannel();
        int n4 = imagePlus.getSlice();
        int n5 = imagePlus.getFrame();
        boolean bl = true;
        int n6 = 1;
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        imagePlus.setPositionWithoutUpdate(n6, 1, 1);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        for (int i = 1; i <= n; ++i) {
            if (n == 1) {
                i = n4;
            }
            for (int j = 1; j <= n2; ++j) {
                if (n2 == 1) {
                    j = n5;
                }
                imagePlus.setPositionWithoutUpdate(n6, i, j);
                Image image = imagePlus.getImage();
                int n7 = imagePlus2.getStackIndex(n6, i, j);
                imageStack2.setPixels(new ColorProcessor(image).getPixels(), n7);
            }
        }
        imagePlus.setPosition(n3, n4, n5);
        imagePlus2.resetStack();
        imagePlus2.setPosition(1, 1, 1);
    }

    void compositeImageToRGB(CompositeImage compositeImage, String string) {
        if (compositeImage.getMode() == 1) {
            ImagePlus imagePlus = compositeImage.createImagePlus();
            compositeImage.updateImage();
            imagePlus.setProcessor(string, new ColorProcessor(compositeImage.getImage()));
            imagePlus.show();
            return;
        }
        ImageStack imageStack = new ImageStack(compositeImage.getWidth(), compositeImage.getHeight());
        int n = compositeImage.getChannel();
        int n2 = compositeImage.getNChannels();
        for (int i = 1; i <= n2; ++i) {
            compositeImage.setPositionWithoutUpdate(i, 1, 1);
            imageStack.addSlice(null, new ColorProcessor(compositeImage.getImage()));
        }
        compositeImage.setPosition(n, 1, 1);
        ImagePlus imagePlus = compositeImage.createImagePlus();
        imagePlus.setStack(string, imageStack);
        Object object = compositeImage.getProperty("Info");
        if (object != null) {
            imagePlus.setProperty("Info", object);
        }
        imagePlus.show();
    }

    void sixteenBitsToRGB(ImagePlus imagePlus) {
        Object object;
        Rectangle rectangle;
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            rectangle = roi.getBounds();
            int n = rectangle.width;
            int n2 = rectangle.height;
        } else {
            rectangle = new Rectangle(0, 0, imagePlus.getWidth(), imagePlus.getHeight());
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(rectangle.width, rectangle.height);
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            imageProcessor.setRoi(rectangle);
            object = imageProcessor.crop();
            object = ((ImageProcessor)object).convertToByte(true);
            imageStack2.addSlice(null, (ImageProcessor)object);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack(imagePlus.getTitle() + " (RGB)", imageStack2);
        object = new ImageConverter(imagePlus2);
        ((ImageConverter)object).convertRGBStackToRGB();
        imagePlus2.show();
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Convert to RGB");
        genericDialog.setInsets(10, 20, 5);
        genericDialog.addMessage("Create RGB Image With:");
        genericDialog.setInsets(0, 35, 0);
        if (this.slices1 != 1) {
            genericDialog.addCheckbox("Slices (" + this.slices1 + ")", true);
        }
        genericDialog.setInsets(0, 35, 0);
        if (this.frames1 != 1) {
            genericDialog.addCheckbox("Frames (" + this.frames1 + ")", true);
        }
        genericDialog.setInsets(5, 20, 0);
        genericDialog.addMessage(this.getNewDimensions() + "      ");
        genericDialog.setInsets(15, 20, 0);
        genericDialog.addCheckbox("Keep Source", this.keep);
        genericDialog.addDialogListener(this);
        genericDialog.showDialog();
        return !genericDialog.wasCanceled();
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        if (this.slices1 != 1) {
            int n = this.slices2 = genericDialog.getNextBoolean() ? this.slices1 : 1;
        }
        if (this.frames1 != 1) {
            this.frames2 = genericDialog.getNextBoolean() ? this.frames1 : 1;
        }
        this.keep = genericDialog.getNextBoolean();
        if (!IJ.isMacro()) {
            staticKeep = this.keep;
        }
        ((Label)genericDialog.getMessage()).setText(this.getNewDimensions());
        return true;
    }

    String getNewDimensions() {
        String string = this.slices2 > 1 ? "x" + this.slices2 : "";
        String string2 = this.frames2 > 1 ? "x" + this.frames2 : "";
        String string3 = this.width + "x" + this.height + string + string2;
        string3 = string3 + " (" + (int)Math.round(this.imageSize * (double)this.slices2 * (double)this.frames2) + "MB)";
        return string3;
    }
}

