/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class ScaleBar
implements PlugIn {
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static final String[] colors = new String[]{"White", "Black", "Light Gray", "Gray", "Dark Gray", "Red", "Green", "Blue", "Yellow"};
    static final String[] bcolors = new String[]{"None", "Black", "White", "Dark Gray", "Gray", "Light Gray", "Yellow", "Blue", "Green", "Red"};
    static final String[] checkboxLabels = new String[]{"Bold Text", "Hide Text", "Serif Font", "Overlay"};
    static double barWidth;
    static int defaultBarHeight;
    static int barHeightInPixels;
    static String location;
    static String color;
    static String bcolor;
    static boolean boldText;
    static boolean hideText;
    static boolean createOverlay;
    static int defaultFontSize;
    static int fontSize;
    static boolean labelAll;
    ImagePlus imp;
    double imageWidth;
    double mag;
    int xloc;
    int yloc;
    int barWidthInPixels;
    int roiX = -1;
    int roiY;
    int roiWidth;
    int roiHeight;
    boolean serifFont;
    boolean[] checkboxStates = new boolean[4];
    boolean showingOverlay;
    boolean drawnScaleBar;
    Overlay baseOverlay;

    @Override
    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp != null) {
            this.baseOverlay = this.imp.getOverlay();
            if (this.showDialog(this.imp) && this.imp.getStackSize() > 1 && labelAll) {
                this.labelSlices(this.imp);
            }
        } else {
            IJ.noImage();
        }
    }

    void labelSlices(ImagePlus imagePlus) {
        if (createOverlay) {
            return;
        }
        ImageStack imageStack = imagePlus.getStack();
        String string = this.getUnits(imagePlus);
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            this.drawScaleBar(imageStack.getProcessor(i), string);
        }
        imagePlus.setStack(imageStack);
    }

    boolean showDialog(ImagePlus imagePlus) {
        int n;
        double d;
        String string;
        Cloneable cloneable;
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            cloneable = roi.getBounds();
            this.roiX = ((Rectangle)cloneable).x;
            this.roiY = ((Rectangle)cloneable).y;
            this.roiWidth = ((Rectangle)cloneable).width;
            this.roiHeight = ((Rectangle)cloneable).height;
            location = locations[4];
        } else if (location.equals(locations[4])) {
            location = locations[0];
        }
        cloneable = imagePlus.getCalibration();
        ImageWindow imageWindow = imagePlus.getWindow();
        double d2 = this.mag = imageWindow != null ? imageWindow.getCanvas().getMagnification() : 1.0;
        if (this.mag > 1.0) {
            this.mag = 1.0;
        }
        if ((double)fontSize < (double)defaultFontSize / this.mag) {
            fontSize = (int)((double)defaultFontSize / this.mag);
        }
        if ((string = ((Calibration)cloneable).getUnits()).equals("micron")) {
            string = "\u00b5m";
        }
        if ((d = ((Calibration)cloneable).pixelWidth) == 0.0) {
            d = 1.0;
        }
        double d3 = 1.0 / d;
        this.imageWidth = (double)imagePlus.getWidth() * d;
        if (this.roiX > 0 && this.roiWidth > 10) {
            barWidth = (double)this.roiWidth * d;
        } else if (barWidth == 0.0 || barWidth > 0.67 * this.imageWidth) {
            barWidth = 80.0 * d / this.mag;
            if (barWidth > 0.67 * this.imageWidth) {
                barWidth = 0.67 * this.imageWidth;
            }
            if (barWidth > 5.0) {
                barWidth = (int)barWidth;
            }
        }
        int n2 = imagePlus.getStackSize();
        int n3 = n = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            n = 2;
        }
        int n4 = (int)(barWidth * 100.0 / this.imageWidth);
        if (this.mag < 1.0 && (double)barHeightInPixels < (double)defaultBarHeight / this.mag) {
            barHeightInPixels = (int)((double)defaultBarHeight / this.mag);
        }
        imagePlus.getProcessor().snapshot();
        if (IJ.macroRunning()) {
            createOverlay = false;
            this.serifFont = false;
            hideText = false;
            boldText = false;
        } else {
            this.updateScalebar();
        }
        BarDialog barDialog = new BarDialog("ScaleBar Plus");
        barDialog.addNumericField("Width in " + string + ": ", barWidth, n);
        barDialog.addNumericField("Height in pixels: ", barHeightInPixels, 0);
        barDialog.addNumericField("Font size: ", fontSize, 0);
        barDialog.addChoice("Color: ", colors, color);
        barDialog.addChoice("Background: ", bcolors, bcolor);
        barDialog.addChoice("Location: ", locations, location);
        this.checkboxStates[0] = boldText;
        this.checkboxStates[1] = hideText;
        this.checkboxStates[2] = this.serifFont;
        this.checkboxStates[3] = createOverlay;
        barDialog.setInsets(10, 25, 0);
        barDialog.addCheckboxGroup(2, 2, checkboxLabels, this.checkboxStates);
        if (n2 > 1) {
            barDialog.setInsets(0, 25, 0);
            barDialog.addCheckbox("Label all slices", labelAll);
        }
        barDialog.showDialog();
        if (barDialog.wasCanceled()) {
            imagePlus.getProcessor().reset();
            imagePlus.updateAndDraw();
            if (this.showingOverlay) {
                imagePlus.setOverlay(null);
            }
            return false;
        }
        barWidth = barDialog.getNextNumber();
        barHeightInPixels = (int)barDialog.getNextNumber();
        fontSize = (int)barDialog.getNextNumber();
        color = barDialog.getNextChoice();
        bcolor = barDialog.getNextChoice();
        location = barDialog.getNextChoice();
        boldText = barDialog.getNextBoolean();
        hideText = barDialog.getNextBoolean();
        this.serifFont = barDialog.getNextBoolean();
        createOverlay = barDialog.getNextBoolean();
        if (n2 > 1) {
            labelAll = barDialog.getNextBoolean();
        }
        if (IJ.macroRunning()) {
            this.updateScalebar();
        }
        return true;
    }

    void drawScaleBar(ImagePlus imagePlus) {
        if (!this.updateLocation()) {
            return;
        }
        Undo.setup(1, imagePlus);
        this.drawScaleBar(imagePlus.getProcessor(), this.getUnits(imagePlus));
        imagePlus.updateAndDraw();
    }

    String getUnits(ImagePlus imagePlus) {
        String string = imagePlus.getCalibration().getUnits();
        if (string.equals("microns")) {
            string = "\u00b5m";
        }
        return string;
    }

    void createOverlay(ImagePlus imagePlus) {
        Overlay overlay = this.baseOverlay;
        overlay = overlay != null ? overlay.duplicate() : new Overlay();
        Color color = this.getColor();
        Color color2 = this.getBColor();
        int n = this.xloc;
        int n2 = this.yloc;
        int n3 = boldText ? 1 : 0;
        String string = this.serifFont ? "Serif" : "SanSerif";
        Font font = new Font(string, n3, fontSize);
        String string2 = this.getLength(barWidth) + " " + this.getUnits(imagePlus);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.setFont(font);
        int n4 = hideText ? 0 : imageProcessor.getStringWidth(string2);
        int n5 = (this.barWidthInPixels - n4) / 2;
        int n6 = barHeightInPixels + (hideText ? 0 : fontSize + fontSize / 4);
        if (color2 != null) {
            int n7;
            int n8;
            int n9 = this.barWidthInPixels;
            int n10 = n6;
            if (n9 < n4) {
                n9 = n4;
            }
            if (n + n5 < (n8 = n)) {
                n8 = n + n5;
            }
            if ((n7 = n9 / 20) < 2) {
                n7 = 2;
            }
            int n11 = n2 - n7;
            Roi roi = new Roi(n8 -= n7, n11, n9 += n7 * 2, n10 += n7 * 2);
            roi.setFillColor(color2);
            overlay.add(roi);
        }
        Roi roi = new Roi(n, n2, this.barWidthInPixels, barHeightInPixels);
        roi.setFillColor(color);
        overlay.add(roi);
        if (!hideText) {
            TextRoi textRoi = new TextRoi(n + n5, n2 + barHeightInPixels, string2, font);
            textRoi.setStrokeColor(color);
            overlay.add(textRoi);
        }
        imagePlus.setOverlay(overlay);
        this.showingOverlay = true;
    }

    void drawScaleBar(ImageProcessor imageProcessor, String string) {
        Color color = this.getColor();
        Color color2 = this.getBColor();
        int n = this.xloc;
        int n2 = this.yloc;
        int n3 = boldText ? 1 : 0;
        String string2 = this.serifFont ? "Serif" : "SanSerif";
        imageProcessor.setFont(new Font(string2, n3, fontSize));
        imageProcessor.setAntialiasedText(true);
        String string3 = this.getLength(barWidth) + " " + string;
        int n4 = hideText ? 0 : imageProcessor.getStringWidth(string3);
        int n5 = (this.barWidthInPixels - n4) / 2;
        int n6 = barHeightInPixels + (hideText ? 0 : fontSize + fontSize / (this.serifFont ? 8 : 4));
        if (color2 != null) {
            int n7;
            int n8;
            int n9 = this.barWidthInPixels;
            int n10 = n6;
            if (n9 < n4) {
                n9 = n4;
            }
            if (n + n5 < (n8 = n)) {
                n8 = n + n5;
            }
            if ((n7 = n9 / 20) < 2) {
                n7 = 2;
            }
            int n11 = n2 - n7;
            imageProcessor.setColor(color2);
            imageProcessor.setRoi(n8 -= n7, n11, n9 += n7 * 2, n10 += n7 * 2);
            imageProcessor.fill();
        }
        imageProcessor.resetRoi();
        imageProcessor.setColor(color);
        imageProcessor.setRoi(n, n2, this.barWidthInPixels, barHeightInPixels);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        if (!hideText) {
            imageProcessor.drawString(string3, n + n5, n2 + n6);
        }
        this.drawnScaleBar = true;
    }

    String getLength(double d) {
        String string;
        int n;
        int n2 = n = (double)((int)d) == d ? 0 : 1;
        if (d < 1.0) {
            n = 1;
        }
        if (n == 1 && !(string = IJ.d2s(d / 0.1, 2)).endsWith(".00")) {
            n = 2;
        }
        return IJ.d2s(d, n);
    }

    boolean updateLocation() {
        Calibration calibration = this.imp.getCalibration();
        this.barWidthInPixels = (int)(barWidth / calibration.pixelWidth);
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        int n3 = 20;
        int n4 = n - n / n3 - this.barWidthInPixels;
        int n5 = 0;
        if (location.equals(locations[0])) {
            n5 = n2 / n3;
        } else if (location.equals(locations[1])) {
            n5 = n2 - n2 / n3 - barHeightInPixels - fontSize;
        } else if (location.equals(locations[3])) {
            n4 = n / n3;
            n5 = n2 / n3;
        } else if (location.equals(locations[2])) {
            n4 = n / n3;
            n5 = n2 - n2 / n3 - barHeightInPixels - fontSize;
        } else {
            if (this.roiX == -1) {
                return false;
            }
            n4 = this.roiX;
            n5 = this.roiY;
        }
        this.xloc = n4;
        this.yloc = n5;
        return true;
    }

    Color getColor() {
        Color color = Color.black;
        if (ScaleBar.color.equals(colors[0])) {
            color = Color.white;
        } else if (ScaleBar.color.equals(colors[2])) {
            color = Color.lightGray;
        } else if (ScaleBar.color.equals(colors[3])) {
            color = Color.gray;
        } else if (ScaleBar.color.equals(colors[4])) {
            color = Color.darkGray;
        } else if (ScaleBar.color.equals(colors[5])) {
            color = Color.red;
        } else if (ScaleBar.color.equals(colors[6])) {
            color = Color.green;
        } else if (ScaleBar.color.equals(colors[7])) {
            color = Color.blue;
        } else if (ScaleBar.color.equals(colors[8])) {
            color = Color.yellow;
        }
        return color;
    }

    Color getBColor() {
        if (bcolor == null || bcolor.equals(bcolors[0])) {
            return null;
        }
        Color color = Color.white;
        if (bcolor.equals(bcolors[1])) {
            color = Color.black;
        } else if (bcolor.equals(bcolors[3])) {
            color = Color.darkGray;
        } else if (bcolor.equals(bcolors[4])) {
            color = Color.gray;
        } else if (bcolor.equals(bcolors[5])) {
            color = Color.lightGray;
        } else if (bcolor.equals(bcolors[6])) {
            color = Color.yellow;
        } else if (bcolor.equals(bcolors[7])) {
            color = Color.blue;
        } else if (bcolor.equals(bcolors[8])) {
            color = Color.green;
        } else if (bcolor.equals(bcolors[9])) {
            color = Color.red;
        }
        return color;
    }

    void updateScalebar() {
        this.updateLocation();
        this.imp.getProcessor().reset();
        if (createOverlay) {
            if (this.drawnScaleBar) {
                this.imp.updateAndDraw();
                this.drawnScaleBar = false;
            }
            this.createOverlay(this.imp);
        } else {
            if (this.showingOverlay) {
                this.imp.setOverlay(null);
                this.showingOverlay = false;
            }
            this.drawScaleBar(this.imp);
        }
    }

    static {
        barHeightInPixels = defaultBarHeight = 4;
        location = locations[1];
        color = colors[0];
        bcolor = bcolors[0];
        boldText = true;
        defaultFontSize = 14;
    }

    class BarDialog
    extends GenericDialog {
        BarDialog(String string) {
            super(string);
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            TextField textField = (TextField)this.numberField.elementAt(0);
            Double d = this.getValue(textField.getText());
            if (d == null) {
                return;
            }
            barWidth = d;
            TextField textField2 = (TextField)this.numberField.elementAt(1);
            d = this.getValue(textField2.getText());
            if (d == null) {
                return;
            }
            barHeightInPixels = (int)d.doubleValue();
            TextField textField3 = (TextField)this.numberField.elementAt(2);
            d = this.getValue(textField3.getText());
            if (d == null) {
                return;
            }
            int n = (int)d.doubleValue();
            if (n > 5) {
                fontSize = n;
            }
            ScaleBar.this.updateScalebar();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Choice choice = (Choice)this.choice.elementAt(0);
            color = choice.getSelectedItem();
            Choice choice2 = (Choice)this.choice.elementAt(1);
            bcolor = choice2.getSelectedItem();
            Choice choice3 = (Choice)this.choice.elementAt(2);
            location = choice3.getSelectedItem();
            boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            hideText = ((Checkbox)this.checkbox.elementAt(1)).getState();
            ScaleBar.this.serifFont = ((Checkbox)this.checkbox.elementAt(2)).getState();
            createOverlay = ((Checkbox)this.checkbox.elementAt(3)).getState();
            ScaleBar.this.updateScalebar();
        }
    }
}

