/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class ScreenGrabber
implements PlugIn {
    @Override
    public void run(String string) {
        ImagePlus imagePlus = null;
        imagePlus = string.equals("image") || string.equals("flatten") ? this.captureImage() : this.captureScreen();
        if (imagePlus != null) {
            imagePlus.show();
        }
    }

    public ImagePlus captureScreen() {
        ImagePlus imagePlus = null;
        try {
            Robot robot = new Robot();
            Dimension dimension = IJ.getScreenSize();
            Rectangle rectangle = new Rectangle(dimension);
            BufferedImage bufferedImage = robot.createScreenCapture(rectangle);
            if (bufferedImage != null) {
                imagePlus = new ImagePlus("Screen", bufferedImage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imagePlus;
    }

    public ImagePlus captureImage() {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.noImage();
            return null;
        }
        ImagePlus imagePlus2 = null;
        try {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow == null) {
                return null;
            }
            imageWindow.toFront();
            IJ.wait(500);
            Point point = imageWindow.getLocation();
            ImageCanvas imageCanvas = imageWindow.getCanvas();
            Rectangle rectangle = imageCanvas.getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            Robot robot = new Robot();
            BufferedImage bufferedImage = robot.createScreenCapture(rectangle2);
            if (bufferedImage != null) {
                String string = WindowManager.getUniqueName(imagePlus.getTitle());
                imagePlus2 = new ImagePlus(string, bufferedImage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imagePlus2;
    }
}

