/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.util.Vector;

public class SpecifyROI
implements PlugIn,
DialogListener {
    static double xRoi;
    static double yRoi;
    static double width;
    static double height;
    static boolean oval;
    static boolean centered;
    static boolean scaledUnits;
    static Rectangle prevRoi;
    static double prevPixelWidth;
    int iSlice;
    boolean bAbort;
    ImagePlus imp;
    Vector fields;
    Vector checkboxes;
    int stackSize;

    @Override
    public void run(String string) {
        this.imp = IJ.getImage();
        this.stackSize = this.imp != null ? this.imp.getStackSize() : 0;
        Roi roi = this.imp.getRoi();
        Calibration calibration = this.imp.getCalibration();
        if (roi != null && roi.getBounds().equals(prevRoi) && calibration.pixelWidth == prevPixelWidth) {
            roi = null;
        }
        if (roi != null) {
            boolean bl = roi != null && (roi.getType() == 0 || roi.getType() == 1);
            oval = bl && roi.getType() == 1;
            Rectangle rectangle = roi.getBounds();
            width = rectangle.width;
            height = rectangle.height;
            xRoi = rectangle.x;
            yRoi = rectangle.y;
            if (scaledUnits && calibration.scaled()) {
                xRoi *= calibration.pixelWidth;
                yRoi *= calibration.pixelHeight;
                width *= calibration.pixelWidth;
                height *= calibration.pixelHeight;
            }
        } else if (!this.validDialogValues()) {
            width = this.imp.getWidth() / 2;
            height = this.imp.getHeight() / 2;
            xRoi = width / 2.0;
            yRoi = height / 2.0;
        }
        if (centered) {
            xRoi += width / 2.0;
            yRoi += height / 2.0;
        }
        this.iSlice = this.imp.getCurrentSlice();
        this.showDialog();
    }

    boolean validDialogValues() {
        Calibration calibration = this.imp.getCalibration();
        double d = calibration.pixelWidth;
        double d2 = calibration.pixelHeight;
        if (width / d < 1.5 || height / d2 < 1.5) {
            return false;
        }
        return !(xRoi / d >= (double)this.imp.getWidth()) && !(yRoi / d2 >= (double)this.imp.getHeight());
    }

    void showDialog() {
        Roi roi;
        Calibration calibration = this.imp.getCalibration();
        int n = 0;
        if (scaledUnits && calibration.scaled()) {
            n = 2;
        }
        if ((roi = this.imp.getRoi()) == null) {
            this.drawRoi();
        }
        GenericDialog genericDialog = new GenericDialog("Specify");
        genericDialog.addNumericField("Width:", width, n);
        genericDialog.addNumericField("Height:", height, n);
        genericDialog.addNumericField("X Coordinate:", xRoi, n);
        genericDialog.addNumericField("Y Coordinate:", yRoi, n);
        if (this.stackSize > 1) {
            genericDialog.addNumericField("Slice:", this.iSlice, 0);
        }
        genericDialog.addCheckbox("Oval", oval);
        genericDialog.addCheckbox("Centered", centered);
        if (calibration.scaled()) {
            genericDialog.addCheckbox("Scaled Units (" + calibration.getUnits() + ")", scaledUnits);
        }
        this.fields = genericDialog.getNumericFields();
        genericDialog.addDialogListener(this);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            if (roi == null) {
                this.imp.killRoi();
            } else {
                this.imp.setRoi(roi);
            }
        }
    }

    void drawRoi() {
        int n = (int)xRoi;
        int n2 = (int)yRoi;
        if (centered) {
            n = (int)(xRoi - width / 2.0);
            n2 = (int)(yRoi - height / 2.0);
        }
        int n3 = (int)width;
        int n4 = (int)height;
        Calibration calibration = this.imp.getCalibration();
        if (scaledUnits && calibration.scaled()) {
            n = (int)Math.round((double)n / calibration.pixelWidth);
            n2 = (int)Math.round((double)n2 / calibration.pixelHeight);
            n3 = (int)Math.round(width / calibration.pixelWidth);
            n4 = (int)Math.round(height / calibration.pixelHeight);
            prevPixelWidth = calibration.pixelWidth;
        }
        Roi roi = oval ? new OvalRoi(n, n2, n3, n4, this.imp) : new Roi(n, n2, n3, n4);
        this.imp.setRoi(roi);
        prevRoi = roi.getBounds();
        prevPixelWidth = calibration.pixelWidth;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        width = genericDialog.getNextNumber();
        height = genericDialog.getNextNumber();
        xRoi = genericDialog.getNextNumber();
        yRoi = genericDialog.getNextNumber();
        if (this.stackSize > 1) {
            this.iSlice = (int)genericDialog.getNextNumber();
        }
        oval = genericDialog.getNextBoolean();
        centered = genericDialog.getNextBoolean();
        if (this.imp.getCalibration().scaled()) {
            scaledUnits = genericDialog.getNextBoolean();
        }
        if (genericDialog.invalidNumber()) {
            return false;
        }
        if (this.stackSize > 1 && this.iSlice > 0 && this.iSlice <= this.stackSize) {
            this.imp.setSlice(this.iSlice);
        }
        this.drawRoi();
        return true;
    }

    static {
        prevPixelWidth = 1.0;
    }
}

