/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;

public class StackCombiner
implements PlugIn {
    ImagePlus imp1;
    ImagePlus imp2;
    static boolean vertical;

    @Override
    public void run(String string) {
        if (!this.showDialog()) {
            return;
        }
        if (this.imp1.getType() != this.imp2.getType() || this.imp1.isHyperStack() || this.imp2.isHyperStack()) {
            this.error();
            return;
        }
        ImageStack imageStack = this.imp1.getStack();
        ImageStack imageStack2 = this.imp2.getStack();
        ImageStack imageStack3 = vertical ? this.combineVertically(imageStack, imageStack2) : this.combineHorizontally(imageStack, imageStack2);
        this.imp1.changes = false;
        this.imp1.close();
        this.imp2.changes = false;
        this.imp2.close();
        new ImagePlus("Combined Stacks", imageStack3).show();
    }

    public ImageStack combineHorizontally(ImageStack imageStack, ImageStack imageStack2) {
        int n = imageStack.getSize();
        int n2 = imageStack2.getSize();
        int n3 = Math.max(n, n2);
        int n4 = imageStack.getWidth();
        int n5 = imageStack.getHeight();
        int n6 = imageStack2.getWidth();
        int n7 = imageStack2.getHeight();
        int n8 = n4 + n6;
        int n9 = Math.max(n5, n7);
        ImageStack imageStack3 = new ImageStack(n8, n9, imageStack.getColorModel());
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        Color color = Toolbar.getBackgroundColor();
        for (int i = 1; i <= n3; ++i) {
            IJ.showProgress((double)i / (double)n3);
            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n8, n9);
            if (n5 != n7) {
                imageProcessor2.setColor(color);
                imageProcessor2.fill();
            }
            if (i <= n) {
                imageProcessor2.insert(imageStack.getProcessor(1), 0, 0);
                if (imageStack2 != imageStack) {
                    imageStack.deleteSlice(1);
                }
            }
            if (i <= n2) {
                imageProcessor2.insert(imageStack2.getProcessor(1), n4, 0);
                imageStack2.deleteSlice(1);
            }
            imageStack3.addSlice(null, imageProcessor2);
        }
        return imageStack3;
    }

    public ImageStack combineVertically(ImageStack imageStack, ImageStack imageStack2) {
        int n = imageStack.getSize();
        int n2 = imageStack2.getSize();
        int n3 = Math.max(n, n2);
        int n4 = imageStack.getWidth();
        int n5 = imageStack.getHeight();
        int n6 = imageStack2.getWidth();
        int n7 = imageStack2.getHeight();
        int n8 = Math.max(n4, n6);
        int n9 = n5 + n7;
        ImageStack imageStack3 = new ImageStack(n8, n9, imageStack.getColorModel());
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        Color color = Toolbar.getBackgroundColor();
        for (int i = 1; i <= n3; ++i) {
            IJ.showProgress((double)i / (double)n3);
            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n8, n9);
            if (n4 != n6) {
                imageProcessor2.setColor(color);
                imageProcessor2.fill();
            }
            if (i <= n) {
                imageProcessor2.insert(imageStack.getProcessor(1), 0, 0);
                if (imageStack2 != imageStack) {
                    imageStack.deleteSlice(1);
                }
            }
            if (i <= n2) {
                imageProcessor2.insert(imageStack2.getProcessor(1), 0, n5);
                imageStack2.deleteSlice(1);
            }
            imageStack3.addSlice(null, imageProcessor2);
        }
        return imageStack3;
    }

    boolean showDialog() {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null || nArray.length < 2) {
            this.error();
            return false;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = WindowManager.getImage(nArray[i]);
            stringArray[i] = object != null ? ((ImagePlus)object).getTitle() : "";
        }
        GenericDialog genericDialog = new GenericDialog("Combiner");
        genericDialog.addChoice("Stack1:", stringArray, stringArray[0]);
        genericDialog.addChoice("Stack2:", stringArray, stringArray[1]);
        genericDialog.addCheckbox("Combine vertically", false);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/image.html#combine");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        object = new int[3];
        int n = genericDialog.getNextChoiceIndex();
        int n2 = genericDialog.getNextChoiceIndex();
        this.imp1 = WindowManager.getImage(nArray[n]);
        this.imp2 = WindowManager.getImage(nArray[n2]);
        vertical = genericDialog.getNextBoolean();
        return true;
    }

    void error() {
        IJ.showMessage("StackCombiner", "This command requires two stacks\nthat are the same data type.");
    }
}

