/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackReducer
implements PlugIn {
    ImagePlus imp;
    private static int factor = 2;
    private boolean hyperstack;
    private boolean reduceSlices;

    @Override
    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        ImageStack imageStack = this.imp.getStack();
        int n = imageStack.getSize();
        if (n == 1 || this.imp.getNChannels() == n && this.imp.isComposite()) {
            IJ.error("Stack or hyperstack required");
            return;
        }
        if (!this.showDialog(imageStack)) {
            return;
        }
        if (this.hyperstack) {
            this.reduceHyperstack(this.imp, factor, this.reduceSlices);
        } else {
            this.reduceStack(this.imp, factor);
        }
    }

    public boolean showDialog(ImageStack imageStack) {
        this.hyperstack = this.imp.isHyperStack();
        boolean bl = false;
        if (this.hyperstack && this.imp.getNSlices() > 1 && this.imp.getNFrames() > 1) {
            bl = true;
        } else if (this.hyperstack && this.imp.getNSlices() > 1) {
            this.reduceSlices = true;
        }
        int n = imageStack.getSize();
        GenericDialog genericDialog = new GenericDialog("Reduce Size");
        genericDialog.addNumericField("Reduction Factor:", factor, 0);
        if (bl) {
            genericDialog.addCheckbox("Reduce in Z-Dimension", false);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        factor = (int)genericDialog.getNextNumber();
        if (bl) {
            this.reduceSlices = genericDialog.getNextBoolean();
        }
        return true;
    }

    public void reduceStack(ImagePlus imagePlus, int n) {
        Calibration calibration;
        ImageStack imageStack = imagePlus.getStack();
        boolean bl = imageStack.isVirtual();
        int n2 = imageStack.getSize();
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = 1; i <= n2; i += n) {
            if (bl) {
                IJ.showProgress(i, n2);
            }
            imageStack2.addSlice(imageStack.getSliceLabel(i), imageStack.getProcessor(i));
        }
        imagePlus.setStack(null, imageStack2);
        if (bl) {
            IJ.showProgress(1.0);
            imagePlus.setTitle(imagePlus.getTitle());
        }
        if ((calibration = imagePlus.getCalibration()).scaled()) {
            calibration.pixelDepth *= (double)n;
        }
    }

    public void reduceHyperstack(ImagePlus imagePlus, int n, boolean bl) {
        int n2 = imagePlus.getNChannels();
        int n3 = imagePlus.getNSlices();
        int n4 = imagePlus.getNFrames();
        int n5 = bl ? n : 1;
        int n6 = bl ? 1 : n;
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(imagePlus.getWidth(), imagePlus.getHeight());
        boolean bl2 = imageStack.isVirtual();
        int n7 = n3 / n5 + (n3 % n5 != 0 ? 1 : 0);
        int n8 = n4 / n6 + (n4 % n6 != 0 ? 1 : 0);
        int n9 = n2 * n7 * n8;
        boolean bl3 = true;
        for (int i = 1; i <= n4; i += n6) {
            for (int j = 1; j <= n3; j += n5) {
                for (int k = 1; k <= n2; ++k) {
                    int n10 = imagePlus.getStackIndex(k, j, i);
                    IJ.showProgress(n10, n9);
                    ImageProcessor imageProcessor = imageStack.getProcessor(imagePlus.getStackIndex(k, j, i));
                    imageStack2.addSlice(imageStack.getSliceLabel(n10), imageProcessor);
                }
            }
        }
        imagePlus.setStack(imageStack2, n2, n7, n8);
        Calibration calibration = imagePlus.getCalibration();
        if (calibration.scaled()) {
            calibration.pixelDepth *= (double)n5;
        }
        if (bl2) {
            imagePlus.setTitle(imagePlus.getTitle());
        }
        IJ.showProgress(1.0);
    }
}

