/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.Polygon;

public class Straightener
implements PlugIn {
    static boolean processStack;

    @Override
    public void run(String string) {
        Object object;
        int n;
        int n2;
        ImagePlus imagePlus = IJ.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isLine()) {
            IJ.error("Straightener", "Line selection required");
            return;
        }
        int n3 = n2 = Math.round(roi.getStrokeWidth());
        boolean bl = IJ.macroRunning() && Macro.getOptions() != null;
        int n4 = imagePlus.getStackSize();
        if (n4 == 1) {
            processStack = false;
        }
        if (n2 == 1 || bl || n4 > 1) {
            if (n2 == 1) {
                n2 = 20;
            }
            GenericDialog genericDialog = new GenericDialog("Straightener");
            genericDialog.addNumericField("Line Width:", n2, 0, 3, "pixels");
            if (n4 > 1) {
                genericDialog.addCheckbox("Process Entire Stack", processStack);
            }
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            n2 = (int)genericDialog.getNextNumber();
            Line.setWidth(n2);
            if (n4 > 1) {
                processStack = genericDialog.getNextBoolean();
            }
        }
        if ((n = (roi = (Roi)imagePlus.getRoi().clone()).getType()) == 7) {
            IJ.run(imagePlus, "Fit Spline", "");
        }
        ImageProcessor imageProcessor = null;
        ImagePlus imagePlus2 = null;
        if (processStack) {
            object = this.straightenStack(imagePlus, roi, n2);
            imagePlus2 = new ImagePlus(WindowManager.getUniqueName(imagePlus.getTitle()), (ImageStack)object);
        } else {
            imageProcessor = this.straighten(imagePlus, roi, n2);
            imagePlus2 = new ImagePlus(WindowManager.getUniqueName(imagePlus.getTitle()), imageProcessor);
        }
        if (imagePlus2 == null) {
            return;
        }
        object = imagePlus.getCalibration();
        if (((Calibration)object).pixelWidth == ((Calibration)object).pixelHeight) {
            imagePlus2.setCalibration((Calibration)object);
        }
        imagePlus2.show();
        if (bl) {
            Line.setWidth(n3);
        }
    }

    public ImageProcessor straighten(ImagePlus imagePlus, Roi roi, int n) {
        ImageProcessor imageProcessor = imagePlus.getBitDepth() == 24 && roi.getType() != 5 ? this.straightenRGB(imagePlus, n) : (imagePlus.isComposite() && ((CompositeImage)imagePlus).getMode() == 1 ? this.straightenComposite(imagePlus, n) : (roi.getType() == 5 ? this.rotateLine(imagePlus, n) : this.straightenLine(imagePlus, n)));
        return imageProcessor;
    }

    public ImageStack straightenStack(ImagePlus imagePlus, Roi roi, int n) {
        int n2 = imagePlus.getCurrentSlice();
        int n3 = imagePlus.getStackSize();
        ImageStack imageStack = null;
        for (int i = 1; i <= n3; ++i) {
            IJ.showProgress(i, n3);
            imagePlus.setSlice(i);
            ImageProcessor imageProcessor = this.straighten(imagePlus, roi, n);
            if (imageStack == null) {
                imageStack = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight());
            }
            imageStack.addSlice(null, imageProcessor);
        }
        imagePlus.setSlice(n2);
        return imageStack;
    }

    public ImageProcessor straightenLine(ImagePlus imagePlus, int n) {
        PolygonRoi polygonRoi = (PolygonRoi)imagePlus.getRoi();
        if (polygonRoi == null) {
            return null;
        }
        if (polygonRoi.getState() == 0) {
            polygonRoi.exitConstructingMode();
        }
        boolean bl = polygonRoi.isSplineFit();
        int n2 = polygonRoi.getType();
        int n3 = polygonRoi.getNCoordinates();
        double d = polygonRoi.getLength();
        if (!bl || !(Math.abs(1.0 - polygonRoi.getLength() / (double)n3) < 0.5)) {
            polygonRoi.fitSplineForStraightening();
        }
        if (polygonRoi.getNCoordinates() < 2) {
            return null;
        }
        FloatPolygon floatPolygon = polygonRoi.getFloatPolygon();
        n3 = floatPolygon.npoints;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        FloatProcessor floatProcessor = new FloatProcessor(n3, n);
        FloatProcessor floatProcessor2 = null;
        if (IJ.debugMode) {
            floatProcessor2 = new FloatProcessor(n3, 1);
        }
        float[] fArray = (float[])((ImageProcessor)floatProcessor).getPixels();
        double d2 = floatPolygon.xpoints[0] - (floatPolygon.xpoints[1] - floatPolygon.xpoints[0]);
        double d3 = floatPolygon.ypoints[0] - (floatPolygon.ypoints[1] - floatPolygon.ypoints[0]);
        if (n == 1) {
            ((ImageProcessor)floatProcessor).putPixelValue(0, 0, imageProcessor.getInterpolatedValue(d2, d3));
        }
        for (int i = 0; i < n3; ++i) {
            if (!processStack && i % 10 == 0) {
                IJ.showProgress(i, n3);
            }
            double d4 = d2;
            double d5 = d3;
            d2 = floatPolygon.xpoints[i];
            d3 = floatPolygon.ypoints[i];
            if (floatProcessor2 != null) {
                ((ImageProcessor)floatProcessor2).putPixelValue(i, 0, (float)Math.sqrt((d2 - d4) * (d2 - d4) + (d3 - d5) * (d3 - d5)));
            }
            if (n == 1) {
                ((ImageProcessor)floatProcessor).putPixelValue(i, 0, imageProcessor.getInterpolatedValue(d2, d3));
                continue;
            }
            double d6 = d2 - d4;
            double d7 = d5 - d3;
            double d8 = (float)Math.sqrt(d6 * d6 + d7 * d7);
            double d9 = d2 - (d7 /= d8) * (double)n / 2.0;
            double d10 = d3 - (d6 /= d8) * (double)n / 2.0;
            int n4 = 0;
            int n5 = n;
            do {
                ((ImageProcessor)floatProcessor).putPixelValue(i, n4++, imageProcessor.getInterpolatedValue(d9, d10));
                d9 += d7;
                d10 += d6;
            } while (--n5 > 0);
        }
        if (!processStack) {
            IJ.showProgress(n3, n3);
        }
        if (!bl) {
            if (n2 == 7) {
                polygonRoi.removeSplineFit();
            } else {
                imagePlus.draw();
            }
        }
        if (imagePlus.getBitDepth() != 24) {
            floatProcessor.setColorModel(imageProcessor.getColorModel());
            ((ImageProcessor)floatProcessor).resetMinAndMax();
        }
        if (floatProcessor2 != null) {
            ((ImageProcessor)floatProcessor2).resetMinAndMax();
            new ImagePlus("Distances", floatProcessor2).show();
        }
        return floatProcessor;
    }

    public ImageProcessor rotateLine(ImagePlus imagePlus, int n) {
        Roi roi = imagePlus.getRoi();
        float f = roi.getStrokeWidth();
        roi.setStrokeWidth(1.0f);
        Polygon polygon = roi.getPolygon();
        roi.setStrokeWidth(f);
        imagePlus.setRoi(new PolygonRoi(polygon.xpoints, polygon.ypoints, 2, 6));
        ImageProcessor imageProcessor = imagePlus.getBitDepth() == 24 ? this.straightenRGB(imagePlus, n) : this.straightenLine(imagePlus, n);
        imagePlus.setRoi(roi);
        return imageProcessor;
    }

    ImageProcessor straightenRGB(ImagePlus imagePlus, int n) {
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        ColorProcessor colorProcessor = (ColorProcessor)imagePlus.getProcessor();
        colorProcessor.getRGB(byArray, byArray2, byArray3);
        ImagePlus imagePlus2 = new ImagePlus("red", new ByteProcessor(n2, n3, byArray, null));
        imagePlus2.setRoi((Roi)imagePlus.getRoi().clone());
        ImageProcessor imageProcessor = this.straightenLine(imagePlus2, n);
        if (imageProcessor == null) {
            return null;
        }
        imagePlus2 = new ImagePlus("green", new ByteProcessor(n2, n3, byArray2, null));
        imagePlus2.setRoi((Roi)imagePlus.getRoi().clone());
        ImageProcessor imageProcessor2 = this.straightenLine(imagePlus2, n);
        if (imageProcessor2 == null) {
            return null;
        }
        imagePlus2 = new ImagePlus("blue", new ByteProcessor(n2, n3, byArray3, null));
        imagePlus2.setRoi((Roi)imagePlus.getRoi().clone());
        ImageProcessor imageProcessor3 = this.straightenLine(imagePlus2, n);
        if (imageProcessor3 == null) {
            return null;
        }
        ColorProcessor colorProcessor2 = new ColorProcessor(imageProcessor.getWidth(), imageProcessor.getHeight());
        imageProcessor = imageProcessor.convertToByte(false);
        imageProcessor2 = imageProcessor2.convertToByte(false);
        imageProcessor3 = imageProcessor3.convertToByte(false);
        colorProcessor2.setRGB((byte[])imageProcessor.getPixels(), (byte[])imageProcessor2.getPixels(), (byte[])imageProcessor3.getPixels());
        imagePlus.setRoi(imagePlus2.getRoi());
        return colorProcessor2;
    }

    ImageProcessor straightenComposite(ImagePlus imagePlus, int n) {
        Image image = imagePlus.getImage();
        ImagePlus imagePlus2 = new ImagePlus("temp", new ColorProcessor(image));
        imagePlus2.setRoi(imagePlus.getRoi());
        ImageProcessor imageProcessor = this.straightenRGB(imagePlus2, n);
        imagePlus.setRoi(imagePlus2.getRoi());
        return imageProcessor;
    }
}

