/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.TextReader;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Convolver
implements ExtendedPlugInFilter,
DialogListener,
ActionListener {
    private ImagePlus imp;
    private int kw;
    private int kh;
    private boolean canceled;
    private float[] kernel;
    private boolean isLineRoi;
    private Button open;
    private Button save;
    private GenericDialog gd;
    private boolean normalize = true;
    private int nSlices;
    private int flags = 16867423;
    private int nPasses = 1;
    private boolean kernelError;
    private PlugInFilterRunner pfr;
    private Thread mainThread;
    private int pass;
    static String kernelText = "-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 24 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n";
    static boolean normalizeFlag = true;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.mainThread = Thread.currentThread();
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        if (string.equals("final") && imagePlus.getRoi() == null) {
            imagePlus.getProcessor().resetMinAndMax();
            imagePlus.updateAndDraw();
            return 4096;
        }
        IJ.resetEscape();
        Roi roi = imagePlus.getRoi();
        this.isLineRoi = roi != null && roi.isLine();
        this.nSlices = imagePlus.getStackSize();
        this.flags = imagePlus.getStackSize() == 1 ? (this.flags |= 0x40000) : (this.flags |= 0x8000);
        imagePlus.startTiming();
        return this.flags;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (this.isLineRoi) {
            imageProcessor.resetRoi();
        }
        if (!this.kernelError) {
            this.convolve(imageProcessor, this.kernel, this.kw, this.kh);
        }
    }

    @Override
    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        this.gd = new GenericDialog("Convolver...", IJ.getInstance());
        this.gd.addTextAreas(kernelText, null, 10, 30);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Normalize Kernel", normalizeFlag);
        this.gd.addPreviewCheckbox(plugInFilterRunner);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        this.pfr = plugInFilterRunner;
        return IJ.setupDialog(imagePlus, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        kernelText = genericDialog.getNextText();
        this.normalize = normalizeFlag = genericDialog.getNextBoolean();
        boolean bl = this.kernelError = !this.decodeKernel(kernelText);
        if (!this.kernelError) {
            IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
            return true;
        }
        return !genericDialog.getPreviewCheckbox().getState();
    }

    boolean decodeKernel(String string) {
        if (Macro.getOptions() != null && !this.hasNewLine(string)) {
            return this.decodeSquareKernel(string);
        }
        String[] stringArray = Tools.split(string, "\n");
        this.kh = stringArray.length;
        if (this.kh == 0) {
            return false;
        }
        String[] stringArray2 = Tools.split(stringArray[0]);
        this.kw = stringArray2.length;
        this.kernel = new float[this.kw * this.kh];
        boolean bl = this.gd.wasOKed();
        int n = 0;
        for (int i = 0; i < this.kh; ++i) {
            stringArray2 = Tools.split(stringArray[i]);
            if (stringArray2.length != this.kw) {
                String string2 = "Row " + (i + 1) + " is not the same length as the first row";
                if (bl) {
                    IJ.error("Convolver", string2);
                } else {
                    IJ.showStatus(string2);
                }
                return false;
            }
            for (int j = 0; j < this.kw; ++j) {
                this.kernel[n++] = (float)Tools.parseDouble(stringArray2[j], 0.0);
            }
        }
        if ((this.kw & 1) != 1 || (this.kh & 1) != 1) {
            String string3 = "Kernel must have odd width and height. This one is " + this.kw + "x" + this.kh + ".";
            if (bl) {
                IJ.error("Convolver", string3);
            } else {
                IJ.showStatus(string3);
            }
            return false;
        }
        return true;
    }

    boolean hasNewLine(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    boolean decodeSquareKernel(String string) {
        String[] stringArray = Tools.split(string);
        int n = stringArray.length;
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        this.kernel = new float[n];
        for (int i = 0; i < n; ++i) {
            this.kernel[i] = (float)Tools.parseDouble(stringArray[i]);
        }
        if (this.kw >= 3 && (this.kw & 1) == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            for (int i = 0; i < this.kh; ++i) {
                for (int j = 0; j < this.kw; ++j) {
                    stringBuffer.append("" + this.kernel[n2++]);
                    if (j >= this.kw - 1) continue;
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\n");
            }
            kernelText = new String(stringBuffer);
            this.gd.getTextArea1().setText(new String(stringBuffer));
            return true;
        }
        IJ.error("Kernel must be square with odd width. This one is " + this.kw + "x" + this.kh + ".");
        return false;
    }

    Panel makeButtonPanel(GenericDialog genericDialog) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        return panel;
    }

    public boolean convolve(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        if (this.canceled || n * n2 != fArray.length) {
            return false;
        }
        if ((n & 1) != 1 || (n2 & 1) != 1) {
            throw new IllegalArgumentException("Kernel width or height not odd (" + n + "x" + n2 + ")");
        }
        boolean bl = !(imageProcessor instanceof FloatProcessor);
        ImageProcessor imageProcessor2 = imageProcessor;
        if (bl) {
            if (imageProcessor2 instanceof ColorProcessor) {
                throw new IllegalArgumentException("RGB images not supported");
            }
            imageProcessor2 = imageProcessor2.convertToFloat();
        }
        if (n == 1 || n2 == 1) {
            this.convolveFloat1D(imageProcessor2, fArray, n, n2);
        } else {
            this.convolveFloat(imageProcessor2, fArray, n, n2);
        }
        if (bl) {
            imageProcessor2 = imageProcessor instanceof ByteProcessor ? imageProcessor2.convertToByte(false) : imageProcessor2.convertToShort(false);
            imageProcessor.setPixels(imageProcessor2.getPixels());
        }
        return !this.canceled;
    }

    public void setNormalize(boolean bl) {
        this.normalize = bl;
    }

    public boolean convolveFloat(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        boolean bl;
        if (!(imageProcessor instanceof FloatProcessor)) {
            throw new IllegalArgumentException("FloatProcessor required");
        }
        if (this.canceled) {
            return false;
        }
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int n9 = n / 2;
        int n10 = n2 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getSnapshotPixels();
        if (fArray3 == null) {
            fArray3 = (float[])imageProcessor.getPixelsCopy();
        }
        double d = this.getScale(fArray);
        Thread thread = Thread.currentThread();
        boolean bl2 = bl = thread == this.mainThread || thread.getName().indexOf("Preview") != -1;
        if (bl) {
            ++this.pass;
        }
        int n11 = n3 - n9;
        int n12 = n4 - n10;
        long l = System.currentTimeMillis();
        for (int i = n6; i < n8; ++i) {
            long l2 = System.currentTimeMillis();
            if (l2 - l > 100L) {
                l = l2;
                if (thread.isInterrupted()) {
                    return false;
                }
                if (bl) {
                    if (IJ.escapePressed()) {
                        this.canceled = true;
                        imageProcessor.reset();
                        ImageProcessor imageProcessor2 = this.imp.getProcessor();
                        if (imageProcessor2.getNChannels() > 1) {
                            imageProcessor2.reset();
                        }
                        return false;
                    }
                    this.showProgress((double)(i - n6) / (double)(n8 - n6));
                }
            }
            for (int j = n5; j < n7; ++j) {
                if (this.canceled) {
                    return false;
                }
                double d2 = 0.0;
                int n13 = 0;
                boolean bl3 = i < n10 || i >= n12 || j < n9 || j >= n11;
                for (int k = -n10; k <= n10; ++k) {
                    int n14 = j + (i + k) * n3;
                    for (int i2 = -n9; i2 <= n9; ++i2) {
                        if (bl3) {
                            if (n13 >= fArray.length) {
                                IJ.log("kernel index error: " + n13);
                            }
                            d2 += (double)(this.getPixel(j + i2, i + k, fArray3, n3, n4) * fArray[n13++]);
                            continue;
                        }
                        d2 += (double)(fArray3[n14 + i2] * fArray[n13++]);
                    }
                }
                fArray2[j + i * n3] = (float)(d2 * d);
            }
        }
        return true;
    }

    void convolveFloat1D(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        if (!(imageProcessor instanceof FloatProcessor)) {
            throw new IllegalArgumentException("FloatProcessor required");
        }
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int n9 = n / 2;
        int n10 = n2 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getSnapshotPixels();
        if (fArray3 == null) {
            fArray3 = (float[])imageProcessor.getPixelsCopy();
        }
        double d = this.getScale(fArray);
        boolean bl = n == 1;
        int n11 = n3 - n9;
        int n12 = n4 - n10;
        for (int i = n6; i < n8; ++i) {
            for (int j = n5; j < n7; ++j) {
                int n13;
                int n14;
                boolean bl2;
                double d2 = 0.0;
                int n15 = 0;
                if (bl) {
                    bl2 = i < n10 || i >= n12;
                    n14 = j + (i - n10) * n3;
                    for (n13 = -n10; n13 <= n10; ++n13) {
                        d2 = bl2 ? (d2 += (double)(this.getPixel(j + n9, i + n13, fArray3, n3, n4) * fArray[n15++])) : (d2 += (double)(fArray3[n14 + n9] * fArray[n15++]));
                        n14 += n3;
                    }
                } else {
                    bl2 = j < n9 || j >= n11;
                    n14 = j + (i - n10) * n3;
                    for (n13 = -n9; n13 <= n9; ++n13) {
                        if (bl2) {
                            d2 += (double)(this.getPixel(j + n13, i + n10, fArray3, n3, n4) * fArray[n15++]);
                            continue;
                        }
                        d2 += (double)(fArray3[n14 + n13] * fArray[n15++]);
                    }
                }
                fArray2[j + i * n3] = (float)(d2 * d);
            }
        }
    }

    double getScale(float[] fArray) {
        double d = 1.0;
        if (this.normalize) {
            double d2 = 0.0;
            for (int i = 0; i < fArray.length; ++i) {
                d2 += (double)fArray[i];
            }
            if (d2 != 0.0) {
                d = (float)(1.0 / d2);
            }
        }
        return d;
    }

    private float getPixel(int n, int n2, float[] fArray, int n3, int n4) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= n4) {
            n2 = n4 - 1;
        }
        return fArray[n + n2 * n3];
    }

    void save() {
        TextArea textArea = this.gd.getTextArea1();
        textArea.selectAll();
        String string = textArea.getText();
        textArea.select(0, 0);
        if (string == null || string.length() == 0) {
            return;
        }
        string = string + "\n";
        SaveDialog saveDialog = new SaveDialog("Save as Text...", "kernel", ".txt");
        String string2 = saveDialog.getFileName();
        if (string2 == null) {
            return;
        }
        String string3 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3 + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.error("" + iOException);
            return;
        }
        IJ.wait(250);
        printWriter.print(string);
        printWriter.close();
    }

    void open() {
        double d;
        int n;
        int n2;
        OpenDialog openDialog = new OpenDialog("Open Kernel...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        TextReader textReader = new TextReader();
        String string3 = string + string2;
        ImageProcessor imageProcessor = textReader.open(string3);
        if (imageProcessor == null) {
            return;
        }
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        if ((n3 & 1) != 1 || (n4 & 1) != 1) {
            IJ.error("Convolver", "Kernel must be have odd width and height");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                d = imageProcessor.getPixelValue(n, n2);
                if ((double)((int)d) == d) continue;
                bl = false;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (n != 0) {
                    stringBuffer.append(" ");
                }
                d = imageProcessor.getPixelValue(n, n2);
                if (bl) {
                    stringBuffer.append(IJ.d2s(imageProcessor.getPixelValue(n, n2), 0));
                    continue;
                }
                stringBuffer.append("" + imageProcessor.getPixelValue(n, n2));
            }
            if (n2 == n4 - 1) continue;
            stringBuffer.append("\n");
        }
        this.gd.getTextArea1().setText(new String(stringBuffer));
    }

    @Override
    public void setNPasses(int n) {
        this.nPasses = n;
        this.pass = 0;
    }

    private void showProgress(double d) {
        d = (double)(this.pass - 1) / (double)this.nPasses + d / (double)this.nPasses;
        IJ.showProgress(d);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Recorder.disablePathRecording();
        if (object == this.save) {
            this.save();
        } else if (object == this.open) {
            this.open();
        }
    }
}

