/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileOpener;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Locale;
import java.util.Vector;

public class ImageProperties
implements PlugInFilter,
TextListener {
    ImagePlus imp;
    static final int NANOMETER = 0;
    static final int MICROMETER = 1;
    static final int MILLIMETER = 2;
    static final int CENTIMETER = 3;
    static final int METER = 4;
    static final int KILOMETER = 5;
    static final int INCH = 6;
    static final int FOOT = 7;
    static final int MILE = 8;
    static final int PIXEL = 9;
    static final int OTHER_UNIT = 10;
    int oldUnitIndex;
    double oldUnitsPerCm;
    Vector nfields;
    Vector sfields;
    boolean duplicatePixelWidth = true;
    String calUnit;
    double calPixelWidth;
    double calPixelHeight;
    double calPixelDepth;
    TextField pixelWidthField;
    TextField pixelHeightField;
    TextField pixelDepthField;
    int textChangedCount;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        this.showDialog(this.imp);
    }

    void showDialog(ImagePlus imagePlus) {
        String string;
        int n;
        Object object;
        String string2 = Macro.getOptions();
        if (string2 != null) {
            object = string2.replaceAll(" depth=", " slices=");
            object = ((String)object).replaceAll(" interval=", " frame=");
            Macro.setOptions((String)object);
        }
        object = imagePlus.getCalibration();
        Calibration calibration = ((Calibration)object).copy();
        this.oldUnitIndex = ImageProperties.getUnitIndex(((Calibration)object).getUnit());
        this.oldUnitsPerCm = ImageProperties.getUnitsPerCm(this.oldUnitIndex);
        int n2 = imagePlus.getImageStackSize();
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        boolean bl = imagePlus.getGlobalCalibration() != null;
        int n6 = ((Calibration)object).pixelWidth < 1.0 || ((Calibration)object).pixelHeight < 1.0 || ((Calibration)object).pixelDepth < 1.0 ? 7 : 4;
        GenericDialog genericDialog = new GenericDialog(imagePlus.getTitle());
        genericDialog.addNumericField("Channels (c):", n3, 0);
        genericDialog.addNumericField("Slices (z):", n4, 0);
        genericDialog.addNumericField("Frames (t):", n5, 0);
        genericDialog.setInsets(0, 5, 0);
        genericDialog.addMessage("Note: c*z*t must equal " + n2);
        genericDialog.setInsets(15, 0, 0);
        genericDialog.addStringField("Unit of Length:", ((Calibration)object).getUnit());
        genericDialog.addNumericField("Pixel_Width:", ((Calibration)object).pixelWidth, n6, 8, null);
        genericDialog.addNumericField("Pixel_Height:", ((Calibration)object).pixelHeight, n6, 8, null);
        genericDialog.addNumericField("Voxel_Depth:", ((Calibration)object).pixelDepth, n6, 8, null);
        genericDialog.setInsets(10, 0, 5);
        double d = ((Calibration)object).frameInterval;
        String string3 = IJ.d2s(d, (double)((int)d) == d ? 0 : 2) + " " + ((Calibration)object).getTimeUnit();
        genericDialog.addStringField("Frame Interval:", string3);
        String string4 = ((Calibration)object).xOrigin == (double)((int)((Calibration)object).xOrigin) ? IJ.d2s(((Calibration)object).xOrigin, 0) : IJ.d2s(((Calibration)object).xOrigin, 2);
        String string5 = ((Calibration)object).yOrigin == (double)((int)((Calibration)object).yOrigin) ? IJ.d2s(((Calibration)object).yOrigin, 0) : IJ.d2s(((Calibration)object).yOrigin, 2);
        String string6 = "";
        if (((Calibration)object).zOrigin != 0.0) {
            string6 = ((Calibration)object).zOrigin == (double)((int)((Calibration)object).zOrigin) ? IJ.d2s(((Calibration)object).zOrigin, 0) : IJ.d2s(((Calibration)object).zOrigin, 2);
            string6 = "," + string6;
        }
        genericDialog.addStringField("Origin (pixels):", string4 + "," + string5 + string6);
        genericDialog.setInsets(5, 20, 0);
        genericDialog.addCheckbox("Global", bl);
        this.nfields = genericDialog.getNumericFields();
        this.pixelWidthField = (TextField)this.nfields.elementAt(3);
        this.pixelHeightField = (TextField)this.nfields.elementAt(4);
        this.pixelDepthField = (TextField)this.nfields.elementAt(5);
        for (n = 0; n < this.nfields.size(); ++n) {
            ((TextField)this.nfields.elementAt(n)).addTextListener(this);
        }
        this.sfields = genericDialog.getStringFields();
        for (n = 0; n < this.sfields.size(); ++n) {
            ((TextField)this.sfields.elementAt(n)).addTextListener(this);
        }
        this.calUnit = ((Calibration)object).getUnit();
        this.calPixelWidth = ((Calibration)object).pixelWidth;
        this.calPixelHeight = ((Calibration)object).pixelHeight;
        this.calPixelDepth = ((Calibration)object).pixelDepth;
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        n3 = (int)genericDialog.getNextNumber();
        if (n3 < 1) {
            n3 = 1;
        }
        if ((n4 = (int)genericDialog.getNextNumber()) < 1) {
            n4 = 1;
        }
        if ((n5 = (int)genericDialog.getNextNumber()) < 1) {
            n5 = 1;
        }
        if (n3 * n4 * n5 == n2) {
            imagePlus.setDimensions(n3, n4, n5);
        } else {
            IJ.error("Properties", "The product of channels (" + n3 + "), slices (" + n4 + ")\n and frames (" + n5 + ") must equal the stack size (" + n2 + ").");
        }
        String string7 = genericDialog.getNextString();
        if (string7.equals("u")) {
            string7 = "\u00b5";
        } else if (string7.equals("A")) {
            string7 = "\u00c5";
        }
        double d2 = genericDialog.getNextNumber();
        double d3 = genericDialog.getNextNumber();
        double d4 = genericDialog.getNextNumber();
        if (string7.equals("") || string7.equalsIgnoreCase("none") || d2 == 0.0) {
            ((Calibration)object).setUnit(null);
            ((Calibration)object).pixelWidth = 1.0;
            ((Calibration)object).pixelHeight = 1.0;
            ((Calibration)object).pixelDepth = 1.0;
        } else {
            ((Calibration)object).setUnit(string7);
            ((Calibration)object).pixelWidth = d2;
            ((Calibration)object).pixelHeight = d3;
            ((Calibration)object).pixelDepth = d4;
        }
        String string8 = this.validateInterval(genericDialog.getNextString());
        String[] stringArray = Tools.split(string8, " -");
        d = Tools.parseDouble(stringArray[0]);
        ((Calibration)object).frameInterval = Double.isNaN(d) ? 0.0 : d;
        String string9 = string = stringArray.length >= 2 ? stringArray[1] : "sec";
        if (string.equals("sec") && ((Calibration)object).frameInterval <= 2.0 && ((Calibration)object).frameInterval >= 0.03333333333333333) {
            ((Calibration)object).fps = 1.0 / ((Calibration)object).frameInterval;
        }
        if (string.equals("usec")) {
            string = "\u00b5sec";
        }
        ((Calibration)object).setTimeUnit(string);
        String[] stringArray2 = Tools.split(genericDialog.getNextString(), " ,");
        double d5 = Tools.parseDouble(stringArray2[0]);
        double d6 = stringArray2.length >= 2 ? Tools.parseDouble(stringArray2[1]) : Double.NaN;
        double d7 = stringArray2.length >= 3 ? Tools.parseDouble(stringArray2[2]) : Double.NaN;
        ((Calibration)object).xOrigin = Double.isNaN(d5) ? 0.0 : d5;
        ((Calibration)object).yOrigin = Double.isNaN(d6) ? ((Calibration)object).xOrigin : d6;
        ((Calibration)object).zOrigin = Double.isNaN(d7) ? 0.0 : d7;
        boolean bl2 = genericDialog.getNextBoolean();
        if (!((Calibration)object).equals(calibration)) {
            imagePlus.setCalibration((Calibration)object);
        }
        imagePlus.setGlobalCalibration((Calibration)(bl2 ? object : null));
        if (bl2 || bl2 != bl) {
            WindowManager.repaintImageWindows();
        } else {
            imagePlus.repaintWindow();
        }
        if (bl2 && bl2 != bl) {
            FileOpener.setShowConflictMessage(true);
        }
    }

    String validateInterval(String string) {
        if (string.indexOf(" ") != -1) {
            return string;
        }
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            n = i;
            break;
        }
        if (n > 0 && n < string.length() - 1) {
            string = string.substring(0, n) + " " + string.substring(n, string.length());
        }
        return string;
    }

    double getNewScale(String string, double d) {
        if (this.oldUnitsPerCm == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        int n = ImageProperties.getUnitIndex(string);
        if (n != this.oldUnitIndex) {
            double d3 = ImageProperties.getUnitsPerCm(n);
            if (this.oldUnitsPerCm != 0.0 && d3 != 0.0) {
                d2 = d * (this.oldUnitsPerCm / d3);
            }
        }
        return d2;
    }

    static int getUnitIndex(String string) {
        if ((string = string.toLowerCase(Locale.US)).equals("cm") || string.startsWith("cent")) {
            return 3;
        }
        if (string.equals("mm") || string.startsWith("milli")) {
            return 2;
        }
        if (string.startsWith("inch")) {
            return 6;
        }
        if (string.startsWith("\u00b5") || string.startsWith("u") || string.startsWith("micro")) {
            return 1;
        }
        if (string.equals("nm") || string.startsWith("nano")) {
            return 0;
        }
        if (string.startsWith("meter")) {
            return 4;
        }
        if (string.equals("km") || string.startsWith("kilo")) {
            return 5;
        }
        if (string.equals("ft") || string.equals("foot") || string.equals("feet")) {
            return 7;
        }
        if (string.equals("mi") || string.startsWith("mile")) {
            return 2;
        }
        return 10;
    }

    static double getUnitsPerCm(int n) {
        switch (n) {
            case 0: {
                return 1.0E7;
            }
            case 1: {
                return 10000.0;
            }
            case 2: {
                return 10.0;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.01;
            }
            case 5: {
                return 1.0E-5;
            }
            case 6: {
                return 0.3937;
            }
            case 7: {
                return 0.0328083;
            }
            case 8: {
                return 6.213E-6;
            }
        }
        return 0.0;
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        Object object;
        ++this.textChangedCount;
        Object object2 = textEvent.getSource();
        int n = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(2)).getText(), -99.0);
        int n2 = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(3)).getText(), -99.0);
        int n3 = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(4)).getText(), -99.0);
        double d = this.calPixelWidth;
        String string = this.pixelWidthField.getText();
        if (object2 == this.pixelWidthField) {
            d = Tools.parseDouble(string, -99.0);
        }
        double d2 = this.calPixelHeight;
        if (object2 == this.pixelHeightField) {
            String string2 = this.pixelHeightField.getText();
            d2 = Tools.parseDouble(string2, -99.0);
            if (!string2.equals(string)) {
                this.duplicatePixelWidth = false;
            }
        }
        double d3 = this.calPixelDepth;
        if (object2 == this.pixelDepthField) {
            object = this.pixelDepthField.getText();
            d3 = Tools.parseDouble((String)object, -99.0);
            if (!((String)object).equals(string)) {
                this.duplicatePixelWidth = false;
            }
        }
        if (this.textChangedCount == 1 && (this.calPixelHeight != 1.0 || this.calPixelDepth != 1.0)) {
            this.duplicatePixelWidth = false;
        }
        if (object2 == this.pixelWidthField && d != -99.0 && this.duplicatePixelWidth) {
            this.pixelHeightField.setText(string);
            this.pixelDepthField.setText(string);
            this.calPixelHeight = this.calPixelWidth;
            this.calPixelDepth = this.calPixelWidth;
        }
        this.calPixelWidth = d;
        this.calPixelHeight = d2;
        this.calPixelDepth = d3;
        object = (TextField)this.sfields.elementAt(0);
        String string3 = ((TextComponent)object).getText();
        if (!string3.equals(this.calUnit)) {
            double d4 = d != 0.0 ? 1.0 / d : 0.0;
            double d5 = d2 != 0.0 ? 1.0 / d2 : 0.0;
            double d6 = d3 != 0.0 ? 1.0 / d3 : 0.0;
            double d7 = this.getNewScale(string3, d4);
            double d8 = this.getNewScale(string3, d5);
            double d9 = this.getNewScale(string3, d6);
            if (d7 != 0.0) {
                double d10 = 1.0 / d7;
                double d11 = 1.0 / d8;
                double d12 = 1.0 / d9;
                int n4 = d10 < 1.0 || d11 < 1.0 || d12 < 1.0 ? 7 : 4;
                this.pixelWidthField.setText(IJ.d2s(1.0 / d7, n4));
                this.pixelHeightField.setText(IJ.d2s(1.0 / d8, n4));
                this.pixelDepthField.setText(IJ.d2s(1.0 / d9, n4));
                this.calPixelWidth = 1.0 / d7;
                this.calPixelHeight = 1.0 / d8;
                this.calPixelDepth = 1.0 / d9;
                this.oldUnitIndex = ImageProperties.getUnitIndex(string3);
                this.oldUnitsPerCm = ImageProperties.getUnitsPerCm(this.oldUnitIndex);
            }
            this.calUnit = string3;
        }
    }
}

