/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;

public class MaximumFinder
implements ExtendedPlugInFilter,
DialogListener {
    private static double tolerance = 10.0;
    public static final int SINGLE_POINTS = 0;
    public static final int IN_TOLERANCE = 1;
    public static final int SEGMENTED = 2;
    public static final int POINT_SELECTION = 3;
    public static final int LIST = 4;
    public static final int COUNT = 5;
    private static int outputType;
    private static int dialogOutputType;
    static final String[] outputTypeNames;
    private static boolean excludeOnEdges;
    private static boolean useMinThreshold;
    private static boolean lightBackground;
    private ImagePlus imp;
    private int flags = 415;
    private boolean thresholded;
    private boolean roiSaved;
    private boolean previewing;
    private Vector checkboxes;
    private boolean thresholdWarningShown = false;
    private Label messageArea;
    private double progressDone;
    private int nPasses = 0;
    private int width;
    private int height;
    private int intEncodeXMask;
    private int intEncodeYMask;
    private int intEncodeShift;
    private int[] dirOffset;
    static final int[] DIR_X_OFFSET;
    static final int[] DIR_Y_OFFSET;
    static final byte MAXIMUM = 1;
    static final byte LISTED = 2;
    static final byte PROCESSED = 4;
    static final byte MAX_AREA = 8;
    static final byte EQUAL = 16;
    static final byte MAX_POINT = 32;
    static final byte ELIMINATED = 64;
    static final byte[] outputTypeMasks;
    static final float SQRT2 = 1.4142135f;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return this.flags;
    }

    @Override
    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.resetBinaryThreshold();
        this.thresholded = imageProcessor.getMinThreshold() != -808080.0;
        GenericDialog genericDialog = new GenericDialog(string);
        int n = imageProcessor instanceof FloatProcessor ? 2 : 0;
        String string2 = imagePlus.getCalibration() != null ? imagePlus.getCalibration().getValueUnit() : null;
        string2 = string2 == null || string2.equals("Gray Value") ? ":" : " (" + string2 + "):";
        genericDialog.addNumericField("Noise tolerance" + string2, tolerance, n);
        genericDialog.addChoice("Output type:", outputTypeNames, outputTypeNames[dialogOutputType]);
        genericDialog.addCheckbox("Exclude edge maxima", excludeOnEdges);
        if (this.thresholded) {
            genericDialog.addCheckbox("Above lower threshold", useMinThreshold);
        }
        genericDialog.addCheckbox("Light background", lightBackground);
        genericDialog.addPreviewCheckbox(plugInFilterRunner, "Preview point selection");
        genericDialog.addMessage("    ");
        this.messageArea = (Label)genericDialog.getMessage();
        genericDialog.addDialogListener(this);
        this.checkboxes = genericDialog.getCheckboxes();
        this.previewing = true;
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#find-maxima");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return 4096;
        }
        this.previewing = false;
        if (!this.dialogItemChanged(genericDialog, null)) {
            return 4096;
        }
        IJ.register(this.getClass());
        return this.flags;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        tolerance = genericDialog.getNextNumber();
        if (tolerance < 0.0) {
            tolerance = 0.0;
        }
        dialogOutputType = genericDialog.getNextChoiceIndex();
        outputType = this.previewing ? 3 : dialogOutputType;
        excludeOnEdges = genericDialog.getNextBoolean();
        useMinThreshold = this.thresholded ? genericDialog.getNextBoolean() : false;
        lightBackground = genericDialog.getNextBoolean();
        boolean bl = this.imp.isInvertedLut();
        if (useMinThreshold && (bl && !lightBackground || !bl && lightBackground)) {
            if (!(this.thresholdWarningShown || IJ.showMessageWithCancel("Find Maxima", "\"Above Lower Threshold\" option cannot be used\nwhen finding minima (image with light background\nor image with dark background and inverting LUT).") || this.previewing)) {
                return false;
            }
            this.thresholdWarningShown = true;
            useMinThreshold = false;
            ((Checkbox)this.checkboxes.elementAt(1)).setState(false);
        }
        if (!genericDialog.getPreviewCheckbox().getState()) {
            this.messageArea.setText("");
        }
        return !genericDialog.invalidNumber();
    }

    @Override
    public void setNPasses(int n) {
        this.nPasses = n;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        Object object;
        Object object2;
        double d;
        Roi roi = this.imp.getRoi();
        if (outputType == 3 && !this.roiSaved) {
            this.imp.saveRoi();
            this.roiSaved = true;
        }
        if (!(roi == null || roi.isArea() && outputType != 2)) {
            this.imp.killRoi();
            roi = null;
        }
        boolean bl = this.imp.isInvertedLut();
        double d2 = d = useMinThreshold ? imageProcessor.getMinThreshold() : -808080.0;
        if (bl && !lightBackground || !bl && lightBackground) {
            d = -808080.0;
            object2 = imageProcessor.getCalibrationTable();
            imageProcessor = imageProcessor.duplicate();
            if (object2 == null) {
                imageProcessor.invert();
            } else {
                object = new float[((float[])object2).length];
                for (int i = ((float[])object2).length - 1; i >= 0; --i) {
                    object[i] = (float)(-object2[i]);
                }
                imageProcessor.setCalibrationTable((float[])object);
            }
            imageProcessor.setRoi(roi);
        }
        object2 = null;
        object2 = this.findMaxima(imageProcessor, tolerance, d, outputType, excludeOnEdges, false);
        if (object2 == null) {
            return;
        }
        if (!Prefs.blackBackground) {
            ((ImageProcessor)object2).invertLut();
        }
        object = outputType == 2 ? (Object)" Segmented" : (Object)" Maxima";
        String string = this.imp.getTitle();
        if (this.imp.getNSlices() > 1) {
            string = string + "(" + this.imp.getCurrentSlice() + ")";
        }
        if (WindowManager.getImage(string = string + (String)object) != null) {
            string = WindowManager.getUniqueName(string);
        }
        ImagePlus imagePlus = new ImagePlus(string, (ImageProcessor)object2);
        Calibration calibration = this.imp.getCalibration().copy();
        calibration.disableDensityCalibration();
        imagePlus.setCalibration(calibration);
        imagePlus.show();
    }

    public ByteProcessor findMaxima(ImageProcessor imageProcessor, double d, double d2, int n, boolean bl, boolean bl2) {
        ByteProcessor byteProcessor;
        float f;
        int n2;
        if (this.dirOffset == null) {
            this.makeDirectionOffsets(imageProcessor);
        }
        Rectangle rectangle = imageProcessor.getRoi();
        byte[] byArray = imageProcessor.getMaskArray();
        if (d2 != -808080.0 && imageProcessor.getCalibrationTable() != null && d2 > 0.0 && d2 < (double)imageProcessor.getCalibrationTable().length) {
            d2 = imageProcessor.getCalibrationTable()[(int)d2];
        }
        ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height);
        byte[] byArray2 = (byte[])byteProcessor2.getPixels();
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        for (n2 = rectangle.y; n2 < rectangle.y + rectangle.height; n2 += 1) {
            for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
                f = imageProcessor.getPixelValue(i, n2);
                if (f2 > f) {
                    f2 = f;
                }
                if (!(f3 < f)) continue;
                f3 = f;
            }
        }
        if (d2 != -808080.0) {
            d2 -= (double)(f3 - f2) * 1.0E-6;
        }
        int n3 = n2 = bl && n != 2 ? 1 : 0;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Getting sorted maxima...");
        long[] lArray = this.getSortedMaxPoints(imageProcessor, byteProcessor2, n2 != 0, bl2, f2, f3, d2);
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Analyzing  maxima...");
        f = 0.0f;
        if (imageProcessor instanceof FloatProcessor) {
            f = 1.1f * (bl2 ? 0.70710677f : (f3 - f2) / 2.0E9f);
        }
        this.analyzeAndMarkMaxima(imageProcessor, byteProcessor2, lArray, n2 != 0, bl2, f2, d, n, f);
        if (n == 3 || n == 4 || n == 5) {
            return null;
        }
        if (n == 2) {
            byteProcessor = this.make8bit(imageProcessor, byteProcessor2, bl2, f2, f3, d2);
            this.cleanupMaxima(byteProcessor, byteProcessor2, lArray);
            if (!this.watershedSegment(byteProcessor)) {
                return null;
            }
            if (!bl2) {
                this.cleanupExtraLines(byteProcessor);
            }
            this.watershedPostProcess(byteProcessor);
            if (bl) {
                this.deleteEdgeParticles(byteProcessor, byteProcessor2);
            }
        } else {
            for (int i = 0; i < this.width * this.height; ++i) {
                byArray2[i] = (byte)((byArray2[i] & outputTypeMasks[n]) != 0 ? 255 : 0);
            }
            byteProcessor = byteProcessor2;
        }
        byte[] byArray3 = (byte[])byteProcessor.getPixels();
        if (rectangle != null) {
            int n4 = 0;
            for (int i = 0; i < byteProcessor.getHeight(); ++i) {
                int n5 = 0;
                while (n5 < byteProcessor.getWidth()) {
                    if (n5 < rectangle.x || n5 >= rectangle.x + rectangle.width || i < rectangle.y || i >= rectangle.y + rectangle.height) {
                        byArray3[n4] = 0;
                    } else if (byArray != null && byArray[n5 - rectangle.x + rectangle.width * (i - rectangle.y)] == 0) {
                        byArray3[n4] = 0;
                    }
                    ++n5;
                    ++n4;
                }
            }
        }
        return byteProcessor;
    }

    long[] getSortedMaxPoints(ImageProcessor imageProcessor, ByteProcessor byteProcessor, boolean bl, boolean bl2, float f, float f2, double d) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle = imageProcessor.getRoi();
        byte[] byArray = (byte[])byteProcessor.getPixels();
        int n4 = 0;
        boolean bl3 = d != -808080.0;
        Thread thread = Thread.currentThread();
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            if (i % 50 == 0 && thread.isInterrupted()) {
                return null;
            }
            int n5 = rectangle.x;
            n3 = n5 + i * this.width;
            while (n5 < rectangle.x + rectangle.width) {
                float f3;
                float f4 = imageProcessor.getPixelValue(n5, i);
                float f5 = f3 = bl2 ? this.trueEdmHeight(n5, i, imageProcessor) : f4;
                if (!(f4 == f || bl && (n5 == 0 || n5 == this.width - 1 || i == 0 || i == this.height - 1) || bl3 && (double)f4 < d)) {
                    n2 = 1;
                    boolean bl4 = i != 0 && i != this.height - 1 && n5 != 0 && n5 != this.width - 1;
                    for (n = 0; n < 8; ++n) {
                        float f6;
                        if (!bl4 && !this.isWithin(n5, i, n)) continue;
                        float f7 = imageProcessor.getPixelValue(n5 + DIR_X_OFFSET[n], i + DIR_Y_OFFSET[n]);
                        float f8 = f6 = bl2 ? this.trueEdmHeight(n5 + DIR_X_OFFSET[n], i + DIR_Y_OFFSET[n], imageProcessor) : f7;
                        if (!(f7 > f4) || !(f6 > f3)) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) {
                        byArray[n3] = 1;
                        ++n4;
                    }
                }
                ++n5;
                ++n3;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        float f9 = (float)(2.0E9 / (double)(f2 - f));
        long[] lArray = new long[n4];
        n3 = 0;
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n6 = rectangle.x;
            n2 = n6 + i * this.width;
            while (n6 < rectangle.x + rectangle.width) {
                if (byArray[n2] == 1) {
                    float f10 = bl2 ? this.trueEdmHeight(n6, i, imageProcessor) : imageProcessor.getPixelValue(n6, i);
                    n = (int)((f10 - f) * f9);
                    lArray[n3++] = (long)n << 32 | (long)n2;
                }
                ++n6;
                ++n2;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        Arrays.sort(lArray);
        return lArray;
    }

    void analyzeAndMarkMaxima(ImageProcessor imageProcessor, ByteProcessor byteProcessor, long[] lArray, boolean bl, boolean bl2, float f, double d, int n, float f2) {
        int n2;
        int n3;
        int n4;
        boolean bl3;
        byte[] byArray = (byte[])byteProcessor.getPixels();
        int n5 = lArray.length;
        int[] nArray = new int[this.width * this.height];
        Vector<int[]> vector = null;
        Roi roi = null;
        boolean bl4 = bl3 = n == 3 || n == 4 || n == 5;
        if (bl3) {
            vector = new Vector<int[]>();
        }
        if (this.imp != null) {
            roi = this.imp.getRoi();
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            boolean bl5;
            if (n4 % 100 == 0 && Thread.currentThread().isInterrupted()) {
                return;
            }
            int n6 = (int)lArray[n4];
            if ((byArray[n6] & 4) != 0) continue;
            n3 = n6 % this.width;
            n2 = n6 / this.width;
            float f3 = bl2 ? this.trueEdmHeight(n3, n2, imageProcessor) : imageProcessor.getPixelValue(n3, n2);
            do {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                nArray[0] = n6;
                int n12 = n6;
                byArray[n12] = (byte)(byArray[n12] | 0x12);
                int n13 = 1;
                int n14 = 0;
                boolean bl6 = n3 == 0 || n3 == this.width - 1 || n2 == 0 || n2 == this.height - 1;
                bl5 = false;
                boolean bl7 = true;
                double d2 = n3;
                double d3 = n2;
                int n15 = 1;
                block2: do {
                    n11 = nArray[n14];
                    int n16 = n11 % this.width;
                    int n17 = n11 / this.width;
                    n10 = n17 != 0 && n17 != this.height - 1 && n16 != 0 && n16 != this.width - 1 ? 1 : 0;
                    for (n9 = 0; n9 < 8; ++n9) {
                        float f4;
                        n8 = n11 + this.dirOffset[n9];
                        if (n10 == 0 && !this.isWithin(n16, n17, n9) || (byArray[n8] & 2) != 0) continue;
                        if ((byArray[n8] & 4) != 0) {
                            bl7 = false;
                            continue block2;
                        }
                        n7 = n16 + DIR_X_OFFSET[n9];
                        int n18 = n17 + DIR_Y_OFFSET[n9];
                        float f5 = f4 = bl2 ? this.trueEdmHeight(n7, n18, imageProcessor) : imageProcessor.getPixelValue(n7, n18);
                        if (f4 > f3 + f2) {
                            bl7 = false;
                            continue block2;
                        }
                        if (!(f4 >= f3 - (float)d)) continue;
                        if (f4 > f3) {
                            bl5 = true;
                            n6 = n8;
                            f3 = f4;
                            n3 = n7;
                            n2 = n18;
                        }
                        nArray[n13] = n8;
                        ++n13;
                        int n19 = n8;
                        byArray[n19] = (byte)(byArray[n19] | 2);
                        if (n7 == 0 || n7 == this.width - 1 || n18 == 0 || n18 == this.height - 1) {
                            bl6 = true;
                            if (bl) {
                                bl7 = false;
                                continue block2;
                            }
                        }
                        if (f4 != f3) continue;
                        int n20 = n8;
                        byArray[n20] = (byte)(byArray[n20] | 0x10);
                        d2 += (double)n7;
                        d3 += (double)n18;
                        ++n15;
                    }
                } while (++n14 < n13);
                if (bl5) {
                    for (n14 = 0; n14 < n13; ++n14) {
                        byArray[nArray[n14]] = 0;
                    }
                } else {
                    n11 = ~(bl7 ? 2 : 18);
                    d2 /= (double)n15;
                    d3 /= (double)n15;
                    double d4 = 1.0E20;
                    n10 = 0;
                    for (n14 = 0; n14 < n13; ++n14) {
                        double d5;
                        n9 = nArray[n14];
                        n8 = n9 % this.width;
                        n7 = n9 / this.width;
                        int n21 = n9;
                        byArray[n21] = (byte)(byArray[n21] & n11);
                        int n22 = n9;
                        byArray[n22] = (byte)(byArray[n22] | 4);
                        if (!bl7) continue;
                        int n23 = n9;
                        byArray[n23] = (byte)(byArray[n23] | 8);
                        if ((byArray[n9] & 0x10) == 0 || !((d5 = (d2 - (double)n8) * (d2 - (double)n8) + (d3 - (double)n7) * (d3 - (double)n7)) < d4)) continue;
                        d4 = d5;
                        n10 = n14;
                    }
                    if (!bl7) continue;
                    int n24 = n9 = nArray[n10];
                    byArray[n24] = (byte)(byArray[n24] | 0x20);
                    if (!bl3) continue;
                    if (excludeOnEdges && bl6) continue;
                    n8 = n9 % this.width;
                    n7 = n9 / this.width;
                    if (roi != null && !roi.contains(n8, n7)) continue;
                    vector.addElement(new int[]{n8, n7});
                }
            } while (bl5);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (bl3 && vector != null) {
            n4 = vector.size();
            if (n == 3 && n4 > 0 && this.imp != null) {
                int[] nArray2 = new int[n4];
                int[] nArray3 = new int[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    int[] nArray4 = (int[])vector.elementAt(n2);
                    nArray2[n2] = nArray4[0];
                    nArray3[n2] = nArray4[1];
                }
                PointRoi pointRoi = new PointRoi(nArray2, nArray3, n4);
                pointRoi.setHideLabels(true);
                this.imp.setRoi(pointRoi);
            } else if (n == 4) {
                Analyzer.resetCounter();
                ResultsTable resultsTable = ResultsTable.getResultsTable();
                for (n3 = 0; n3 < n4; ++n3) {
                    int[] nArray5 = (int[])vector.elementAt(n3);
                    resultsTable.incrementCounter();
                    resultsTable.addValue("X", (double)nArray5[0]);
                    resultsTable.addValue("Y", (double)nArray5[1]);
                }
                resultsTable.show("Results");
            } else if (n == 5) {
                ResultsTable resultsTable = ResultsTable.getResultsTable();
                resultsTable.incrementCounter();
                resultsTable.setValue("Count", resultsTable.getCounter() - 1, (double)n4);
                resultsTable.show("Results");
            }
        }
        if (this.previewing) {
            this.messageArea.setText((vector == null ? 0 : vector.size()) + " Maxima");
        }
    }

    ByteProcessor make8bit(ImageProcessor imageProcessor, ByteProcessor byteProcessor, boolean bl, float f, float f2, double d) {
        double d2;
        byte[] byArray = (byte[])byteProcessor.getPixels();
        if (bl) {
            d = 0.5;
            d2 = 1.0;
        } else {
            d2 = d == -808080.0 ? (double)f : d;
        }
        double d3 = d2 - ((double)f2 - d2) * 0.001975284584980237;
        double d4 = 253.0 / ((double)f2 - d2);
        if (bl && d4 > 1.0) {
            d4 = 1.0;
        }
        ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height);
        byte[] byArray2 = (byte[])byteProcessor2.getPixels();
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            int n2 = 0;
            while (n2 < this.width) {
                long l;
                float f3 = imageProcessor.getPixelValue(n2, i);
                byArray2[n] = d != -808080.0 && (double)f3 < d ? 0 : ((byArray[n] & 8) != 0 ? -1 : ((l = 1L + Math.round(((double)f3 - d3) * d4)) < 1L ? 1 : (l <= 254L ? (int)((int)(l & 0xFFL)) : -2)));
                ++n2;
                ++n;
            }
        }
        return byteProcessor2;
    }

    float trueEdmHeight(int n, int n2, ImageProcessor imageProcessor) {
        int n3 = this.width - 1;
        int n4 = imageProcessor.getHeight() - 1;
        float[] fArray = (float[])imageProcessor.getPixels();
        int n5 = n + n2 * this.width;
        float f = fArray[n5];
        if (n == 0 || n2 == 0 || n == n3 || n2 == n4 || f == 0.0f) {
            return f;
        }
        float f2 = f + 0.70710677f;
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            float f3;
            int n6 = (i + 4) % 8;
            float f4 = fArray[n5 + this.dirOffset[i]];
            float f5 = fArray[n5 + this.dirOffset[n6]];
            if (f >= f4 && f >= f5) {
                bl = true;
                f3 = (f4 + f5) / 2.0f;
            } else {
                f3 = Math.min(f4, f5);
            }
            f3 += i % 2 == 0 ? 1.0f : 1.4142135f;
            if (!(f2 > f3)) continue;
            f2 = f3;
        }
        if (!bl) {
            f2 = f;
        }
        return f2;
    }

    void cleanupMaxima(ByteProcessor byteProcessor, ByteProcessor byteProcessor2, long[] lArray) {
        byte[] byArray = (byte[])byteProcessor.getPixels();
        byte[] byArray2 = (byte[])byteProcessor2.getPixels();
        int n = lArray.length;
        int[] nArray = new int[this.width * this.height];
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            int n3 = (int)lArray[i];
            if ((byArray2[n3] & 0x48) != 0) continue;
            int n4 = byArray[n3] & 0xFF;
            int n5 = n4 + 1;
            nArray[0] = n3;
            int n6 = n3;
            byArray2[n6] = (byte)(byArray2[n6] | 2);
            int n7 = 1;
            int n8 = 1;
            int n9 = 0;
            boolean bl = false;
            while (!bl && n5 > 0) {
                --n5;
                n8 = n7;
                n9 = 0;
                block2: do {
                    n2 = nArray[n9];
                    int n10 = n2 % this.width;
                    int n11 = n2 / this.width;
                    boolean bl2 = n11 != 0 && n11 != this.height - 1 && n10 != 0 && n10 != this.width - 1;
                    for (int j = 0; j < 8; ++j) {
                        int n12 = n2 + this.dirOffset[j];
                        if (!bl2 && !this.isWithin(n10, n11, j) || (byArray2[n12] & 2) != 0) continue;
                        if ((byArray2[n12] & 8) != 0 || (byArray2[n12] & 0x40) != 0 && (byArray[n12] & 0xFF) >= n5) {
                            bl = true;
                            continue block2;
                        }
                        if ((byArray[n12] & 0xFF) < n5 || (byArray2[n12] & 0x40) != 0) continue;
                        nArray[n7] = n12;
                        ++n7;
                        int n13 = n12;
                        byArray2[n13] = (byte)(byArray2[n13] | 2);
                    }
                } while (!bl && ++n9 < n7);
            }
            for (n9 = 0; n9 < n7; ++n9) {
                int n14 = nArray[n9];
                byArray2[n14] = (byte)(byArray2[n14] & 0xFFFFFFFD);
            }
            for (n9 = 0; n9 < n8; ++n9) {
                n2 = nArray[n9];
                byArray[n2] = (byte)n5;
                int n15 = n2;
                byArray2[n15] = (byte)(byArray2[n15] | 0x40);
            }
        }
    }

    void cleanupExtraLines(ImageProcessor imageProcessor) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            int n2 = 0;
            while (n2 < this.width) {
                byte by = byArray[n];
                if (by != -1 && by != 0) {
                    int n3 = this.nRadii(byArray, n2, i);
                    if (n3 == 0) {
                        byArray[n] = -1;
                    } else if (n3 == 1) {
                        this.removeLineFrom(byArray, n2, i);
                    }
                }
                ++n2;
                ++n;
            }
        }
    }

    void removeLineFrom(byte[] byArray, int n, int n2) {
        boolean bl;
        byArray[n + this.width * n2] = -1;
        block0: do {
            bl = false;
            boolean bl2 = n2 != 0 && n2 != this.height - 1 && n != 0 && n != this.width - 1;
            for (int i = 0; i < 8; i += 2) {
                int n3;
                byte by;
                if (!bl2 && !this.isWithin(n, n2, i) || (by = byArray[n + this.width * n2 + this.dirOffset[i]]) == -1 || by == 0 || (n3 = this.nRadii(byArray, n + DIR_X_OFFSET[i], n2 + DIR_Y_OFFSET[i])) > 1) continue;
                byArray[(n += MaximumFinder.DIR_X_OFFSET[i]) + this.width * (n2 += MaximumFinder.DIR_Y_OFFSET[i])] = -1;
                bl = n3 == 1;
                continue block0;
            }
        } while (bl);
    }

    int nRadii(byte[] byArray, int n, int n2) {
        int n3 = n + n2 * this.width;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = n2 != 0 && n2 != this.height - 1 && n != 0 && n != this.width - 1;
        for (int i = 0; i < 8; ++i) {
            boolean bl4 = bl;
            if (bl3 || this.isWithin(n, n2, i)) {
                boolean bl5;
                boolean bl6 = bl5 = byArray[n3 + this.dirOffset[i]] != -1;
                if ((i & 1) == 0) {
                    bl4 = bl5;
                } else if (!bl5) {
                    bl4 = false;
                }
            } else {
                bl4 = true;
            }
            if (bl4 && !bl) {
                ++n4;
            }
            bl = bl4;
            if (i != 0) continue;
            bl2 = bl4;
        }
        if (bl2 && !bl) {
            ++n4;
        }
        return n4;
    }

    private void watershedPostProcess(ImageProcessor imageProcessor) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth() * imageProcessor.getHeight();
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) >= 255) continue;
            byArray[i] = 0;
        }
    }

    void deleteEdgeParticles(ByteProcessor byteProcessor, ByteProcessor byteProcessor2) {
        int n;
        int n2;
        byte[] byArray = (byte[])byteProcessor.getPixels();
        byte[] byArray2 = (byte[])byteProcessor2.getPixels();
        this.width = byteProcessor.getWidth();
        this.height = byteProcessor.getHeight();
        byteProcessor.setValue(0.0);
        Wand wand = new Wand(byteProcessor);
        for (n2 = 0; n2 < this.width; ++n2) {
            n = 0;
            if ((byArray2[n2 + n * this.width] & 8) != 0 && byArray[n2 + n * this.width] != 0) {
                this.deleteParticle(n2, n, byteProcessor, wand);
            }
            if ((byArray2[n2 + (n = this.height - 1) * this.width] & 8) == 0 || byArray[n2 + n * this.width] == 0) continue;
            this.deleteParticle(n2, n, byteProcessor, wand);
        }
        for (n2 = 1; n2 < this.height - 1; ++n2) {
            n = 0;
            if ((byArray2[n + n2 * this.width] & 8) != 0 && byArray[n + n2 * this.width] != 0) {
                this.deleteParticle(n, n2, byteProcessor, wand);
            }
            if ((byArray2[(n = this.width - 1) + n2 * this.width] & 8) == 0 || byArray[n + n2 * this.width] == 0) continue;
            this.deleteParticle(n, n2, byteProcessor, wand);
        }
    }

    void deleteParticle(int n, int n2, ByteProcessor byteProcessor, Wand wand) {
        wand.autoOutline(n, n2, 255, 255);
        if (wand.npoints == 0) {
            IJ.log("wand error selecting edge particle at x, y = " + n + ", " + n2);
            return;
        }
        PolygonRoi polygonRoi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 4);
        byteProcessor.snapshot();
        byteProcessor.setRoi(polygonRoi);
        byteProcessor.fill();
        byteProcessor.reset(byteProcessor.getMask());
    }

    private boolean watershedSegment(ByteProcessor byteProcessor) {
        int n;
        boolean bl = IJ.debugMode;
        ImageStack imageStack = null;
        if (bl) {
            imageStack = new ImageStack(byteProcessor.getWidth(), byteProcessor.getHeight());
            imageStack.addSlice("pre-watershed EDM", byteProcessor.duplicate());
        }
        byte[] byArray = (byte[])byteProcessor.getPixels();
        int[] nArray = byteProcessor.getHistogram();
        int n2 = this.width * this.height - nArray[0] - nArray[255];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray3 = new int[256];
        for (int i = 1; i < 255; ++i) {
            nArray3[i] = n5;
            n5 += nArray[i];
            if (nArray[i] > 0) {
                n3 = i;
            }
            if (nArray[i] <= n4) continue;
            n4 = nArray[i];
        }
        int[] nArray4 = new int[n3 + 1];
        int n6 = 0;
        for (int i = 0; i < this.height; ++i) {
            int n7 = 0;
            while (n7 < this.width) {
                n = byArray[n6] & 0xFF;
                if (n > 0 && n < 255) {
                    n5 = nArray3[n] + nArray4[n];
                    nArray2[n5] = n7 | i << this.intEncodeShift;
                    int n8 = n;
                    nArray4[n8] = nArray4[n8] + 1;
                }
                ++n7;
                ++n6;
            }
        }
        int[] nArray5 = new int[Math.min(n4, (this.width * this.height + 2) / 3)];
        int[] nArray6 = this.makeFateTable();
        IJ.showStatus("Segmenting (Esc to cancel)");
        int[] nArray7 = new int[]{7, 3, 1, 5, 0, 4, 2, 6};
        for (n = n3; n >= 1; --n) {
            int n9;
            int n10;
            int n11;
            int n12 = nArray[n];
            int n13 = 0;
            while (n12 > 0 && n13 < 8) {
                n11 = 0;
                n10 = 0;
                do {
                    n9 = this.processLevel(nArray7[n10 % 8], byteProcessor, nArray6, nArray3[n], n12, nArray2, nArray5);
                    n12 -= n9;
                    n11 += n9;
                    if (n9 > 0) {
                        n13 = 0;
                    }
                    ++n10;
                } while (n12 > 0 && n13++ < 8);
                this.addProgress((double)n11 / (double)n2);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                IJ.showProgress(1.0);
                return false;
            }
            if (n12 > 0 && n > 1) {
                n11 = n;
                while (--n11 > 1 && nArray[n11] == 0) {
                }
                if (n11 > 0) {
                    n10 = nArray3[n11] + nArray[n11];
                    n9 = 0;
                    int n14 = nArray3[n];
                    while (n9 < n12) {
                        int n15 = nArray2[n14];
                        int n16 = n15 & this.intEncodeXMask;
                        int n17 = (n15 & this.intEncodeYMask) >> this.intEncodeShift;
                        int n18 = n16 + n17 * this.width;
                        if ((byArray[n18] & 0xFF) == 255) {
                            IJ.log("ERROR");
                        }
                        boolean bl2 = false;
                        if (n16 == 0 || n17 == 0 || n16 == this.width - 1 || n17 == this.height - 1) {
                            bl2 = true;
                        } else {
                            for (int i = 0; i < 8; ++i) {
                                if (!this.isWithin(n16, n17, i) || byArray[n18 + this.dirOffset[i]] != 0) continue;
                                bl2 = true;
                                break;
                            }
                        }
                        if (bl2) {
                            nArray2[n10++] = n15;
                        }
                        ++n9;
                        ++n14;
                    }
                    nArray[n11] = n10 - nArray3[n11];
                }
            }
            if (!bl || n <= 170 && (n <= 100 || n >= 110) && n >= 10) continue;
            imageStack.addSlice("level " + n, byteProcessor.duplicate());
        }
        if (bl) {
            new ImagePlus("Segmentation Movie", imageStack).show();
        }
        return true;
    }

    private int processLevel(int n, ImageProcessor imageProcessor, int[] nArray, int n2, int n3, int[] nArray2, int[] nArray3) {
        int n4 = this.width - 1;
        int n5 = this.height - 1;
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n2;
        while (n8 < n3) {
            int n10;
            int n11 = nArray2[n9];
            int n12 = n11 & this.intEncodeXMask;
            int n13 = (n11 & this.intEncodeYMask) >> this.intEncodeShift;
            int n14 = n12 + n13 * this.width;
            int n15 = 0;
            if (n13 > 0 && (byArray[n14 - this.width] & 0xFF) == 255) {
                n15 ^= 1;
            }
            if (n12 < n4 && n13 > 0 && (byArray[n14 - this.width + 1] & 0xFF) == 255) {
                n15 ^= 2;
            }
            if (n12 < n4 && (byArray[n14 + 1] & 0xFF) == 255) {
                n15 ^= 4;
            }
            if (n12 < n4 && n13 < n5 && (byArray[n14 + this.width + 1] & 0xFF) == 255) {
                n15 ^= 8;
            }
            if (n13 < n5 && (byArray[n14 + this.width] & 0xFF) == 255) {
                n15 ^= 0x10;
            }
            if (n12 > 0 && n13 < n5 && (byArray[n14 + this.width - 1] & 0xFF) == 255) {
                n15 ^= 0x20;
            }
            if (n12 > 0 && (byArray[n14 - 1] & 0xFF) == 255) {
                n15 ^= 0x40;
            }
            if (n12 > 0 && n13 > 0 && (byArray[n14 - this.width - 1] & 0xFF) == 255) {
                n15 ^= 0x80;
            }
            if ((nArray[n15] & (n10 = 1 << n)) == n10) {
                nArray3[n6++] = n14;
            } else {
                nArray2[n2 + n7++] = n11;
            }
            ++n8;
            ++n9;
        }
        for (n8 = 0; n8 < n6; ++n8) {
            byArray[nArray3[n8]] = -1;
        }
        return n6;
    }

    private int[] makeFateTable() {
        int[] nArray = new int[256];
        boolean[] blArray = new boolean[8];
        for (int i = 0; i < 256; ++i) {
            int n;
            int n2 = 1;
            for (n = 0; n < 8; ++n) {
                blArray[n] = (i & n2) == n2;
                n2 *= 2;
            }
            n2 = 1;
            for (n = 0; n < 8; ++n) {
                if (blArray[(n + 4) % 8]) {
                    int n3 = i;
                    nArray[n3] = nArray[n3] | n2;
                }
                n2 *= 2;
            }
            for (n = 0; n < 8; n += 2) {
                if (!blArray[n]) continue;
                blArray[(n + 1) % 8] = true;
                blArray[(n + 7) % 8] = true;
            }
            n = 0;
            boolean bl = true;
            for (n2 = 0; n2 < 8; ++n2) {
                if (blArray[n2] == blArray[(n2 + 1) % 8]) continue;
                ++n;
            }
            if (n < 4) continue;
            nArray[i] = 0;
        }
        return nArray;
    }

    void makeDirectionOffsets(ImageProcessor imageProcessor) {
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        int n = 0;
        int n2 = 1;
        do {
            ++n;
        } while ((n2 *= 2) < this.width);
        this.intEncodeXMask = n2 - 1;
        this.intEncodeYMask = ~this.intEncodeXMask;
        this.intEncodeShift = n;
        this.dirOffset = new int[]{-this.width, -this.width + 1, 1, this.width + 1, this.width, this.width - 1, -1, -this.width - 1};
    }

    boolean isWithin(int n, int n2, int n3) {
        int n4 = this.width - 1;
        int n5 = this.height - 1;
        switch (n3) {
            case 0: {
                return n2 > 0;
            }
            case 1: {
                return n < n4 && n2 > 0;
            }
            case 2: {
                return n < n4;
            }
            case 3: {
                return n < n4 && n2 < n5;
            }
            case 4: {
                return n2 < n5;
            }
            case 5: {
                return n > 0 && n2 < n5;
            }
            case 6: {
                return n > 0;
            }
            case 7: {
                return n > 0 && n2 > 0;
            }
        }
        return false;
    }

    private void addProgress(double d) {
        if (this.nPasses == 0) {
            return;
        }
        this.progressDone += d;
        IJ.showProgress(this.progressDone / (double)this.nPasses);
    }

    static {
        dialogOutputType = 3;
        outputTypeNames = new String[]{"Single Points", "Maxima Within Tolerance", "Segmented Particles", "Point Selection", "List", "Count"};
        DIR_X_OFFSET = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        DIR_Y_OFFSET = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
        outputTypeMasks = new byte[]{32, 8, 8};
    }
}

