/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.ImageProperties;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class Printer
implements PlugInFilter,
Printable {
    private ImagePlus imp;
    private static double scaling = 100.0;
    private static boolean drawBorder;
    private static boolean center;
    private static boolean label;
    private static boolean printSelection;
    private static boolean rotate;
    private static boolean actualSize;
    private static int fontSize;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        if (string.equals("setup")) {
            this.pageSetup();
            return 4096;
        }
        this.imp = imagePlus;
        IJ.register(Printer.class);
        return 159;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        this.print(this.imp);
    }

    void pageSetup() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Roi roi = imagePlus != null ? imagePlus.getRoi() : null;
        boolean bl = roi != null && roi.isArea();
        GenericDialog genericDialog = new GenericDialog("Page Setup");
        genericDialog.addNumericField("Scale:", scaling, 0, 3, "%");
        genericDialog.addCheckbox("Draw border", drawBorder);
        genericDialog.addCheckbox("Center on page", center);
        genericDialog.addCheckbox("Print title", label);
        if (bl) {
            genericDialog.addCheckbox("Selection only", printSelection);
        }
        genericDialog.addCheckbox("Rotate 90\u00b0", rotate);
        genericDialog.addCheckbox("Print_actual size", actualSize);
        if (imagePlus != null) {
            genericDialog.enableYesNoCancel(" OK ", "Print");
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        scaling = genericDialog.getNextNumber();
        if (scaling < 5.0) {
            scaling = 5.0;
        }
        drawBorder = genericDialog.getNextBoolean();
        center = genericDialog.getNextBoolean();
        label = genericDialog.getNextBoolean();
        printSelection = bl ? genericDialog.getNextBoolean() : false;
        rotate = genericDialog.getNextBoolean();
        actualSize = genericDialog.getNextBoolean();
        if (!genericDialog.wasOKed() && imagePlus != null) {
            this.imp = imagePlus;
            this.print(imagePlus);
        }
    }

    void print(ImagePlus imagePlus) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (IJ.macroRunning() || printerJob.printDialog()) {
            imagePlus.startTiming();
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                IJ.log("" + printerException);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Roi roi = this.imp.getRoi();
        ImagePlus imagePlus = this.imp;
        if (imagePlus.getOverlay() != null && !imagePlus.getHideOverlay()) {
            imagePlus.killRoi();
            imagePlus = imagePlus.flatten();
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (printSelection && roi != null && roi.isArea()) {
            imageProcessor.setRoi(roi);
        }
        imageProcessor = imageProcessor.crop();
        if (rotate) {
            imageProcessor = imageProcessor.rotateLeft();
        }
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = 0;
        if (drawBorder) {
            n4 = 1;
        }
        double d = scaling / 100.0;
        int n5 = (int)((double)n2 * d);
        int n6 = (int)((double)n3 * d);
        int n7 = (int)pageFormat.getImageableX();
        int n8 = (int)pageFormat.getImageableY();
        int n9 = n7 + n4;
        int n10 = n8 + n4;
        Image image = imageProcessor.createImage();
        double d2 = pageFormat.getImageableWidth() - (double)(2 * n4);
        double d3 = pageFormat.getImageableHeight() - (double)(2 * n4);
        if (label && d2 - (double)n5 < (double)(fontSize + 5)) {
            n10 += fontSize + 5;
            d3 -= (double)(fontSize + 5);
        }
        if (actualSize) {
            Calibration calibration = this.imp.getCalibration();
            int n11 = ImageProperties.getUnitIndex(calibration.getUnit());
            if (n11 != 10) {
                double d4 = ImageProperties.getUnitsPerCm(n11);
                double d5 = (double)n2 * calibration.pixelWidth / d4;
                double d6 = (double)n3 * calibration.pixelHeight / d4;
                n5 = (int)(d5 * 28.3464 * d);
                n6 = (int)(d6 * 28.3464 * d);
            }
            if (center && (double)n5 < d2 && (double)n6 < d3) {
                n9 = (int)((double)n9 + (d2 - (double)n5) / 2.0);
                n10 = (int)((double)n10 + (d3 - (double)n6) / 2.0);
            }
        } else if ((double)n5 > d2 || (double)n6 > d3) {
            double d7 = d2 / (double)n5;
            double d8 = d3 / (double)n6;
            double d9 = d7 <= d8 ? d7 : d8;
            n5 = (int)((double)n5 * d9);
            n6 = (int)((double)n6 * d9);
        } else if (center) {
            n9 = (int)((double)n9 + (d2 - (double)n5) / 2.0);
            n10 = (int)((double)n10 + (d3 - (double)n6) / 2.0);
        }
        graphics.drawImage(image, n9, n10, n9 + n5, n10 + n6, 0, 0, n2, n3, null);
        if (drawBorder) {
            graphics.drawRect(n9 - 1, n10 - 1, n5 + 1, n6 + 1);
        }
        if (label) {
            graphics.setFont(new Font("SanSerif", 0, fontSize));
            graphics.setColor(Color.black);
            graphics.drawString(this.imp.getTitle(), n7 + 5, n8 + fontSize);
        }
        return 0;
    }

    static {
        center = true;
        fontSize = 12;
    }
}

