/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.gui.ProfilePlot;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Dimension;

public class Profiler
implements PlugInFilter {
    ImagePlus imp;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        if (string.equals("set")) {
            this.doOptions();
            return 4096;
        }
        this.imp = imagePlus;
        return 1439;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        boolean bl = Prefs.verticalProfile || IJ.altKeyDown();
        new ProfilePlot(this.imp, bl).createWindow();
    }

    public void doOptions() {
        boolean bl;
        double d = ProfilePlot.getFixedMin();
        double d2 = ProfilePlot.getFixedMax();
        boolean bl2 = bl = d != 0.0 || d2 != 0.0;
        GenericDialog genericDialog = new GenericDialog("Profile Plot Options", IJ.getInstance());
        genericDialog.addNumericField("Width (pixels):", PlotWindow.plotWidth, 0);
        genericDialog.addNumericField("Height (pixels):", PlotWindow.plotHeight, 0);
        genericDialog.addNumericField("Minimum Y:", d, 2);
        genericDialog.addNumericField("Maximum Y:", d2, 2);
        genericDialog.addCheckbox("Fixed y-axis scale", bl);
        genericDialog.addCheckbox("Do not save x-values", !PlotWindow.saveXValues);
        genericDialog.addCheckbox("Auto-close", PlotWindow.autoClose);
        genericDialog.addCheckbox("Vertical profile", Prefs.verticalProfile);
        genericDialog.addCheckbox("List values", PlotWindow.listValues);
        genericDialog.addCheckbox("Interpolate line profiles", PlotWindow.interpolate);
        genericDialog.addCheckbox("Draw grid lines", !PlotWindow.noGridLines);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#plot-options");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        Dimension dimension = IJ.getScreenSize();
        int n = (int)genericDialog.getNextNumber();
        int n2 = (int)genericDialog.getNextNumber();
        if (n < 100) {
            n = 100;
        }
        if (n > dimension.width - 140) {
            n = dimension.width - 140;
        }
        if (n2 < 50) {
            n2 = 50;
        }
        if (n2 > dimension.height - 300) {
            n2 = dimension.height - 300;
        }
        PlotWindow.plotWidth = n;
        PlotWindow.plotHeight = n2;
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        bl = genericDialog.getNextBoolean();
        PlotWindow.saveXValues = !genericDialog.getNextBoolean();
        PlotWindow.autoClose = genericDialog.getNextBoolean();
        Prefs.verticalProfile = genericDialog.getNextBoolean();
        PlotWindow.listValues = genericDialog.getNextBoolean();
        PlotWindow.interpolate = genericDialog.getNextBoolean();
        boolean bl3 = PlotWindow.noGridLines = !genericDialog.getNextBoolean();
        if (!(bl || bl2 || d == 0.0 && d2 == 0.0)) {
            bl = true;
        }
        if (!bl) {
            d = 0.0;
            d2 = 0.0;
        } else if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        ProfilePlot.setMinAndMax(d, d2);
        IJ.register(Profiler.class);
    }
}

