/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class Rotator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32863;
    private static double angle = 15.0;
    private static boolean fillWithBackground;
    private static boolean enlarge;
    private static int gridLines;
    private ImagePlus imp;
    private int bitDepth;
    private boolean canEnlarge;
    private boolean isEnlarged;
    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private static int interpolationMethod;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus != null) {
            this.bitDepth = imagePlus.getBitDepth();
            Roi roi = imagePlus.getRoi();
            Rectangle rectangle = roi != null ? roi.getBounds() : null;
            this.canEnlarge = rectangle == null || rectangle.x == 0 && rectangle.y == 0 && rectangle.width == imagePlus.getWidth() && rectangle.height == imagePlus.getHeight();
        }
        return this.flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ImageProcessor imageProcessor) {
        if (enlarge && this.gd.wasOKed()) {
            Rotator rotator = this;
            synchronized (rotator) {
                if (!this.isEnlarged) {
                    this.enlargeCanvas();
                    this.isEnlarged = true;
                }
            }
        }
        if (this.isEnlarged) {
            int n = this.pfr.getSliceNumber();
            imageProcessor = this.imp.getStackSize() == 1 ? this.imp.getProcessor() : this.imp.getStack().getProcessor(n);
        }
        imageProcessor.setInterpolationMethod(interpolationMethod);
        if (fillWithBackground) {
            Color color = Toolbar.getBackgroundColor();
            if (this.bitDepth == 8) {
                imageProcessor.setBackgroundValue(imageProcessor.getBestIndex(color));
            } else if (this.bitDepth == 24) {
                imageProcessor.setBackgroundValue(color.getRGB());
            }
        } else {
            imageProcessor.setBackgroundValue(0.0);
        }
        imageProcessor.rotate(angle);
        if (!this.gd.wasOKed()) {
            this.drawGridLines(gridLines);
        }
        if (this.isEnlarged && this.imp.getStackSize() == 1) {
            this.imp.changes = true;
            this.imp.updateAndDraw();
            Undo.setup(5, this.imp);
        }
    }

    void enlargeCanvas() {
        this.imp.unlock();
        if (this.imp.getStackSize() == 1) {
            Undo.setup(4, this.imp);
        }
        IJ.run("Select All");
        IJ.run("Rotate...", "angle=" + angle);
        Roi roi = this.imp.getRoi();
        Rectangle rectangle = roi.getBounds();
        if (rectangle.width < this.imp.getWidth()) {
            rectangle.width = this.imp.getWidth();
        }
        if (rectangle.height < this.imp.getHeight()) {
            rectangle.height = this.imp.getHeight();
        }
        IJ.showStatus("Rotate: Enlarging...");
        IJ.run("Canvas Size...", "width=" + rectangle.width + " height=" + rectangle.height + " position=Center " + (fillWithBackground ? "" : "zero"));
        IJ.showStatus("Rotating...");
    }

    void drawGridLines(int n) {
        ImageCanvas imageCanvas = this.imp.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        if (n == 0) {
            imageCanvas.setDisplayList(null);
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        float f = this.imp.getWidth();
        float f2 = this.imp.getHeight();
        float f3 = f / (float)n;
        float f4 = f2 / (float)n;
        float f5 = f3 / 2.0f;
        float f6 = f4 / 2.0f;
        for (int i = 0; i < n; ++i) {
            generalPath.moveTo(f5 + f3 * (float)i, 0.0f);
            generalPath.lineTo(f5 + f3 * (float)i, f2);
            generalPath.moveTo(0.0f, f6 + f4 * (float)i);
            generalPath.lineTo(f, f6 + f4 * (float)i);
        }
        imageCanvas.setDisplayList(generalPath, null, null);
    }

    @Override
    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        this.pfr = plugInFilterRunner;
        String string2 = Macro.getOptions();
        if (string2 != null) {
            if (string2.indexOf(" interpolate") != -1) {
                string2.replaceAll(" interpolate", " interpolation=Bilinear");
            } else if (string2.indexOf(" interpolation=") == -1) {
                string2 = string2 + " interpolation=None";
            }
            Macro.setOptions(string2);
        }
        this.gd = new GenericDialog("Rotate", IJ.getInstance());
        this.gd.addNumericField("Angle (degrees):", angle, (double)((int)angle) == angle ? 1 : 2);
        this.gd.addNumericField("Grid Lines:", gridLines, 0);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        if (this.bitDepth == 8 || this.bitDepth == 24) {
            this.gd.addCheckbox("Fill with Background Color", fillWithBackground);
        }
        if (this.canEnlarge) {
            this.gd.addCheckbox("Enlarge Image to Fit Result", enlarge);
        } else {
            enlarge = false;
        }
        this.gd.addPreviewCheckbox(plugInFilterRunner);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        this.drawGridLines(0);
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        if (!enlarge) {
            this.flags |= 0x1000000;
        } else if (imagePlus.getStackSize() == 1) {
            this.flags |= 0x80;
        }
        return IJ.setupDialog(imagePlus, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        angle = genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            if (genericDialog.wasOKed()) {
                IJ.error("Angle is invalid.");
            }
            return false;
        }
        gridLines = (int)genericDialog.getNextNumber();
        interpolationMethod = genericDialog.getNextChoiceIndex();
        if (this.bitDepth == 8 || this.bitDepth == 24) {
            fillWithBackground = genericDialog.getNextBoolean();
        }
        if (this.canEnlarge) {
            enlarge = genericDialog.getNextBoolean();
        }
        return true;
    }

    @Override
    public void setNPasses(int n) {
    }

    static {
        gridLines = 1;
        interpolationMethod = 1;
    }
}

