/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.Roi;
import ij.io.FileOpener;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.SetScaleDialog;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Panel;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(ScaleDialog.class);
        return 159;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        String string = "pixel";
        boolean bl = this.imp.getGlobalCalibration() != null;
        Calibration calibration = this.imp.getCalibration();
        Calibration calibration2 = calibration.copy();
        boolean bl2 = calibration.scaled();
        String string2 = "0.00";
        String string3 = "<no scale>";
        int n = 2;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi instanceof Line) {
            d = ((Line)roi).getRawLength();
            string2 = IJ.d2s(d, 2);
        }
        if (bl2) {
            if (d != 0.0) {
                d2 = d * calibration.pixelWidth;
            } else {
                d = 1.0 / calibration.pixelWidth;
                d2 = 1.0;
            }
            double d4 = d / d2;
            n = Tools.getDecimalPlaces(d4, d4);
            string = calibration.getUnit();
            string3 = IJ.d2s(d4, n) + " pixels/" + string;
            d3 = calibration.pixelHeight / calibration.pixelWidth;
        }
        n = Tools.getDecimalPlaces(d, d);
        int n2 = d3 == 1.0 ? 1 : 3;
        SetScaleDialog setScaleDialog = new SetScaleDialog("Set Scale", string3, string2);
        setScaleDialog.addNumericField("Distance in pixels:", d, n, 8, null);
        setScaleDialog.addNumericField("Known distance:", d2, 2, 8, null);
        setScaleDialog.addNumericField("Pixel aspect ratio:", d3, n2, 8, null);
        setScaleDialog.addStringField("Unit of length:", string);
        setScaleDialog.addPanel(this.makeButtonPanel(setScaleDialog), 13, new Insets(5, 0, 0, 0));
        setScaleDialog.setInsets(0, 30, 0);
        setScaleDialog.addCheckbox("Global", bl);
        setScaleDialog.setInsets(10, 0, 0);
        setScaleDialog.addMessage("Scale: 12345.789 pixels per centimeter");
        setScaleDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#scale");
        setScaleDialog.showDialog();
        if (setScaleDialog.wasCanceled()) {
            return;
        }
        d = setScaleDialog.getNextNumber();
        d2 = setScaleDialog.getNextNumber();
        d3 = setScaleDialog.getNextNumber();
        string = setScaleDialog.getNextString();
        if (string.equals("A")) {
            string = "\u00c5";
        }
        boolean bl3 = setScaleDialog.getNextBoolean();
        if (d == d2 && string.equals("unit")) {
            string = "pixel";
        }
        if (d <= 0.0 || d2 <= 0.0 || string.startsWith("pixel") || string.startsWith("Pixel") || string.equals("")) {
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
            calibration.pixelDepth = 1.0;
            calibration.setUnit("pixel");
        } else {
            if (setScaleDialog.scaleChanged || IJ.macroRunning()) {
                calibration.pixelDepth = calibration.pixelWidth = d2 / d;
            }
            calibration.pixelHeight = d3 != 0.0 ? calibration.pixelWidth * d3 : calibration.pixelWidth;
            calibration.setUnit(string);
        }
        if (!calibration.equals(calibration2)) {
            this.imp.setCalibration(calibration);
        }
        this.imp.setGlobalCalibration(bl3 ? calibration : null);
        if (bl3 || bl3 != bl) {
            WindowManager.repaintImageWindows();
        } else {
            this.imp.repaintWindow();
        }
        if (bl3 && bl3 != bl) {
            FileOpener.setShowConflictMessage(true);
        }
    }

    Panel makeButtonPanel(SetScaleDialog setScaleDialog) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        setScaleDialog.unscaleButton = new Button("Click to Remove Scale");
        setScaleDialog.unscaleButton.addActionListener(setScaleDialog);
        panel.add(setScaleDialog.unscaleButton);
        return panel;
    }
}

