/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class XYWriter
implements PlugInFilter {
    ImagePlus imp;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 1183;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        try {
            this.saveXYCoordinates(this.imp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IJ.error("XYWriter", illegalArgumentException.getMessage());
        }
    }

    public void saveXYCoordinates(ImagePlus imagePlus) {
        Object object;
        Object object2;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        if (!(roi instanceof PolygonRoi)) {
            throw new IllegalArgumentException("Irregular area or line selection required");
        }
        SaveDialog saveDialog = new SaveDialog("Save Coordinates as Text...", imagePlus.getTitle(), ".txt");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            object2 = new FileOutputStream(string2 + string);
            object = new BufferedOutputStream((OutputStream)object2);
            printWriter = new PrintWriter((OutputStream)object);
        }
        catch (IOException iOException) {
            IJ.error("XYWriter", "" + iOException);
            return;
        }
        object2 = roi.getBounds();
        object = (PolygonRoi)roi;
        int n = ((PolygonRoi)object).getNCoordinates();
        int[] nArray = ((PolygonRoi)object).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)object).getYCoordinates();
        Calibration calibration = imagePlus.getCalibration();
        String string3 = System.getProperty("line.separator");
        boolean bl = calibration.scaled();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                printWriter.print(IJ.d2s((double)(((Rectangle)object2).x + nArray[i]) * calibration.pixelWidth) + "\t" + IJ.d2s((double)(((Rectangle)object2).y + nArray2[i]) * calibration.pixelHeight) + string3);
                continue;
            }
            printWriter.print(((Rectangle)object2).x + nArray[i] + "\t" + (((Rectangle)object2).y + nArray2[i]) + string3);
        }
        printWriter.close();
    }
}

